/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Upload;
import com.sun.web.ui.renderer.FieldRenderer;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.util.UploadFilterFileItem;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.fileupload.FileUploadBase;

public class UploadRenderer
extends FieldRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Upload upload = (Upload)component;
        Map map = context.getExternalContext().getRequestMap();
        if (this.checkForFatalErrors(context, component, map)) {
            upload.setSubmittedValue(null);
            return;
        }
        String id = component.getClientId(context);
        UploadFilterFileItem fi = null;
        if (map.containsKey(id)) {
            fi = (UploadFilterFileItem)map.get(id);
        } else if (map.containsKey(id = id.concat("_com.sun.web.ui.upload"))) {
            fi = (UploadFilterFileItem)map.get(id);
        }
        upload.setSubmittedValue(null);
        if (fi != null && !this.checkForFileErrors(context, component, fi)) {
            upload.setSubmittedValue(id);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Upload)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Upload.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Upload.renderer", params);
            throw new FacesException(message);
        }
        Map map = context.getExternalContext().getRequestMap();
        this.checkForFatalErrors(context, component, map);
        boolean spanRendered = super.renderField(context, (Upload)component, "file", this.getStyles(context));
        StringBuffer jsString = new StringBuffer(200);
        String id = component.getClientId(context);
        jsString.append("upload_setEncodingType('");
        jsString.append(id);
        jsString.append("');");
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"\n", null);
        writer.startElement("script", component);
        writer.writeText((Object)jsString.toString(), null);
        writer.endElement("script");
        if (!spanRendered) {
            String param = id.concat("_com.sun.web.ui.uploadParam");
            RenderingUtilities.renderHiddenField(component, writer, param, id);
        }
    }

    protected boolean checkForFatalErrors(FacesContext context, UIComponent component, Map map) {
        String message = null;
        Throwable cause = null;
        Throwable error = (Throwable)map.get("upload_error_key");
        if (error != null) {
            cause = error.getCause();
            if (cause != null) {
                message = cause.getMessage();
            } else {
                cause = error;
            }
            if (message == null) {
                message = error.getMessage();
            }
            if (message == null) {
                message = ThemeUtilities.getTheme(context).getMessage("Upload.fatalError.parseException");
            }
        } else {
            String errorKey = (String)map.get("upload_nodata_key");
            if (errorKey != null) {
                message = ThemeUtilities.getTheme(context).getMessage("Upload.fatalError.noData");
            } else {
                return false;
            }
        }
        FacesMessage fmsg = new FacesMessage(message);
        context.addMessage(component.getClientId(context), fmsg);
        if (LogUtil.warningEnabled(Upload.class)) {
            if (cause != null) {
                LogUtil.warning((Object)Upload.class, message, cause);
            } else {
                LogUtil.warning(Upload.class, message);
            }
        }
        map.remove("upload_error_key");
        map.remove("upload_nodata_key");
        return true;
    }

    protected boolean checkForFileErrors(FacesContext context, UIComponent component, UploadFilterFileItem ufi) {
        List errorLog = ufi.getErrorLog();
        if (errorLog == null || errorLog.isEmpty()) {
            return false;
        }
        String msg = null;
        Iterator iterator = errorLog.iterator();
        while (iterator.hasNext()) {
            Exception e = (Exception)iterator.next();
            msg = e instanceof FileUploadBase.SizeLimitExceededException ? ThemeUtilities.getTheme(context).getMessage("Upload.error", new Object[]{Long.valueOf(e.getMessage())}) : e.getMessage();
            if (msg == null) {
                msg = ThemeUtilities.getTheme(context).getMessage("Upload.fileError.IOException");
            }
            FacesMessage fmsg = new FacesMessage(msg);
            context.addMessage(component.getClientId(context), fmsg);
            if (!LogUtil.fineEnabled(class$com$sun$web$ui$component$Upload == null ? UploadRenderer.class$("com.sun.web.ui.component.Upload") : class$com$sun$web$ui$component$Upload)) continue;
            LogUtil.fine((Object)(class$com$sun$web$ui$component$Upload == null ? UploadRenderer.class$("com.sun.web.ui.component.Upload") : class$com$sun$web$ui$component$Upload), msg == null ? e.getClass().getName() : msg, e);
        }
        return true;
    }
}

