/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.util;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public class FilterUtil
implements FileFilter {
    private String filterString = null;
    private String extPattern = null;
    private String namePattern = null;

    public FilterUtil() {
    }

    public FilterUtil(String filterString) {
        if (filterString != null) {
            this.filterString = filterString;
            this.filterString.trim();
            int index = filterString.indexOf(46);
            if (index == -1) {
                this.namePattern = filterString;
            } else if (index == 0) {
                if (filterString.length() > 1) {
                    this.extPattern = filterString.substring(1);
                }
            } else if (index == filterString.length() - 1) {
                this.namePattern = filterString.substring(0, index - 1);
            } else {
                this.namePattern = filterString.substring(0, index);
                this.extPattern = filterString.substring(index + 1);
            }
        }
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (this.filterString == null) {
            return true;
        }
        if (this.filterString.length() == 0) {
            return true;
        }
        if (this.filterString.equals("*")) {
            return true;
        }
        String fileName = f.getName();
        if (this.filterString.equals(fileName)) {
            return true;
        }
        String extension = this.getExtension(fileName);
        String name = this.getName(fileName);
        if (this.filterString.indexOf(46) == -1) {
            return this.check(fileName, this.filterString);
        }
        if (this.filterString.indexOf(46) != -1 && fileName.indexOf(46) == -1) {
            return false;
        }
        boolean nameFlag = this.check(name, this.namePattern);
        boolean extFlag = this.check(extension, this.extPattern);
        return nameFlag && extFlag;
    }

    private boolean check(String value, String pattern) {
        boolean flag = false;
        if (value == null && pattern == null) {
            flag = true;
        } else if (value == null && pattern != null) {
            if (pattern.equals("*")) {
                flag = true;
            }
        } else if (value != null && pattern != null) {
            if (pattern.equals("*")) {
                flag = true;
            } else if (pattern.equals(value)) {
                flag = true;
            } else {
                StringTokenizer st = new StringTokenizer(pattern, "*");
                if (st.countTokens() == 1) {
                    if (pattern.endsWith("*") && pattern.startsWith("*")) {
                        flag = this.checkPattern(st, value);
                    } else if (pattern.endsWith("*")) {
                        String prefix = pattern.substring(0, pattern.length() - 1);
                        flag = value.startsWith(prefix);
                    } else if (pattern.startsWith("*")) {
                        String suffix = pattern.substring(1, pattern.length());
                        flag = value.endsWith(suffix);
                    }
                } else {
                    flag = this.checkPattern(st, value);
                }
            }
        }
        return flag;
    }

    private boolean checkPattern(StringTokenizer token, String name) {
        int position = 0;
        boolean flag = true;
        while (token.hasMoreTokens()) {
            String subset = token.nextToken();
            int index = name.indexOf(subset, position);
            if (index == -1) {
                flag = false;
                break;
            }
            position = index + subset.length();
        }
        return flag;
    }

    private String getExtension(String name) {
        String ext = null;
        if (name != null) {
            int i = name.indexOf(46);
            if (i == -1) {
                return null;
            }
            if (i == 0) {
                ext = name.substring(1);
            } else if (i < name.length() - 1) {
                ext = name.substring(i + 1);
            }
        }
        return ext;
    }

    private String getName(String name) {
        String fileName = null;
        int length = name.length();
        if (name != null) {
            int i = name.indexOf(46);
            if (i == -1) {
                fileName = name;
            } else if (i == 0) {
                fileName = null;
            } else if (i <= length - 1) {
                fileName = name.substring(0, i);
            }
        }
        return fileName;
    }
}

