/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebugTrace;
import com.sun.web.ui.common.CCSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CCDebug {
    private static final boolean ON = true;
    private static final int TRACE_OFF = 0;
    private static final String DEBUG_LEVEL_PROP = "com.sun.web.ui.debug.options";
    private static final String DEBUG_DEVICE_PROP = "com.sun.web.ui.debug.device";
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static CCDebugTrace tracer = null;
    private static boolean trace_time = false;
    private static boolean trace_method = false;
    private static boolean trace_thread = false;
    private static PrintStream pStream = null;

    public static final synchronized void initTrace() {
        Object object;
        Object object2;
        if (trace_init) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            trace_level = 0;
            if (CCSystem.isAppInConsole()) {
                object2 = CCSystem.getServerInterface();
                tracer = object2.getCCDebugTrace();
                if (tracer != null) {
                    trace_level = tracer.getLevel();
                }
                if (trace_level > 0) {
                    tracer.enableTrace(trace_level);
                }
            } else {
                string = System.getProperty(DEBUG_LEVEL_PROP);
                string2 = System.getProperty(DEBUG_DEVICE_PROP);
                if (string == null || string.length() == 0) {
                    object2 = RequestManager.getRequestContext();
                    object = object2.getServletContext();
                    string = object.getInitParameter(DEBUG_LEVEL_PROP);
                    string2 = object.getInitParameter(DEBUG_DEVICE_PROP);
                }
            }
        }
        catch (Throwable throwable) {
            trace_level = 0;
        }
        try {
            if (string != null && string2 != null) {
                trace_level = Integer.parseInt(string.substring(0, 1));
                trace_method = string.indexOf(109) > 0;
                trace_time = string.indexOf(116) > 0;
                boolean bl = trace_thread = string.indexOf(112) > 0;
                if (string2.equalsIgnoreCase(STDOUT)) {
                    pStream = System.out;
                } else if (string2.equalsIgnoreCase(STDERR)) {
                    pStream = System.err;
                } else {
                    object2 = new File(string2);
                    if (((File)object2).exists()) {
                        object = new FileOutputStream((File)object2, true);
                        pStream = new PrintStream((OutputStream)object);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            trace_level = 0;
        }
        trace_init = true;
        CCDebug.trace1("Starting component debug tracing...");
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final void trace1(String string) {
        if (trace_level > 0) {
            CCDebug.writeTrace(string, null);
        }
    }

    public static final void trace1(String string, Throwable throwable) {
        if (trace_level > 0) {
            CCDebug.writeTrace(string, throwable);
        }
    }

    public static final void trace2(String string) {
        if (trace_level > 1) {
            CCDebug.writeTrace(string, null);
        }
    }

    public static final void trace2(String string, Throwable throwable) {
        if (trace_level > 1) {
            CCDebug.writeTrace(string, throwable);
        }
    }

    public static final void trace3(String string) {
        if (trace_level > 2) {
            CCDebug.writeTrace(string, null);
        }
    }

    public static final void trace3(String string, Throwable throwable) {
        if (trace_level > 2) {
            CCDebug.writeTrace(string, throwable);
        }
    }

    public static String getClassMethod(int n) {
        StackTraceElement stackTraceElement = CCDebug.getStackFrame(++n);
        return stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName();
    }

    public static String where(int n) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        StackTraceElement[] stackTraceElementArray = CCDebug.getStack();
        n += 2;
        for (int i = 2; i < stackTraceElementArray.length && i < n; ++i) {
            stringBuffer.append(stackTraceElementArray[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String where(Throwable throwable, int n) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(throwable.getClass().getName()).append(" : ").append(throwable.getMessage()).append("\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            stringBuffer.append("    ").append(stackTraceElementArray[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    private static synchronized void writeTrace(String string, Throwable throwable) {
        String[] stringArray;
        if (tracer != null) {
            String[] stringArray2 = CCDebug.getClassMethodNames();
            tracer.trace(trace_level, string, stringArray2[0], stringArray2[1], throwable);
            return;
        }
        String string2 = "";
        if (trace_time) {
            stringArray = new SimpleDateFormat("HH:mm:ss");
            string2 = stringArray.format(new Date()) + " | ";
        }
        if (trace_thread) {
            stringArray = Thread.currentThread();
            string2 = string2 + stringArray.getName() + " | ";
        }
        if (trace_method) {
            stringArray = CCDebug.getClassMethodNames();
            string2 = string2 + stringArray[0] + ":" + stringArray[1] + " | ";
        }
        string2 = string2 + string;
        pStream.println(string2);
        if (throwable != null) {
            throwable.printStackTrace(pStream);
        }
    }

    private static String[] getClassMethodNames() {
        String string;
        StackTraceElement stackTraceElement = CCDebug.getStackFrame(3);
        String[] stringArray = new String[]{"", ""};
        String string2 = stackTraceElement.getClassName();
        if (string2 != null) {
            stringArray[0] = string2;
        }
        if ((string = stackTraceElement.getMethodName()) != null) {
            stringArray[1] = string;
        }
        return stringArray;
    }

    private static StackTraceElement getStackFrame(int n) {
        StackTraceElement[] stackTraceElementArray = CCDebug.getStack();
        if ((n += 2) > stackTraceElementArray.length) {
            return stackTraceElementArray[2];
        }
        return stackTraceElementArray[n];
    }

    private static StackTraceElement[] getStack() {
        Exception exception = new Exception();
        exception.fillInStackTrace();
        return exception.getStackTrace();
    }
}

