/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CCI18NFileIO
extends CCI18N {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String PROPS_SUFFIX = ".properties";

    public CCI18NFileIO(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, String string3, String string4) {
        super(servletRequest, string2);
        if (string2 != null) {
            CCI18NFileIO.setResourceBundle(servletRequest, servletResponse, string, string2, locale, string3, string4);
        } else {
            CCI18NFileIO.initContentType(servletRequest, servletResponse);
            this.setResourceBundle(CCI18NFileIO.findResourceBundle(servletRequest, string, locale != null ? locale : CCI18NFileIO.getTagsLocale(servletRequest), string3, string4));
        }
    }

    public static boolean setResourceBundle(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, String string3, String string4) {
        CCI18NFileIO.initContentType(servletRequest, servletResponse);
        ResourceBundle resourceBundle = CCI18NFileIO.findResourceBundle(servletRequest, string, locale != null ? locale : CCI18NFileIO.getTagsLocale(servletRequest), string3, string4);
        if (resourceBundle == null) {
            CCDebug.trace3("The resource bundle could not be found.");
            return false;
        }
        CCI18NFileIO.setResourceBundle(servletRequest, resourceBundle, string2);
        CCI18NFileIO.setBaseName(servletRequest, string, string2);
        return true;
    }

    private static ResourceBundle findResourceBundle(ServletRequest servletRequest, String string, Locale locale, String string2, String string3) {
        Locale locale2;
        if (servletRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        ResourceBundle resourceBundle = null;
        ArrayList<Object> arrayList = new ArrayList<Locale>();
        if (locale != null) {
            arrayList.add(locale);
        } else {
            arrayList = Collections.list(servletRequest.getLocales());
        }
        for (int i = 0; i < arrayList.size() && (!(locale2 = (Locale)arrayList.get(i)).getLanguage().equals(Locale.ENGLISH.getLanguage()) || !locale2.getCountry().equals(Locale.US.getCountry()) && locale2.getCountry().length() != 0); ++i) {
            resourceBundle = CCI18NFileIO.loadResourceBundle(servletRequest, string, locale2, string2, string3);
            if (resourceBundle == null) continue;
            if (resourceBundle.getLocale() == null || resourceBundle.getLocale().getLanguage().length() > 0) break;
            CCDebug.trace3("Locale not available: " + locale);
        }
        if (resourceBundle == null || resourceBundle.getLocale() == null || resourceBundle.getLocale().getLanguage().length() == 0) {
            resourceBundle = CCI18NFileIO.loadResourceBundle(servletRequest, string, new Locale(""), string2, string3);
        }
        return resourceBundle;
    }

    private static ResourceBundle loadResourceBundle(ServletRequest servletRequest, String string, Locale locale, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("appRoot cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ResourceBundle resourceBundle = null;
        if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            arrayList.add(CCI18NFileIO.getSuffix(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        }
        if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0) {
            arrayList.add(CCI18NFileIO.getSuffix(locale.getLanguage(), locale.getCountry(), ""));
        }
        if (locale.getLanguage().length() > 0) {
            arrayList.add(CCI18NFileIO.getSuffix(locale.getLanguage(), "", ""));
        }
        arrayList.add("");
        for (int i = 0; i < arrayList.size() && (resourceBundle = CCI18NFileIO.loadResourceBundle((String)arrayList.get(i), string, string2, string3)) == null; ++i) {
        }
        return resourceBundle;
    }

    private static ResourceBundle loadResourceBundle(String string, String string2, String string3, String string4) {
        String string5 = string2 + string;
        String string6 = string4 != null ? string4 + string + ".jar" : null;
        return CCI18NFileIO.findResourceFile(string5, string3, string6);
    }

    private static ResourceBundle findResourceFile(String string, String string2, String string3) {
        Object object;
        Object object2;
        String string4 = CCI18NFileIO.normalizeBaseName(string);
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(string2).append(SEPARATOR).append("WEB-INF").append(SEPARATOR).append("lib").append(SEPARATOR).append(string3);
        File file = new File(nonSyncStringBuffer.toString());
        if (file.exists()) {
            try {
                object2 = new JarFile(file);
                object = ((JarFile)object2).getJarEntry(string4);
                if (object != null) {
                    InputStream inputStream = ((JarFile)object2).getInputStream((ZipEntry)object);
                    return new PropertyResourceBundle(inputStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        nonSyncStringBuffer = new NonSyncStringBuffer(string2).append(SEPARATOR).append("WEB-INF").append(SEPARATOR).append("classes").append(SEPARATOR).append(string4);
        try {
            object2 = new File(nonSyncStringBuffer.toString());
            object = new FileInputStream((File)object2);
            return new PropertyResourceBundle((InputStream)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String normalizeBaseName(String string) {
        String string2 = string.replace('.', SEPARATOR.toCharArray()[0]);
        return string2 + PROPS_SUFFIX;
    }

    private static String getSuffix(String string, String string2, String string3) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        String string4 = "_";
        if (string.length() > 0) {
            nonSyncStringBuffer.append(string4 + string);
        }
        if (string2.length() > 0) {
            nonSyncStringBuffer.append(string4 + string2);
        }
        if (string3.length() > 0) {
            nonSyncStringBuffer.append(string4 + string3);
        }
        return nonSyncStringBuffer.toString();
    }

    private static void setBaseName(ServletRequest servletRequest, String string, String string2) {
        servletRequest.setAttribute("com.sun.web.ui.common.CCI18N.Base:" + string2, (Object)string);
    }
}

