/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;

public class CCJspWriterImpl
extends JspWriter {
    public static final int K = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected Writer out;
    protected ServletResponse response;
    protected char[] cb;
    protected int nextChar;
    protected static int defaultCharBufferSize = 8192;
    protected boolean flushed = false;
    static String lineSeparator = System.getProperty("line.separator");

    public CCJspWriterImpl() {
        super(defaultCharBufferSize, true);
    }

    public CCJspWriterImpl(ServletResponse servletResponse) {
        this(servletResponse, defaultCharBufferSize, true);
    }

    public CCJspWriterImpl(ServletResponse servletResponse, int n, boolean bl) {
        super(n, bl);
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = servletResponse;
        this.cb = n == 0 ? null : new char[n];
        this.nextChar = 0;
    }

    void init(ServletResponse servletResponse, int n, boolean bl) {
        this.response = servletResponse;
        if (n > 0 && (this.cb == null || n > this.cb.length)) {
            this.cb = new char[n];
        }
        this.nextChar = 0;
        this.autoFlush = bl;
        this.bufferSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                return;
            }
            this.flushed = true;
            this.ensureOpen();
            if (this.nextChar == 0) {
                return;
            }
            this.initOut();
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    protected void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException("Illegal to clear() when buffer size == 0");
            }
            if (this.flushed) {
                throw new IOException("Error: Attempt to clear a buffer that's already been flushed");
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException("Illegal to clear() when buffer size == 0");
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException("Error: JSP Buffer overflow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            if (this.out != null) {
                this.out.flush();
                this.response.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                return;
            }
            this.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    protected void ensureOpen() throws IOException {
        if (this.response == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(n);
            } else {
                if (this.nextChar >= this.bufferSize) {
                    if (this.autoFlush) {
                        this.flushBuffer();
                    } else {
                        this.bufferOverflow();
                    }
                }
                this.cb[this.nextChar++] = (char)n;
            }
        }
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(cArray, n, n2);
                return;
            }
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (n2 >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.initOut();
                this.out.write(cArray, n, n2);
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
                System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(string, n, n2);
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(lineSeparator);
        }
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int n) throws IOException {
        this.write(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) throws IOException {
        this.write(cArray);
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) throws IOException {
        this.write(String.valueOf(object));
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    void recycle() {
        this.flushed = false;
        this.nextChar = 0;
    }
}

