/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCServerInterface;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.EntityResolver;

public class CCSystem {
    static String DEFAULT_SERVER_IMPL_CLASS = "com.sun.web.console.ui.CCServerImpl";
    static String RESOURCE_CONTEXT_PATH = "com_sun_web_ui";
    static String CONSOLE_SECUREPORT = System.getProperty("com.sun.web.console.secureport");
    static String CONSOLE_UNSECUREPORT = System.getProperty("com.sun.web.console.unsecureport");
    static String CONSOLE_UNSECUREHOST = System.getProperty("com.sun.web.console.unsecurehost");
    static boolean HELP_SECURE = false;
    static EntityResolver MODEL_ENTITY_RESOLVER = null;
    public static final String SERVER_IMPL_CLASS_NAME = "com_sun_web_ui_serverimpl";
    public static final String URL_SEPARATOR = "/";
    public static final String CONSOLE_APPBASE = System.getProperty("com.sun.web.console.appbase");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String FILE_PRODNAME = "/com_sun_web_ui/images/ProductName.properties";
    private static final String SPLIT_PROBE_PATH = "/com_sun_web_ui/dtd/descriptor.dtd";
    private static final String ATTR_PRODNAME = "com.sun.web.ui.prodname.";
    private static final String PROP_PRODNAME_PRIMARY = "primary.";
    private static final String PROP_PRODNAME_SECONDARY = "secondary.";
    private static final String PROP_PRODNAME_VERSION = "version.";
    private static final String PROP_PRODNAME_URI = "uri";
    private static final String PROP_PRODNAME_HEIGHT = "height";
    private static final String PROP_PRODNAME_WIDTH = "width";
    private static String JSP_URL_PREFIX = "/com_sun_web_ui";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String LOCAL_HOST = "localhost";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static String hostName = null;
    private static String httpPrefix = null;
    private static Object osync = new Object();
    private static CCServerInterface serverImpl = null;
    private static String lookingForFile = "file=\"";
    private static String lookingForLink = "virtual=\"";

    public static String getResourceContextPath() {
        String string;
        block5: {
            string = null;
            if (!CCSystem.isAppInConsole()) {
                try {
                    RequestContext requestContext = RequestManager.getRequestContext();
                    ServletContext servletContext = requestContext.getServletContext();
                    URL uRL = servletContext.getResource(SPLIT_PROBE_PATH);
                    if (uRL != null) {
                        string = requestContext.getRequest().getContextPath() + URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                        break block5;
                    }
                    string = URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                }
                catch (Exception exception) {
                    string = URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                }
            } else {
                string = serverImpl.getResourceContextPath();
            }
        }
        CCDebug.trace3("RCPATH : " + string);
        return string;
    }

    public static String getSecurePort() {
        return CONSOLE_SECUREPORT;
    }

    public static String getUnsecurePort() {
        return CONSOLE_UNSECUREPORT;
    }

    public static String getUnsecureServerName() {
        return CONSOLE_UNSECUREHOST;
    }

    public static boolean isHelpSecure() {
        return HELP_SECURE;
    }

    public static int getVersion() {
        return 301;
    }

    public static EntityResolver getEntityResolver() {
        return MODEL_ENTITY_RESOLVER;
    }

    public static CCServerInterface getServerInterface() {
        return serverImpl;
    }

    public static boolean isAppInConsole() {
        return serverImpl != null;
    }

    public static String getURLPrefix() {
        return JSP_URL_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceImage(String string) {
        BufferedImage bufferedImage = null;
        if (string == null) {
            return bufferedImage;
        }
        RequestContext requestContext = RequestManager.getRequestContext();
        ServletContext servletContext = requestContext.getServletContext();
        InputStream inputStream = null;
        inputStream = servletContext.getResourceAsStream(URL_SEPARATOR + string);
        if (inputStream != null) {
            try {
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (Exception exception) {
                CCDebug.trace1("Could not read image from inputstream", exception);
            }
        } else {
            Object object = osync;
            synchronized (object) {
                if (hostName == null) {
                    hostName = CCSystem.getUnsecureServerName();
                    if (hostName == null || hostName.length() == 0) {
                        try {
                            hostName = requestContext.getRequest().getServerName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (hostName == null) {
                        try {
                            hostName = InetAddress.getLocalHost().getHostName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (hostName == null) {
                        hostName = LOCAL_HOST;
                    }
                    httpPrefix = HTTP_PROTOCOL + hostName + ":" + CCSystem.getUnsecurePort();
                }
            }
            try {
                bufferedImage = ImageIO.read(new URL(httpPrefix + string));
            }
            catch (Exception exception) {
                CCDebug.trace1("Error loading image " + httpPrefix + string + ": " + exception.getMessage());
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    public static String[] getProductNameImage(String string, String string2, String string3, String string4) {
        String[] stringArray;
        Object object;
        Object object2;
        ServletContext servletContext = null;
        String string5 = null;
        RequestContext requestContext = RequestManager.getRequestContext();
        if (requestContext != null) {
            try {
                object2 = requestContext.getRequest();
                if (object2 != null) {
                    string5 = object2.getContextPath();
                    servletContext = object2.getSession().getServletContext();
                }
            }
            catch (Exception exception) {
                servletContext = null;
            }
        }
        if (servletContext == null) {
            CCDebug.trace1("get product name called outside request");
            object2 = new String[]{string2, string3, string4};
            return object2;
        }
        object2 = new Properties();
        String string6 = null;
        string6 = string5 != null && string5.length() > 1 ? ATTR_PRODNAME + string5.substring(1) : ATTR_PRODNAME;
        try {
            object2 = (Properties)servletContext.getAttribute(string6);
            if (object2 == null) {
                object2 = new Properties();
                object = servletContext.getResourceAsStream(FILE_PRODNAME);
                if (object != null) {
                    ((Properties)object2).load((InputStream)object);
                    ((InputStream)object).close();
                }
                servletContext.setAttribute(string6, object2);
            }
        }
        catch (Exception exception) {
            CCDebug.trace1("Error reading product name properties: " + exception.getMessage());
            object2 = new Properties();
        }
        object = string2;
        String string7 = string3;
        String string8 = string4;
        try {
            String string9;
            stringArray = null;
            if (string.equalsIgnoreCase("primary")) {
                stringArray = "primary.";
            } else if (string.equalsIgnoreCase("secondary")) {
                stringArray = PROP_PRODNAME_SECONDARY;
            } else if (string.equalsIgnoreCase("version")) {
                stringArray = PROP_PRODNAME_VERSION;
            }
            if (stringArray != null && (string9 = ((Properties)object2).getProperty((String)stringArray + PROP_PRODNAME_URI)) != null) {
                object = string5 + string9;
                string7 = ((Properties)object2).getProperty((String)stringArray + PROP_PRODNAME_HEIGHT);
                string8 = ((Properties)object2).getProperty((String)stringArray + PROP_PRODNAME_WIDTH);
            }
        }
        catch (Exception exception) {
            CCDebug.trace3("Error obtaining buffered image: " + exception.getMessage());
        }
        stringArray = new String[]{object, string7, string8};
        return stringArray;
    }

    public static String getHelpUrlHeader(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        String string3;
        String string4 = "";
        if (HELP_SECURE) {
            string3 = "https";
            string2 = CONSOLE_UNSECUREHOST;
            string = CONSOLE_SECUREPORT;
        } else {
            string3 = "http";
            string2 = CONSOLE_UNSECUREHOST;
            string = CONSOLE_UNSECUREPORT;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = LOOPBACK_ADDRESS;
        }
        if (string == null || string.length() == 0) {
            CCDebug.trace1("Help port not set, using request header");
            if (httpServletRequest != null) {
                string3 = httpServletRequest.getScheme();
                string2 = httpServletRequest.getServerName();
                string = String.valueOf(httpServletRequest.getServerPort());
            } else {
                CCDebug.trace1("No help url header, request is null");
            }
        }
        if (string != null && string.length() > 0) {
            string4 = string3 + "://" + string2 + ":" + string;
        }
        return string4;
    }

    public static String getVersionTxt(String string, String string2) {
        CCDebug.trace3("APPCONTEXT = " + string2);
        int n = string.indexOf(string2);
        CCDebug.trace3("INDEX = " + n);
        String string3 = string.substring(n + string2.length());
        CCDebug.trace3("REST OF THE STRING = " + string3);
        RequestContext requestContext = RequestManager.getRequestContext();
        ServletContext servletContext = requestContext.getServletContext();
        InputStream inputStream = servletContext.getResourceAsStream(string3);
        if (inputStream != null) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string4 = null;
                String string5 = null;
                while (bufferedReader.ready()) {
                    String string6 = lookingForFile;
                    string4 = bufferedReader.readLine();
                    CCDebug.trace3("LINE " + string4);
                    int n2 = string4.indexOf(string6);
                    if (n2 == -1) {
                        string6 = lookingForLink;
                        n2 = string4.indexOf(lookingForLink);
                    }
                    CCDebug.trace3("INDEX1 " + n2);
                    int n3 = string4.indexOf("\"", n2 + string6.length() + 1);
                    CCDebug.trace3("INDEX2 " + n3);
                    if (n2 == -1) continue;
                    CCDebug.trace3("LINE FOUND!!!!");
                    string5 = string4.substring(n2 + string6.length(), n3);
                    CCDebug.trace3("txtFile " + string5);
                    break;
                }
                int n4 = string3.lastIndexOf(URL_SEPARATOR);
                String string7 = string3.substring(0, n4 + 1) + string5;
                CCDebug.trace3("txt " + string7);
                inputStream.close();
                inputStreamReader.close();
                bufferedReader.close();
                inputStream = servletContext.getResourceAsStream(string7);
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while (bufferedReader.ready()) {
                    stringBuffer.append(bufferedReader.readLine());
                }
                CCDebug.trace3("version info: " + stringBuffer.toString());
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                CCDebug.trace1("Could not read line from inputstream", exception);
            }
        }
        return string3;
    }

    public static boolean checkRelativeUrl(String string) {
        boolean bl = false;
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() == null && uRI.getHost() == null && uRI.getPort() == -1 && uRI.getPath() != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            CCDebug.trace1("Invalid context relative Url: " + (string == null ? "(null)" : string));
        }
        return bl;
    }

    public static String getRelativeUrl(String string) {
        String string2 = "";
        try {
            URI uRI = new URI(string);
            string2 = uRI.getPath();
            if (uRI.getQuery() != null) {
                string2 = string2 + "?" + uRI.getQuery();
            }
            if (uRI.getFragment() != null) {
                string2 = string2 + "#" + uRI.getFragment();
            }
        }
        catch (Exception exception) {
            CCDebug.trace1("Invalid relative Url: " + (string == null ? "null" : string));
        }
        return string2;
    }

    private CCSystem() {
    }

    static void setSecurePort(int n) {
        CONSOLE_SECUREPORT = String.valueOf(n);
    }

    static void setUnsecurePort(int n) {
        CONSOLE_UNSECUREPORT = String.valueOf(n);
    }

    static void setUnsecureServerName(String string) {
        CONSOLE_UNSECUREHOST = string;
    }

    static void setResourceContextPath(String string) {
        RESOURCE_CONTEXT_PATH = string;
    }

    static void setEntityResolver(EntityResolver entityResolver) {
        MODEL_ENTITY_RESOLVER = entityResolver;
    }

    static void setSecureHelp(boolean bl) {
        HELP_SECURE = bl;
    }

    static {
        try {
            serverImpl = (CCServerInterface)Class.forName(DEFAULT_SERVER_IMPL_CLASS).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            CCDebug.trace1("could not find console implementation of CCServerInterface");
            serverImpl = null;
        }
        catch (Exception exception) {
            CCDebug.trace1("could not instantiate console implementation of CCServerInterface", exception);
            serverImpl = null;
        }
    }
}

