/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCDocumentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCBreadCrumbsModel
extends DefaultModel
implements CCBreadCrumbsModelInterface {
    private static final long serialVersionUID = -4753069606370138839L;
    protected String useGrayBg = null;
    protected String currentPageLabel;
    public static final String LINK_TAG_NAME = "link";
    public static final String PAGE_TAG_NAME = "page";
    public static final String ONCLICK_ATTR = "onClick";
    public static final String TARGET_ATTR = "target";
    public static final String COMMANDFIELD_ATTR = "href";
    public static final String MOUSEOVER_ATTR = "mouseOver";
    public static final String VALUE_ATTR = "hrefValue";
    protected transient Document xmlDocument;
    protected transient InputStream xmlStream;
    private String xmlAsString = null;

    public CCBreadCrumbsModel() {
    }

    public CCBreadCrumbsModel(String string) {
        this.currentPageLabel = string;
    }

    public CCBreadCrumbsModel(ServletContext servletContext, String string) {
        this(servletContext.getResourceAsStream(string));
    }

    public CCBreadCrumbsModel(InputStream inputStream) {
        this.xmlStream = inputStream;
        try {
            this.parseXML();
            this.buildPathFromDOM();
            this.xmlAsString = CCDocumentBuilder.getXMLString(inputStream);
        }
        catch (Exception exception) {
            System.out.println("err in bc constructor");
            exception.printStackTrace();
            CCDebug.trace1("Error building breadcrumb model from given XML", exception);
        }
    }

    public String getCurrentPageLabel() {
        return this.currentPageLabel;
    }

    public void setCurrentPageLabel(String string) {
        this.currentPageLabel = string;
    }

    protected void parseXML() {
        this.xmlDocument = CCDocumentBuilder.createDocument(this.xmlStream);
    }

    protected void buildPathFromDOM() {
        Node node;
        NodeList nodeList = this.xmlDocument.getElementsByTagName(LINK_TAG_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.appendRow();
            node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.setValue("label", node.getFirstChild().getNodeValue());
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                String string = namedNodeMap.item(j).getNodeName();
                String string2 = namedNodeMap.item(j).getNodeValue();
                if (string.equals(COMMANDFIELD_ATTR)) {
                    this.setValue("commandField", string2);
                    continue;
                }
                if (string.equals(MOUSEOVER_ATTR)) {
                    this.setValue("status", string2);
                    continue;
                }
                if (string.equals(ONCLICK_ATTR)) {
                    this.setValue(ONCLICK_ATTR, string2);
                    continue;
                }
                if (string.equals(TARGET_ATTR)) {
                    this.setValue(TARGET_ATTR, string2);
                    continue;
                }
                if (!string.equals(VALUE_ATTR)) continue;
                this.setValue("value", string2);
            }
        }
        nodeList = this.xmlDocument.getElementsByTagName(PAGE_TAG_NAME);
        node = nodeList.item(0);
        this.currentPageLabel = node.getFirstChild().getNodeValue();
    }

    public String getUseGrayBg() {
        return this.isUseGrayBgSet() ? this.useGrayBg : "false";
    }

    public void setUseGrayBg(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.useGrayBg = string;
    }

    public boolean isUseGrayBgSet() {
        return this.useGrayBg != null;
    }

    public boolean next() throws ModelControlException {
        boolean bl = super.next();
        if (bl && this.getRowIndex() == 0) {
            bl = this.getValue("commandField") != null;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        CCDocumentBuilder.createDocument(new ByteArrayInputStream(this.xmlAsString.getBytes()));
    }
}

