/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CCDefaultEntityResolver
implements EntityResolver,
Serializable {
    protected static final String DTD_DIR = "dtd";
    protected static final String TAG_DIR = "tags";
    protected static final String CCC_DIR = "com_sun_web_ui";
    private static final String FILE_PROTOCOL = "file://";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String DTD_SUFFIX = ".dtd";
    private static final String LOCAL_HOST = "localhost";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String JARDTD_PATH = "com/sun/web/ui/model/dtd/";
    private static String xmlEncoding = "UTF-8";
    private String httpPort = CCSystem.getUnsecurePort();
    private String httpHost = CCSystem.getUnsecureServerName();
    private String httpPrefix = null;
    private String userDir = null;
    private String resourceContextName = null;
    private ServletContext context = null;

    public CCDefaultEntityResolver() {
        if (this.httpPort == null || this.httpHost == null || this.httpHost.length() == 0) {
            try {
                RequestContext requestContext = RequestManager.getRequestContext();
                HttpServletRequest httpServletRequest = requestContext.getRequest();
                if (httpServletRequest.getScheme().equalsIgnoreCase("http")) {
                    this.httpHost = httpServletRequest.getServerName();
                    this.httpPort = Integer.toString(httpServletRequest.getServerPort());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.httpHost != null && this.httpPort != null) {
            this.httpPrefix = HTTP_PROTOCOL + this.httpHost + ":" + this.httpPort;
        }
        this.userDir = System.getProperty("user.dir");
        this.userDir = this.userDir.replace('\\', '/');
        this.resourceContextName = CCSystem.getResourceContextPath();
        if (this.resourceContextName.startsWith("/")) {
            this.resourceContextName = this.resourceContextName.substring(1);
        }
        if (this.httpHost == null || this.httpPort == null) {
            CCDebug.trace1("Unable to determine unsecure host and port, unsecure host: " + (this.httpHost == null ? "null" : this.httpHost) + ", unsecure port: " + (this.httpPort == null ? "null" : this.httpPort));
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        String string3 = this.getSystemId(string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        int n = stringTokenizer.countTokens();
        if (n != 1 && n != 3) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        InputSource inputSource = null;
        if (n == 1 && stringArray[0].endsWith(DTD_SUFFIX)) {
            inputSource = this.getFromJarfile(stringArray[0]);
        }
        if (n == 3 && stringArray[1].equals(DTD_DIR) && stringArray[2].endsWith(DTD_SUFFIX) && (stringArray[0].equals(CCC_DIR) || stringArray[0].equals(TAG_DIR))) {
            inputSource = this.getFromJarfile(stringArray[2]);
        }
        if (inputSource != null) {
            return inputSource;
        }
        try {
            String string4 = null;
            if (this.httpPrefix == null || !CCSystem.isAppInConsole()) {
                RequestContext requestContext = RequestManager.getRequestContext();
                this.context = requestContext.getServletContext();
                string4 = n == 1 && stringArray[0].endsWith(DTD_SUFFIX) ? CCSystem.getURLPrefix() + "/" + DTD_DIR + "/" + stringArray[0] : (n == 3 && stringArray[1].equals(DTD_DIR) && stringArray[2].endsWith(DTD_SUFFIX) ? "/" + stringArray[0] + "/" + DTD_DIR + "/" + stringArray[2] : string3);
                InputStream inputStream = this.context.getResourceAsStream(string4);
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    return inputSource;
                }
            }
        }
        catch (Exception exception) {
            CCDebug.trace3("exception while getting from inputStream", exception);
        }
        if (this.httpPrefix == null) {
            return null;
        }
        try {
            if (n == 1) {
                if (stringArray[0].endsWith(DTD_SUFFIX)) {
                    inputSource = this.buildInputSource(this.resourceContextName, stringArray[0]);
                }
            } else if (n == 3 && stringArray[1].equals(DTD_DIR) && stringArray[2].endsWith(DTD_SUFFIX)) {
                inputSource = stringArray[0].equals(CCC_DIR) ? this.buildInputSource(this.resourceContextName, stringArray[2]) : (stringArray[0].equals(TAG_DIR) ? this.buildInputSource(this.resourceContextName, stringArray[2]) : this.buildInputSource(stringArray[0], stringArray[2]));
            }
        }
        catch (Exception exception) {
            CCDebug.trace1("cannot convert DTD, using default behaviour: " + exception.getMessage());
            inputSource = null;
        }
        return inputSource;
    }

    protected String getSystemId(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        CCDebug.trace3("entity resolver systemid: " + string);
        try {
            string2 = URLDecoder.decode(string, xmlEncoding);
        }
        catch (Exception exception) {
            string2 = string;
        }
        int n2 = string2.indexOf(47);
        if (n2 > 0 && (n = string2.indexOf(58)) >= 0 && n < n2) {
            if (!string2.startsWith(FILE_PROTOCOL)) {
                return null;
            }
            string2 = string2.substring(FILE_PROTOCOL.length());
            if (this.userDir != null) {
                if (string2.startsWith(this.userDir)) {
                    string2 = string2.substring(this.userDir.length());
                } else if (string2.startsWith("/" + this.userDir)) {
                    string2 = string2.substring(this.userDir.length() + 1);
                }
            }
        }
        return string2;
    }

    protected String getHostName() {
        return this.httpHost;
    }

    protected String getPortNumber() {
        return this.httpPort;
    }

    private InputSource buildInputSource(String string, String string2) {
        String string3;
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(128);
        nonSyncStringBuffer.append(this.httpPrefix);
        try {
            string3 = URLEncoder.encode(string, xmlEncoding);
        }
        catch (Exception exception) {
            string3 = string;
        }
        nonSyncStringBuffer.append("/" + string3);
        nonSyncStringBuffer.append("/dtd");
        try {
            string3 = URLEncoder.encode(string2, xmlEncoding);
        }
        catch (Exception exception) {
            string3 = string2;
        }
        nonSyncStringBuffer.append("/" + string3);
        String string4 = nonSyncStringBuffer.toString();
        CCDebug.trace3("Converted systemid: " + string4);
        return new InputSource(string4);
    }

    private InputSource getFromJarfile(String string) {
        InputSource inputSource = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(JARDTD_PATH + string);
            if (inputStream != null) {
                inputSource = new InputSource(inputStream);
                CCDebug.trace3("DTD reference found in jar file: " + string);
            }
        }
        catch (Exception exception) {
            CCDebug.trace3("DTD reference not found in jar file: " + string);
        }
        return inputSource;
    }
}

