/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCNavNodeInterface;
import java.util.ArrayList;
import java.util.List;

public class CCNavNode
extends DefaultModel
implements CCNavNodeInterface {
    private static final long serialVersionUID = -6567750992047718315L;
    protected String label = null;
    protected String value = null;
    protected CCNavNodeInterface parent = null;
    protected boolean visible = true;
    protected boolean acceptsChildren = true;
    protected String tooltip = null;
    protected String status = null;
    protected List children = null;
    protected boolean expanded = false;
    protected boolean notClickable = false;
    protected boolean isRoot = false;
    protected String imageSrc = null;
    protected String imageAltText;
    protected int imageWidth = -1;
    protected int imageHeight;
    protected int id;
    protected String target;
    protected String onclick;
    protected int alarmSeverity = 5;

    public CCNavNode(int n) {
        this.id = n;
    }

    public CCNavNode(int n, String string, String string2, String string3) {
        this.id = n;
        this.setLabel(string);
        this.setTooltip(string2);
        this.setStatus(string3);
    }

    public CCNavNode(int n, String string, String string2, String string3, boolean bl) {
        this(n, string, string2, string3);
        this.acceptsChildren = bl;
    }

    public CCNavNode(int n, CCNavNodeInterface cCNavNodeInterface, String string, String string2, String string3) {
        this(n, string, string2, string3);
        if (cCNavNodeInterface != null) {
            cCNavNodeInterface.addChild(this);
        }
    }

    public CCNavNode(int n, CCNavNodeInterface cCNavNodeInterface, String string, String string2, String string3, boolean bl) {
        this(n, cCNavNodeInterface, string, string2, string3);
        this.acceptsChildren = bl;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getOnClick() {
        return this.onclick;
    }

    public void setOnClick(String string) {
        this.onclick = string;
    }

    public CCNavNodeInterface getParent() {
        return this.parent;
    }

    public boolean setParent(CCNavNodeInterface cCNavNodeInterface) {
        if (this.isRoot) {
            return false;
        }
        if (this.parent != null) {
            List list = this.parent.getChildren();
            list.remove(list.indexOf(this));
        }
        this.parent = cCNavNodeInterface;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
        return true;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public boolean getAcceptsChildren() {
        return this.acceptsChildren;
    }

    public void setAcceptsChildren(boolean bl) {
        this.acceptsChildren = bl;
        if (!bl) {
            this.removeAllChildren();
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public boolean isRoot() {
        if (this.getLevel() > 0) {
            this.isRoot = false;
        }
        return this.isRoot;
    }

    public boolean setAsRoot() {
        if (!this.acceptsChildren) {
            return false;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
        this.isRoot = true;
        return true;
    }

    public CCNavNodeInterface getNextSibling() {
        CCNavNodeInterface cCNavNodeInterface = null;
        if (this.parent != null) {
            List list = this.parent.getChildren();
            int n = list.indexOf(this);
            if (++n < list.size()) {
                cCNavNodeInterface = (CCNavNodeInterface)list.get(n);
            }
        }
        return cCNavNodeInterface;
    }

    public CCNavNodeInterface getPreviousSibling() {
        CCNavNodeInterface cCNavNodeInterface = null;
        if (this.parent != null) {
            List list = this.parent.getChildren();
            int n = list.indexOf(this);
            if (--n > -1) {
                cCNavNodeInterface = (CCNavNodeInterface)list.get(n);
            }
        }
        return cCNavNodeInterface;
    }

    public boolean addChild(CCNavNodeInterface cCNavNodeInterface) {
        if (!this.acceptsChildren || cCNavNodeInterface == null) {
            return false;
        }
        cCNavNodeInterface.setParent(this);
        return true;
    }

    public boolean insertChildAfter(CCNavNodeInterface cCNavNodeInterface, CCNavNodeInterface cCNavNodeInterface2) {
        if (!this.acceptsChildren || cCNavNodeInterface == null || cCNavNodeInterface2 == null) {
            return false;
        }
        int n = this.getChildren().indexOf(cCNavNodeInterface);
        if (n < 0) {
            return false;
        }
        if (++n == this.getChildren().size()) {
            this.getChildren().add(cCNavNodeInterface2);
        } else {
            this.getChildren().add(n, cCNavNodeInterface2);
        }
        return true;
    }

    public boolean insertChildBefore(CCNavNodeInterface cCNavNodeInterface, CCNavNodeInterface cCNavNodeInterface2) {
        if (!this.acceptsChildren || cCNavNodeInterface == null || cCNavNodeInterface2 == null) {
            return false;
        }
        int n = this.getChildren().indexOf(cCNavNodeInterface);
        if (n < 0 || cCNavNodeInterface2 == null) {
            return false;
        }
        this.getChildren().add(n, cCNavNodeInterface2);
        return true;
    }

    public boolean removeChild(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface == null || !this.isNodeChild(cCNavNodeInterface)) {
            return false;
        }
        cCNavNodeInterface.setParent(null);
        return true;
    }

    public int getNumDescendants() {
        int n;
        int n2 = n = this.getChildren().size();
        for (int i = 0; i < n; ++i) {
            n2 += ((CCNavNodeInterface)this.getChildren().get(i)).getNumDescendants();
        }
        return n2;
    }

    public int getNumSiblings() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getChildren().size() - 1;
    }

    public int getLevel() {
        int n = 0;
        for (CCNavNodeInterface cCNavNodeInterface = this.parent; cCNavNodeInterface != null; cCNavNodeInterface = cCNavNodeInterface.getParent()) {
            ++n;
        }
        return n;
    }

    public void removeAllChildren() {
        List list = this.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            ((CCNavNodeInterface)list.get(i)).setParent(null);
        }
        this.children = new ArrayList();
    }

    public CCNavNodeInterface[] getPath() {
        int n;
        CCNavNodeInterface[] cCNavNodeInterfaceArray = new CCNavNodeInterface[n];
        CCNavNodeInterface cCNavNodeInterface = this.parent;
        for (n = this.getLevel(); n > 0; --n) {
            cCNavNodeInterfaceArray[n - 1] = cCNavNodeInterface;
            cCNavNodeInterface = cCNavNodeInterface.getParent();
        }
        return cCNavNodeInterfaceArray;
    }

    public List getPathList() {
        CCNavNodeInterface[] cCNavNodeInterfaceArray = this.getPath();
        ArrayList<CCNavNodeInterface> arrayList = new ArrayList<CCNavNodeInterface>(cCNavNodeInterfaceArray.length);
        for (int i = 0; i < cCNavNodeInterfaceArray.length; ++i) {
            arrayList.add(cCNavNodeInterfaceArray[i]);
        }
        return arrayList;
    }

    public CCNavNodeInterface getLastChild() {
        List list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return (CCNavNodeInterface)list.get(list.size() - 1);
    }

    public CCNavNodeInterface getFirstChild() {
        List list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return (CCNavNodeInterface)list.get(0);
    }

    public boolean isNodeChild(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface == null) {
            return false;
        }
        return this.getChildren().contains(cCNavNodeInterface);
    }

    public boolean isNodeAncestor(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface == null) {
            return false;
        }
        if (this == cCNavNodeInterface) {
            return true;
        }
        boolean bl = false;
        for (CCNavNodeInterface cCNavNodeInterface2 = this.parent; cCNavNodeInterface2 != null && !bl; cCNavNodeInterface2 = cCNavNodeInterface2.getParent()) {
            bl = cCNavNodeInterface2.equals(cCNavNodeInterface);
        }
        return bl;
    }

    public boolean isNodeDescendant(CCNavNodeInterface cCNavNodeInterface) {
        return cCNavNodeInterface.isNodeAncestor(this);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public CCNavNodeInterface hasDescendant(int n) {
        CCNavNodeInterface cCNavNodeInterface = null;
        if (this.getId() == n) {
            return this;
        }
        int n2 = this.getChildren().size();
        for (int i = 0; i < n2 && (cCNavNodeInterface = ((CCNavNodeInterface)this.getChildren().get(i)).hasDescendant(n)) == null; ++i) {
        }
        return cCNavNodeInterface;
    }

    public int getNumChildren() {
        return this.getChildren().size();
    }

    public String getImage() {
        return this.imageSrc;
    }

    public void setImage(String string) {
        this.imageSrc = string;
    }

    public void setAlarmSeverity(int n) {
        if (n < 1 && n > 5) {
            CCDebug.trace1("Invalid alarm severity : " + n);
            return;
        }
        this.alarmSeverity = n;
    }

    public int getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public List getPathToDescendant(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface == null || this.hasDescendant(cCNavNodeInterface.getId()) == null) {
            return null;
        }
        List list = cCNavNodeInterface.getPathList();
        if (list == null) {
            return null;
        }
        list = list.subList(list.indexOf(this), list.size());
        return list;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public boolean getNotClickable() {
        return this.notClickable;
    }

    public void setNotClickable(boolean bl) {
        this.notClickable = bl;
    }
}

