/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;

public class CCTopologyIconSet
implements CCTopologyModelInterface.IconSet {
    private final Object context;
    private final Map icons = new HashMap();

    public CCTopologyIconSet() {
        this.icons.put(new Integer(0), null);
        this.context = null;
    }

    public CCTopologyIconSet(Class clazz) {
        this.icons.put(new Integer(0), null);
        if (clazz == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = clazz;
    }

    public CCTopologyIconSet(ServletContext servletContext) {
        this.icons.put(new Integer(0), null);
        if (servletContext == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = servletContext;
    }

    public final void addIcon(int n, String string) {
        if (n == 0) {
            throw new IllegalArgumentException("icon == NONE (0)");
        }
        this.icons.put(new Integer(n), string);
    }

    public final void validateImage(int n) throws IOException, NoClassDefFoundError {
        if (!this.isValid(n)) {
            throw new IllegalArgumentException("Invalid icon");
        }
        if (n != 0 && this.getImage(n) == null) {
            String string = (String)this.icons.get(new Integer(n));
            if (string == null) {
                return;
            }
            if (this.context == null) {
                ImageLoader.getImage(string);
            } else if (this.context instanceof Class) {
                ImageLoader.getImage((Class)this.context, string);
            } else {
                ImageLoader.getImage((ServletContext)this.context, string);
            }
        }
    }

    public final void clearImageCache() {
        if (this.context == null) {
            ImageLoader.flushCachedImages();
        } else if (this.context instanceof Class) {
            ImageLoader.flushCachedImages((Class)this.context);
        } else {
            ImageLoader.flushCachedImages((ServletContext)this.context);
            ImageLoader.flushCachedImages();
        }
    }

    public void finalize() {
        this.clearImageCache();
    }

    public final int[] getValidIds() {
        Integer[] integerArray = this.icons.keySet().toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public final boolean isValid(int n) {
        return this.icons.containsKey(new Integer(n));
    }

    public Image getImage(int n) {
        String string = (String)this.icons.get(new Integer(n));
        return string == null ? null : (this.context == null ? ImageLoader.getCachedImage(string) : (this.context instanceof Class ? ImageLoader.getCachedImage((Class)this.context, string) : ImageLoader.getCachedImage((ServletContext)this.context, string)));
    }

    public static final class ImageLoader {
        private static final String NULL_IMAGE = "0";
        private static final Map staticCache = new HashMap();

        private ImageLoader() {
        }

        public static Image getCachedImage(String string) {
            Image image;
            String string2;
            block7: {
                if (string == null) {
                    return null;
                }
                string2 = ImageLoader.getKey("URL", string);
                Object v = staticCache.get(string2);
                if (v instanceof Image) {
                    return (Image)v;
                }
                if (NULL_IMAGE.equals(v)) {
                    return null;
                }
                image = null;
                try {
                    image = ImageLoader.getImage(string);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from URL: " + string, noClassDefFoundError);
                    }
                }
                catch (IOException iOException) {
                    if (!CCDebug.isOn()) break block7;
                    CCDebug.trace1("could not load image from URL: " + string, iOException);
                }
            }
            staticCache.put(string2, image != null ? image : NULL_IMAGE);
            return image;
        }

        public static Image getCachedImage(Class clazz, String string) {
            Image image;
            String string2;
            block7: {
                if (clazz == null || string == null) {
                    return null;
                }
                string2 = ImageLoader.getKey(clazz.getName(), string);
                Object v = staticCache.get(string2);
                if (v instanceof Image) {
                    return (Image)v;
                }
                if (NULL_IMAGE.equals(v)) {
                    return null;
                }
                image = null;
                try {
                    image = ImageLoader.getImage(clazz, string);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from class resources: " + clazz.getName() + ": " + string, noClassDefFoundError);
                    }
                }
                catch (IOException iOException) {
                    if (!CCDebug.isOn()) break block7;
                    CCDebug.trace1("could not load image from class resources: " + clazz.getName() + ": " + string, iOException);
                }
            }
            staticCache.put(string2, image != null ? image : NULL_IMAGE);
            return image;
        }

        public static Image getCachedImage(ServletContext servletContext, String string) {
            Image image;
            String string2;
            block8: {
                if (servletContext == null || string == null) {
                    return null;
                }
                string2 = ImageLoader.getKey("com.sun.web.ui.model.CCTopologyIconSet.ImageLoader", string);
                Object object = servletContext.getAttribute(string2);
                if (object instanceof Image) {
                    return (Image)object;
                }
                if (NULL_IMAGE.equals(object)) {
                    return null;
                }
                image = CCSystem.getResourceImage(string);
                if (image != null) {
                    return image;
                }
                try {
                    image = ImageLoader.getImage(servletContext, string);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (CCDebug.isOn()) {
                        CCDebug.trace1("could not load image from ServletContext resources: " + string, noClassDefFoundError);
                    }
                }
                catch (IOException iOException) {
                    if (!CCDebug.isOn()) break block8;
                    CCDebug.trace1("could not load image from ServletContext resources: " + string, iOException);
                }
            }
            servletContext.setAttribute(string2, image != null ? image : NULL_IMAGE);
            return image;
        }

        private static String getKey(String string, String string2) {
            return string + '|' + string2;
        }

        public static void flushCachedImages() {
            ImageLoader.flushCachedImages((Class)null);
        }

        public static void flushCachedImages(Class clazz) {
            String string = clazz == null ? null : ImageLoader.getKey(clazz.getName(), "");
            Iterator iterator = staticCache.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string != null && !string2.startsWith(string)) continue;
                Object v = staticCache.get(string2);
                if (v instanceof Image) {
                    ((Image)v).flush();
                }
                iterator.remove();
            }
        }

        public static void flushCachedImages(ServletContext servletContext) {
            Object object;
            if (servletContext == null) {
                return;
            }
            String string = ImageLoader.getKey("com.sun.web.ui.model.CCTopologyIconSet.ImageLoader", "");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Enumeration enumeration = servletContext.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (!((String)object).startsWith(string)) continue;
                arrayList.add(object);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                Object object2 = servletContext.getAttribute(string2);
                if (object2 instanceof Image) {
                    ((Image)object2).flush();
                }
                servletContext.removeAttribute(string2);
            }
        }

        public static Image getImage(String string) throws IOException, NoClassDefFoundError {
            if (string == null) {
                return null;
            }
            return ImageIO.read(new URL(string));
        }

        public static Image getImage(Class clazz, String string) throws IOException, NoClassDefFoundError {
            if (clazz == null || string == null) {
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = clazz.getResourceAsStream(string);
                if (inputStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    return bufferedImage;
                }
                throw new IOException("Resource not found: " + clazz.getName() + ": " + string);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }

        public static Image getImage(ServletContext servletContext, String string) throws IOException, NoClassDefFoundError {
            if (servletContext == null || string == null) {
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = servletContext.getResourceAsStream(string);
                if (inputStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    return bufferedImage;
                }
                throw new IOException("Resource not found: ServletContext: " + string);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }

        public static Image getImage(byte[] byArray) throws IOException, NoClassDefFoundError {
            if (byArray == null) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (byteArrayInputStream != null) {
                    BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                    return bufferedImage;
                }
                throw new IOException("Image byte[] not valid");
            }
            finally {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
        }
    }
}

