/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCDefaultBadgeSet;
import com.sun.web.ui.model.CCDefaultIconSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class CCTopologyModel
implements CCTopologyModelInterface {
    protected CCTopologyModelInterface.Node[][] tierNodes;
    protected CCTopologyModelInterface.Edge[] edges;
    protected CCTopologyModelInterface.IconSet iconSet;
    protected CCTopologyModelInterface.BadgeSet badgeSet;
    protected CCTopologyModelInterface.ActionSet actionSet;
    protected Map nodeMap = new HashMap();
    protected Map edgeMap = new HashMap();
    private String jatoName;
    private Map jatoValues;

    public CCTopologyModel() {
    }

    public CCTopologyModel(ServletContext servletContext) {
        this.iconSet = new CCDefaultIconSet(servletContext);
        this.badgeSet = new CCDefaultBadgeSet(servletContext);
        this.actionSet = new CCDefaultActionSet();
    }

    public CCTopologyModel(CCTopologyModelInterface.Node[][] nodeArray, CCTopologyModelInterface.Edge[] edgeArray, CCTopologyModelInterface.IconSet iconSet, CCTopologyModelInterface.BadgeSet badgeSet, CCTopologyModelInterface.ActionSet actionSet) {
        this.setTierNodes(nodeArray);
        this.setEdges(edgeArray);
        this.iconSet = iconSet;
        this.badgeSet = badgeSet;
        this.actionSet = actionSet;
    }

    public int getTierCount() {
        return this.tierNodes == null ? 0 : this.tierNodes.length;
    }

    public CCTopologyModelInterface.Node[] getTierNodes(int n) {
        if (n < 0 || n >= this.getTierCount() || this.tierNodes[n] == null) {
            return new CCTopologyModelInterface.Node[0];
        }
        return this.tierNodes[n];
    }

    public void setTierNodes(CCTopologyModelInterface.Node[][] nodeArray) {
        HashMap hashMap = new HashMap();
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                this.addNodesToMap(hashMap, nodeArray[i], i);
            }
        }
        this.tierNodes = nodeArray;
        this.nodeMap = hashMap;
    }

    private void addNodesToMap(Map map, CCTopologyModelInterface.Node[] nodeArray, int n) {
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                CCTopologyModelInterface.Node node = nodeArray[i];
                if (node == null) {
                    throw new IllegalArgumentException("tierNodes[" + n + "]...[" + i + "] == null");
                }
                map.put(node.getId(), node);
                if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                this.addNodesToMap(map, ((CCTopologyModelInterface.GroupNode)node).getNodes(), n);
            }
        }
    }

    public CCTopologyModelInterface.Edge[] getEdges() {
        return this.edges == null ? new CCTopologyModelInterface.Edge[]{} : this.edges;
    }

    public void setEdges(CCTopologyModelInterface.Edge[] edgeArray) {
        HashMap<String, CCTopologyModelInterface.Edge> hashMap = new HashMap<String, CCTopologyModelInterface.Edge>();
        if (edgeArray != null) {
            for (int i = 0; i < edgeArray.length; ++i) {
                CCTopologyModelInterface.Edge edge = edgeArray[i];
                if (edge == null) {
                    throw new IllegalArgumentException("edges[" + i + "] == null");
                }
                hashMap.put(edge.getId(), edge);
            }
        }
        this.edges = edgeArray;
        this.edgeMap = hashMap;
    }

    public CCTopologyModelInterface.IconSet getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(CCTopologyModelInterface.IconSet iconSet) {
        this.iconSet = iconSet;
    }

    public CCTopologyModelInterface.BadgeSet getBadgeSet() {
        return this.badgeSet;
    }

    public void setBadgeSet(CCTopologyModelInterface.BadgeSet badgeSet) {
        this.badgeSet = badgeSet;
    }

    public CCTopologyModelInterface.ActionSet getActionSet() {
        return this.actionSet;
    }

    public void setActionSet(CCTopologyModelInterface.ActionSet actionSet) {
        this.actionSet = actionSet;
    }

    public CCTopologyModelInterface.Node getNode(String string) {
        return (CCTopologyModelInterface.Node)this.nodeMap.get(string);
    }

    public CCTopologyModelInterface.Edge getEdge(String string) {
        return (CCTopologyModelInterface.Edge)this.edgeMap.get(string);
    }

    public String getName() {
        return this.jatoName != null ? this.jatoName : "TopologyModel_" + this.hashCode();
    }

    public Object getValue(String string) {
        return this.jatoValues != null ? this.jatoValues.get(string) : null;
    }

    public Object[] getValues(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return new Object[]{object};
    }

    public void setName(String string) {
        this.jatoName = string;
    }

    public synchronized void setValue(String string, Object object) {
        if (this.jatoValues == null) {
            this.jatoValues = new HashMap();
        }
        this.jatoValues.put(string, object);
    }

    public void setValues(String string, Object[] objectArray) {
        this.setValue(string, objectArray);
    }
}

