/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.ClassUtil;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCWizardModelInterface;
import com.sun.web.ui.model.WizardInterfaceExtImpl;
import com.sun.web.ui.model.wizard.WizardCache;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.model.wizard.WizardInterfaceExt;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;

public class CCWizardModel
extends DefaultModel
implements CCWizardModelInterface,
RequestParticipant,
RequestCompletionListener {
    DefaultModel wizardModel = new DefaultModel();
    private final String WIZARD_NAME = this.getQualifiedName("wizName");
    private final String HTTP_GET = "get";
    private WizardInterface wizard;
    private WizardState wizardState;
    private transient WizardInterfaceExt wizardExt;
    private transient RequestContext requestContext;

    public String initialize(String string) {
        if (string == null) {
            if (this.wizardState != null) {
                return this.wizardState.id;
            }
            throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : wizardState is null cannot continue.\n" + "Check the request parameters on the " + "initial GET request");
        }
        return this.createWizard(string, null);
    }

    protected String createWizard(String string, String string2) {
        Object object = WizardCache.get(string);
        if (object == null) {
            if (string2 == null) {
                throw new IllegalArgumentException("Cannot create a wizard without the wizClassName request parameter.");
            }
            this.wizard = this.getWizardFromFactory(string, string2);
            WizardCache.put(string, this.wizard);
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
            this.wizardState = new WizardState(this.wizard, this.wizardExt, string, WizardCache.getId(string + "_"));
            this.wizardState.name = string;
            WizardCache.put(this.wizardState.id, this.wizardState);
        } else if (object instanceof WizardInterface) {
            this.wizard = (WizardInterface)object;
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
            this.wizardState = new WizardState(this.wizard, this.wizardExt, string, WizardCache.getId(string + "_"));
            WizardCache.put(this.wizardState.id, this.wizardState);
        } else if (object instanceof WizardState) {
            this.wizardState = (WizardState)object;
            this.wizard = this.wizardState.wizard;
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
        }
        return this.wizardState.id;
    }

    public String dumpState() {
        return this.wizardState.toString();
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        String string = this.getParameter("wizName", requestContext);
        String string2 = this.getParameter("wizClassName", requestContext);
        if (string != null && string2 != null) {
            this.createWizard(string, string2);
        }
    }

    private WizardInterface getWizardFromFactory(String string, String string2) {
        WizardInterface wizardInterface = null;
        Object var4_4 = null;
        try {
            Class clazz = ClassUtil.getClass((String)string2);
            Method method = clazz.getMethod("create", RequestContext.class);
            Object[] objectArray = new Object[]{this.requestContext};
            wizardInterface = (WizardInterface)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.throwIllegalArgumentException(exception, "Failed to create WizardInterface \"" + string + "\" instance from " + " " + string2);
        }
        if (wizardInterface == null) {
            this.throwIllegalArgumentException(null, "Failed to create WizardInterface \"" + string + "\" instance from " + " " + string2);
        }
        return wizardInterface;
    }

    private void throwIllegalArgumentException(Exception exception, String string) {
        Throwable throwable;
        String string2 = null;
        if (exception != null && (throwable = exception.getCause()) != null) {
            string2 = throwable.getMessage();
        }
        string2 = string2 == null ? string : string2 + "\n" + string;
        throw new IllegalArgumentException(string2);
    }

    public void requestComplete() {
        if (this.wizardState.isDone()) {
            WizardCache.remove(this.wizardState.id);
            if (this.wizard.done(this.wizardState.name)) {
                WizardCache.remove(this.wizardState.name);
            }
        }
    }

    public boolean nextRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("NEXT");
        boolean bl = this.wizard.nextStep(wizardEvent);
        if (bl) {
            this.wizardState.nextRequest();
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    public boolean previousRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("PREVIOUS");
        boolean bl = this.wizard.previousStep(wizardEvent);
        if (bl) {
            this.wizardState.previousRequest();
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    public boolean cancelRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("CANCEL");
        boolean bl = this.wizard.cancelStep(wizardEvent);
        if (bl) {
            this.wizardState.cancelRequest();
        }
        return bl;
    }

    public boolean finishRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("FINISH");
        boolean bl = this.wizard.finishStep(wizardEvent);
        if (bl) {
            this.wizardState.finishRequest();
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    public void closeRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("CLOSE");
        this.wizardExt.closeStep(wizardEvent);
        this.wizardState.closeRequest();
        this.processEvent(true, wizardEvent, "errorPrompt");
    }

    public boolean gotoRequest(View view) {
        String string = (String)this.getValue("pagingHref");
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, string, this.wizardState.name);
        wizardEvent.setEvent("GOTO");
        boolean bl = this.wizard.gotoStep(wizardEvent);
        if (bl) {
            this.wizardState.gotoRequest(string);
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    public boolean helpRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("HELP");
        boolean bl = this.wizardExt.helpTab(wizardEvent);
        if (bl) {
            this.wizardState.activeTab = 1;
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    public boolean stepRequest(View view) {
        WizardEvent wizardEvent = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        wizardEvent.setEvent("STEP");
        boolean bl = this.wizardExt.stepTab(wizardEvent);
        if (bl) {
            this.wizardState.activeTab = 0;
        }
        this.processEvent(bl, wizardEvent, "errorPrompt");
        return bl;
    }

    private void processEvent(boolean bl, WizardEvent wizardEvent, String string) {
        if (bl) {
            this.setValue(string, null);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(wizardEvent.getSeverity()), wizardEvent.getErrorMessage()};
        this.setValue(string, objectArray);
    }

    public Model getCurrentPageModel() {
        Model model = this.wizard.getPageModel(this.wizardState.currentPageId);
        if (model == null) {
            model = new DefaultModel();
        }
        return model;
    }

    public int getActiveTab() {
        return this.wizardState.activeTab;
    }

    public boolean firstPageSeen() {
        return this.wizardState.firstPageSeen;
    }

    public String[] getVisitedPages() {
        if (this.wizardState.visitedPages.size() == 0) {
            return null;
        }
        Object[] objectArray = this.wizardState.visitedPages.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public String[] getVisitedSteps() {
        Object[] objectArray = this.wizardState.visitedPages.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = this.wizard.getStepText((String)objectArray[i]);
        }
        return stringArray;
    }

    public String getResourceBundle() {
        return this.wizard.getResourceBundle();
    }

    public Class getCurrentPageClass() {
        if (this.wizardState == null || this.wizardState.state == this.wizardState.CMD_LAST) {
            return null;
        }
        return this.wizard.getPageClass(this.wizardState.currentPageId);
    }

    public String getTitle() {
        return this.wizard.getTitle();
    }

    public String getStepTitle() {
        return this.wizard.getStepTitle(this.wizardState.currentPageId);
    }

    public String getStepTitle(String string) {
        return this.wizard.getStepTitle(string);
    }

    public String[] getFuturePages() {
        return this.wizard.getFuturePages(this.wizardState.currentPageId);
    }

    public String[] getFutureSteps() {
        return this.wizard.getFutureSteps(this.wizardState.currentPageId);
    }

    public String getStepInstruction() {
        return this.wizard.getStepInstruction(this.wizardState.currentPageId);
    }

    public String getStepText() {
        return this.wizard.getStepText(this.wizardState.currentPageId);
    }

    public String[] getStepHelp() {
        return this.wizard.getStepHelp(this.wizardState.currentPageId);
    }

    public String getCancelPrompt() {
        return this.wizard.getCancelPrompt(this.wizardState.currentPageId);
    }

    public String getWizardName() {
        return this.wizardState.id;
    }

    public boolean isFinishPage() {
        return this.wizard.isFinishPageId(this.wizardState.currentPageId);
    }

    public boolean hasPreviousPage() {
        return this.wizard.hasPreviousPageId(this.wizardState.currentPageId);
    }

    public boolean isSubstep(String string) {
        return this.wizardExt.isSubstep(string);
    }

    public String getCurrentPageId() {
        return this.wizardState.currentPageId;
    }

    public String getPlaceholderText(String string) {
        return this.wizardExt.getPlaceholderText(string);
    }

    public boolean isResultsPage() {
        return this.wizardState.state == this.wizardState.CMD_FINISH;
    }

    public boolean canBeStepLink(String string) {
        return !this.isResultsPage() && this.wizardExt.canBeStepLink(string);
    }

    private Object getWizardValue(String string) {
        if (string.equals(this.WIZARD_NAME)) {
            return this.wizardState.id;
        }
        if (string.equals("visitedPages")) {
            return this.getVisitedPages();
        }
        if (string.equals("visitedSteps")) {
            return this.getVisitedSteps();
        }
        if (string.equals("futureSteps")) {
            return this.getFutureSteps();
        }
        if (string.equals("currentStep")) {
            return this.getStepText();
        }
        if (string.equals("wizardTitle")) {
            return this.getTitle();
        }
        if (string.equals("stepTitle")) {
            return this.getStepTitle();
        }
        if (string.equals("stepInstruction")) {
            return this.getStepInstruction();
        }
        if (string.equals("stepHelp")) {
            return this.getStepHelp();
        }
        if (string.equals("cancelPrompt")) {
            return this.getCancelPrompt();
        }
        return this.wizardModel.getValue(string);
    }

    private Object[] getWizardValues(String string) {
        if (string.equals(this.WIZARD_NAME)) {
            return new Object[]{this.wizardState.id};
        }
        if (string.equals("visitedPages")) {
            return this.getVisitedPages();
        }
        if (string.equals("visitedSteps")) {
            return this.getVisitedSteps();
        }
        if (string.equals("futureSteps")) {
            return this.getFutureSteps();
        }
        if (string.equals("currentStep")) {
            return new Object[]{this.getStepText()};
        }
        if (string.equals("wizardTitle")) {
            return new Object[]{this.getTitle()};
        }
        if (string.equals("stepTitle")) {
            return new Object[]{this.getStepTitle()};
        }
        if (string.equals("stepInstruction")) {
            return new Object[]{this.getStepInstruction()};
        }
        if (string.equals("stepHelp")) {
            return new Object[]{this.getStepHelp()};
        }
        if (string.equals("cancelPrompt")) {
            return new Object[]{this.getCancelPrompt()};
        }
        return this.wizardModel.getValues(string);
    }

    public Object getValue(String string) {
        Object object = this.getWizardValue(string);
        return object;
    }

    public Object[] getValues(String string) {
        Object[] objectArray = this.getWizardValues(string);
        return objectArray;
    }

    public void setValue(String string, Object object) throws ValidationException {
        this.wizardModel.setValue(string, object);
    }

    public void setValues(String string, Object[] objectArray) throws ValidationException {
        this.wizardModel.setValues(string, objectArray);
    }

    public String getFirstPageId() {
        return this.wizard.getFirstPageId();
    }

    private String getParameter(String string, RequestContext requestContext) {
        HttpServletRequest httpServletRequest = this.requestContext.getRequest();
        Map map = this.requestContext.getRequest().getParameterMap();
        String[] stringArray = (String[])map.get(this.getQualifiedName(string));
        return stringArray == null ? null : stringArray[0];
    }

    private String getQualifiedName(String string) {
        return "WizardWindow." + string;
    }

    class WizardState
    implements Serializable {
        static final long serialVersionUID = 4439992595001302854L;
        final int CMD_FIRST = 0;
        final int CMD_PREVIOUS = 1;
        final int CMD_NEXT = 2;
        final int CMD_LAST = 3;
        final int CMD_HELP = 4;
        final int CMD_STEPS = 5;
        final int CMD_PAGE = 6;
        final int CMD_WAIT = 7;
        final int CMD_ERROR = 8;
        final int CMD_CANCEL = 9;
        final int CMD_FINISH = 10;
        WizardInterface wizard;
        String id;
        String name;
        String currentPageId;
        int state;
        Stack visitedPages;
        int activeTab;
        boolean firstPageSeen;

        public WizardState(WizardInterface wizardInterface, WizardInterfaceExt wizardInterfaceExt, String string, String string2) {
            this.wizard = wizardInterface;
            this.id = string2;
            this.name = string;
            this.visitedPages = new Stack();
            this.activeTab = 0;
            this.state = 0;
            this.currentPageId = wizardInterface.getFirstPageId();
            this.firstPageSeen = false;
        }

        public boolean isDone() {
            return this.state == 3 || this.state == 9;
        }

        public void nextRequest() {
            this.firstPageSeen = true;
            this.state = 2;
            this.visitedPages.push(this.currentPageId);
            this.currentPageId = this.wizard.getNextPageId(this.currentPageId);
        }

        public void previousRequest() {
            this.state = 1;
            try {
                this.currentPageId = (String)this.visitedPages.pop();
            }
            catch (EmptyStackException emptyStackException) {
                CCDebug.trace1("The application wizard returned success for previousStep but there is no previous page.");
            }
        }

        public void cancelRequest() {
            this.state = 9;
        }

        public void finishRequest() {
            String string = CCWizardModel.this.wizardExt.getResultsPageId(this.currentPageId);
            if (string != null) {
                this.state = 10;
                this.visitedPages.push(this.currentPageId);
                this.currentPageId = string;
            } else {
                this.state = 3;
            }
        }

        public void closeRequest() {
            this.state = 3;
        }

        public void gotoRequest(String string) {
            this.state = 6;
            try {
                while (!((String)this.visitedPages.pop()).equals(string)) {
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : page " + string + " has not been seen.");
            }
            this.currentPageId = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("wizard = ").append(this.wizard).append("\nid = ").append(this.id).append("\nname = ").append(this.name).append("\nvisitedPages = ").append(this.visitedPages).append("\nactiveTab = ").append(this.activeTab).append("\ncurrentPageId = ").append(this.currentPageId).append("\nstate = ").append(this.state);
            return stringBuffer.toString();
        }

        private void debugout(String string) {
            System.out.println("\n** " + CCDebug.getClassMethod(1) + " : " + string + " **\n");
        }
    }
}

