/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.help2;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCSystem;
import java.beans.Beans;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.Merge;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.ServletHelpBroker;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Help2Utils
implements SearchListener {
    private ServletHelpBroker helpBroker;
    private TOCView tocView;
    private Enumeration tocTreeEnum;
    private ArrayList tocTreeList;
    private DefaultMutableTreeNode tocTopNode;
    private IndexView indexView;
    private Enumeration indexTreeEnum;
    private ArrayList indexTreeList;
    private DefaultMutableTreeNode indexTopNode;
    private SearchView searchView;
    private MergingSearchEngine helpSearch;
    private SearchQuery searchQuery;
    private Vector searchNodes;
    private Enumeration searchEnum;
    private boolean searchFinished;
    private String appName;
    private String pathPrefix;
    private Locale tagsLocale;
    public static final String BASE_ID = "root";
    protected static final String SECURE_SCHEME = "https";
    protected static final String UNSECURE_SCHEME = "http";
    protected static final String FILE_SCHEME = "file";
    protected static final String HTML_DIR = "html";
    protected static final String HELP_DIR = "help";
    protected static final String DEFAULT_HELPSET_NAME = "app.hs";
    protected static final String TIPS_ON_SEARCHING_FILE = "tips_on_searching.html";

    public Help2Utils(HttpServletRequest httpServletRequest, String string) {
        CCDebug.initTrace();
        this.appName = string;
        this.tagsLocale = CCI18N.getTagsLocale((ServletRequest)httpServletRequest);
        this.initHelp(httpServletRequest);
    }

    public Help2Utils(HttpServletRequest httpServletRequest, String string, String string2) {
        CCDebug.initTrace();
        this.appName = string;
        if (string2 != null && string2.length() != 0 && string2.trim().length() != 0) {
            this.pathPrefix = string2.trim();
        }
        this.tagsLocale = CCI18N.getTagsLocale((ServletRequest)httpServletRequest);
        this.initHelp(httpServletRequest);
    }

    public String getTipsOnSearchingPath(ServletContext servletContext) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("/").append(this.getHelpPath(this.appName)).append("/html/" + this.tagsLocale.toString() + "/" + HELP_DIR + "/" + TIPS_ON_SEARCHING_FILE);
        String string = this.clean(nonSyncStringBuffer.toString());
        if (servletContext.getResourceAsStream(string) != null) {
            return string;
        }
        nonSyncStringBuffer = new NonSyncStringBuffer(CCSystem.getResourceContextPath() + "/" + HTML_DIR + "/" + this.tagsLocale.toString() + "/" + HELP_DIR + "/" + TIPS_ON_SEARCHING_FILE);
        return this.clean(nonSyncStringBuffer.toString());
    }

    private void initHelp(HttpServletRequest httpServletRequest) {
        this.instantiateHelpBroker(httpServletRequest);
        String string = this.getDefaultHelpSetPath(httpServletRequest);
        CCDebug.trace3("hsPath: " + string);
        this.validateHelpSet(httpServletRequest, string, false);
        this.validateID(null);
        this.initNavigatorViews();
    }

    private void instantiateHelpBroker(HttpServletRequest httpServletRequest) {
        try {
            this.helpBroker = (ServletHelpBroker)Beans.instantiate(this.getClass().getClassLoader(), "javax.help.ServletHelpBroker");
        }
        catch (ClassNotFoundException classNotFoundException) {
            CCDebug.trace1("Cannot instantiate ServletHelpBroker." + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            CCDebug.trace1("Cannot create bean of class ServletHelpBroker." + exception.getMessage());
        }
    }

    public ServletHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public String getDefaultHelpSetPath(HttpServletRequest httpServletRequest) {
        if (this.appName == null) {
            this.appName = httpServletRequest.getContextPath();
            if (this.appName == null) {
                CCDebug.trace1("Unable to obtain app name from request.");
                this.appName = "";
            } else {
                this.appName = HtmlUtil.escape((String)this.appName);
                if (this.appName.startsWith("/")) {
                    this.appName = this.appName.substring(1);
                }
            }
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("/").append(this.getHelpPath(this.appName)).append("/").append(HTML_DIR).append("/").append(this.tagsLocale.toString()).append("/").append(HELP_DIR).append("/").append(DEFAULT_HELPSET_NAME);
        return this.clean(nonSyncStringBuffer.toString());
    }

    private String getHelpPath(String string) {
        if (string == null || string.length() == 0) {
            return HTML_DIR;
        }
        if (this.pathPrefix == null) {
            return string;
        }
        this.pathPrefix = HtmlUtil.escape((String)this.pathPrefix);
        if (this.pathPrefix.startsWith("/" + string + "/")) {
            return this.pathPrefix;
        }
        return string + "/" + this.pathPrefix;
    }

    private void initNavigatorViews() {
        HelpSet helpSet = this.helpBroker.getHelpSet();
        Locale locale = helpSet.getLocale();
        this.tocView = (TOCView)helpSet.getNavigatorView("TOC");
        if (this.tocView != null) {
            this.tocTopNode = this.tocView.getDataAsTree();
            this.addSubHelpSets(helpSet);
            this.tocTreeEnum = this.tocTopNode.preorderEnumeration();
            this.setTOCTreeList();
        }
        this.indexView = (IndexView)helpSet.getNavigatorView("Index");
        if (this.indexView != null) {
            this.indexTopNode = this.indexView.getDataAsTree();
            this.indexTreeEnum = this.indexTopNode.preorderEnumeration();
            this.setIndexTreeList();
        }
        this.searchView = (SearchView)helpSet.getNavigatorView("Search");
    }

    public void validateHelpSet(HttpServletRequest httpServletRequest, String string, boolean bl) {
        HelpSet helpSet = this.helpBroker.getHelpSet();
        if (helpSet != null) {
            if (string == null) {
                return;
            }
            HelpSet helpSet2 = this.createHelpSet(httpServletRequest, string);
            if (bl && !helpSet.contains(helpSet2)) {
                helpSet.add(helpSet2);
            } else {
                this.helpBroker.setHelpSet(helpSet2);
            }
        } else {
            if (string == null) {
                CCDebug.trace1("Invalid URL path: " + string);
                return;
            }
            this.helpBroker.setHelpSet(this.createHelpSet(httpServletRequest, string));
        }
    }

    public void validateID(String string) {
        if (string != null) {
            this.helpBroker.setCurrentID(string);
        } else if (this.helpBroker.getCurrentID() == null && this.helpBroker.getCurrentURL() == null) {
            try {
                this.helpBroker.setCurrentID(this.helpBroker.getHelpSet().getHomeID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                // empty catch block
            }
        }
    }

    public void setCurrentHelpPage(URL uRL) {
        this.helpBroker.setCurrentURL(uRL);
    }

    private HelpSet createHelpSet(HttpServletRequest httpServletRequest, String string) {
        Object object;
        HelpSet helpSet = null;
        String string2 = null;
        int n = string.indexOf(":");
        if (n > 0 && (((String)(object = string.substring(0, n))).equalsIgnoreCase(SECURE_SCHEME) || ((String)object).equalsIgnoreCase(UNSECURE_SCHEME) || ((String)object).equalsIgnoreCase(FILE_SCHEME))) {
            string2 = string;
        }
        if (string2 == null) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            string2 = CCSystem.getHelpUrlHeader(httpServletRequest) + string;
        }
        try {
            object = new URL(string2);
            helpSet = new HelpSet(null, (URL)object);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (HelpSetException helpSetException) {
            if (!this.tagsLocale.equals(Locale.ENGLISH)) {
                this.tagsLocale = Locale.ENGLISH;
                try {
                    helpSet = this.createHelpSet(httpServletRequest, this.getDefaultHelpSetPath(httpServletRequest));
                }
                catch (Exception exception) {
                    CCDebug.trace1("Can not create helpset for en locale: " + exception.getMessage());
                    throw new RuntimeException(exception);
                }
            }
            CCDebug.trace1("Can not create helpset for en locale: " + helpSetException.getMessage());
            throw new RuntimeException(helpSetException);
        }
        return helpSet;
    }

    private void addSubHelpSets(HelpSet helpSet) {
        Enumeration enumeration = helpSet.getHelpSets();
        while (enumeration.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
            if (helpSet2 == null) continue;
            NavigatorView[] navigatorViewArray = helpSet2.getNavigatorViews();
            for (int i = 0; i < navigatorViewArray.length; ++i) {
                Merge merge;
                if (!(navigatorViewArray[i] instanceof TOCView) || (merge = Merge.DefaultMergeFactory.getMerge((NavigatorView)this.tocView, (NavigatorView)navigatorViewArray[i])) == null) continue;
                merge.processMerge((TreeNode)this.tocTopNode);
            }
            this.addSubHelpSets(helpSet2);
        }
    }

    public String getID(TreeNode treeNode) {
        if (treeNode == this.tocTopNode) {
            return BASE_ID;
        }
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 == null) {
            return "";
        }
        String string = this.getID(treeNode2);
        return string.concat("_" + Integer.toString(treeNode2.getIndex(treeNode)));
    }

    public String getContentURL(TreeItem treeItem) {
        URL uRL = null;
        Map.ID iD = treeItem.getID();
        if (iD != null) {
            HelpSet helpSet = iD.hs;
            Map map = helpSet.getLocalMap();
            try {
                uRL = map.getURLFromID(iD);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL != null ? uRL.toExternalForm() : "";
    }

    public String getExternalContentURL(TreeItem treeItem, HttpServletRequest httpServletRequest) {
        String string = null;
        Map.ID iD = treeItem.getID();
        if (iD != null) {
            HelpSet helpSet = iD.hs;
            Map map = helpSet.getLocalMap();
            try {
                string = this.getExternalContentURL(map.getURLFromID(iD), httpServletRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String getExternalContentURL(URL uRL, HttpServletRequest httpServletRequest) {
        String string = this.clean(uRL.getPath());
        String string2 = null;
        if (uRL != null && uRL.getPath().length() > 0) {
            string2 = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + Integer.toString(httpServletRequest.getServerPort()) + string;
            if (uRL.getRef() != null) {
                string2 = string2 + "#" + uRL.getRef();
            }
        }
        return string2;
    }

    private void setTOCTreeList() {
        this.tocTreeList = new ArrayList();
        while (this.tocTreeEnum.hasMoreElements()) {
            this.tocTreeList.add(this.tocTreeEnum.nextElement());
        }
    }

    public ArrayList getTOCTreeList() {
        if (this.tocTreeList == null) {
            this.setTOCTreeList();
        }
        return this.tocTreeList;
    }

    private void setIndexTreeList() {
        this.indexTreeList = new ArrayList();
        while (this.indexTreeEnum.hasMoreElements()) {
            this.indexTreeList.add(this.indexTreeEnum.nextElement());
        }
    }

    public ArrayList getIndexTreeList() {
        if (this.indexTreeList == null) {
            this.setIndexTreeList();
        }
        return this.indexTreeList;
    }

    public synchronized Enumeration doSearch(String string) {
        if (string == null) {
            return null;
        }
        if (this.helpSearch == null) {
            if (this.searchView == null) {
                this.searchView = (SearchView)this.helpBroker.getHelpSet().getNavigatorView("Search");
            }
            if (this.searchView == null) {
                return null;
            }
            this.helpSearch = new MergingSearchEngine((NavigatorView)this.searchView);
            this.searchQuery = this.helpSearch.createQuery();
            this.searchQuery.addSearchListener((SearchListener)this);
        }
        if (this.searchQuery.isActive()) {
            this.searchQuery.stop();
        }
        this.searchFinished = false;
        this.searchQuery.start(string, this.tagsLocale);
        if (!this.searchFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.searchEnum;
    }

    public synchronized void searchStarted(SearchEvent searchEvent) {
        this.searchNodes = new Vector();
        this.searchFinished = false;
    }

    public synchronized void searchFinished(SearchEvent searchEvent) {
        this.searchFinished = true;
        this.searchEnum = this.searchNodes.elements();
        this.notifyAll();
    }

    public synchronized void itemsFound(SearchEvent searchEvent) {
        Enumeration enumeration = searchEvent.getSearchItems();
        while (enumeration.hasMoreElements()) {
            SearchTOCItem searchTOCItem;
            URL uRL;
            SearchItem searchItem = (SearchItem)enumeration.nextElement();
            try {
                uRL = new URL(searchItem.getBase(), searchItem.getFilename());
            }
            catch (MalformedURLException malformedURLException) {
                CCDebug.trace3("Could not create URL from: " + searchItem.getBase() + "|" + searchItem.getFilename());
                continue;
            }
            boolean bl = false;
            Enumeration enumeration2 = this.searchNodes.elements();
            while (enumeration2.hasMoreElements()) {
                searchTOCItem = (SearchTOCItem)enumeration2.nextElement();
                URL uRL2 = searchTOCItem.getURL();
                if (uRL2 == null || uRL == null || !uRL.sameFile(uRL2)) continue;
                searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
                bl = true;
                break;
            }
            if (bl) continue;
            searchTOCItem = new SearchTOCItem(searchItem);
            this.searchNodes.addElement(searchTOCItem);
        }
    }

    private String clean(String string) {
        return string.replaceAll("//*", "/");
    }

    public void printDebug() {
        ArrayList arrayList = this.getTOCTreeList();
        if (arrayList == null) {
            CCDebug.trace1("tocTreeList null.");
            return;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("tocTreeList dump:\n");
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(i);
            nonSyncStringBuffer.append(this.tocTreeToString(defaultMutableTreeNode)).append("\n");
        }
        ArrayList arrayList2 = this.getIndexTreeList();
        if (arrayList2 == null) {
            CCDebug.trace1("indexTreeList null.");
            return;
        }
        nonSyncStringBuffer = new NonSyncStringBuffer("indexTreeList dump:\n");
        n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList2.get(i);
            nonSyncStringBuffer.append(this.indexTreeToString(defaultMutableTreeNode)).append("\n");
        }
    }

    public String tocTreeToString(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return "\n\tTOC tree node is null.";
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem == null) {
            return "\n\tTOCItem is null.";
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        nonSyncStringBuffer.append("\n\tname:          " + tOCItem.getName());
        nonSyncStringBuffer.append("\n\thelpID:        " + (tOCItem.getID() != null ? tOCItem.getID().id : ""));
        nonSyncStringBuffer.append("\n\tparentID:        " + (defaultMutableTreeNode2 != null ? Integer.toHexString(defaultMutableTreeNode2.hashCode()) : ""));
        nonSyncStringBuffer.append("\n\tparentID 2:      " + this.getID(defaultMutableTreeNode2));
        nonSyncStringBuffer.append("\n\tnode:          " + Integer.toHexString(defaultMutableTreeNode.hashCode()));
        nonSyncStringBuffer.append("\n\tnodeID:        " + this.getID(defaultMutableTreeNode));
        nonSyncStringBuffer.append("\n\tcontentURL:    " + this.getContentURL((TreeItem)tOCItem));
        nonSyncStringBuffer.append("\n\texpansionType: " + Integer.toString(tOCItem.getExpansionType()));
        return nonSyncStringBuffer.toString();
    }

    public String indexTreeToString(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return "\n\tTree node is null.";
        }
        IndexItem indexItem = (IndexItem)defaultMutableTreeNode.getUserObject();
        if (indexItem == null) {
            return "\n\tIndexItem is null.";
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        nonSyncStringBuffer.append("\n\tname:          " + indexItem.getName());
        nonSyncStringBuffer.append("\n\thelpID:        " + (indexItem.getID() != null ? indexItem.getID().id : ""));
        nonSyncStringBuffer.append("\n\tparentID:        " + (defaultMutableTreeNode2 != null ? Integer.toHexString(defaultMutableTreeNode2.hashCode()) : ""));
        nonSyncStringBuffer.append("\n\tparentID 2:      " + this.getID(defaultMutableTreeNode2));
        nonSyncStringBuffer.append("\n\tnode:          " + Integer.toHexString(defaultMutableTreeNode.hashCode()));
        nonSyncStringBuffer.append("\n\tnodeID:        " + this.getID(defaultMutableTreeNode));
        nonSyncStringBuffer.append("\n\texpansionType: " + Integer.toString(indexItem.getExpansionType()));
        return nonSyncStringBuffer.toString();
    }

    public static String enforceNumericString(String string) {
        if (string == null) {
            return string;
        }
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return "0";
        }
        return string;
    }

    public static String escapeJsEvent(String string) {
        if (string == null) {
            return string;
        }
        String string2 = "(?i)o((?i)nblur|nerror|nload|nchange|nfocus|nreset|nselect|nsubmit|nabort|nkeydown|nkeypress|nkeyup|nclick|ndblclick|nmousedown|nmousemove|nmouseout|nmouseover|nmouseup)";
        String string3 = "#$1";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.replaceAll(string3);
        }
        return string;
    }
}

