/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCTopologyEdge;
import com.sun.web.ui.model.CCTopologyIconSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.model.CCTopologyNode;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class CCDefaultTopologyRenderer
implements CCTopologyRenderer {
    private static final int DEFAULT_ICON_SIZE = 8;
    private static final int EDGE_HOT_SPACE = 2;
    private static final int TEXT_HSPACE = 5;
    private static final int TEXT_VSPACE = 1;
    private static final int MIN_EDGE_LENGTH = 10;
    private static final int ARROW_SPACE = 7;
    private static final int NODE_SPACE = 5;
    private static final int EDGE_SPACE = 4;
    private static final int BADGE_OVERHANG = 3;
    private static final String TURNER_OPEN = "topologyTurnerOpen.gif";
    private static final String TURNER_CLOSED = "topologyTurnerClosed.gif";
    private static final String TURNER_CLOSED_WLINE = "topologyTurnerClosedWithLine.gif";
    private static final int TURNER_CENTER = 4;
    private static final int TURNER_NARROW = 5;
    private static final int TURNER_WIDE = 9;
    private static final int TURNER_HEIGHT = 13;
    private static final int PLURAL_IMAGE_COUNT = 3;
    private static final int PLURAL_IMAGE_OFFSET = 4;
    private static final int PLURAL_EXTRA = 8;
    private static final int GROUP_LINE_WIDTH = 1;
    private static final int GROUP_LINE_HEIGHT = 1;
    private static final int GROUP_LINE_SPACE = 5;
    private static final int GROUP_INDENT = 25;
    private static final int GROUP_BOX_WIDTH = 38;
    private static final int GROUP_BOX_HEIGHT = 32;
    private static final int NODE_EDGE_SPACE = 3;
    private static final Color BG_COLOR = Color.white;
    private static final Color FG_COLOR = Color.black;
    private static final Object NULL_SIZE = new Object();
    private static final Color GROUP_LINE_COLOR = new Color(204, 204, 204);
    private static final Color FILTER_COLOR = new Color(204, 204, 204);
    private static final Stroke STROKE_1PIXEL = new BasicStroke(1.0f);
    private static final Stroke STROKE_3PIXEL = new BasicStroke(3.0f, 0, 0);
    private static final Stroke STROKE_5PIXEL = new BasicStroke(5.0f, 0, 0);
    private final CCTopologyModelInterface model;
    private final Font font;
    private final FontRenderContext fontContext;
    private final CCI18N cci18n;
    private final CCI18N i18n;
    private DisplayModel displayModel;
    private Dimension size;
    private final Map pluralImages = new WeakHashMap();
    private final Map filteredImages = new WeakHashMap();
    private final Map badgeSizes = new HashMap();

    public CCDefaultTopologyRenderer(CCTopologyModelInterface cCTopologyModelInterface, CCI18N cCI18N, CCI18N cCI18N2, Font font) {
        this.validateModel(cCTopologyModelInterface);
        this.model = cCTopologyModelInterface;
        this.cci18n = cCI18N;
        this.i18n = cCI18N2;
        this.font = font != null ? font : this.getDefaultLabelFont();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 9);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        this.fontContext = graphics2D.getFontRenderContext();
        graphics2D.dispose();
        bufferedImage.flush();
    }

    public static Image createPluralImage(Image image) {
        if (image == null) {
            return null;
        }
        int n = 8;
        int n2 = image.getWidth(null) + n;
        int n3 = image.getHeight(null) + n;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 9);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, n2, n3);
        int n4 = 0;
        int n5 = 0;
        while (n4 < 3) {
            graphics2D.drawImage(image, n5, n5, BG_COLOR, null);
            ++n4;
            n5 += 4;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image createFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.2f);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 9);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(image, 0, 0, BG_COLOR, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public final CCTopologyModelInterface getModel() {
        return this.model;
    }

    public final void renderModel() {
        this.layoutImage();
    }

    public Dimension getImageSize() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        return this.size;
    }

    public final BufferedImage getImage(Rectangle rectangle) {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        BufferedImage bufferedImage = null;
        try {
            int n = rectangle == null ? this.size.width : Math.min(this.size.width, rectangle.width);
            int n2 = rectangle == null ? this.size.height : Math.min(this.size.height, rectangle.height);
            bufferedImage = new BufferedImage(n, n2, 9);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            CCDebug.trace1("Could not create off-screen image", outOfMemoryError);
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (rectangle != null) {
            graphics2D.setTransform(AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
            graphics2D.clip(rectangle);
        }
        try {
            this.drawTopology(graphics2D);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            CCDebug.trace1("Could not draw topology image", throwable);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public CCTopologyModelInterface.Node[] getDisplayedNodes() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        CCTopologyModelInterface.Node[] nodeArray = this.displayModel.getTierNodes(0);
        CCTopologyModelInterface.Node[] nodeArray2 = this.displayModel.getTierNodes(1);
        CCTopologyModelInterface.Node[] nodeArray3 = this.displayModel.getTierNodes(2);
        CCTopologyModelInterface.Node[] nodeArray4 = new CCTopologyModelInterface.Node[nodeArray.length + nodeArray2.length + nodeArray3.length];
        System.arraycopy(nodeArray, 0, nodeArray4, 0, nodeArray.length);
        System.arraycopy(nodeArray2, 0, nodeArray4, nodeArray.length, nodeArray2.length);
        System.arraycopy(nodeArray3, 0, nodeArray4, nodeArray.length + nodeArray2.length, nodeArray3.length);
        return nodeArray4;
    }

    public CCTopologyModelInterface.Edge[] getDisplayedEdges() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Object[] objectArray = this.displayModel.getEdges();
        Arrays.sort(objectArray);
        return objectArray;
    }

    public Rectangle getIconArea(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        DisplayElement displayElement;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Rectangle rectangle2 = (displayElement = this.displayModel.getDisplayElement(node)) instanceof DisplayNode ? ((DisplayNode)displayElement).imageBounds : null;
        return this.clipArea(rectangle2, rectangle);
    }

    public Rectangle getLabelArea(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        DisplayElement displayElement;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Rectangle rectangle2 = (displayElement = this.displayModel.getDisplayElement(node)) instanceof DisplayNode ? ((DisplayNode)displayElement).labelBounds : null;
        return this.clipArea(rectangle2, rectangle);
    }

    public Polygon getEdgeArea(CCTopologyModelInterface.Edge edge, Rectangle rectangle) {
        DisplayElement displayElement;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Polygon polygon = (displayElement = this.displayModel.getDisplayElement(edge)) instanceof DisplayEdge ? ((DisplayEdge)displayElement).getArea() : null;
        return this.clipArea(polygon, rectangle);
    }

    public Rectangle getBadgeArea(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        Dimension dimension;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        if ((dimension = this.getBadgeSize(node.getBadge())) == null) {
            return null;
        }
        DisplayNode displayNode = (DisplayNode)this.displayModel.getDisplayElement(node);
        return displayNode == null ? null : this.clipArea(new Rectangle(displayNode.imageBounds.x + displayNode.imageBounds.width - dimension.width + 3, displayNode.imageBounds.y + displayNode.imageBounds.height - dimension.height + 3, dimension.width, dimension.height), rectangle);
    }

    public Rectangle getBadgeArea(CCTopologyModelInterface.Edge edge, Rectangle rectangle) {
        Dimension dimension;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        if ((dimension = this.getBadgeSize(edge.getBadge())) != null) {
            DisplayEdge displayEdge = (DisplayEdge)this.displayModel.getDisplayElement(edge);
            if (displayEdge == null) {
                return null;
            }
            if (displayEdge.getBadge() != 0) {
                Point point = displayEdge.getPoints()[displayEdge.badgePoint];
                int n = point.x - dimension.width / 2;
                int n2 = point.y - dimension.height / 2;
                return this.clipArea(new Rectangle(n, n2, dimension.width, dimension.height), rectangle);
            }
        }
        return null;
    }

    public Rectangle getTurnerArea(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        DisplayNode displayNode;
        if (!(node instanceof CCTopologyModelInterface.GroupNode)) {
            return null;
        }
        if (this.displayModel == null) {
            this.layoutImage();
        }
        return (displayNode = (DisplayNode)this.displayModel.getDisplayElement(node)) == null ? null : this.clipArea(new Rectangle(displayNode.turnerPoint.x, displayNode.turnerPoint.y, displayNode.isExpanded ? 9 : 5, displayNode.isExpanded ? 5 : 9), rectangle);
    }

    public final Font getLabelFont() {
        return this.font;
    }

    public final Font getDefaultLabelFont() {
        return new Font("SansSerif", 10, 0).deriveFont(0, 10.0f);
    }

    private void validateModel(CCTopologyModelInterface cCTopologyModelInterface) {
        int n;
        if (cCTopologyModelInterface == null) {
            throw new IllegalArgumentException("model == null");
        }
        int n2 = cCTopologyModelInterface.getTierCount();
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("invalid model: tierCount not 1, 2 or 3");
        }
        CCTopologyModelInterface.Node[][] nodeArray = new CCTopologyModelInterface.Node[n2][0];
        for (int i = 0; i < n2; ++i) {
            nodeArray[i] = cCTopologyModelInterface.getTierNodes(i);
            if (nodeArray[i] == null) {
                throw new IllegalArgumentException("invalid model: getTierNodes(" + i + ") == null");
            }
            for (n = 0; n < nodeArray[i].length; ++n) {
                if (nodeArray[i][n] == null) {
                    throw new IllegalArgumentException("invalid model: getTierNodes(" + i + ")[" + n + "] == null");
                }
                if (nodeArray[i][n].getLabel() != null) continue;
                throw new IllegalArgumentException("invalid model: getTierNodes(" + i + ")[" + n + "].getLabel() == null");
            }
        }
        CCTopologyModelInterface.Edge[] edgeArray = cCTopologyModelInterface.getEdges();
        if (edgeArray == null) {
            throw new IllegalArgumentException("invalid model: getEdges() == null");
        }
        for (n = 0; n < edgeArray.length; ++n) {
            if (edgeArray[n] == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n + "] == null");
            }
            CCTopologyModelInterface.Node node = edgeArray[n].getSource();
            CCTopologyModelInterface.Node node2 = edgeArray[n].getDestination();
            if (node == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n + "].getSource() == null");
            }
            if (node2 == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n + "].getDestination() == null");
            }
            if (cCTopologyModelInterface.getNode(node.getId()) == null) {
                throw new IllegalArgumentException("invalid model: getNode(getEdges()[" + n + "].getSource().getId()) == null");
            }
            if (cCTopologyModelInterface.getNode(node2.getId()) != null) continue;
            throw new IllegalArgumentException("invalid model: getNode(getEdges()[" + n + "].getDestination().getId()) == null (label=" + node2.getLabel() + ")");
        }
    }

    private Dimension getBadgeSize(int n) {
        Integer n2 = new Integer(n);
        Object object = this.badgeSizes.get(n2);
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        if (object == null && badgeSet != null) {
            Image image = badgeSet.getImage(n);
            object = image == null ? NULL_SIZE : new Dimension(image.getWidth(null), image.getHeight(null));
            this.badgeSizes.put(n2, object);
        }
        return object instanceof Dimension ? (Dimension)object : null;
    }

    private Rectangle clipArea(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null) {
            return rectangle;
        }
        if (rectangle == null || !rectangle.intersects(rectangle2)) {
            return null;
        }
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        rectangle3.translate(-rectangle2.x, -rectangle2.y);
        return rectangle3;
    }

    private Polygon clipArea(Polygon polygon, Rectangle rectangle) {
        if (rectangle == null) {
            return polygon;
        }
        if (polygon == null || !polygon.intersects(rectangle)) {
            return null;
        }
        polygon.translate(-rectangle.x, -rectangle.y);
        return polygon;
    }

    private void layoutImage() {
        this.displayModel = new DisplayModel(this.model, this.cci18n, this.i18n);
        int n = this.displayModel.getTierCount();
        this.size = n == 1 && !this.displayModel.hasGroupNodes ? this.layoutDiagonally() : (n > 0 && n < 4 ? this.layoutOrthogonally() : new Dimension(1, 1));
    }

    private Dimension layoutDiagonally() {
        int n;
        int n2;
        DisplayNode displayNode;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        DisplayNode[] displayNodeArray = (DisplayNode[])this.displayModel.getTierNodes(0);
        int n8 = this.calculateSizes(displayNodeArray, true);
        int n9 = Math.max(10, 4 + (this.displayModel.hasArrowheads ? 7 : 0) + (this.displayModel.hasEdgeBadges || this.displayModel.hasSelectableEdges || this.displayModel.hasGroupEdges ? 7 : 0));
        DisplayEdge[][] displayEdgeArrayArray = new DisplayEdge[displayNodeArray.length][];
        int n10 = 1;
        boolean[] blArray = new boolean[displayNodeArray.length];
        boolean bl = false;
        for (n7 = 0; n7 < displayNodeArray.length; ++n7) {
            DisplayNode displayNode2 = displayNodeArray[n7];
            n6 = displayNode2.edges.size();
            displayEdgeArrayArray[n7] = displayNode2.edges.toArray(new DisplayEdge[n6]);
            Arrays.sort(displayEdgeArrayArray[n7], new DiagonalTierEdgeComparator(displayNode2));
            for (n5 = 0; n5 < displayEdgeArrayArray[n7].length; ++n5) {
                if (displayEdgeArrayArray[n7][n5].sortIndex != 0) continue;
                displayEdgeArrayArray[n7][n5].sortIndex = n10++;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                DisplayNode displayNode3 = displayEdgeArrayArray[n7][n5].getOtherNode(displayNode2);
                if (displayNode3.index == displayNode2.index) {
                    bl = true;
                    blArray[n7] = true;
                }
                if (displayNode3.index < displayNode2.index) continue;
                displayNode2.belowEdgeCount = n6 - n5;
                break;
            }
            displayNode2.aboveEdgeCount = n6 - displayNode2.belowEdgeCount;
        }
        n7 = 4 + (bl && this.displayModel.hasSelectableEdges || this.displayModel.hasEdgeBadges || this.displayModel.hasArrowheads || this.displayModel.hasGroupEdges ? 3 : 0);
        if (this.displayModel.hasGroupEdges || this.displayModel.hasEdgeBadges) {
            ++n7;
        }
        int n11 = 5 + (this.displayModel.hasNodeBadges ? 3 : 0);
        n6 = 3 + (this.displayModel.hasNodeBadges ? 3 : 0);
        n5 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n4 = 0; n4 < displayNodeArray.length; ++n4) {
            n12 = Math.max(n12, displayNodeArray[n4].imageBounds.width);
            n13 = Math.max(n13, displayNodeArray[n4].imageBounds.height);
        }
        n4 = displayNodeArray.length > 0 ? displayNodeArray[0].labelBounds.width + 5 : 0;
        int n14 = 0;
        for (n3 = 0; n3 < displayNodeArray.length; ++n3) {
            displayNode = displayNodeArray[n3];
            n2 = Math.max(n12, (displayNode.aboveEdgeCount + 2) * n7);
            n = Math.max(n13, (displayNode.belowEdgeCount + 2) * n7);
            displayNode.imageBounds.setLocation(n4 + (n2 - n12) / 2, n14 + (n - n13) / 2);
            displayNode.labelBounds.setLocation(displayNode.imageBounds.x - 5 - displayNode.labelBounds.width, displayNode.imageBounds.y + displayNode.imageBounds.height - displayNode.labelBounds.height);
            n5 = Math.min(n5, displayNode.labelBounds.x);
            n4 += n2 + n11 + (blArray[n3] ? n9 : 0);
            n14 += n + n11;
        }
        if (n5 < 0) {
            for (n3 = 0; n3 < displayNodeArray.length; ++n3) {
                displayNode = displayNodeArray[n3];
                displayNode.labelBounds.x -= n5;
                displayNode.imageBounds.x -= n5;
            }
            n4 -= n5;
        }
        n3 = n4 - 5;
        int n15 = n14 - 5;
        n2 = 0;
        for (n = 0; n < displayNodeArray.length; ++n) {
            int n16;
            DisplayNode displayNode4 = displayNodeArray[n];
            DisplayEdge[] displayEdgeArray = displayEdgeArrayArray[n];
            n4 = displayNode4.imageBounds.x + (displayNode4.imageBounds.width - (displayNode4.aboveEdgeCount - 1) * n7) / 2;
            n14 = displayNode4.imageBounds.y - 3;
            for (n16 = 0; n16 < displayNode4.aboveEdgeCount; ++n16) {
                if (displayNode4 == displayEdgeArray[n16].displaySource) {
                    displayEdgeArray[n16].sourcePoint = new Point(n4, n14);
                } else {
                    displayEdgeArray[n16].destinationPoint = new Point(n4, n14);
                }
                n4 += n7;
            }
            n4 = Math.max(n4, displayNode4.imageBounds.x + displayNode4.imageBounds.width + n6);
            n14 = displayNode4.imageBounds.y + (displayNode4.imageBounds.height + (displayNode4.belowEdgeCount - 1) * n7) / 2;
            while (n16 < displayEdgeArray.length) {
                if (displayNode4 == displayEdgeArray[n16].displaySource) {
                    if (displayNode4 == displayEdgeArray[n16].displayDestination) {
                        displayEdgeArray[n16].sourcePoint = new Point(n4, n14);
                        displayEdgeArray[n16].destinationPoint = new Point(n4, n14 -= n7);
                        displayEdgeArray[n16].offset = n9;
                        ++n16;
                        if (n == displayNodeArray.length - 1) {
                            n2 = 1;
                        }
                    } else {
                        displayEdgeArray[n16].sourcePoint = new Point(n4, n14);
                    }
                } else {
                    displayEdgeArray[n16].destinationPoint = new Point(n4, n14);
                }
                n14 -= n7;
                ++n16;
            }
        }
        if (n2 != 0) {
            n3 += n6 + n9 + 3;
        }
        return new Dimension(n3, n15);
    }

    private Dimension layoutOrthogonally() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        boolean bl;
        DisplayNode[] displayNodeArray = (DisplayNode[])this.displayModel.getTierNodes(0);
        DisplayNode[] displayNodeArray2 = (DisplayNode[])this.displayModel.getTierNodes(1);
        DisplayNode[] displayNodeArray3 = (DisplayNode[])this.displayModel.getTierNodes(2);
        int n24 = this.calculateSizes(displayNodeArray, true);
        int n25 = this.calculateSizes(displayNodeArray2, false);
        int n26 = this.calculateSizes(displayNodeArray3, true);
        int n27 = Math.max(n24, n26);
        boolean bl2 = bl = displayNodeArray.length == 0;
        if (!bl && this.displayModel.hasGroupNodes) {
            for (n23 = 0; n23 < displayNodeArray2.length; ++n23) {
                if (!displayNodeArray2[n23].isGroup) continue;
                bl = true;
                break;
            }
        }
        n23 = 0;
        DisplayEdge[][][] displayEdgeArrayArray = new DisplayEdge[3][][];
        int n28 = 1;
        for (n22 = 0; n22 < 3; ++n22) {
            DisplayNode[] displayNodeArray4 = n22 == 0 ? displayNodeArray : (n22 == 1 ? displayNodeArray2 : displayNodeArray3);
            displayEdgeArrayArray[n22] = new DisplayEdge[displayNodeArray4.length][];
            for (n21 = 0; n21 < displayNodeArray4.length; ++n21) {
                DisplayNode displayNode = displayNodeArray4[n21];
                n20 = displayNode.edges.size();
                displayEdgeArrayArray[n22][n21] = displayNode.edges.toArray(new DisplayEdge[n20]);
                if (n22 == 0 || n22 == 1 && bl) {
                    Arrays.sort(displayEdgeArrayArray[n22][n21], new TierOneEdgeComparator(displayNode));
                } else {
                    Arrays.sort(displayEdgeArrayArray[n22][n21], new TierThreeEdgeComparator(displayNode));
                }
                for (n19 = 0; n19 < displayEdgeArrayArray[n22][n21].length; ++n19) {
                    if (displayEdgeArrayArray[n22][n21][n19].sortIndex != 0) continue;
                    displayEdgeArrayArray[n22][n21][n19].sortIndex = n28++;
                }
                block0 : switch (n22) {
                    case 0: {
                        displayNode.belowEdgeCount = n20;
                        break;
                    }
                    case 2: {
                        displayNode.belowEdgeCount = 0;
                        break;
                    }
                    case 1: {
                        DisplayNode displayNode2;
                        if (bl) {
                            for (n19 = 0; n19 < n20; ++n19) {
                                displayNode2 = displayEdgeArrayArray[n22][n21][n19].getOtherNode(displayNode);
                                if (displayNode2.tier < displayNode.tier) continue;
                                displayNode.belowEdgeCount = n20 - n19;
                                break block0;
                            }
                        } else {
                            for (n19 = 0; n19 < n20; ++n19) {
                                displayNode2 = displayEdgeArrayArray[n22][n21][n19].getOtherNode(displayNode);
                                if (displayNode2.tier <= displayNode.tier) continue;
                                displayNode.belowEdgeCount = n20 - n19;
                                break block0;
                            }
                        }
                        break;
                    }
                }
                displayNode.aboveEdgeCount = n20 - displayNode.belowEdgeCount;
                for (n19 = 0; n19 < displayEdgeArrayArray[n22][n21].length; ++n19) {
                    if (displayEdgeArrayArray[n22][n21][n19].displaySource != displayEdgeArrayArray[n22][n21][n19].displayDestination) continue;
                    n23 = 1;
                }
            }
        }
        n22 = 4 + (n23 != 0 && this.displayModel.hasSelectableEdges || this.displayModel.hasEdgeBadges || this.displayModel.hasArrowheads || this.displayModel.hasGroupEdges ? 3 : 0);
        int n29 = 5 + (this.displayModel.hasNodeBadges ? 3 : 0);
        n21 = this.displayModel.hasNodeBadges ? 6 : 3;
        int n30 = Math.max(10, 4 + (this.displayModel.hasArrowheads ? 7 : 0) + (this.displayModel.hasEdgeBadges || this.displayModel.hasSelectableEdges ? 7 : 0));
        n20 = 0;
        n19 = 0;
        int n31 = 0;
        for (n18 = 0; n18 < displayNodeArray.length; ++n18) {
            n19 = Math.max(n19, displayNodeArray[n18].imageBounds.width);
        }
        n18 = n27 - n19;
        int n32 = this.displayModel.hasEdgeBadges ? 3 : 0;
        int n33 = 0;
        DisplayNode[] displayNodeArray5 = new DisplayNode[Math.max(displayNodeArray.length, Math.max(displayNodeArray2.length, displayNodeArray3.length))];
        for (n17 = 0; n17 < displayNodeArray.length; ++n17) {
            int n34;
            DisplayNode displayNode = displayNodeArray[n17];
            n16 = displayNode.isGroup && displayNode.isExpanded ? 1 : 0;
            n31 = n16 != 0 ? Math.max(13, displayNode.labelBounds.height) : displayNode.imageBounds.height;
            n15 = Math.max(n31, displayNode.belowEdgeCount * n22 + n30 - n29);
            n14 = n18;
            n13 = displayNode.nesting * 25;
            n33 = Math.max(n33, n13);
            if (n16 == 0) {
                displayNode.imageBounds.setLocation(n18 + n13, n32 + (n15 - n31) / 2);
            }
            if (displayNode.isGroup) {
                n20 = 1;
                n14 = n18 - 5 - 5;
                displayNode.turnerPoint = new Point(n14 + n13, n32 + (n15 - 9) / 2);
            }
            displayNode.labelBounds.setLocation(n14 + n13 - 5 - displayNode.labelBounds.width, n32 + (n15 - displayNode.labelBounds.height) / 2);
            n32 += n15;
            int n35 = n34 = n17 == displayNodeArray.length - 1 ? 0 : displayNodeArray[n17 + 1].nesting;
            if (n34 > displayNode.nesting) {
                displayNodeArray5[displayNode.nesting] = displayNode;
            } else if (n34 < displayNode.nesting) {
                for (n12 = displayNode.nesting - 1; n12 >= n34; --n12) {
                    displayNodeArray5[n12].groupLineLength = (n32 += 5) - displayNodeArray5[n12].turnerPoint.y;
                }
            }
            n32 += n29;
        }
        n19 = 0;
        n31 = 0;
        for (n17 = 0; n17 < displayNodeArray2.length; ++n17) {
            n31 = Math.max(n31, displayNodeArray2[n17].imageBounds.height);
        }
        n18 = n27 + n21 + n30;
        n17 = 0;
        if (displayNodeArray.length > 0) {
            n32 = n32 - n29 + n30;
        }
        int n36 = 0;
        for (n16 = 0; n16 < displayNodeArray2.length; ++n16) {
            n36 = Math.max(n36, displayNodeArray2[n16].labelBounds.height);
        }
        n16 = bl ? n32 + (--n36 - 1) + 1 : n32;
        n15 = n32;
        if (!bl) {
            n15 += n31 + 1;
            if (this.displayModel.hasNodeBadges) {
                n15 += 3;
            }
        }
        n14 = 0;
        for (n13 = 0; n13 < displayNodeArray2.length; ++n13) {
            DisplayNode displayNode;
            DisplayNode displayNode3 = displayNodeArray2[n13];
            n12 = displayNode3.isGroup && displayNode3.isExpanded ? 1 : 0;
            int n37 = n19 = n12 != 0 ? 0 : displayNode3.imageBounds.width;
            n11 = displayNode3.isGroup ? (displayNode3.isExpanded ? 9 : 5) + 5 : 0;
            n10 = Math.max(Math.max(displayNode3.aboveEdgeCount, displayNode3.belowEdgeCount) * n22 + n30 - n29, Math.max(n11 + n19, displayNode3.labelBounds.width));
            n9 = displayNode3.nesting * 25;
            n17 = Math.max(n17, n9);
            n8 = n18 + (n10 - n19 - n11) / 2;
            if (displayNode3.isGroup) {
                displayNode3.turnerPoint = new Point(n8, n16 + n9 + 1);
            }
            if (n12 == 0) {
                displayNode3.imageBounds.setLocation(n8 + n11, n16 + n9);
                displayNode3.labelBounds.setLocation(displayNode3.imageBounds.x + (displayNode3.imageBounds.width - displayNode3.labelBounds.width) / 2, n15 + n9);
            } else {
                displayNode3.labelBounds.setLocation(n18 + (n10 - displayNode3.labelBounds.width) / 2, n15 + n9);
            }
            n7 = 0;
            if (n13 == 0 && n12 != 0) {
                n7 = Math.min(n18, n10 + n29);
            } else if (n14 != 0) {
                displayNode = displayNodeArray2[n13 - 1];
                n6 = displayNode3.labelBounds.x;
                if (displayNode3.imageBounds.x > 0) {
                    n6 = Math.min(n6, displayNode3.imageBounds.x);
                }
                if (n8 != 0) {
                    n6 = Math.min(n6, n8);
                }
                n4 = (n5 = displayNode3.aboveEdgeCount * n22) > 0 ? n6 + (n10 - n5) / 2 : n6 + n10;
                n7 = Math.min(n6 - displayNode.turnerPoint.x + 9, n4 - (displayNode.labelBounds.x + displayNode.labelBounds.width)) - n29 - 5;
            }
            if (n7 > 0) {
                if (n14 != 0 && n12 == 0 && n13 == 1) {
                    displayNode = displayNodeArray2[n13 - 1];
                    displayNode.labelBounds.x += n7;
                    displayNode.turnerPoint.x += n7;
                } else {
                    displayNode3.labelBounds.x -= n7;
                    if (displayNode3.imageBounds.x > 0) {
                        displayNode3.imageBounds.x -= n7;
                    }
                    if (displayNode3.turnerPoint != null) {
                        displayNode3.turnerPoint.x -= n7;
                    }
                    n18 -= n7;
                }
            }
            n14 = n12;
            n18 += n10;
            int n38 = n3 = n13 == displayNodeArray2.length - 1 ? 0 : displayNodeArray2[n13 + 1].nesting;
            if (n3 > displayNode3.nesting) {
                displayNodeArray5[displayNode3.nesting] = displayNode3;
            } else if (n3 < displayNode3.nesting) {
                for (n6 = displayNode3.nesting - 1; n6 >= n3; --n6) {
                    displayNodeArray5[n6].groupLineLength = (n18 += 5) - displayNodeArray5[n6].turnerPoint.x;
                }
            }
            n18 += n29;
        }
        n13 = n18 - 5 + (this.displayModel.hasEdgeBadges ? 3 : 0);
        n32 += n31 + 1 + n36 + n30 + n17;
        n19 = 0;
        n31 = 0;
        for (n2 = 0; n2 < displayNodeArray3.length; ++n2) {
            n19 = Math.max(n19, displayNodeArray3[n2].imageBounds.width);
        }
        n18 = n27 - n19;
        for (n2 = 0; n2 < displayNodeArray3.length; ++n2) {
            DisplayNode displayNode = displayNodeArray3[n2];
            n11 = displayNode.isGroup && displayNode.isExpanded ? 1 : 0;
            n31 = n11 != 0 ? Math.max(13, displayNode.labelBounds.height) : displayNode.imageBounds.height;
            n10 = Math.max(n31, displayNode.aboveEdgeCount * n22 + n30 - n29);
            n9 = displayNode.nesting * 25;
            n33 = Math.max(n33, n9);
            if (n11 == 0) {
                displayNode.imageBounds.setLocation(n18 + n9, n32 + (n10 - n31) / 2);
            }
            n8 = n18;
            if (displayNode.isGroup) {
                n20 = 1;
                n8 = n18 - 5 - 5;
                displayNode.turnerPoint = new Point(n8 + n9, n32 + (n10 - 9) / 2);
            }
            displayNode.labelBounds.setLocation(n8 + n9 - 5 - displayNode.labelBounds.width, n32 + (n10 - displayNode.labelBounds.height) / 2);
            n32 += n10;
            int n39 = n7 = n2 == displayNodeArray3.length - 1 ? 0 : displayNodeArray3[n2 + 1].nesting;
            if (n7 > displayNode.nesting) {
                displayNodeArray5[displayNode.nesting] = displayNode;
            } else if (n7 < displayNode.nesting) {
                for (n3 = displayNode.nesting - 1; n3 >= n7; --n3) {
                    displayNodeArray5[n3].groupLineLength = (n32 += 5) - displayNodeArray5[n3].turnerPoint.y;
                }
            }
            n32 += n29;
        }
        n2 = displayNodeArray3.length == 0 ? n32 + 1 : n32 - 5 + (this.displayModel.hasEdgeBadges ? 3 : 0);
        for (n = 0; n < displayNodeArray.length; ++n) {
            DisplayNode displayNode = displayNodeArray[n];
            DisplayEdge[] displayEdgeArray = displayEdgeArrayArray[0][n];
            n18 = displayNode.imageBounds.x + displayNode.imageBounds.width + n21;
            n32 = displayNode.imageBounds.y + (displayNode.imageBounds.height + (displayNode.belowEdgeCount - 1) * n22) / 2;
            for (n9 = 0; n9 < displayEdgeArray.length && displayNode == displayEdgeArray[n9].displaySource && displayNode == displayEdgeArray[n9].displayDestination; n9 += 2) {
                displayEdgeArray[n9].sourcePoint = new Point(n18, n32);
                displayEdgeArray[n9].destinationPoint = new Point(n18, n32 -= n22);
                n32 -= n22;
                displayEdgeArray[n9].offset = n30;
            }
            for (n8 = displayEdgeArray.length - 1; n8 >= n9; --n8) {
                if (displayNode == displayEdgeArray[n8].displaySource) {
                    displayEdgeArray[n8].sourcePoint = new Point(n18, n32);
                } else {
                    displayEdgeArray[n8].destinationPoint = new Point(n18, n32);
                }
                n32 -= n22;
            }
        }
        for (n = 0; n < displayNodeArray2.length; ++n) {
            DisplayNode displayNode = displayNodeArray2[n];
            DisplayEdge[] displayEdgeArray = displayEdgeArrayArray[1][n];
            n18 = displayNode.imageBounds.x + (displayNode.imageBounds.width - (displayNode.aboveEdgeCount - 1) * n22) / 2;
            n32 = Math.min(displayNode.imageBounds.y, displayNode.labelBounds.y) - 3 - 1;
            for (n9 = 0; n9 < displayNode.aboveEdgeCount; ++n9) {
                if (displayNode == displayEdgeArray[n9].displaySource) {
                    if (displayNode == displayEdgeArray[n9].displayDestination) {
                        displayEdgeArray[n9].destinationPoint = new Point(n18, n32);
                        displayEdgeArray[n9].sourcePoint = new Point(n18 += n22, n32);
                        displayEdgeArray[n9].offset = n30;
                        ++n9;
                    } else {
                        displayEdgeArray[n9].sourcePoint = new Point(n18, n32);
                    }
                } else {
                    displayEdgeArray[n9].destinationPoint = new Point(n18, n32);
                }
                n18 += n22;
            }
            n18 = displayNode.imageBounds.x + (displayNode.imageBounds.width - (displayNode.belowEdgeCount - 1) * n22) / 2;
            n32 = Math.max(displayNode.imageBounds.y + displayNode.imageBounds.height + n21, displayNode.labelBounds.y + displayNode.labelBounds.height + 3);
            if (!bl) {
                n32 -= 2;
            }
            while (n9 < displayEdgeArray.length) {
                if (displayNode == displayEdgeArray[n9].displaySource) {
                    if (displayNode == displayEdgeArray[n9].displayDestination) {
                        displayEdgeArray[n9].destinationPoint = new Point(n18, n32);
                        displayEdgeArray[n9].sourcePoint = new Point(n18 += n22, n32);
                        displayEdgeArray[n9].offset = n30;
                        ++n9;
                    } else {
                        displayEdgeArray[n9].sourcePoint = new Point(n18, n32);
                    }
                } else {
                    displayEdgeArray[n9].destinationPoint = new Point(n18, n32);
                }
                n18 += n22;
                ++n9;
            }
        }
        for (n = 0; n < displayNodeArray3.length; ++n) {
            DisplayNode displayNode = displayNodeArray3[n];
            DisplayEdge[] displayEdgeArray = displayEdgeArrayArray[2][n];
            n18 = displayNode.imageBounds.x + displayNode.imageBounds.width + n21;
            n32 = displayNode.imageBounds.y + (displayNode.imageBounds.height + (displayNode.aboveEdgeCount - 1) * n22) / 2;
            for (n9 = displayEdgeArray.length - 1; n9 >= 0; --n9) {
                if (displayNode == displayEdgeArray[n9].displaySource) {
                    if (displayNode == displayEdgeArray[n9].displayDestination) {
                        displayEdgeArray[n9].sourcePoint = new Point(n18, n32);
                        displayEdgeArray[n9].destinationPoint = new Point(n18, n32 -= n22);
                        displayEdgeArray[n9].offset = n30;
                        --n9;
                    } else {
                        displayEdgeArray[n9].sourcePoint = new Point(n18, n32);
                    }
                } else {
                    displayEdgeArray[n9].destinationPoint = new Point(n18, n32);
                }
                n32 -= n22;
            }
        }
        int[][] nArrayArray = new int[3][];
        int[][] nArrayArray2 = new int[3][];
        nArrayArray[0] = new int[displayNodeArray.length];
        nArrayArray2[0] = new int[displayNodeArray.length];
        nArrayArray[1] = new int[displayNodeArray2.length];
        nArrayArray2[1] = new int[displayNodeArray2.length];
        nArrayArray[2] = new int[displayNodeArray3.length];
        nArrayArray2[2] = new int[displayNodeArray3.length];
        int n40 = 0;
        if (displayNodeArray.length > 0) {
            n40 = displayNodeArray[0].imageBounds.x + displayNodeArray[0].imageBounds.width;
            for (n9 = 0; n9 < nArrayArray[0].length - 1; ++n9) {
                n8 = displayNodeArray[n9 + 1].imageBounds.x + displayNodeArray[n9 + 1].imageBounds.width;
                nArrayArray2[0][n9] = Math.max(n40, n8);
                nArrayArray[0][n9] = n30 + nArrayArray2[0][n9];
                n40 = n8;
            }
        }
        if (displayNodeArray2.length > 0) {
            n40 = displayNodeArray2[0].imageBounds.y + displayNodeArray2[0].imageBounds.height;
            for (n9 = 0; n9 < nArrayArray[1].length - 1; ++n9) {
                n8 = displayNodeArray2[n9 + 1].imageBounds.y + displayNodeArray2[n9 + 1].imageBounds.height;
                nArrayArray2[1][n9] = Math.max(n40, n8);
                nArrayArray[1][n9] = n30 + nArrayArray2[1][n9];
                n40 = n8;
            }
        }
        if (displayNodeArray3.length > 0) {
            n40 = displayNodeArray3[0].imageBounds.x + displayNodeArray3[0].imageBounds.width;
            for (n9 = 0; n9 < nArrayArray[2].length - 1; ++n9) {
                n8 = displayNodeArray3[n9 + 1].imageBounds.x + displayNodeArray3[n9 + 1].imageBounds.width;
                nArrayArray2[2][n9] = Math.max(n40, n8);
                nArrayArray[2][n9] = n30 + nArrayArray2[2][n9];
                n40 = n8;
            }
        }
        DisplayEdge[] displayEdgeArray = (DisplayEdge[])this.displayModel.getEdges();
        Arrays.sort(displayEdgeArray, new WithinTierEdgeComparator());
        for (n8 = 0; n8 < displayEdgeArray.length; ++n8) {
            int n41;
            displayEdgeArray[n8].invalidateLayout();
            if (WithinTierEdgeComparator.getEdgeLength(displayEdgeArray[n8]) == Integer.MAX_VALUE) break;
            n7 = displayEdgeArray[n8].displaySource.tier;
            n3 = displayEdgeArray[n8].displaySource.index;
            n6 = displayEdgeArray[n8].displayDestination.index;
            if (n3 > n6) {
                n3 = n6;
                n6 = displayEdgeArray[n8].displaySource.index;
            }
            n5 = displayEdgeArray[n8].displaySource.tier == 1 ? displayEdgeArray[n8].displaySource.imageBounds.y + displayEdgeArray[n8].displaySource.imageBounds.height : displayEdgeArray[n8].displaySource.imageBounds.x + displayEdgeArray[n8].displaySource.imageBounds.width;
            n4 = 0;
            if (n3 == n6) {
                n4 = n30 + n5;
            } else {
                for (n41 = n3; n41 < n6; ++n41) {
                    n4 = Math.max(n4, nArrayArray[n7][n41]);
                }
                n4 += n22;
            }
            displayEdgeArray[n8].offset = n7 == 1 && !bl ? -(n4 - n5) : n4 - n5;
            if (n3 == n6) {
                nArrayArray[n7][n3] = Math.max(nArrayArray[n7][n3], n4);
                continue;
            }
            for (n41 = n3; n41 < n6; ++n41) {
                nArrayArray[n7][n41] = n4;
            }
        }
        n8 = 0;
        n7 = 0;
        for (n3 = 0; n3 < nArrayArray[0].length - 1; ++n3) {
            n8 = Math.max(n8, nArrayArray[0][n3] - nArrayArray2[0][n3]);
        }
        for (n3 = 0; n3 < nArrayArray[1].length - 1; ++n3) {
            n7 = Math.max(n7, nArrayArray[1][n3] - nArrayArray2[1][n3]);
        }
        for (n3 = 0; n3 < nArrayArray[2].length - 1; ++n3) {
            n8 = Math.max(n8, nArrayArray[2][n3] - nArrayArray2[2][n3]);
        }
        int n42 = n3 = bl ? 0 : n7;
        if ((n8 += n33) > 0 || n3 > 0) {
            for (n6 = 0; n6 < displayNodeArray2.length; ++n6) {
                displayNodeArray2[n6].imageBounds.translate(n8, n3);
                displayNodeArray2[n6].labelBounds.translate(n8, n3);
                if (displayNodeArray2[n6].turnerPoint == null) continue;
                displayNodeArray2[n6].turnerPoint.translate(n8, n3);
            }
        }
        if (n7 > 0) {
            for (n6 = 0; n6 < displayNodeArray3.length; ++n6) {
                displayNodeArray3[n6].imageBounds.translate(0, n7);
                displayNodeArray3[n6].labelBounds.translate(0, n7);
                if (displayNodeArray3[n6].turnerPoint == null) continue;
                displayNodeArray3[n6].turnerPoint.translate(0, n7);
            }
        }
        if (n7 > 0 || n8 > 0) {
            block51: for (n6 = 0; n6 < displayEdgeArray.length; ++n6) {
                switch (displayEdgeArray[n6].displaySource.tier) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        displayEdgeArray[n6].sourcePoint.translate(n8, n3);
                        break;
                    }
                    case 2: {
                        displayEdgeArray[n6].sourcePoint.translate(0, n7);
                    }
                }
                switch (displayEdgeArray[n6].displayDestination.tier) {
                    case 0: {
                        continue block51;
                    }
                    case 1: {
                        displayEdgeArray[n6].destinationPoint.translate(n8, n3);
                        continue block51;
                    }
                    case 2: {
                        displayEdgeArray[n6].destinationPoint.translate(0, n7);
                    }
                }
            }
        }
        n6 = 4;
        return new Dimension(n13 + n8 + 1 + n6, n2 + n7 + n6);
    }

    private int calculateSizes(DisplayNode[] displayNodeArray, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        for (int i = 0; i < displayNodeArray.length; ++i) {
            int n2;
            String string;
            int n3;
            DisplayNode displayNode = displayNodeArray[i];
            Image image = this.getIconImage(displayNode.getIcon());
            int n4 = displayNode.usesPluralIcon ? 8 : 0;
            int n5 = image == null ? -1 : image.getWidth(null) + n4;
            int n6 = n3 = image == null ? -1 : image.getHeight(null) + n4;
            if (n5 == -1) {
                n5 = 8;
            }
            if (n3 == -1) {
                n3 = 8;
            }
            displayNode.labelBounds = this.font.getStringBounds((string = displayNode.getLabel()) != null ? string : " ", this.fontContext).getBounds();
            ++displayNode.labelBounds.width;
            displayNode.imageBounds = new Rectangle(0, 0, n5, n3);
            int n7 = n2 = bl ? displayNode.labelBounds.width + n5 : displayNode.labelBounds.height + n3;
            if (bl && displayNode.isGroup) {
                bl2 = true;
            }
            n = Math.max(n, n2);
        }
        if (bl2) {
            n += 10;
        }
        return n + (bl ? 5 : 1);
    }

    private void drawTopology(Graphics2D graphics2D) {
        int n;
        graphics2D.setFont(this.getLabelFont());
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, this.size.width, this.size.height);
        graphics2D.setColor(FG_COLOR);
        for (int i = 0; i < this.displayModel.getTierCount(); ++i) {
            DisplayNode[] displayNodeArray = (DisplayNode[])this.displayModel.getTierNodes(i);
            for (int j = 0; j < displayNodeArray.length; ++j) {
                this.drawNode(graphics2D, displayNodeArray[j], this.displayModel.hasGroupNodes);
            }
        }
        DisplayEdge[] displayEdgeArray = (DisplayEdge[])this.displayModel.getEdges();
        for (n = 0; n < displayEdgeArray.length; ++n) {
            if (displayEdgeArray[n].isInFilter()) continue;
            this.drawEdgeLines(graphics2D, displayEdgeArray[n]);
        }
        for (n = 0; n < displayEdgeArray.length; ++n) {
            if (displayEdgeArray[n].isInFilter()) continue;
            this.drawEdgeAdornments(graphics2D, displayEdgeArray[n]);
        }
        for (n = 0; n < displayEdgeArray.length; ++n) {
            if (!displayEdgeArray[n].isInFilter()) continue;
            this.drawEdgeLines(graphics2D, displayEdgeArray[n]);
        }
        for (n = 0; n < displayEdgeArray.length; ++n) {
            if (!displayEdgeArray[n].isInFilter()) continue;
            this.drawEdgeAdornments(graphics2D, displayEdgeArray[n]);
        }
    }

    private void drawNode(Graphics2D graphics2D, DisplayNode displayNode, boolean bl) {
        Object object;
        Image image;
        int n = graphics2D.getFontMetrics().getAscent();
        graphics2D.setColor(displayNode.isInFilter() ? FG_COLOR : FILTER_COLOR);
        graphics2D.setStroke(STROKE_1PIXEL);
        graphics2D.drawString(displayNode.getLabel(), displayNode.labelBounds.x, displayNode.labelBounds.y + n);
        if (displayNode.isGroup) {
            if (displayNode.isExpanded) {
                int n2;
                int n3;
                if (displayNode.tier == 1) {
                    n3 = displayNode.turnerPoint.x + 4;
                    n2 = displayNode.turnerPoint.y + 4;
                    int n4 = n3 + displayNode.groupLineLength;
                    int n5 = n2 + 32;
                    graphics2D.setColor(BG_COLOR);
                    graphics2D.fillRect(n3, n2, n4 - n3, n5 - n2);
                    graphics2D.setColor(GROUP_LINE_COLOR);
                    graphics2D.fillRect(n3, n2, 1, n5 - n2);
                    graphics2D.fillRect(n3, n5, n4 - n3, 1);
                    graphics2D.fillRect(n4 - 1, n2, 1, n5 - n2);
                    graphics2D.fillRect(n4 - 5, n2, 5, 1);
                } else {
                    n3 = displayNode.turnerPoint.x + 4;
                    n2 = displayNode.turnerPoint.y + 4;
                    int n6 = n3 + 38 + (displayNode.imageBounds.width - (displayNode.usesPluralIcon ? 8 : 0)) / 2;
                    int n7 = n2 + displayNode.groupLineLength;
                    graphics2D.setColor(BG_COLOR);
                    graphics2D.fillRect(n3, n2, n6 - n3, n7 - n2);
                    graphics2D.setColor(GROUP_LINE_COLOR);
                    graphics2D.fillRect(n3, n2, n6 - n3, 1);
                    graphics2D.fillRect(n6 - 1, n2, 1, n7 - n2);
                    graphics2D.fillRect(n3, n7, n6 - n3, 1);
                    graphics2D.fillRect(n3, n7 - 5, 1, 5);
                }
            }
            if ((image = CCTopologyIconSet.ImageLoader.getCachedImage(CCDefaultTopologyRenderer.class, (String)(object = displayNode.isExpanded ? TURNER_OPEN : (displayNode.nesting == 0 && displayNode.tier == 1 ? TURNER_CLOSED_WLINE : TURNER_CLOSED)))) != null) {
                graphics2D.drawImage(image, displayNode.turnerPoint.x, displayNode.turnerPoint.y, null);
            }
        }
        if (!displayNode.isGroup || !displayNode.isExpanded) {
            object = this.getIconImage(displayNode.getIcon());
            if (displayNode.usesPluralIcon) {
                object = this.getPluralImage((Image)object);
            }
            if (!displayNode.isInFilter()) {
                object = this.getFilteredImage((Image)object);
            }
            if (object == null) {
                return;
            }
            graphics2D.drawImage((Image)object, displayNode.imageBounds.x, displayNode.imageBounds.y, null);
            image = this.getBadgeImage(displayNode.getBadge());
            if (image == null) {
                return;
            }
            if (!displayNode.isInFilter()) {
                image = this.getFilteredImage(image);
            }
            graphics2D.drawImage(image, (int)displayNode.imageBounds.getMaxX() + 3 - image.getWidth(null), (int)displayNode.imageBounds.getMaxY() + 3 - image.getHeight(null), null);
        }
    }

    private final Image getIconImage(int n) {
        CCTopologyModelInterface.IconSet iconSet = this.model.getIconSet();
        return iconSet == null ? null : iconSet.getImage(n);
    }

    private final Image getBadgeImage(int n) {
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        return badgeSet == null ? null : badgeSet.getImage(n);
    }

    private final Color getBadgeColor(int n) {
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        return badgeSet == null ? null : badgeSet.getColor(n);
    }

    private Image getPluralImage(Image image) {
        if (image == null) {
            return null;
        }
        Image image2 = (Image)this.pluralImages.get(image);
        if (image2 == null) {
            image2 = CCDefaultTopologyRenderer.createPluralImage(image);
            this.pluralImages.put(image, image2);
        }
        return image2;
    }

    private Image getFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        Image image2 = (Image)this.filteredImages.get(image);
        if (image2 == null) {
            image2 = CCDefaultTopologyRenderer.createFilteredImage(image);
            this.filteredImages.put(image, image2);
        }
        return image2;
    }

    private void drawEdgeLines(Graphics2D graphics2D, DisplayEdge displayEdge) {
        Color color;
        Point[] pointArray = displayEdge.getPoints();
        int n = pointArray.length;
        if (n < 2) {
            return;
        }
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            nArray[i] = pointArray[i].x;
            nArray2[i] = pointArray[i].y;
        }
        nArray[n] = nArray[n - 2];
        nArray2[n] = nArray2[n - 2];
        graphics2D.setColor(BG_COLOR);
        graphics2D.setStroke(displayEdge.isGroup ? STROKE_5PIXEL : STROKE_3PIXEL);
        graphics2D.drawPolyline(nArray, nArray2, n);
        Color color2 = color = !displayEdge.isInFilter() ? FILTER_COLOR : this.getBadgeColor(displayEdge.getBadge());
        if (color == null || color.equals(BG_COLOR)) {
            color = FG_COLOR;
        }
        graphics2D.setColor(color);
        if (displayEdge.isGroup) {
            graphics2D.setStroke(STROKE_3PIXEL);
            graphics2D.drawPolyline(nArray, nArray2, n);
            graphics2D.setColor(BG_COLOR);
        }
        graphics2D.setStroke(STROKE_1PIXEL);
        graphics2D.drawPolyline(nArray, nArray2, n);
    }

    private void drawEdgeAdornments(Graphics2D graphics2D, DisplayEdge displayEdge) {
        Color color;
        Point[] pointArray = displayEdge.getPoints();
        boolean bl = displayEdge.isInFilter();
        boolean bl2 = displayEdge.displaySource == displayEdge.displayDestination;
        Image image = this.getBadgeImage(displayEdge.getBadge());
        if (!displayEdge.isInFilter()) {
            image = this.getFilteredImage(image);
        }
        Color color2 = color = !bl ? FILTER_COLOR : this.getBadgeColor(displayEdge.getBadge());
        if (color == null) {
            color = FG_COLOR;
        }
        graphics2D.setColor(color);
        boolean bl3 = displayEdge.getAction() == Integer.MIN_VALUE ? this.model.getActionSet() instanceof CCDefaultActionSet : displayEdge.getAction() != 0;
        for (int i = 1; i < pointArray.length - 1; ++i) {
            int n = pointArray[i].x;
            int n2 = pointArray[i].y;
            if (image != null && i == displayEdge.badgePoint) {
                graphics2D.drawImage(image, n - image.getWidth(null) / 2, n2 - image.getHeight(null) / 2, null);
                continue;
            }
            if (!bl || bl2 && i != displayEdge.badgePoint) continue;
            if (bl3) {
                int n3 = 0;
                int n4 = 0;
                if (n2 == pointArray[i - 1].y) {
                    n3 = n2 < pointArray[i + 1].y ? 1 : -1;
                    n4 = n < pointArray[i - 1].x ? 1 : -1;
                } else {
                    n3 = n2 < pointArray[i - 1].y ? 1 : -1;
                    n4 = n < pointArray[i + 1].x ? 1 : -1;
                }
                int n5 = displayEdge.isGroup ? 1 : 0;
                int[] nArray = new int[7];
                int[] nArray2 = new int[7];
                int n6 = 0;
                nArray[n6] = n -= n4;
                nArray2[n6++] = n2 -= n3;
                nArray[n6] = n += n4 * (8 + n5);
                nArray2[n6++] = n2;
                nArray[n6] = n;
                nArray2[n6++] = n2 += n3 * (2 + n5);
                nArray[n6] = n -= n4 * 3;
                nArray2[n6++] = n2;
                nArray[n6] = n -= n4 * 3;
                nArray2[n6++] = n2 += n3 * 3;
                nArray[n6] = n;
                nArray2[n6++] = n2 += n3 * 3;
                nArray[n6] = n -= n4 * (2 + n5);
                nArray2[n6++] = n2;
                graphics2D.fillPolygon(nArray, nArray2, 7);
                graphics2D.drawPolygon(nArray, nArray2, 7);
                continue;
            }
            if (displayEdge.isGroup) continue;
            graphics2D.fillRect(pointArray[i].x - 1, pointArray[i].y - 1, 3, 3);
        }
        if (displayEdge.isDirected() && pointArray.length > 1) {
            this.drawArrowhead(graphics2D, pointArray[pointArray.length - 2], pointArray[pointArray.length - 1], displayEdge.isGroup);
            if (displayEdge.isBidirectional()) {
                this.drawArrowhead(graphics2D, pointArray[1], pointArray[0], displayEdge.isGroup);
            }
        }
    }

    private void drawArrowhead(Graphics2D graphics2D, Point point, Point point2, boolean bl) {
        if (bl) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(BG_COLOR);
            graphics2D.fillRect(point2.x - 2, point2.y - 2, 5, 5);
            graphics2D.setColor(color);
        }
        graphics2D.fillRect(point2.x, point2.y, 1, 1);
        if (point.y == point2.y) {
            int n = point.x > point2.x ? 1 : -1;
            int n2 = n > 0 ? 0 : -1;
            graphics2D.fillRect(point2.x + n2, point2.y, 2, 1);
            graphics2D.fillRect(point2.x + n2 + 2 * n, point2.y - 1, 2, 3);
            graphics2D.fillRect(point2.x + n2 + 4 * n, point2.y - 2, 2, 5);
        } else {
            int n = point.y > point2.y ? 1 : -1;
            int n3 = n > 0 ? 0 : -1;
            graphics2D.fillRect(point2.x, point2.y + n3, 1, 2);
            graphics2D.fillRect(point2.x - 1, point2.y + n3 + 2 * n, 3, 2);
            graphics2D.fillRect(point2.x - 2, point2.y + n3 + 4 * n, 5, 2);
        }
    }

    private static class WithinTierEdgeComparator
    implements Comparator {
        private WithinTierEdgeComparator() {
        }

        public int compare(Object object, Object object2) {
            DisplayEdge displayEdge = null;
            DisplayEdge displayEdge2 = null;
            try {
                displayEdge = (DisplayEdge)object;
                displayEdge2 = (DisplayEdge)object2;
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
            int n = WithinTierEdgeComparator.getEdgeLength(displayEdge);
            int n2 = WithinTierEdgeComparator.getEdgeLength(displayEdge2);
            return n != n2 ? n - n2 : (displayEdge.displaySource.index != displayEdge2.displaySource.index ? displayEdge.displaySource.index - displayEdge2.displaySource.index : (displayEdge.displayDestination.index != displayEdge2.displayDestination.index ? displayEdge.displayDestination.index - displayEdge2.displayDestination.index : displayEdge.getId().compareTo(displayEdge2.getId())));
        }

        public static int getEdgeLength(DisplayEdge displayEdge) {
            if (displayEdge.displaySource.tier != displayEdge.displayDestination.tier) {
                return Integer.MAX_VALUE;
            }
            return displayEdge.displaySource.tier == 1 ? Math.abs(displayEdge.sourcePoint.x - displayEdge.destinationPoint.x) : Math.abs(displayEdge.sourcePoint.y - displayEdge.destinationPoint.y);
        }
    }

    private static class TierThreeEdgeComparator
    implements Comparator {
        public static final int LEFT = 0;
        public static final int ABOVE = 1;
        public static final int RIGHT = 2;
        public static final int BELOW = 3;
        private DisplayNode node;

        public TierThreeEdgeComparator(DisplayNode displayNode) {
            this.node = displayNode;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            if (!(object instanceof DisplayEdge) || !(object2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayEdge displayEdge = (DisplayEdge)object;
            DisplayEdge displayEdge2 = (DisplayEdge)object2;
            DisplayNode displayNode = displayEdge.getOtherNode(this.node);
            DisplayNode displayNode2 = displayEdge2.getOtherNode(this.node);
            if (displayNode == null || displayNode2 == null) {
                return displayNode == null ? (displayNode2 == null ? 0 : -1) : 1;
            }
            int n3 = this.getPosition(displayNode);
            if (n3 != (n2 = this.getPosition(displayNode2))) {
                return n3 - n2;
            }
            int n4 = n = n3 == 0 || n3 == 2 ? displayNode2.index - displayNode.index : displayNode.index - displayNode2.index;
            if (n == 0) {
                n = n3 == 0 || n3 == 1 && this.node.tier == 1 ? displayEdge2.getId().compareTo(displayEdge.getId()) : displayEdge.getId().compareTo(displayEdge2.getId());
            }
            return n;
        }

        public int getPosition(DisplayNode displayNode) {
            if (displayNode.tier == this.node.tier) {
                return displayNode.index < this.node.index ? 0 : 2;
            }
            return displayNode.tier < this.node.tier ? 1 : 3;
        }
    }

    private static class TierOneEdgeComparator
    implements Comparator {
        public static final int ABOVE = 0;
        public static final int LEFT = 1;
        public static final int BELOW = 2;
        public static final int RIGHT = 3;
        private DisplayNode node;

        public TierOneEdgeComparator(DisplayNode displayNode) {
            this.node = displayNode;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            if (!(object instanceof DisplayEdge) || !(object2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayEdge displayEdge = (DisplayEdge)object;
            DisplayEdge displayEdge2 = (DisplayEdge)object2;
            DisplayNode displayNode = displayEdge.getOtherNode(this.node);
            DisplayNode displayNode2 = displayEdge2.getOtherNode(this.node);
            if (displayNode == null || displayNode2 == null) {
                return displayNode == null ? (displayNode2 == null ? 0 : -1) : 1;
            }
            int n3 = this.getPosition(displayNode);
            if (n3 != (n2 = this.getPosition(displayNode2))) {
                return this.node.tier == 1 ? n3 - n2 : n2 - n3;
            }
            int n4 = n = n3 == 1 || n3 == 3 ? displayNode.index - displayNode2.index : displayNode2.index - displayNode.index;
            if (this.node.tier == 1) {
                n = -n;
            }
            if (n == 0) {
                n = n3 == 1 || n3 == 0 ? displayEdge2.getId().compareTo(displayEdge.getId()) : displayEdge.getId().compareTo(displayEdge2.getId());
            }
            return n;
        }

        public int getPosition(DisplayNode displayNode) {
            if (displayNode.tier == this.node.tier) {
                return displayNode.index < this.node.index ? 1 : 3;
            }
            return displayNode.tier < this.node.tier ? 0 : 2;
        }
    }

    private static final class DiagonalTierEdgeComparator
    implements Comparator {
        private DisplayNode node;

        public DiagonalTierEdgeComparator(DisplayNode displayNode) {
            this.node = displayNode;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof DisplayEdge) || !(object2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayNode displayNode = ((DisplayEdge)object).getOtherNode(this.node);
            DisplayNode displayNode2 = ((DisplayEdge)object2).getOtherNode(this.node);
            int n = displayNode.index - displayNode2.index;
            if (n == 0) {
                n = displayNode.getId().compareTo(displayNode2.getId());
            }
            if (displayNode.index < this.node.index && displayNode2.index < this.node.index && displayNode.index != displayNode2.index) {
                n = -n;
            }
            return n;
        }
    }

    private static final class DisplayModel
    implements CCTopologyModelInterface {
        public boolean hasNodeBadges;
        public boolean hasEdgeBadges;
        public boolean hasArrowheads;
        public boolean hasSelectableEdges;
        public boolean hasGroupNodes;
        public boolean hasGroupEdges;
        private final int tierCount;
        private final DisplayNode[][] displayNodes;
        private final DisplayEdge[] displayEdges;
        private final Map elementMap = new HashMap();

        DisplayModel(CCTopologyModelInterface cCTopologyModelInterface, CCI18N cCI18N, CCI18N cCI18N2) {
            int n;
            CCTopologyModelInterface.Node[][] nodeArrayArray = new CCTopologyModelInterface.Node[3][];
            int n2 = cCTopologyModelInterface.getTierCount();
            for (n = 0; n < n2; ++n) {
                nodeArrayArray[n] = cCTopologyModelInterface.getTierNodes(n);
            }
            if (n2 == 2) {
                n2 = 3;
                nodeArrayArray[2] = nodeArrayArray[1];
                nodeArrayArray[1] = nodeArrayArray[0];
                nodeArrayArray[0] = new DisplayNode[0];
            }
            this.tierCount = n2;
            this.displayNodes = new DisplayNode[n2][];
            for (n = 0; n < n2; ++n) {
                ArrayList arrayList = new ArrayList();
                this.createDisplayNodes(arrayList, nodeArrayArray[n], 0, cCI18N, cCI18N2, cCTopologyModelInterface.getBadgeSet());
                this.displayNodes[n] = arrayList.toArray(new DisplayNode[arrayList.size()]);
                boolean bl = n2 != 1 && n == 0;
                for (int i = 0; i < this.displayNodes[n].length; ++i) {
                    this.displayNodes[n][i].tier = n;
                    this.displayNodes[n][i].i18n = cCI18N2;
                    this.displayNodes[n][i].index = bl ? this.displayNodes[n].length - 1 - i : i;
                }
            }
            this.displayEdges = this.createDisplayEdges(cCTopologyModelInterface.getEdges(), cCI18N, cCI18N2, cCTopologyModelInterface.getBadgeSet());
            for (n = 0; n < this.displayEdges.length; ++n) {
                this.displayEdges[n].displaySource.edges.add(this.displayEdges[n]);
                this.displayEdges[n].displayDestination.edges.add(this.displayEdges[n]);
                if (!this.hasEdgeBadges && this.displayEdges[n].getBadge() != 0) {
                    this.hasEdgeBadges = true;
                }
                if (!this.hasArrowheads && this.displayEdges[n].isDirected()) {
                    this.hasArrowheads = true;
                }
                if (!this.hasGroupEdges && this.displayEdges[n].isGroup) {
                    this.hasGroupEdges = true;
                }
                if (this.hasSelectableEdges || this.displayEdges[n].getAction() == 0) continue;
                this.hasSelectableEdges = true;
            }
        }

        public int getTierCount() {
            return this.tierCount;
        }

        public CCTopologyModelInterface.Node[] getTierNodes(int n) {
            return n >= 0 && n < this.tierCount ? this.displayNodes[n] : new CCTopologyModelInterface.Node[]{};
        }

        public CCTopologyModelInterface.Edge[] getEdges() {
            return this.displayEdges;
        }

        public CCTopologyModelInterface.IconSet getIconSet() {
            return null;
        }

        public CCTopologyModelInterface.BadgeSet getBadgeSet() {
            return null;
        }

        public CCTopologyModelInterface.ActionSet getActionSet() {
            return null;
        }

        public CCTopologyModelInterface.Node getNode(String string) {
            return null;
        }

        public CCTopologyModelInterface.Edge getEdge(String string) {
            return null;
        }

        public String getName() {
            return null;
        }

        public Object getValue(String string) {
            return null;
        }

        public Object[] getValues(String string) {
            return null;
        }

        public void setName(String string) {
        }

        public void setValue(String string, Object object) {
        }

        public void setValues(String string, Object[] objectArray) {
        }

        public DisplayElement getDisplayElement(Object object) {
            return object == null ? null : (object instanceof DisplayElement ? (DisplayElement)object : (DisplayElement)this.elementMap.get(object));
        }

        private int createDisplayNodes(List list, CCTopologyModelInterface.Node[] nodeArray, int n, CCI18N cCI18N, CCI18N cCI18N2, CCTopologyModelInterface.BadgeSet badgeSet) {
            if (nodeArray == null) {
                return 0;
            }
            int n2 = 0;
            for (int i = 0; i < nodeArray.length; ++i) {
                DisplayNode displayNode = null;
                displayNode = nodeArray[i] instanceof CCTopologyModelInterface.GroupNode ? new DisplayGroupNode((CCTopologyModelInterface.GroupNode)nodeArray[i], n, cCI18N, cCI18N2, badgeSet) : new DisplayNode(nodeArray[i], n, cCI18N2, badgeSet);
                list.add(displayNode);
                this.elementMap.put(nodeArray[i], displayNode);
                if (!this.hasNodeBadges && displayNode.getBadge() != 0) {
                    this.hasNodeBadges = true;
                }
                if (!this.hasGroupNodes && displayNode.isGroup) {
                    this.hasGroupNodes = true;
                }
                if (displayNode.isExpanded) {
                    displayNode.childCount = this.createDisplayNodes(list, displayNode.nodes, n + 1, cCI18N, cCI18N2, badgeSet);
                    n2 += displayNode.childCount;
                    continue;
                }
                if (displayNode.isGroup) {
                    displayNode.childCount = this.setDisplayNode(nodeArray[i], displayNode);
                    n2 += displayNode.childCount;
                    continue;
                }
                ++n2;
            }
            return n2;
        }

        private int setDisplayNode(CCTopologyModelInterface.Node node, DisplayNode displayNode) {
            this.elementMap.put(node, displayNode);
            int n = 1;
            if (node instanceof CCTopologyModelInterface.GroupNode) {
                CCTopologyModelInterface.GroupNode groupNode = (CCTopologyModelInterface.GroupNode)node;
                CCTopologyModelInterface.Node[] nodeArray = groupNode.getNodes();
                for (int i = 0; i < nodeArray.length; ++i) {
                    n += this.setDisplayNode(nodeArray[i], displayNode);
                }
                if (groupNode.usesSubnodeRollup()) {
                    --n;
                }
            }
            return n;
        }

        private DisplayNode getDisplayNode(CCTopologyModelInterface.Node node) {
            try {
                return (DisplayNode)this.elementMap.get(node);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private DisplayEdge[] createDisplayEdges(CCTopologyModelInterface.Edge[] edgeArray, CCI18N cCI18N, CCI18N cCI18N2, CCTopologyModelInterface.BadgeSet badgeSet) {
            ArrayList<DisplayEdge> arrayList = new ArrayList<DisplayEdge>();
            for (int i = 0; i < edgeArray.length; ++i) {
                DisplayEdge displayEdge;
                boolean bl;
                CCTopologyModelInterface.Node node = edgeArray[i].getSource();
                CCTopologyModelInterface.Node node2 = edgeArray[i].getDestination();
                DisplayNode displayNode = this.getDisplayNode(node);
                DisplayNode displayNode2 = this.getDisplayNode(node2);
                if (displayNode == null || displayNode2 == null) continue;
                boolean bl2 = bl = !node.getId().equals(displayNode.getId()) || !node2.getId().equals(displayNode2.getId());
                if (bl) {
                    if (displayNode == displayNode2) continue;
                    displayEdge = displayNode.getDisplayEdge(displayNode2);
                    if (displayEdge == null) {
                        displayEdge = new DisplayEdge(edgeArray[i], cCI18N, cCI18N2, displayNode, displayNode2, true);
                        arrayList.add(displayEdge);
                        this.elementMap.put(edgeArray[i], displayEdge);
                        continue;
                    }
                    displayEdge.addEdge(edgeArray[i], displayNode, displayNode2, badgeSet);
                    continue;
                }
                displayEdge = new DisplayEdge(edgeArray[i], null, cCI18N2, displayNode, displayNode2, false);
                arrayList.add(displayEdge);
                this.elementMap.put(edgeArray[i], displayEdge);
            }
            return arrayList.toArray(new DisplayEdge[arrayList.size()]);
        }
    }

    private static final class DisplayEdge
    extends CCTopologyEdge
    implements DisplayElement,
    Comparable {
        public DisplayNode displaySource;
        public DisplayNode displayDestination;
        public boolean isGroup;
        public Point sourcePoint;
        public Point destinationPoint;
        public int badgePoint = -1;
        public int offset;
        private Point[] points;
        private Polygon area;
        private final CCI18N cci18n;
        private final CCI18N i18n;
        public int edgeCount = 1;
        public int sortIndex;

        DisplayEdge(CCTopologyModelInterface.Edge edge, CCI18N cCI18N, CCI18N cCI18N2, DisplayNode displayNode, DisplayNode displayNode2, boolean bl) {
            super(bl ? displayNode.getId() + "^cc^" + displayNode2.getId() : edge.getId(), displayNode, displayNode2, bl ? "topology.group.edge" : edge.getTooltip(), bl ? -2147483647 : edge.getAction(), edge.isInFilter(), edge.getBadge(), edge.getBadgeTooltip(), bl ? -2147483646 : edge.getBadgeAction(), edge.isDirected(), edge.isBidirectional());
            this.displaySource = displayNode;
            this.displayDestination = displayNode2;
            this.i18n = cCI18N2;
            this.cci18n = cCI18N;
            this.isGroup = bl;
            displayNode.addDisplayEdge(displayNode2, this);
        }

        public String getTooltip() {
            return this.localizeTooltip(super.getTooltip());
        }

        public String getBadgeTooltip() {
            return this.localizeTooltip(super.getBadgeTooltip());
        }

        private String localizeTooltip(String string) {
            String string2 = null;
            if (string != null) {
                boolean bl;
                boolean bl2 = string == "topology.group.edge";
                boolean bl3 = bl = string == "topology.group.edge.badge";
                if (this.i18n != null) {
                    string2 = bl2 ? this.i18n.getMessage(string, new String[]{String.valueOf(this.edgeCount)}) : this.i18n.getMessage(string);
                }
                if ((bl2 || bl) && string2.equals(string) && this.cci18n != null) {
                    string2 = this.cci18n.getMessage(string, new String[]{String.valueOf(this.edgeCount)});
                }
            }
            return string2;
        }

        public void addEdge(CCTopologyModelInterface.Edge edge, DisplayNode displayNode, DisplayNode displayNode2, CCTopologyModelInterface.BadgeSet badgeSet) {
            ++this.edgeCount;
            this.inFilter |= edge.isInFilter();
            if (badgeSet != null) {
                int n = badgeSet.getCombinedBadge(this.badge, edge.getBadge());
                if (n != this.badge) {
                    this.badgeTooltip = edge.getBadgeTooltip();
                }
                this.badge = n;
            }
            if (displayNode != displayNode2 && !this.bidirectional && edge.isDirected()) {
                if (edge.isBidirectional()) {
                    this.directed = true;
                    this.bidirectional = true;
                } else if (displayNode == this.getSource()) {
                    this.directed = true;
                } else if (this.directed) {
                    this.bidirectional = true;
                } else {
                    DisplayNode displayNode3 = this.displaySource;
                    this.displaySource = this.displayDestination;
                    this.source = this.displaySource;
                    this.displayDestination = displayNode3;
                    this.destination = this.displayDestination;
                    this.directed = true;
                }
            }
        }

        public Polygon getArea() {
            if (this.area != null) {
                return this.area;
            }
            this.getPoints();
            int n = this.points[0].x < this.points[2].x ? 2 : -2;
            int n2 = this.points[0].y < this.points[2].y ? 2 : -2;
            this.area = new Polygon();
            if (this.points[0].y == this.points[1].y) {
                int n3 = this.points[0].x;
                int n4 = this.points[0].y - n2;
                this.area.addPoint(n3, n4);
                n3 = this.points[1].x + n;
                this.area.addPoint(n3, n4);
                if (this.points.length == 3) {
                    n4 = this.points[2].y;
                    this.area.addPoint(n3, n4);
                } else {
                    n4 = this.points[2].y + n2;
                    this.area.addPoint(n3, n4);
                    n3 = this.points[3].x;
                    this.area.addPoint(n3, n4);
                    n4 = this.points[3].y - n2;
                    this.area.addPoint(n3, n4);
                }
                n3 = this.points[2].x - n;
                this.area.addPoint(n3, n4);
                n4 = this.points[1].y + n2;
                this.area.addPoint(n3, n4);
                n3 = this.points[0].x;
                this.area.addPoint(n3, n4);
            } else {
                int n5 = this.points[0].x + n;
                int n6 = this.points[0].y;
                this.area.addPoint(n5, n6);
                n6 = this.points[1].y - n2;
                this.area.addPoint(n5, n6);
                if (this.points.length == 3) {
                    n5 = this.points[2].x;
                    this.area.addPoint(n5, n6);
                } else {
                    n5 = this.points[2].x - n;
                    this.area.addPoint(n5, n6);
                    n6 = this.points[3].y;
                    this.area.addPoint(n5, n6);
                    n5 = this.points[2].x + n;
                    this.area.addPoint(n5, n6);
                }
                n6 = this.points[2].y + n2;
                this.area.addPoint(n5, n6);
                n5 = this.points[1].x - n;
                this.area.addPoint(n5, n6);
                n6 = this.points[0].y;
                this.area.addPoint(n5, n6);
            }
            return this.area;
        }

        public DisplayNode getOtherNode(DisplayNode displayNode) {
            return displayNode == this.displaySource ? this.displayDestination : this.displaySource;
        }

        public void invalidateLayout() {
            this.points = null;
            this.area = null;
        }

        public Point[] getPoints() {
            if (this.sourcePoint == null || this.destinationPoint == null) {
                return new Point[0];
            }
            if (this.points != null) {
                return this.points;
            }
            if (this.offset == 0) {
                this.points = new Point[]{this.sourcePoint, this.sourcePoint.x < this.destinationPoint.x ? new Point(this.destinationPoint.x, this.sourcePoint.y) : new Point(this.sourcePoint.x, this.destinationPoint.y), this.destinationPoint};
                this.badgePoint = 1;
            } else {
                boolean bl;
                boolean bl2 = bl = this.displaySource.tier != 1;
                if (bl) {
                    Point[] pointArray;
                    Point point = this.sourcePoint.y < this.destinationPoint.y ? this.sourcePoint : this.destinationPoint;
                    Point point2 = point == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    int n = this.sourcePoint.x + this.offset;
                    Point point3 = new Point(n, point.y);
                    Point point4 = new Point(n, point2.y);
                    if (point == this.sourcePoint) {
                        Point[] pointArray2 = new Point[4];
                        pointArray2[0] = point;
                        pointArray2[1] = point3;
                        pointArray2[2] = point4;
                        pointArray = pointArray2;
                        pointArray2[3] = point2;
                    } else {
                        Point[] pointArray3 = new Point[4];
                        pointArray3[0] = point2;
                        pointArray3[1] = point4;
                        pointArray3[2] = point3;
                        pointArray = pointArray3;
                        pointArray3[3] = point;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].y < this.points[2].y ? 1 : 2;
                } else {
                    Point[] pointArray;
                    Point point = this.sourcePoint.x < this.destinationPoint.x ? this.sourcePoint : this.destinationPoint;
                    Point point5 = point == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    int n = this.sourcePoint.y + this.offset;
                    Point point6 = new Point(point.x, n);
                    Point point7 = new Point(point5.x, n);
                    if (point == this.sourcePoint) {
                        Point[] pointArray4 = new Point[4];
                        pointArray4[0] = point;
                        pointArray4[1] = point6;
                        pointArray4[2] = point7;
                        pointArray = pointArray4;
                        pointArray4[3] = point5;
                    } else {
                        Point[] pointArray5 = new Point[4];
                        pointArray5[0] = point5;
                        pointArray5[1] = point7;
                        pointArray5[2] = point6;
                        pointArray = pointArray5;
                        pointArray5[3] = point;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].x < this.points[2].x ? 1 : 2;
                }
            }
            return this.points;
        }

        public int compareTo(Object object) {
            try {
                return this.sortIndex - ((DisplayEdge)object).sortIndex;
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
        }
    }

    private static class DisplayNode
    implements DisplayElement,
    CCTopologyModelInterface.Node {
        public final CCTopologyModelInterface.Node node;
        public CCI18N i18n;
        public int tier;
        public int index;
        public Rectangle imageBounds;
        public Rectangle labelBounds;
        public Point turnerPoint;
        public Collection edges = new ArrayList();
        public int aboveEdgeCount;
        public int belowEdgeCount;
        public int nesting;
        public int groupLineLength;
        public int badge;
        public int childCount;
        public String tooltip;
        public boolean isGroup;
        public boolean isExpanded;
        public boolean usesPluralIcon;
        public CCTopologyModelInterface.Node[] nodes;
        private Map displayEdges = new HashMap();

        DisplayNode(CCTopologyModelInterface.Node node, int n, CCI18N cCI18N, CCTopologyModelInterface.BadgeSet badgeSet) {
            this.node = node;
            this.nesting = n;
            if (node instanceof CCTopologyModelInterface.GroupNode) {
                CCTopologyModelInterface.GroupNode groupNode = (CCTopologyModelInterface.GroupNode)node;
                this.isGroup = true;
                this.isExpanded = groupNode.isExpanded();
                this.usesPluralIcon = groupNode.usesPluralIcon();
                this.nodes = groupNode.getNodes();
                this.badge = DisplayNode.getGroupBadge(groupNode, badgeSet);
                this.tooltip = DisplayNode.getGroupTooltip(groupNode, cCI18N);
            } else {
                this.badge = node.getBadge();
            }
        }

        public String getId() {
            return this.node.getId();
        }

        public String getLabel() {
            String string = this.node.getLabel();
            try {
                if (this.i18n != null && string != null) {
                    string = this.i18n.getMessage(string);
                }
            }
            catch (Throwable throwable) {
                CCDebug.trace3("node.getLabel() : " + this.node.getLabel());
                CCDebug.trace3(string + " (" + this.childCount + ")", throwable);
            }
            return this.isGroup ? string + " (" + this.childCount + ')' : string;
        }

        public String getTooltip() {
            if (this.tooltip != null) {
                return this.tooltip;
            }
            String string = this.node.getTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public int getAction() {
            return this.node.getAction();
        }

        public boolean isInFilter() {
            return this.node.isInFilter();
        }

        public int getBadge() {
            return this.badge;
        }

        public String getBadgeTooltip() {
            String string = this.node.getBadgeTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public int getBadgeAction() {
            return this.node.getBadgeAction();
        }

        public int getIcon() {
            return this.node.getIcon();
        }

        public void addDisplayEdge(DisplayNode displayNode, DisplayEdge displayEdge) {
            this.displayEdges.put(displayNode, displayEdge);
        }

        private DisplayEdge getDisplayEdge(DisplayNode displayNode) {
            DisplayEdge displayEdge = (DisplayEdge)this.displayEdges.get(displayNode);
            if (displayEdge == null) {
                displayEdge = (DisplayEdge)displayNode.displayEdges.get(this);
            }
            return displayEdge;
        }

        public static String getGroupTooltip(CCTopologyModelInterface.GroupNode groupNode, CCI18N cCI18N) {
            String string = groupNode.getTooltip();
            CCTopologyModelInterface.Node[] nodeArray = groupNode.getNodes();
            if (string == null && groupNode.usesSubnodeRollup() && nodeArray != null) {
                NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (i > 0) {
                        nonSyncStringBuffer.append(", ");
                    }
                    String string2 = nodeArray[i].getLabel();
                    nonSyncStringBuffer.append(cCI18N == null || string2 == null ? string2 : cCI18N.getMessage(string2));
                }
                string = nonSyncStringBuffer.toString();
            }
            return string;
        }

        public static int getGroupBadge(CCTopologyModelInterface.GroupNode groupNode, CCTopologyModelInterface.BadgeSet badgeSet) {
            int n = groupNode.getBadge();
            if (badgeSet != null && n == 0 && groupNode.usesSubnodeRollup()) {
                CCTopologyModelInterface.Node[] nodeArray = groupNode.getNodes();
                for (int i = 0; i < nodeArray.length; ++i) {
                    int n2 = nodeArray[i] instanceof CCTopologyModelInterface.GroupNode ? DisplayNode.getGroupBadge((CCTopologyModelInterface.GroupNode)nodeArray[i], badgeSet) : nodeArray[i].getBadge();
                    n = badgeSet.getCombinedBadge(n, n2);
                }
            }
            if (groupNode instanceof CCTopologyNode) {
                ((CCTopologyNode)((Object)groupNode)).setBadge(n);
            }
            return n;
        }
    }

    private static final class DisplayGroupNode
    extends DisplayNode
    implements CCTopologyModelInterface.GroupNode {
        private final CCI18N cci18n;

        public DisplayGroupNode(CCTopologyModelInterface.GroupNode groupNode, int n, CCI18N cCI18N, CCI18N cCI18N2, CCTopologyModelInterface.BadgeSet badgeSet) {
            super(groupNode, n, cCI18N2, badgeSet);
            this.cci18n = cCI18N;
        }

        public CCTopologyModelInterface.Node[] getNodes() {
            return this.nodes != null ? this.nodes : new CCTopologyModelInterface.Node[]{};
        }

        public String getBadgeTooltip() {
            String string = null;
            if (this.usesSubnodeRollup() && this.getBadge() != 0) {
                String string2 = "topology.group.node.badge";
                if (this.i18n != null) {
                    this.tooltip = this.i18n.getMessage(string2);
                }
                if (this.tooltip.equals(string2) && this.cci18n != null) {
                    this.tooltip = this.cci18n.getMessage(string2);
                }
                if (!this.tooltip.equals(string2)) {
                    string = ", " + this.tooltip;
                }
            }
            return string != null ? super.getBadgeTooltip() : super.getBadgeTooltip() + string;
        }

        public int getBadgeAction() {
            int n = this.node.getBadgeAction();
            if (this.usesSubnodeRollup() && this.getBadge() != 0) {
                n = -2147483645;
            }
            return n;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public void setExpanded(boolean bl) {
            this.isExpanded = bl;
        }

        public boolean usesPluralIcon() {
            return this.usesPluralIcon;
        }

        public boolean usesSubnodeRollup() {
            return ((CCTopologyModelInterface.GroupNode)this.node).usesSubnodeRollup();
        }
    }

    private static interface DisplayElement {
        public String getId();

        public String getTooltip();

        public int getAction();

        public boolean isInFilter();

        public int getBadge();

        public String getBadgeTooltip();

        public int getBadgeAction();
    }
}

