/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.filechooser;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.OptionList;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.filechooser.CCPopupEventHandlerInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.html.CCTextField;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CCFileChooser
extends RequestHandlingViewBase
implements CCStateData {
    public static final String FILE_NAME_TEXT = "fileName";
    public static final String ENTER_FLAG = "enterFlag";
    public static final String LOOK_IN_TEXTFIELD = "lookIn";
    public static final String TIME_TO_SORT_HREF = "timeToSort";
    public static final String LOOK_IN_COMMAND_HREF = "lookInEntered";
    public static final String ENTER_COMMAND_HREF = "listLookInEntered";
    public static final String SELECTED_FILE_COMMAND_HREF = "selectedFileEntered";
    public static final String FILE_TYPE_FILTER = "fileType";
    public static final String SORT_MENU = "sortField";
    public static final String FILE_LIST = "files";
    public static final String MOVE_UP_BUTTON = "moveUp";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String DB_CLICK_COMMAND_HREF = "DBClicked";
    public static final String OPEN_FOLDER_BUTTON = "openFolder";
    public static final String FILECHOOSER_ALERT_MSG = "alert";
    public static final String ENTER_KEY_PRESSED = "enterPressed";
    public static final String ENTER_KEY_PRESSED_INLISTBOX = "enterList";
    public static final String WINDOWS_OS = "window";
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private static final String SHOW_IN_DIALOG = "showInDialog";
    private static final String SHOW_CONTROL_BUTTONS = "showControlBtns";
    private static final String FILE_CHOOSER_TYPE = "type";
    protected CCFileChooserModelInterface model;
    private OptionList sortMenuOptions = new OptionList(new String[]{"filechooser.sortOption1", "filechooser.sortOption4", "filechooser.sortOption2", "filechooser.sortOption5", "filechooser.sortOption3", "filechooser.sortOption6"}, new String[]{"filechooser.sortOption1", "filechooser.sortOption4", "filechooser.sortOption2", "filechooser.sortOption5", "filechooser.sortOption3", "filechooser.sortOption6"});

    public CCFileChooser(ContainerView containerView, CCFileChooserModelInterface cCFileChooserModelInterface, String string) {
        super((View)containerView, string);
        CCDebug.initTrace();
        RequestContext requestContext = this.getRequestContext();
        this.setModel(cCFileChooserModelInterface);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(FILE_LIST, CCSelectableList.class);
        this.registerChild(LOOK_IN_TEXTFIELD, CCTextField.class);
        this.registerChild(FILE_TYPE_FILTER, CCTextField.class);
        this.registerChild(FILE_NAME_TEXT, CCTextField.class);
        this.registerChild(ENTER_FLAG, CCHiddenField.class);
        this.registerChild(SORT_MENU, CCDropDownMenu.class);
        this.registerChild(OPEN_FOLDER_BUTTON, CCButton.class);
        this.registerChild(MOVE_UP_BUTTON, CCButton.class);
        this.registerChild(CANCEL_BUTTON, CCButton.class);
        this.registerChild(LOOK_IN_COMMAND_HREF, HREF.class);
        this.registerChild(ENTER_COMMAND_HREF, HREF.class);
        this.registerChild(SELECTED_FILE_COMMAND_HREF, HREF.class);
        this.registerChild(TIME_TO_SORT_HREF, HREF.class);
        this.registerChild(DB_CLICK_COMMAND_HREF, HREF.class);
        this.registerChild(FILECHOOSER_ALERT_MSG, CCAlertInline.class);
    }

    protected View createChild(String string) {
        if (string.equals(FILE_LIST)) {
            return new CCSelectableList((ContainerView)this, string, null);
        }
        if (string.equals(LOOK_IN_COMMAND_HREF) || string.equals(ENTER_COMMAND_HREF) || string.equals(SELECTED_FILE_COMMAND_HREF) || string.equals(TIME_TO_SORT_HREF) || string.equals(DB_CLICK_COMMAND_HREF)) {
            return new HREF((ContainerView)this, string, null);
        }
        if (string.equals(FILE_NAME_TEXT)) {
            return new CCTextField((ContainerView)this, string, null);
        }
        if (string.equals(ENTER_FLAG)) {
            return new CCHiddenField((ContainerView)this, string, null);
        }
        if (string.equals(LOOK_IN_TEXTFIELD) || string.equals(FILE_TYPE_FILTER)) {
            return new CCTextField((ContainerView)this, string, null);
        }
        if (string.equals(SORT_MENU)) {
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            cCDropDownMenu.setOptions(this.sortMenuOptions);
            cCDropDownMenu.setCommandChild(TIME_TO_SORT_HREF);
            return cCDropDownMenu;
        }
        if (string.equals(OPEN_FOLDER_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, "filechooser.openFolder");
            return cCButton;
        }
        if (string.equals(MOVE_UP_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, "filechooser.upOneLevel");
            return cCButton;
        }
        if (string.equals(CANCEL_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, "filechooser.cancel");
            return cCButton;
        }
        if (string.equals(FILECHOOSER_ALERT_MSG)) {
            return new CCAlertInline((ContainerView)this, string, null);
        }
        throw new IllegalArgumentException("Invalid child name [" + string + "]");
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
        this.restoreStateData();
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, this.model.getCurrentDirectory());
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
    }

    public void resetStateData() throws ModelControlException {
        this.setDisplayFieldValue(FILE_NAME_TEXT, null);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, null);
        this.setDisplayFieldValue(FILE_TYPE_FILTER, null);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public Map getStateData() throws ModelControlException {
        String string;
        String string2;
        String string3;
        this.restoreStateData();
        if (this.model == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String[] stringArray = this.model.getSelectedFiles();
        if (stringArray != null) {
            hashMap.put(FILE_NAME_TEXT, stringArray);
        }
        if ((string3 = this.model.getCurrentDirectory()) != null) {
            hashMap.put(LOOK_IN_TEXTFIELD, string3);
        }
        if ((string2 = this.model.getFilterString()) != null) {
            hashMap.put(FILE_TYPE_FILTER, string2);
        }
        if ((string = this.model.getType()) != null) {
            hashMap.put(FILE_CHOOSER_TYPE, string);
        }
        return hashMap;
    }

    public void restoreStateData() throws ModelControlException {
        Object object;
        if (this.model == null) {
            return;
        }
        Map map = (Map)this.getParentViewBean().getPageSessionAttribute(this.STATE_DATA);
        if (map == null) {
            return;
        }
        String string = (String)map.get(FILE_CHOOSER_TYPE);
        if (string != null) {
            this.model.setType(string);
        }
        if (this.model.getFileFilter() == null && (object = (String[])map.get(FILE_TYPE_FILTER)) != null) {
            this.model.setFilterString((String)object);
        }
        if (this.model.getSelectedFiles() == null && (object = (String[])map.get(FILE_NAME_TEXT)) != null && ((String[])object).length != 0) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.model.addSelectedFile(object[i]);
            }
        }
        if (this.model.getCurrentDirectory() == null && (object = (String)map.get(LOOK_IN_TEXTFIELD)) != null) {
            this.model.setCurrentDirectory((String)object);
        }
    }

    public void setStateData(Map map) throws ModelControlException {
        String string;
        String string2;
        String[] stringArray;
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.resetStateData();
        String string3 = (String)map.get(FILE_CHOOSER_TYPE);
        if (string3 != null) {
            this.model.setType(string3);
        }
        if ((stringArray = (String[])map.get(FILE_NAME_TEXT)) != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.addSelectedFile(stringArray[i]);
            }
        }
        if ((string2 = (String)map.get(LOOK_IN_TEXTFIELD)) != null) {
            this.model.setCurrentDirectory(string2);
        }
        if ((string = (String)map.get(FILE_TYPE_FILTER)) != null) {
            this.model.setFilterString(string);
        }
    }

    public void setModel(CCFileChooserModelInterface cCFileChooserModelInterface) throws IllegalArgumentException {
        if (cCFileChooserModelInterface == null) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.model = cCFileChooserModelInterface;
    }

    public CCFileChooserModelInterface getModel() {
        return this.model;
    }

    public void handleOpenFolderRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        Object object;
        this.setSortField();
        CCSelectableList cCSelectableList = (CCSelectableList)this.getChild(FILE_LIST);
        String string = null;
        Object[] objectArray = cCSelectableList.getValues();
        if (objectArray == null || objectArray.length == 0) {
            this.displayAlert("filechooser.noFolderSelectedErrSum", "filechooser.noFolderSelectedErrDet", null, null);
        } else if (objectArray.length > 1) {
            this.displayAlert("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
        } else {
            string = (String)objectArray[0];
            object = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
            if (object == null || ((String)object).length() == 0) {
                object = this.model.getCurrentDirectory();
            }
            this.loadFiles(requestInvocationEvent, (String)object, string);
        }
        object = this.getParentViewBean();
        object.forwardTo(this.getRequestContext());
    }

    protected void loadFiles(RequestInvocationEvent requestInvocationEvent, String string, String string2) {
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        File[] fileArray = null;
        try {
            if (!cCFileChooserModelInterface.canRead(string)) {
                string = cCFileChooserModelInterface.getCurrentDirectory();
                this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
            } else {
                fileArray = cCFileChooserModelInterface.getFiles(string);
                CCSelectableList cCSelectableList = (CCSelectableList)this.getChild(FILE_LIST);
                int n = new Integer(string2);
                if (fileArray == null) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotCompleteErrDet", null, null);
                    string = cCFileChooserModelInterface.getCurrentDirectory();
                } else if (fileArray.length > 0) {
                    File file = fileArray[n];
                    if (!file.isDirectory()) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotCompleteErrDet", null, null);
                    } else if (!cCFileChooserModelInterface.canRead(string = string.endsWith(File.separator) ? string + file.getName() : string + File.separator + file.getName())) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                        string = cCFileChooserModelInterface.getCurrentDirectory();
                    } else {
                        this.setDisplayFieldValue(FILE_NAME_TEXT, null);
                    }
                    cCSelectableList.setValue(null);
                }
            }
        }
        catch (Exception exception) {
            this.displayAlert("filechooser.cannotCompleteErrSum", exception.getLocalizedMessage(), null, null);
            string = cCFileChooserModelInterface.getCurrentDirectory();
        }
        cCFileChooserModelInterface.setCurrentDirectory(string);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, string);
    }

    public void handleMoveUpRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        String string = (String)this.getDisplayFieldValue(ENTER_FLAG);
        if (string.equals(ENTER_KEY_PRESSED)) {
            this.handleLookInEnteredRequest(requestInvocationEvent);
        } else {
            this.setSortField();
            CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
            String string2 = (String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD);
            int n = string2.indexOf(File.separator);
            int n2 = string2.lastIndexOf(File.separator);
            if (n == n2) {
                if (string2.length() > n + 1) {
                    string2 = string2.substring(0, n + 1);
                } else {
                    this.displayAlert("filechooser.errMoveUpErrSum", "filechooser.errMoveUpErrDet", null, null);
                }
            } else {
                if (string2.endsWith(File.separator)) {
                    string2 = string2.substring(0, n2);
                }
                string2 = (n2 = string2.lastIndexOf(File.separator)) == 0 ? File.separator : string2.substring(0, n2);
            }
            this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, string2);
            this.setDisplayFieldValue(FILE_NAME_TEXT, null);
            cCFileChooserModelInterface.setCurrentDirectory(string2);
            ((CCSelectableList)this.getChild(FILE_LIST)).setValue(null);
            ViewBean viewBean = this.getParentViewBean();
            viewBean.forwardTo(this.getRequestContext());
        }
    }

    public void handleListLookInEnteredRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        this.handleOpenFolderRequest(requestInvocationEvent);
    }

    public void handleSelectedFileEnteredRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        this.setSortField();
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        String string = ((String)this.getDisplayFieldValue(FILE_NAME_TEXT)).trim();
        String string2 = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (string2 == null || string2.length() == 0) {
            string2 = cCFileChooserModelInterface.getCurrentDirectory();
        }
        if (string != null && string.length() > 0) {
            string2 = this.checkSelectedResource(string, string2, cCFileChooserModelInterface);
        }
        cCFileChooserModelInterface.setCurrentDirectory(string2);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, string2);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        ViewBean viewBean = this.getParentViewBean();
        if (cCFileChooserModelInterface.isPopupMode()) {
            ((CCPopupEventHandlerInterface)viewBean).selectFieldEnterEvent(requestInvocationEvent);
        } else {
            viewBean.forwardTo(this.getRequestContext());
        }
    }

    public void handleLookInEnteredRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        this.setSortField();
        String string = null;
        String string2 = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (string2 == null || string2.length() == 0) {
            string = this.model.getHomeDirectory();
        } else {
            string = this.stripExtraSeparators(string2);
            try {
                boolean bl = true;
                if (!this.model.canRead(string)) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                    string = this.model.getCurrentDirectory();
                } else {
                    File[] fileArray = this.model.getFiles(string);
                    if (fileArray == null) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{string2});
                        string = this.model.getCurrentDirectory();
                    }
                }
            }
            catch (Exception exception) {
                this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{string2});
                string = this.model.getCurrentDirectory();
            }
        }
        this.model.setCurrentDirectory(string);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, string);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        ViewBean viewBean = this.getParentViewBean();
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleTimeToSortRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        String string = cCFileChooserModelInterface.getCurrentDirectory();
        this.setSortField();
        ViewBean viewBean = this.getParentViewBean();
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleDBClickedRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        File[] fileArray;
        this.setSortField();
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        CCSelectableList cCSelectableList = (CCSelectableList)this.getChild(FILE_LIST);
        String string = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (string == null || string.length() == 0) {
            string = cCFileChooserModelInterface.getCurrentDirectory();
        }
        String string2 = null;
        Object[] objectArray = cCSelectableList.getValues();
        if (objectArray == null || objectArray.length == 0) {
            this.displayAlert("filechooser.noFolderSelectedErrSum", "filechooser.noFolderSelectedErrDet", null, null);
        } else if (objectArray.length > 1) {
            this.displayAlert("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
        } else {
            string2 = (String)objectArray[0];
            try {
                cCFileChooserModelInterface.clearFiles();
                fileArray = cCFileChooserModelInterface.getFiles(string);
                int n = new Integer(string2);
                if (fileArray.length > 0) {
                    File file = fileArray[n];
                    if (file.isDirectory()) {
                        if (!cCFileChooserModelInterface.canRead(string = string.endsWith(File.separator) ? string + file.getName() : string + File.separator + file.getName())) {
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                            string = cCFileChooserModelInterface.getCurrentDirectory();
                        } else {
                            this.setDisplayFieldValue(FILE_NAME_TEXT, null);
                        }
                        cCSelectableList.setValue(null);
                    } else if (cCFileChooserModelInterface.getType().equals("file")) {
                        cCFileChooserModelInterface.addSelectedFile(string.concat(File.separator).concat(file.getName()));
                    }
                }
            }
            catch (Exception exception) {
                this.displayAlert("filechooser.cannotCompleteErrSum", exception.getLocalizedMessage(), null, null);
            }
        }
        cCFileChooserModelInterface.setCurrentDirectory(string);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, string);
        fileArray = this.getParentViewBean();
        if (cCFileChooserModelInterface.isPopupMode()) {
            ((CCPopupEventHandlerInterface)fileArray).dblClickEvent(requestInvocationEvent);
        } else {
            fileArray.forwardTo(this.getRequestContext());
        }
    }

    public String[] getSelectedResources() {
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        String string = ((String)this.getDisplayFieldValue(FILE_NAME_TEXT)).trim();
        String string2 = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (string2 == null || string2.length() == 0) {
            string2 = cCFileChooserModelInterface.getCurrentDirectory();
        }
        if (string != null && string.length() > 0) {
            string2 = this.checkSelectedResource(string, string2, cCFileChooserModelInterface);
            return cCFileChooserModelInterface.getSelectedFiles();
        }
        CCSelectableList cCSelectableList = (CCSelectableList)this.getChild(FILE_LIST);
        Object[] objectArray = cCSelectableList.getValues();
        cCFileChooserModelInterface.clearFiles();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        File[] fileArray = null;
        try {
            fileArray = cCFileChooserModelInterface.getFiles(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (cCFileChooserModelInterface.getType().equals("file")) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                int n = new Integer(string3);
                if (fileArray[n].isDirectory()) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                    cCFileChooserModelInterface.clearFiles();
                    break;
                }
                this.addSelectedFile(string2, cCFileChooserModelInterface, fileArray[n]);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                String string4 = (String)objectArray[i];
                int n = new Integer(string4);
                if (fileArray[n].isFile()) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                    cCFileChooserModelInterface.clearFiles();
                    break;
                }
                this.addSelectedFile(string2, cCFileChooserModelInterface, fileArray[n]);
            }
        }
        return cCFileChooserModelInterface.getSelectedFiles();
    }

    protected void setSortField() {
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        String string = (String)this.getDisplayFieldValue(SORT_MENU);
        if (string.equals("filechooser.sortOption1")) {
            cCFileChooserModelInterface.setSortField("alpha");
        } else if (string.equals("filechooser.sortOption2")) {
            cCFileChooserModelInterface.setSortField("lma");
        } else if (string.equals("filechooser.sortOption3")) {
            cCFileChooserModelInterface.setSortField("sza");
        } else if (string.equals("filechooser.sortOption4")) {
            cCFileChooserModelInterface.setSortField("alphd");
        } else if (string.equals("filechooser.sortOption5")) {
            cCFileChooserModelInterface.setSortField("lmd");
        } else if (string.equals("filechooser.sortOption6")) {
            cCFileChooserModelInterface.setSortField("szd");
        }
    }

    protected void displayAlert(String string, String string2, String[] stringArray, String[] stringArray2) {
        CCFileChooserModelInterface cCFileChooserModelInterface = this.getModel();
        CCI18N cCI18N = new CCI18N((ServletRequest)RequestManager.getRequest(), (ServletResponse)RequestManager.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        ContainerView containerView = (ContainerView)this.getParent();
        CCAlertInline cCAlertInline = (CCAlertInline)containerView.getChild(cCFileChooserModelInterface.getAlertChildView());
        cCAlertInline.setValue("error");
        if (stringArray != null && stringArray.length != 0) {
            cCAlertInline.setSummary(cCI18N.getMessage(string), stringArray);
        } else {
            cCAlertInline.setSummary(cCI18N.getMessage(string));
        }
        if (stringArray2 != null && stringArray2.length != 0) {
            cCAlertInline.setDetail(cCI18N.getMessage(string2), stringArray2);
        } else {
            cCAlertInline.setDetail(cCI18N.getMessage(string2));
        }
    }

    private String checkSelectedResource(String string, String string2, CCFileChooserModelInterface cCFileChooserModelInterface) {
        block17: {
            boolean bl = false;
            if (cCFileChooserModelInterface.getType().equals("file")) {
                bl = true;
            }
            try {
                cCFileChooserModelInterface.clearFiles();
                String[] stringArray = string.split(",");
                String string3 = null;
                if (stringArray.length == 1) {
                    string3 = this.getAbsolutePath(string, string2);
                    if (!cCFileChooserModelInterface.canRead(string3)) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                        string2 = cCFileChooserModelInterface.getCurrentDirectory();
                    } else {
                        File[] fileArray = cCFileChooserModelInterface.getFiles(string3);
                        if (bl) {
                            if (fileArray == null) {
                                cCFileChooserModelInterface.addSelectedFile(string3);
                            } else {
                                string2 = string3;
                            }
                        } else {
                            cCFileChooserModelInterface.addSelectedFile(string3);
                            string2 = string3;
                        }
                    }
                    break block17;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = this.getAbsolutePath(stringArray[i].trim(), string2);
                    try {
                        if (!cCFileChooserModelInterface.canRead(string3)) continue;
                        File[] fileArray = cCFileChooserModelInterface.getFiles(string3);
                        if (bl) {
                            if (fileArray == null) {
                                cCFileChooserModelInterface.addSelectedFile(string3);
                                continue;
                            }
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                            cCFileChooserModelInterface.clearFiles();
                        } else {
                            if (fileArray != null) {
                                cCFileChooserModelInterface.addSelectedFile(string3);
                                continue;
                            }
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                            cCFileChooserModelInterface.clearFiles();
                        }
                        break;
                    }
                    catch (Exception exception) {
                        cCFileChooserModelInterface.clearFiles();
                        CCDebug.trace1("cannot read " + string3, exception);
                    }
                }
            }
            catch (Exception exception) {
                String string4 = null;
                string4 = bl ? "filechooser.fileSelectError" : "filechooser.folderSelectError";
                cCFileChooserModelInterface.clearFiles();
                this.displayAlert("filechooser.cannotCompleteErrSum", string4, null, null);
                string2 = cCFileChooserModelInterface.getCurrentDirectory();
            }
        }
        return string2;
    }

    private String getAbsolutePath(String string, String string2) {
        boolean bl = false;
        if (this.getOSName().startsWith(WINDOWS_OS)) {
            if (string.startsWith("\\\\") || string.indexOf(":\\") != -1) {
                bl = true;
            }
        } else if (string.startsWith(File.separator)) {
            bl = true;
        }
        if (bl) {
            return string;
        }
        return string2.concat(File.separator).concat(string);
    }

    private String getOSName() {
        return System.getProperty("os.name").toUpperCase();
    }

    private void addSelectedFile(String string, CCFileChooserModelInterface cCFileChooserModelInterface, File file) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        nonSyncStringBuffer.append(string);
        if (!string.endsWith(File.separator)) {
            nonSyncStringBuffer.append(File.separator);
        }
        nonSyncStringBuffer.append(file.getName());
        cCFileChooserModelInterface.addSelectedFile(nonSyncStringBuffer.toString());
    }

    private String stripExtraSeparators(String string) {
        if (string == null) {
            return null;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == File.separatorChar) {
                if (bl) continue;
                nonSyncStringBuffer.append(string.charAt(i));
                bl = true;
                continue;
            }
            bl = false;
            nonSyncStringBuffer.append(string.charAt(i));
        }
        return nonSyncStringBuffer.toString();
    }
}

