/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.topology;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.CommandFieldBase;
import com.iplanet.jato.view.CommandSourceTargetPair;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class CCTopology
extends CommandFieldBase {
    private CCTopologyModelInterface model;

    public CCTopology(ContainerView containerView, String string, CCTopologyModelInterface cCTopologyModelInterface) {
        super(containerView, string, null);
        this.setTopologyModel(cCTopologyModelInterface);
        CCTopology.expandSimilarGroupNodes(this.getSavedTopologyModel(RequestManager.getSession()), cCTopologyModelInterface);
    }

    protected Object getSourceValue(CommandSourceTargetPair commandSourceTargetPair, int n) {
        return null;
    }

    public CCTopologyModelInterface getTopologyModel() {
        return this.model;
    }

    public CCTopologyModelInterface getSavedTopologyModel(HttpSession httpSession) {
        try {
            String string = "CCTopology." + this.getQualifiedName();
            SoftReference softReference = (SoftReference)httpSession.getAttribute(string);
            return (CCTopologyModelInterface)softReference.get();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public void setTopologyModel(CCTopologyModelInterface cCTopologyModelInterface) {
        if (cCTopologyModelInterface == null) {
            throw new IllegalArgumentException("model == null");
        }
        this.model = cCTopologyModelInterface;
    }

    public String getRequestId(RequestInvocationEvent requestInvocationEvent) {
        HttpServletRequest httpServletRequest = requestInvocationEvent.getRequestContext().getRequest();
        return httpServletRequest.getParameter("cctopologyid");
    }

    public String getRequestAction(RequestInvocationEvent requestInvocationEvent) {
        HttpServletRequest httpServletRequest = requestInvocationEvent.getRequestContext().getRequest();
        return httpServletRequest.getParameter("cctopologyaction");
    }

    public String[] getRequestGroupEdgeNodeIds(RequestInvocationEvent requestInvocationEvent) {
        String string = this.getRequestId(requestInvocationEvent);
        String string2 = this.getRequestAction(requestInvocationEvent);
        if (string != null) {
            int n = string.indexOf("^cc^");
            int n2 = string.indexOf("^cc^", n + 1);
            if (n != -1 && n2 != -1) {
                return new String[]{string.substring(0, n), string.substring(n + "^cc^".length(), n2)};
            }
        }
        return null;
    }

    public int getRequestGroupEdgeBadge(RequestInvocationEvent requestInvocationEvent) {
        String string = this.getRequestId(requestInvocationEvent);
        String string2 = this.getRequestAction(requestInvocationEvent);
        if (string != null) {
            int n = string.indexOf("^cc^");
            int n2 = string.indexOf("^cc^", n + 1);
            if (n != -1 && n2 != -1) {
                try {
                    return Integer.parseInt(string.substring(n2 + "^cc^".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public boolean handleRequest(RequestInvocationEvent requestInvocationEvent) {
        CCTopologyModelInterface cCTopologyModelInterface = this.getSavedTopologyModel(requestInvocationEvent.getRequestContext().getRequest().getSession());
        if (cCTopologyModelInterface == null) {
            cCTopologyModelInterface = this.model;
        }
        Map map = null;
        boolean bl = false;
        try {
            String string = this.getRequestAction(requestInvocationEvent);
            boolean bl2 = "cctrno".equals(string);
            if (bl2 || "cctrnc".equals(string)) {
                CCTopologyModelInterface.GroupNode groupNode = (CCTopologyModelInterface.GroupNode)cCTopologyModelInterface.getNode(this.getRequestId(requestInvocationEvent));
                if (groupNode != null) {
                    groupNode.setExpanded(bl2);
                }
                bl = true;
            } else if ("ccGedg".equals(string)) {
                String[] stringArray = this.getRequestGroupEdgeNodeIds(requestInvocationEvent);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        CCTopologyModelInterface.Node node = cCTopologyModelInterface.getNode(stringArray[i]);
                        if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                        ((CCTopologyModelInterface.GroupNode)node).setExpanded(true);
                    }
                    bl = true;
                }
            } else if ("ccGnodb".equals(string)) {
                CCTopologyModelInterface.GroupNode groupNode = (CCTopologyModelInterface.GroupNode)cCTopologyModelInterface.getNode(this.getRequestId(requestInvocationEvent));
                int n = groupNode.getBadge();
                if (groupNode != null && n != 0) {
                    ArrayList<CCTopologyModelInterface.Node> arrayList = new ArrayList<CCTopologyModelInterface.Node>();
                    arrayList.add(groupNode);
                    while (arrayList.size() > 0) {
                        groupNode = (CCTopologyModelInterface.GroupNode)arrayList.remove(0);
                        groupNode.setExpanded(true);
                        CCTopologyModelInterface.Node[] nodeArray = groupNode.getNodes();
                        for (int i = 0; i < nodeArray.length; ++i) {
                            if (nodeArray[i].getBadge() != n || !(nodeArray[i] instanceof CCTopologyModelInterface.GroupNode)) continue;
                            arrayList.add(nodeArray[i]);
                        }
                    }
                }
                bl = true;
            } else if ("ccGedgb".equals(string)) {
                String[] stringArray = this.getRequestGroupEdgeNodeIds(requestInvocationEvent);
                int n = this.getRequestGroupEdgeBadge(requestInvocationEvent);
                if (n != 0 && stringArray != null) {
                    map = NodeData.createNodeDataMap(cCTopologyModelInterface);
                    CCTopologyModelInterface.Edge[] edgeArray = cCTopologyModelInterface.getEdges();
                    for (int i = 0; i < edgeArray.length; ++i) {
                        if (edgeArray[i] == null || edgeArray[i].getBadge() != n) continue;
                        CCTopologyModelInterface.Node node = edgeArray[i].getSource();
                        CCTopologyModelInterface.Node node2 = edgeArray[i].getDestination();
                        if (node == null || node2 == null) continue;
                        NodeData nodeData = (NodeData)map.get(node.getId());
                        NodeData nodeData2 = (NodeData)map.get(node2.getId());
                        if (nodeData == null || nodeData2 == null) continue;
                        boolean bl3 = nodeData.openIfDescendent(stringArray);
                        boolean bl4 = nodeData2.openIfDescendent(stringArray);
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            CCDebug.trace1("Could not handle request", exception);
        }
        CCTopology.expandSimilarGroupNodes(cCTopologyModelInterface, this.model, map);
        return bl;
    }

    protected static void expandSimilarGroupNodes(CCTopologyModelInterface cCTopologyModelInterface, CCTopologyModelInterface cCTopologyModelInterface2) {
        CCTopology.expandSimilarGroupNodes(cCTopologyModelInterface, cCTopologyModelInterface2, null);
    }

    private static void expandSimilarGroupNodes(CCTopologyModelInterface cCTopologyModelInterface, CCTopologyModelInterface cCTopologyModelInterface2, Map map) {
        if (cCTopologyModelInterface != null && cCTopologyModelInterface2 != null && cCTopologyModelInterface2 != cCTopologyModelInterface) {
            NodeData nodeData;
            Object object;
            int n;
            if (map == null) {
                map = NodeData.createNodeDataMap(cCTopologyModelInterface);
            }
            Map map2 = NodeData.createNodeDataMap(cCTopologyModelInterface2);
            ArrayList<CCTopologyModelInterface.Node> arrayList = new ArrayList<CCTopologyModelInterface.Node>();
            for (n = 0; n < cCTopologyModelInterface.getTierCount(); ++n) {
                arrayList.addAll(Arrays.asList(cCTopologyModelInterface.getTierNodes(n)));
            }
            while (arrayList.size() > 0) {
                CCTopologyModelInterface.Node node = (CCTopologyModelInterface.Node)arrayList.remove(0);
                if (node instanceof CCTopologyModelInterface.GroupNode) {
                    arrayList.addAll(Arrays.asList(((CCTopologyModelInterface.GroupNode)node).getNodes()));
                    continue;
                }
                object = (NodeData)map.get(node.getId());
                nodeData = (NodeData)map2.get(node.getId());
                if (object == null || nodeData == null || ((NodeData)object).depth != nodeData.depth) continue;
                NodeData nodeData2 = ((NodeData)object).parent;
                NodeData nodeData3 = nodeData.parent;
                while (nodeData2 != null && nodeData3 != null) {
                    nodeData3.openVotes = nodeData2.isOpen ? ++nodeData3.openVotes : --nodeData3.openVotes;
                    nodeData2 = nodeData2.parent;
                    nodeData3 = nodeData3.parent;
                }
            }
            for (n = 0; n < cCTopologyModelInterface2.getTierCount(); ++n) {
                arrayList.addAll(Arrays.asList(cCTopologyModelInterface2.getTierNodes(n)));
            }
            while (arrayList.size() > 0) {
                CCTopologyModelInterface.Node node = (CCTopologyModelInterface.Node)arrayList.remove(0);
                if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                object = (CCTopologyModelInterface.GroupNode)node;
                arrayList.addAll(Arrays.asList(object.getNodes()));
                nodeData = (NodeData)map2.get(node.getId());
                if (nodeData == null) continue;
                object.setExpanded(nodeData.openVotes > 0);
            }
        }
    }

    static final class NodeData {
        public int openVotes = 0;
        public final CCTopologyModelInterface.Node node;
        public final NodeData parent;
        public final int depth;
        public boolean isOpen;

        public NodeData(NodeData nodeData, CCTopologyModelInterface.Node node) {
            this.node = node;
            this.parent = nodeData;
            this.depth = nodeData == null ? 0 : nodeData.depth + 1;
            this.isOpen = node instanceof CCTopologyModelInterface.GroupNode ? ((CCTopologyModelInterface.GroupNode)node).isExpanded() : false;
        }

        public boolean openIfDescendent(String[] stringArray) {
            String string = this.node.getId();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                this.isOpen = true;
                return true;
            }
            if (this.parent != null && this.parent.openIfDescendent(stringArray)) {
                this.isOpen = true;
                return true;
            }
            return false;
        }

        public static Map createNodeDataMap(CCTopologyModelInterface cCTopologyModelInterface) {
            HashMap hashMap = new HashMap();
            for (int i = 0; i < cCTopologyModelInterface.getTierCount(); ++i) {
                NodeData.addNodeData(hashMap, null, cCTopologyModelInterface.getTierNodes(i));
            }
            return hashMap;
        }

        private static void addNodeData(Map map, NodeData nodeData, CCTopologyModelInterface.Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i] == null) continue;
                NodeData nodeData2 = new NodeData(nodeData, nodeArray[i]);
                map.put(nodeArray[i].getId(), nodeData2);
                if (!(nodeArray[i] instanceof CCTopologyModelInterface.GroupNode)) continue;
                NodeData.addNodeData(map, nodeData2, ((CCTopologyModelInterface.GroupNode)nodeArray[i]).getNodes());
            }
        }
    }
}

