/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.fstype;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Data;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Native;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_HSFS
implements InstanceProvider,
Authorizable {
    private static final String FSMGR_READ_RIGHT = "solaris.admin.fsmgr.read";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil;
    private static final String providerName = "Solaris_HSFS";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, providerName);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        try {
            Object object;
            String string = "";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                object = (CIMProperty)enumeration.nextElement();
                if (!object.getName().equalsIgnoreCase("Name")) continue;
                string = (String)object.getValue().getValue();
            }
            object = this.getHSFSFileSystemData(string);
            if (object != null) {
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, (Solaris_FileSystem_Data)object);
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                return cIMInstance.filterProperties(stringArray, bl2, bl3);
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return null;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = null;
        try {
            this.hash = this.getHSFSFileSystemData();
            vector = new Vector<CIMObjectPath>();
            cIMObjectPathArray = this.hash.elements();
            while (cIMObjectPathArray.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)cIMObjectPathArray.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)providerName));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = null;
        try {
            this.hash = this.getHSFSFileSystemData();
            vector = new Vector<CIMInstance>();
            cIMInstanceArray = this.hash.elements();
            while (cIMInstanceArray.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)cIMInstanceArray.nextElement();
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, solaris_FileSystem_Data);
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, Solaris_FileSystem_Data solaris_FileSystem_Data) throws Exception {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)providerName));
        cIMInstance.setProperty("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
        cIMInstance.setProperty("Root", new CIMValue((Object)solaris_FileSystem_Data.getDevice()));
        UnsignedInt64 unsignedInt64 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getBlockSize());
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)unsignedInt64));
        UnsignedInt64 unsignedInt642 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getFileSystemSize());
        cIMInstance.setProperty("FileSystemSize", new CIMValue((Object)unsignedInt642));
        UnsignedInt64 unsignedInt643 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getAvailableSpace());
        cIMInstance.setProperty("AvailableSpace", new CIMValue((Object)unsignedInt643));
        cIMInstance.setProperty("ReadOnly", new CIMValue((Object)new Boolean(solaris_FileSystem_Data.getReadOnly())));
        cIMInstance.setProperty("EncryptionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CompressionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CaseSensitive", new CIMValue((Object)new Boolean(true)));
        cIMInstance.setProperty("CasePreserved", new CIMValue((Object)new Boolean(true)));
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.addElement(new UnsignedInt16(0));
        cIMInstance.setProperty("CodeSet", new CIMValue(vector));
        UnsignedInt32 unsignedInt32 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getMaxFileNameLength());
        cIMInstance.setProperty("MaxFileNameLength", new CIMValue((Object)unsignedInt32));
        cIMInstance.setProperty("ClusterSize", new CIMValue((Object)new UnsignedInt32(Integer.toString(solaris_FileSystem_Data.getClusterSize()))));
        UnsignedInt32 unsignedInt322 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getClusterSize());
        cIMInstance.setProperty("FileSystemType", new CIMValue((Object)solaris_FileSystem_Data.getFileSystemType()));
        UnsignedInt64 unsignedInt644 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getUsedSpace());
        cIMInstance.setProperty("UsedSpace", new CIMValue((Object)unsignedInt644));
        return cIMInstance;
    }

    private Hashtable getHSFSFileSystemData() {
        Hashtable<String, Solaris_FileSystem_Data> hashtable = new Hashtable<String, Solaris_FileSystem_Data>();
        Vector vector = new Vector();
        vector = (Vector)Solaris_FileSystem_Native.getFileSystemData();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)vector.elementAt(i);
                if (!solaris_FileSystem_Data.getFileSystemType().equalsIgnoreCase("hsfs")) continue;
                hashtable.put(solaris_FileSystem_Data.getMountPoint(), solaris_FileSystem_Data);
            }
        }
        return hashtable;
    }

    private Solaris_FileSystem_Data getHSFSFileSystemData(String string) {
        Vector vector = new Vector();
        vector = (Vector)Solaris_FileSystem_Native.getFileSystemData();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)vector.elementAt(i);
                if (!solaris_FileSystem_Data.getFileSystemType().equalsIgnoreCase("hsfs") || !solaris_FileSystem_Data.getMountPoint().equals(string)) continue;
                return solaris_FileSystem_Data;
            }
        }
        return null;
    }

    private UnsignedInt64 convertLongToCIMUnsignedLong(long l) {
        try {
            return new UnsignedInt64(new BigInteger(Long.toString(l)));
        }
        catch (Exception exception) {
            return new UnsignedInt64(new BigInteger("0"));
        }
    }

    private UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }
}

