/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.share;

import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShare;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareInterface;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.FileDirectoryTable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FsMgrDfsTable
implements FsMgrShareInterface {
    public static final String DFSTAB = new String("dfstab");
    private static final String[] shareCommands = new String[]{new String("/usr/sbin/share"), new String("share")};
    private static final String descOption = new String("-d");
    private static final String FSSpecOption = new String("-o");
    private static final String FSTypeOption = new String("-F");
    private static final String emptyString = new String("");
    private static final String quote = new String("\"");
    private static final String space = new String(" ");
    private static final String fileType = new String("File");
    private static final int commandColumn = 1;
    private Object wrapper = null;

    public FsMgrDfsTable(Object object) {
        this.wrapper = object;
    }

    public Vector list() throws DirectoryTableException {
        Vector<FsMgrShare> vector = new Vector<FsMgrShare>();
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openDfsTable();
            DirectoryRow directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                FsMgrShare fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                    fsMgrShare.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                    vector.addElement(fsMgrShare);
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrShare getShareEntry(String string) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        FsMgrShare fsMgrShare = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openDfsTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    if (string.equals(fsMgrShare.getPathname())) {
                        FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                        fsMgrShare.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                        break;
                    }
                    fsMgrShare = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return fsMgrShare;
    }

    public void addShare(FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryTable directoryTable;
        try {
            directoryTable = this.openDfsTable();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable = this.createDfsTable();
        }
        try {
            DirectoryRow directoryRow = this.makeRow(directoryTable, fsMgrShare);
            directoryTable.addRow(directoryRow);
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void removeShare(FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openDfsTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrShare.getRawString(), directoryRow, 1);
            directoryTable.deleteRow(directoryRow);
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void modifyShare(FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openDfsTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrShare.getRawString(), directoryRow, 1);
            DirectoryRow directoryRow2 = this.makeRow(directoryTable, fsMgrShare2);
            directoryTable.modifyRow(directoryRow, directoryRow2);
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    private DirectoryTable createDfsTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)fileType, (String)emptyString, (String)emptyString);
        directoryTable.create(DFSTAB);
        return directoryTable;
    }

    private DirectoryTable openDfsTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)fileType, (String)emptyString, (String)emptyString);
        directoryTable.open(DFSTAB);
        return directoryTable;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String[] stringArray = fsMgrShare.toArray(true);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + "\t";
        }
        directoryRow.putColumn(1, string);
        return directoryRow;
    }

    private FsMgrShare parseShareEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = emptyString;
        int n = 1;
        string = directoryRow.getColumn(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", false);
        int n2 = stringTokenizer.countTokens();
        int n3 = 0;
        stringTokenizer.nextToken();
        ++n3;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens() && bl) {
            string7 = stringTokenizer.nextToken();
            ++n3;
            if (string7 == null) {
                return null;
            }
            if (string7.equals(FSTypeOption)) {
                string4 = stringTokenizer.nextToken();
                ++n3;
                continue;
            }
            if (string7.equals(FSSpecOption)) {
                string5 = stringTokenizer.nextToken();
                ++n3;
                continue;
            }
            if (string7.equals(descOption)) {
                boolean bl2 = false;
                String string8 = " ";
                while (stringTokenizer.hasMoreTokens() && string8.length() != 0) {
                    string8 = stringTokenizer.nextToken();
                    ++n3;
                    int n4 = 0;
                    while ((n4 = string8.indexOf(quote, n4)) != -1) {
                        bl2 = !bl2;
                        ++n4;
                    }
                    string6 = !string6.equals(emptyString) ? string6 + space + string8 : string8;
                    if (bl2) continue;
                    break;
                }
                if (string6.startsWith(quote) && string6.endsWith(quote)) {
                    string6 = string6.substring(1, string6.length() - 1);
                }
                if (string6 != null) continue;
                return null;
            }
            bl = false;
        }
        string2 = string7;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            ++n3;
        } else {
            string3 = "-";
        }
        if (n3 < n2) {
            return null;
        }
        FsMgrShare fsMgrShare = new FsMgrShare(string2, string3, string4, string5, string6);
        return fsMgrShare;
    }
}

