/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.share;

import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrException;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrNfsd;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShare;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareInterface;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareWrapper;
import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import java.util.Vector;

public class FsMgrShareTable
implements FsMgrShareInterface {
    public static final String SHARETAB = new String("sharetab");
    private static final int pathnameColumn = 1;
    private static final int resourceColumn = 2;
    private static final int fsTypeColumn = 3;
    private static final int optionsColumn = 4;
    private static final int descriptionColumn = 5;
    private static final String unshareCommand = new String("/usr/sbin/unshare");
    private static final String emptyString = new String("");
    private static final String space = new String(" ");
    private static final String fileType = new String("File");
    private FsMgrShareWrapper wrapper = null;

    public FsMgrShareTable(FsMgrShareWrapper fsMgrShareWrapper) {
        this.wrapper = fsMgrShareWrapper;
    }

    public Vector list() throws DirectoryTableException {
        Vector<FsMgrShare> vector = new Vector<FsMgrShare>();
        FsMgrShare fsMgrShare = null;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShareTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    vector.addElement(fsMgrShare);
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrShare getShareEntry(String string) throws DirectoryTableException {
        FsMgrShare fsMgrShare = null;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShareTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    if (string.equals(fsMgrShare.getPathname())) break;
                    fsMgrShare = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return fsMgrShare;
    }

    public void addShare(FsMgrShare fsMgrShare) throws FsMgrException {
        Vector vector;
        String[] stringArray;
        FsMgrNfsd fsMgrNfsd = new FsMgrNfsd();
        if (!fsMgrNfsd.isMountdRunning()) {
            fsMgrNfsd.startMountd();
            this.wrapper.writeLog(0, "LM_4000", "LM_4015", null, null, null, null);
        }
        if (!fsMgrNfsd.isNfsdRunning()) {
            fsMgrNfsd.startNfsd();
            this.wrapper.writeLog(0, "LM_4000", "LM_4014", null, null, null, null);
        }
        if ((stringArray = (String[])(vector = CommonTools.CMN_exec((String[])fsMgrShare.toArray(), (boolean)true)).elementAt(1)).length != 0) {
            this.wrapper.writeLog(2, "LM_4066", "LM_4099", stringArray[0], null, null, null);
            int n = stringArray[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_SHARE_ERROR", fsMgrShare.getPathname(), stringArray[0].substring(n));
        }
    }

    public void removeShare(FsMgrShare fsMgrShare) throws FsMgrException {
        String[] stringArray = new String[]{unshareCommand, fsMgrShare.getPathname()};
        Vector vector = CommonTools.CMN_exec((String[])stringArray, (boolean)true);
        String[] stringArray2 = (String[])vector.elementAt(1);
        if (stringArray2.length != 0) {
            this.wrapper.writeLog(2, "LM_4067", "LM_4099", stringArray2[0], null, null, null);
            int n = stringArray2[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_UNSHARE_ERROR", fsMgrShare.getPathname(), stringArray2[0].substring(n));
        }
    }

    public void modifyShare(FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2) throws FsMgrException {
        this.removeShare(fsMgrShare);
        try {
            this.addShare(fsMgrShare2);
        }
        catch (FsMgrException fsMgrException) {
            this.addShare(fsMgrShare);
            throw fsMgrException;
        }
    }

    private DirectoryTable openShareTable() throws DirectoryTableException {
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)fileType, (String)emptyString, (String)emptyString);
        directoryTable.open("sharetab");
        return directoryTable;
    }

    private FsMgrShare parseShareEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        string = directoryRow.getColumn(1);
        string2 = directoryRow.getColumn(2);
        string3 = directoryRow.getColumn(3);
        string4 = directoryRow.getColumn(4);
        string5 = directoryRow.getColumn(5);
        string5 = string5.replace('\"', ' ');
        string5 = string5.trim();
        FsMgrShare fsMgrShare = new FsMgrShare(string, string2, string3, string4, string5);
        return fsMgrShare;
    }
}

