/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.model.Indicator;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"dir", "lang", "style"};
    private static final String[] intAttributes = new String[]{"tabIndex"};
    public static final String ALERT_IMAGE_FACET = "alertImage";

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof Alert)) {
            throw new IllegalArgumentException("AlertRenderer can only render Alert components.");
        }
        Alert alert = (Alert)component;
        String type = alert.getType();
        Theme theme = this.getTheme();
        String summary = alert.getSummary();
        JSONObject json = new JSONObject();
        json.put("summary", (Object)RenderingUtilities.formattedMessage(context, (UIComponent)alert, summary)).put("detail", (Object)RenderingUtilities.formattedMessage(context, (UIComponent)alert, alert.getDetail())).put("visible", summary == null || summary.trim().length() == 0 ? false : alert.isVisible()).put("type", (Object)type).put("className", (Object)alert.getStyleClass());
        List<Indicator> indicators = alert.getIndicators();
        Iterator<Indicator> iter1 = indicators.iterator();
        UIComponent imageFacet = alert.getFacet(ALERT_IMAGE_FACET);
        String ignoreType = null;
        if (imageFacet != null) {
            ignoreType = type;
        }
        JSONArray jArray = WidgetUtilities.getIndicators(context, iter1, ignoreType, theme, (UIComponent)alert);
        JSONObject jsonFacet = new JSONObject();
        if (ignoreType != null) {
            jsonFacet.put("type", (Object)ignoreType);
            jsonFacet.put("image", (Object)WidgetUtilities.renderComponent(context, imageFacet));
            jArray.put((Object)jsonFacet);
        }
        json.put("indicators", (Object)jArray);
        json.put("moreInfo", (Object)WidgetUtilities.renderComponent(context, alert.getAlertLink()));
        Icon dotImg = null;
        dotImg = ThemeUtilities.getIcon(theme, "DOT");
        if (dotImg.getId() == null) {
            dotImg.setId("DOT");
        }
        if (dotImg.getParent() == null) {
            dotImg.setParent((UIComponent)alert);
        }
        json.put("spacerImage", (Object)WidgetUtilities.renderComponent(context, (UIComponent)dotImg));
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.alert");
    }
}

