/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AnchorRendererBase
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"accessKey", "charset", "coords", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "rel", "rev", "shape", "style", "target", "type"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        this.setAttributes(context, component, json);
        this.setContents(context, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.anchor");
    }

    protected void setAttributes(FacesContext context, UIComponent component, JSONObject json) throws JSONException, IOException {
        Map attrsMap = component.getAttributes();
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        String tmp = null;
        tmp = (String)attrsMap.get("style");
        if (tmp != null && tmp.length() > 0) {
            json.put("style", (Object)tmp);
        }
        if ((tmp = (String)attrsMap.get("styleClass")) != null && tmp.length() > 0) {
            json.put("className", (Object)tmp);
        }
        if ((tmp = (String)attrsMap.get("toolTip")) != null && tmp.length() > 0) {
            json.put("title", (Object)tmp);
        }
        if ((tmp = (String)attrsMap.get("urlLang")) != null && tmp.length() > 0) {
            json.put("hrefLang", (Object)tmp);
        }
        json.put("disabled", ((Boolean)attrsMap.get("disabled")).booleanValue());
        json.put("visible", ((Boolean)attrsMap.get("visible")).booleanValue());
        String url = (String)attrsMap.get("url");
        this.setURL(context, component, json, url);
        int tabIndex = (Integer)attrsMap.get("tabIndex");
        if (tabIndex != Integer.MIN_VALUE) {
            json.put("tabIndex", tabIndex);
        }
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws JSONException, IOException {
        JSONArray jArray = new JSONArray();
        json.put("contents", (Object)jArray);
        String text = (String)component.getAttributes().get("text");
        if (text != null && text.length() > 0) {
            text = ConversionUtilities.convertValueToString(component, text);
        }
        jArray.put((Object)text);
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UIParameter) continue;
            jArray.put((Object)WidgetUtilities.renderComponent(context, child));
        }
    }

    protected void setURL(FacesContext context, UIComponent component, JSONObject json, String url) throws JSONException {
        if (url != null && url.length() > 0) {
            if (!url.startsWith("#")) {
                url = context.getApplication().getViewHandler().getResourceURL(context, url);
                url = WidgetUtilities.translateURL(context, component, url);
            }
            json.put("href", (Object)url);
        }
    }
}

