/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarMonthRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"style"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof CalendarMonth)) {
            throw new IllegalArgumentException("CalendarMonthRenderer can only render CalendarMonth components.");
        }
        CalendarMonth calendarMonth = (CalendarMonth)component;
        Calendar calendar = calendarMonth.getCalendar();
        Theme theme = this.getTheme();
        DateFormat df = SimpleDateFormat.getDateInstance(2, context.getViewRoot().getLocale());
        df.setTimeZone(calendarMonth.getTimeZone());
        Date today = calendar.getTime();
        Object[] param = new String[]{df.format(today)};
        String todayDateMsg = theme.getMessage("CalendarMonth.todayIs", param);
        JSONObject json = new JSONObject();
        this.initializeChildren(calendarMonth, context, calendar, json);
        json.put("todayDateMsg", (Object)todayDateMsg).put("dateFormat", (Object)calendarMonth.getDateFormatPattern());
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.calendar");
    }

    private void initializeChildren(CalendarMonth cm, FacesContext context, Calendar calendar, JSONObject json) throws IOException, JSONException {
        DropDown mMenu;
        SimpleDateFormat dateFormat = (SimpleDateFormat)cm.getDateFormat();
        Date minDate = null;
        Date maxDate = null;
        UIComponent parent = cm.getParent();
        if (parent instanceof DateManager) {
            minDate = ((DateManager)parent).getFirstAvailableDate();
            maxDate = ((DateManager)parent).getLastAvailableDate();
        }
        if (minDate != null) {
            json.put("minDate", (Object)dateFormat.format(minDate));
        }
        if (maxDate != null) {
            json.put("maxDate", (Object)dateFormat.format(maxDate));
        }
        Theme theme = this.getTheme();
        DropDown yMenu = (DropDown)cm.getFacet("yearMenu");
        if (yMenu != null) {
            yMenu.setToolTip(theme.getMessage("CalendarMonth.selectYear"));
            json.put("yearMenu", (Object)WidgetUtilities.renderComponent(context, (UIComponent)yMenu));
        }
        if ((mMenu = (DropDown)cm.getFacet("monthMenu")) != null) {
            mMenu.setToolTip(theme.getMessage("CalendarMonth.selectMonth"));
            json.put("monthMenu", (Object)WidgetUtilities.renderComponent(context, (UIComponent)mMenu));
        }
    }
}

