/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class SelectorGroupRenderer
extends RendererBase {
    private static final String[] attributes = new String[]{"accessKey", "dir", "lang", "tabIndex", "title", "onBlur", "onClick", "onChange", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "onSelect"};

    SelectorGroupRenderer() {
    }

    protected UIComponent getSelectorComponent(FacesContext context, UIComponent component, String id, Option option) {
        RbCbSelector rbcb;
        block5: {
            String[] subValue;
            block4: {
                Selector rbcbGrp = (Selector)component;
                String componentId = rbcbGrp.getClientId(context);
                if (rbcbGrp instanceof ComplexComponent) {
                    componentId = ((ComplexComponent)((Object)rbcbGrp)).getLabeledElementId(context);
                }
                rbcb = this.createSelectorComponent();
                rbcb.setId(id);
                rbcb.setParent(component);
                rbcb.setName(componentId);
                rbcb.setToolTip(option.getTooltip());
                rbcb.setImageURL(option.getImage());
                rbcb.setSelectedValue(option.getValue());
                rbcb.setLabel(option.getLabel());
                rbcb.setDisabled(rbcbGrp.isDisabled());
                rbcb.setReadOnly(rbcbGrp.isReadOnly());
                String[] names = attributes;
                Map attributes = component.getAttributes();
                Map rbAttributes = rbcb.getAttributes();
                for (int i = 0; i < names.length; ++i) {
                    Object value = attributes.get(names[i]);
                    if (value == null || value instanceof Integer && (Integer)value == Integer.MIN_VALUE) continue;
                    rbAttributes.put(names[i], value);
                }
                rbcb.setSelected(null);
                subValue = (String[])rbcbGrp.getSubmittedValue();
                if (subValue != null) break block4;
                if (!this.isSelected(option, rbcbGrp.getSelected())) break block5;
                rbcb.setSelected(rbcb.getSelectedValue());
                break block5;
            }
            if (subValue.length != 0) {
                Object selectedValue = rbcb.getSelectedValue();
                String selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                for (int i = 0; i < subValue.length; ++i) {
                    if (subValue[i] == null || !subValue[i].equals(selectedValueAsString)) continue;
                    rbcb.setSelected(selectedValue);
                    break;
                }
            }
        }
        return rbcb;
    }

    protected abstract RbCbSelector createSelectorComponent();

    protected abstract boolean isSelected(Option var1, Object var2);

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (ComponentUtilities.isDisabled(component) || ComponentUtilities.isReadOnly(component)) {
            return;
        }
        this.setSubmittedValues(context, component);
    }

    protected JSONObject getProperties(FacesContext context, Selector component) throws IOException, JSONException {
        JSONObject json = new JSONObject();
        json.put("label", (Object)WidgetUtilities.renderComponent(context, this.getLabelComponent(context, (UIComponent)component)));
        json.put("className", (Object)component.getStyleClass());
        json.put("disabled", component.isDisabled());
        json.put("multiple", component.isMultiple());
        json.put("visible", component.isVisible());
        json.put("style", (Object)component.getStyle());
        Selector selector = component;
        Object selected = selector.getSelected();
        if (selector.getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue((UIComponent)component, selected);
        }
        this.setContents(context, (UIComponent)component, json);
        return json;
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws IOException, JSONException {
        JSONArray jArray = new JSONArray();
        json.put("contents", (Object)jArray);
        Option[] items = this.getItems((Selector)component);
        int length = items.length;
        int itemN = 0;
        for (int i = 0; i < length; ++i) {
            UIComponent child = this.getChildComponent(context, component, itemN);
            jArray.put((Object)WidgetUtilities.renderComponent(context, child));
            ++itemN;
        }
    }

    private UIComponent getChildComponent(FacesContext context, UIComponent component, int itemN) throws IOException {
        Option[] items = this.getItems((Selector)component);
        if (itemN >= items.length) {
            return null;
        }
        String id = component.getId().concat("_") + itemN;
        UIComponent child = this.getSelectorComponent(context, component, id, items[itemN]);
        return child;
    }

    private Option[] getItems(Selector selector) {
        Object items = selector.getItems();
        if (items == null) {
            return null;
        }
        if (items instanceof Option[]) {
            return (Option[])items;
        }
        if (items instanceof Map) {
            int size = ((Map)items).size();
            return ((Map)items).values().toArray(new Option[size]);
        }
        if (items instanceof Collection) {
            int size = ((Collection)items).size();
            return ((Collection)items).toArray(new Option[size]);
        }
        throw new IllegalArgumentException("Selector.items is not Option[], Map, or Collection");
    }

    private UIComponent getLabelComponent(FacesContext context, UIComponent component) throws IOException {
        Integer lblLvl;
        UIComponent labelComponent = component.getFacet("label");
        if (labelComponent != null) {
            return labelComponent;
        }
        String attrvalue = (String)component.getAttributes().get("label");
        if (attrvalue == null || attrvalue.length() <= 0) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet(component, "label", true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId(component, "label"));
            ComponentUtilities.putPrivateFacet(component, "label", (UIComponent)label);
        }
        label.setText(attrvalue);
        label.setLabeledComponent(component);
        label.setIndicatorComponent(component);
        attrvalue = (String)component.getAttributes().get("toolTip");
        if (attrvalue != null) {
            label.setToolTip(attrvalue);
        }
        if ((lblLvl = (Integer)component.getAttributes().get("labelLevel")) == null) {
            lblLvl = new Integer(2);
        }
        label.setLabelLevel(lblLvl == null ? 2 : lblLvl);
        return label;
    }

    private void setSubmittedValues(FacesContext context, UIComponent component) {
        Map requestParameterValuesMap;
        String clientId = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            clientId = ((ComplexComponent)component).getLabeledElementId(context);
        }
        if ((requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap()).containsKey(clientId)) {
            String[] newValues = (String[])requestParameterValuesMap.get(clientId);
            ((UIInput)component).setSubmittedValue((Object)newValues);
            return;
        }
        ((UIInput)component).setSubmittedValue((Object)new String[0]);
    }
}

