/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.UploadFilterDiskFileUpload;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;

public class UploadFilter
implements Filter {
    public static final String MAX_SIZE = "maxSize";
    public static final String SIZE_THRESHOLD = "sizeThreshold";
    public static final String TMP_DIR = "tmpDir";
    private long maxSize = 1000000L;
    private int sizeThreshold = 4096;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private String messages = "com.sun.web.ui.resources.LogMessages";
    private static final String FILEUPLOAD_V4_MAXSIZE_PROP = "com.sun.webui.v4.uploadfilter.maxfilesize";
    private FilterConfig filterConfig;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object consoleMaxSize;
        ServletContext sc;
        HttpServletRequest req = (HttpServletRequest)request;
        if (!FileUpload.isMultipartContent((HttpServletRequest)req)) {
            chain.doFilter(request, response);
            return;
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (this.filterConfig != null && (sc = this.filterConfig.getServletContext()) != null && (consoleMaxSize = sc.getAttribute(FILEUPLOAD_V4_MAXSIZE_PROP)) != null && consoleMaxSize instanceof Long) {
            this.maxSize = (Long)consoleMaxSize < 0L ? -1L : (Long)consoleMaxSize;
        }
        UploadFilterDiskFileUpload fu = new UploadFilterDiskFileUpload(this.sizeThreshold, this.maxSize, this.tmpDir, encoding);
        List fileItems = null;
        try {
            fileItems = fu.parseRequest(req);
        }
        catch (Exception fue) {
            request.setAttribute("upload_error_key", (Object)fue);
        }
        Hashtable parameters = null;
        if (fileItems != null && !fileItems.isEmpty()) {
            parameters = this.getFormDataAsRequestParameters(fileItems, request);
        } else {
            request.setAttribute("upload_nodata_key", (Object)"upload_nodata_key");
            parameters = new Hashtable();
        }
        UploadRequest wrappedRequest = new UploadRequest(req, parameters);
        chain.doFilter((ServletRequest)wrappedRequest, response);
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object o = request.getAttribute(name);
            if (o instanceof FileItem) {
                ((FileItem)o).delete();
            }
            request.removeAttribute(name);
        }
    }

    public void init(FilterConfig filterConfig) {
        block17: {
            Object[] params;
            String param;
            block16: {
                block15: {
                    this.filterConfig = filterConfig;
                    param = filterConfig.getInitParameter(MAX_SIZE);
                    if (param != null) {
                        try {
                            this.maxSize = Long.parseLong(param);
                        }
                        catch (NumberFormatException nfe) {
                            params = new Object[]{MAX_SIZE, param, this.maxSize};
                            if (!LogUtil.warningEnabled()) break block15;
                            LogUtil.warning(UploadFilter.class, "Upload.filter.invalidLong", params);
                        }
                    }
                }
                if ((param = filterConfig.getInitParameter(SIZE_THRESHOLD)) != null) {
                    try {
                        this.sizeThreshold = Integer.parseInt(param);
                    }
                    catch (NumberFormatException nfe) {
                        params = new Object[]{SIZE_THRESHOLD, param, this.sizeThreshold};
                        if (!LogUtil.warningEnabled()) break block16;
                        LogUtil.warning(UploadFilter.class, "Upload.filter.invalidInt", params);
                    }
                }
            }
            if ((param = filterConfig.getInitParameter(TMP_DIR)) != null) {
                try {
                    String msgKey = null;
                    File dir = new File(param);
                    if (!dir.exists() || !dir.isDirectory()) {
                        msgKey = "Upload.filter.doesNotExist";
                    } else if (!dir.canWrite() || !dir.canRead()) {
                        msgKey = "Upload.filter.cantReadWrite";
                    } else {
                        this.tmpDir = param;
                    }
                    if (msgKey != null) {
                        Object[] params2 = new Object[]{TMP_DIR, param, this.tmpDir};
                        if (LogUtil.warningEnabled()) {
                            LogUtil.warning(UploadFilter.class, msgKey, params2);
                        }
                    }
                }
                catch (Exception e) {
                    params = new Object[]{TMP_DIR, param, e.getMessage() != null ? e.getMessage() : "", this.tmpDir};
                    String msg = MessageUtil.getMessage(this.messages, "Upload.filter.invalidDir", params);
                    if (!LogUtil.warningEnabled()) break block17;
                    LogUtil.warning(UploadFilter.class, msg, e);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void destroy() {
    }

    private boolean getFormData(FileItem fileItem, Hashtable formDataMap, ServletRequest request) throws UnsupportedEncodingException {
        boolean haveMultipleValues = false;
        String fieldName = fileItem.getFieldName();
        if (!fileItem.isFormField()) {
            request.setAttribute(fieldName, (Object)fileItem);
        } else {
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            String svalue = fileItem.getString(encoding);
            Object value = formDataMap.get(fieldName);
            if (value == null) {
                formDataMap.put(fieldName, new String[]{svalue});
            } else if (value instanceof ArrayList) {
                ((ArrayList)value).add(svalue);
            } else {
                haveMultipleValues = true;
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(((String[])value)[0]);
                valueList.add(svalue);
                formDataMap.put(fieldName, valueList);
            }
        }
        return haveMultipleValues;
    }

    Hashtable getFormDataAsRequestParameters(List fileItems, ServletRequest request) throws UnsupportedEncodingException {
        boolean haveMultipleValues = false;
        Hashtable formDataMap = new Hashtable();
        Iterator<Object> iterator = fileItems.iterator();
        while (iterator.hasNext()) {
            if (!this.getFormData((FileItem)iterator.next(), formDataMap, request)) continue;
            haveMultipleValues = true;
        }
        if (!haveMultipleValues) {
            return formDataMap;
        }
        Set keys = formDataMap.entrySet();
        Hashtable<String, Object> requestParameters = new Hashtable<String, Object>();
        for (Map.Entry entry : keys) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ArrayList) {
                requestParameters.put(key, ((ArrayList)value).toArray(new String[((ArrayList)value).size()]));
                continue;
            }
            requestParameters.put(key, value);
        }
        return requestParameters;
    }

    class UploadRequest
    extends HttpServletRequestWrapper {
        private boolean merged;
        private Hashtable parameters;
        private Map unmodifiableParametersMap;

        public UploadRequest(HttpServletRequest request, Hashtable parameters) {
            super(request);
            this.merged = false;
            this.parameters = parameters;
        }

        public String getParameter(String name) {
            Object param = this.parameters.get(name);
            if (param == null) {
                return this.merged ? null : super.getParameter(name);
            }
            if (param instanceof String) {
                return (String)param;
            }
            if (param instanceof String[]) {
                String[] params = (String[])param;
                return params.length == 0 ? null : params[0];
            }
            return param.toString();
        }

        public String[] getParameterValues(String name) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return this.merged ? null : super.getParameterValues(name);
            }
            return (String[])value;
        }

        public Enumeration getParameterNames() {
            this.mergeParameters();
            return this.parameters.keys();
        }

        public Map getParameterMap() {
            this.mergeParameters();
            return this.unmodifiableParametersMap;
        }

        private void mergeParameters() {
            if (this.merged) {
                return;
            }
            Hashtable mergedmap = new Hashtable(super.getParameterMap());
            mergedmap.putAll(this.parameters);
            this.parameters = mergedmap;
            this.unmodifiableParametersMap = Collections.unmodifiableMap(this.parameters);
            this.merged = true;
        }
    }
}

