/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.SPIThemeFactory;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeFactory;
import com.sun.webui.theme.ThemeImage;
import com.sun.webui.theme.ThemeLogger;
import com.sun.webui.theme.ThemeReference;
import com.sun.webui.theme.ThemeResourceBundle;
import com.sun.webui.theme.ThemeResources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleTheme
implements Theme {
    protected static ResourceBundleTheme theme = new ResourceBundleTheme();
    protected static ThemeResourceBundle themeResourceBundle = new ThemeResourceBundle();
    static ThreadLocal threadThemeResources = new ThreadLocal();
    private static final String[] suffixes = new String[]{"_ALT", "_TITLE", "_HEIGHT", "_WIDTH", "_UNITS"};
    private static int KEY_PROP = 0;
    private static int ALT_PROP = 1;
    private static int TITLE_PROP = 2;
    private static int HEIGHT_PROP = 3;
    private static int WIDTH_PROP = 4;
    private static int UNITS_PROP = 5;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ThemeResources getThemeResources() {
        return (ThemeResources)threadThemeResources.get();
    }

    protected ResourceBundleTheme() {
    }

    public static Theme getInstance(ThemeResources themeResources) {
        threadThemeResources.set(themeResources);
        return theme;
    }

    @Override
    public String getMessage(String key) {
        String property = key;
        try {
            property = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.MESSAGES);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
            return null;
        }
        return property;
    }

    @Override
    public String getMessage(String key, Object[] params) {
        String property = key;
        try {
            property = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.MESSAGES);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
            return key;
        }
        ThemeResources themeResources = this.getThemeResources();
        Locale locale = themeResources.getLocale() == null ? themeResources.getThemeContext().getDefaultLocale() : themeResources.getLocale();
        try {
            MessageFormat mf = new MessageFormat(property, locale);
            return mf.format(params);
        }
        catch (Exception e) {
            ThemeLogger.log(Level.FINEST, "Could not format message {0}.", new Object[]{property}, e);
            return property;
        }
    }

    @Override
    public String[] getGlobalJSFiles() {
        ThemeResources themeResources = this.getThemeResources();
        try {
            String[] jsfiles = (String[])this.getGlobalArrayProperty(themeResources.getThemeReferenceIterator(true), ThemeResourceBundle.ThemeBundle.JAVASCRIPT, ThemeResourceBundle.ThemeProperty.JAVASCRIPT, themeResources.getLocale(), themeResources.getThemeContext().getDefaultClassLoader());
            return jsfiles == null ? null : this.getPathArray(jsfiles);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{ThemeResourceBundle.ThemeProperty.JAVASCRIPT.getKey(), themeResources.getName()}, mre);
            return null;
        }
    }

    @Override
    public String[] getGlobalStylesheets() {
        ThemeResources themeResources = this.getThemeResources();
        try {
            String[] cssfiles = (String[])this.getGlobalArrayProperty(themeResources.getThemeReferenceIterator(true), ThemeResourceBundle.ThemeBundle.STYLESHEET, ThemeResourceBundle.ThemeProperty.STYLESHEET, themeResources.getLocale(), themeResources.getThemeContext().getDefaultClassLoader());
            return cssfiles == null ? null : this.getPathArray(cssfiles);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{ThemeResourceBundle.ThemeProperty.STYLESHEET.getKey(), themeResources.getName()}, mre);
            return null;
        }
    }

    @Override
    public String[] getMasterStylesheets() {
        try {
            ThemeResources themeResources = this.getThemeResources();
            String[] cssfiles = (String[])this.getGlobalArrayProperty(themeResources.getThemeReferenceIterator(true), ThemeResourceBundle.ThemeBundle.STYLESHEET, ThemeResourceBundle.ThemeProperty.STYLESHEET_MASTER, themeResources.getLocale(), themeResources.getThemeContext().getDefaultClassLoader());
            return cssfiles == null ? null : this.getPathArray(cssfiles);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{ThemeResourceBundle.ThemeProperty.STYLESHEET_MASTER.getKey(), this.getThemeResources().getName()}, mre);
            return null;
        }
    }

    @Override
    public String[] getStylesheets(String key) {
        try {
            ThemeResources themeResources = this.getThemeResources();
            String[] cssFiles = (String[])this.getGlobalArrayProperty(themeResources.getThemeReferenceIterator(true), ThemeResourceBundle.ThemeBundle.STYLESHEET, key, themeResources.getLocale(), themeResources.getThemeContext().getDefaultClassLoader());
            return cssFiles == null ? null : this.getPathArray(cssFiles);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
            return null;
        }
    }

    @Override
    public String getPathToJSFile(String key) {
        String jsfile = null;
        try {
            jsfile = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.JAVASCRIPT);
            jsfile = this.fixUpPath(jsfile);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
        }
        return jsfile;
    }

    @Override
    public String getJSString(String key) {
        String jsprop = null;
        try {
            jsprop = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.JAVASCRIPT);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
        }
        return jsprop;
    }

    @Override
    public String getPathToTemplate(String key) {
        try {
            String templatefile = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.TEMPLATE);
            return this.fixUpPath(templatefile);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
            return null;
        }
    }

    @Override
    public String getStyleClass(String key) {
        String styleClass = key;
        try {
            styleClass = (String)this.getProperty(key, ThemeResourceBundle.ThemeBundle.CLASSMAPPER);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "NO_SUCH_PROPERTY", new Object[]{key, this.getThemeResources().getName()}, mre);
        }
        return styleClass;
    }

    @Override
    public ThemeImage getImage(String key) {
        String title;
        StringBuilder sb = new StringBuilder(16);
        String[] keys = new String[suffixes.length + 1];
        int len = key.length();
        int i = 0;
        keys[i++] = key;
        sb.append(key);
        for (String suffix : suffixes) {
            sb.append(suffix);
            keys[i++] = sb.toString();
            sb.setLength(len);
        }
        Object[] properties = null;
        try {
            properties = this.getProperties(keys, ThemeResourceBundle.ThemeBundle.IMAGES);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.FINEST, "No such image {0}.", new Object[]{key}, mre);
            return null;
        }
        if (properties == null || properties[0] == null || ((String)properties[KEY_PROP]).trim().length() == 0) {
            ThemeLogger.log(Level.FINEST, "No path found for image {0}.", new Object[]{key}, null);
            return null;
        }
        int ht = this.verifyImageDimension(key, (String)properties[WIDTH_PROP]);
        int wt = this.verifyImageDimension(key, (String)properties[HEIGHT_PROP]);
        String units = properties[UNITS_PROP] == null || ((String)properties[UNITS_PROP]).trim().length() == 0 ? null : (String)properties[UNITS_PROP];
        String alt = (String)properties[ALT_PROP];
        if (alt != null) {
            alt = this.getMessage(alt);
        }
        if ((title = (String)properties[TITLE_PROP]) != null) {
            title = this.getMessage(title);
        }
        return new ThemeImage(ht, wt, units, alt == null ? (String)properties[ALT_PROP] : alt, title == null ? (String)properties[TITLE_PROP] : title, this.fixUpPath((String)properties[KEY_PROP]));
    }

    @Override
    public String getImagePath(String key) {
        String path = null;
        try {
            path = this.getImageString(key);
            if (path == null || path.trim().length() == 0) {
                return null;
            }
            path = this.fixUpPath(path);
        }
        catch (MissingResourceException mre) {
            ThemeLogger.log(Level.SEVERE, "No such image {0}.", new Object[]{key}, mre);
            throw new RuntimeException(mre.getLocalizedMessage(), mre);
        }
        return path;
    }

    private int verifyImageDimension(String imageKey, String dim) {
        int result = Integer.MIN_VALUE;
        if (dim == null || dim.trim().length() == 0) {
            return result;
        }
        try {
            result = Integer.parseInt(dim);
        }
        catch (Exception e) {
            ThemeLogger.log(Level.FINEST, "Could not convert dimension {0} for image {1}.", new Object[]{dim, imageKey}, null);
        }
        return result;
    }

    @Override
    public String getImageString(String key) {
        ThemeResources themeResources = this.getThemeResources();
        ClassLoader classLoader = themeResources.getThemeContext().getDefaultClassLoader();
        Locale locale = themeResources.getLocale();
        if (locale == null) {
            locale = themeResources.getThemeContext().getDefaultLocale();
        }
        String string = (String)this.getProperty(themeResources.getThemeReferenceIterator(), ThemeResourceBundle.ThemeBundle.IMAGES, key, locale, classLoader);
        return string;
    }

    protected String[] getPathArray(String[] files) {
        String[] paths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = this.fixUpPath(files[i]);
        }
        return paths;
    }

    protected String fixUpPath(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String path = uri;
        ThemeContext themeContext = this.getThemeResources().getThemeContext();
        try {
            path = themeContext.getResourcePath(uri);
        }
        catch (Exception e) {
            path = uri;
        }
        return path;
    }

    protected Object getGlobalArrayProperty(Iterator<ThemeReference> themeReferenceIterator, ThemeResourceBundle.ThemeBundle themeBundle, ThemeResourceBundle.ThemeProperty themeProperty, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        return this.getGlobalArrayProperty(themeReferenceIterator, themeBundle, themeProperty.getKey(), locale, classLoader);
    }

    protected Object getGlobalArrayProperty(Iterator<ThemeReference> themeReferenceIterator, ThemeResourceBundle.ThemeBundle themeBundle, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ArrayList properties = new ArrayList();
        MissingResourceException mre = null;
        Object property = null;
        while (themeReferenceIterator.hasNext()) {
            ThemeReference ref = themeReferenceIterator.next();
            try {
                themeResourceBundle.getGlobalArrayProperty(ref.getBasename(), themeBundle, key, locale, ref.getClassLoader() == null ? classLoader : ref.getClassLoader(), properties);
            }
            catch (MissingResourceException e) {
                if (mre != null) continue;
                mre = e;
            }
        }
        if (properties.size() != 0) {
            return properties.toArray(new String[properties.size()]);
        }
        if (mre != null) {
            throw mre;
        }
        return null;
    }

    public Object getProperty(String key, ThemeResourceBundle.ThemeBundle themeBundle) throws MissingResourceException {
        ThemeResources themeResources = this.getThemeResources();
        ThemeContext themeContext = themeResources.getThemeContext();
        Locale locale = themeResources.getLocale();
        if (locale == null) {
            locale = themeContext.getDefaultLocale();
        }
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        return this.getProperty(themeResources.getThemeReferenceIterator(), themeBundle, key, locale, classLoader);
    }

    protected Object getProperty(Iterator<ThemeReference> themeReferenceIterator, ThemeResourceBundle.ThemeBundle themeBundle, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object property = null;
        MissingResourceException mre = null;
        while (themeReferenceIterator.hasNext()) {
            ThemeReference ref = themeReferenceIterator.next();
            try {
                property = themeResourceBundle.getProperty(ref.getBasename(), themeBundle, key, locale, ref.getClassLoader() == null ? classLoader : ref.getClassLoader());
            }
            catch (MissingResourceException e) {
                if (mre == null) continue;
                mre = e;
                continue;
            }
            if (property == null) continue;
            break;
        }
        if (property == null && mre != null) {
            throw mre;
        }
        return property;
    }

    public Object[] getProperties(String[] keys, ThemeResourceBundle.ThemeBundle themeBundle) throws MissingResourceException {
        ThemeResources themeResources = this.getThemeResources();
        ThemeContext themeContext = themeResources.getThemeContext();
        Locale locale = themeResources.getLocale();
        if (locale == null) {
            locale = themeContext.getDefaultLocale();
        }
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        return this.getProperties(themeResources.getThemeReferenceIterator(), themeBundle, keys, locale, classLoader);
    }

    protected Object[] getProperties(Iterator<ThemeReference> themeReferenceIterator, ThemeResourceBundle.ThemeBundle themeBundle, String[] keys, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object[] properties = null;
        MissingResourceException mre = null;
        while (themeReferenceIterator.hasNext()) {
            ThemeReference ref = themeReferenceIterator.next();
            try {
                properties = themeResourceBundle.getProperties(ref.getBasename(), themeBundle, keys, locale, ref.getClassLoader() == null ? classLoader : ref.getClassLoader());
            }
            catch (MissingResourceException e) {
                if (mre == null) continue;
                mre = e;
                continue;
            }
            if (properties == null) continue;
            break;
        }
        if (properties == null && mre != null) {
            throw mre;
        }
        return properties;
    }

    public static final void main(String[] args) {
        String UNKNOWN_OPTION = "Unknown argument: {0}\n{1}";
        String CANT_GET_THEME_FACTORY_CLASS = "Exception obtaining Class instance for {0}.";
        String CANT_GET_THEME = "Exception obtaining Theme instance ''{0}''.";
        String CANT_CREATE_FILE = "Exception creating file {0}{1}{2}.";
        String CANT_WRITE_COPYRIGHT = "Exception writing copyright to {0}{1}{2}.";
        String UNKNOWN_THEME_BUNDLE = "Unrecognized ThemeBundle ''{0}''.";
        String CANT_CONVER_BUNDLE_TO_JS = "themeBundleToJavaScript failed to convert bundle ''{0}''.";
        String CANT_WRITE_BUNDLE = "Exception writing bundle converted ''{0}''.";
        String CANT_CLOSE_FILE = "Exception closing file {0}{1}{2}.";
        String CANT_JSON_PUT = "JSONException in 'put' of bundle ''{0}''.";
        String usage = "Usage: java com.sun.webui.jsf.theme.ResourceBundleTheme \n[-bundle messages|stylesheets|templates|properties|javascript|images|styles]\n[-factory <ThemeFactory implementation class name>]\n[-dir destination-directory]\n[-theme <theme name>]\n[-version <theme version>]\n[-locale <lang>[_<country>[_<variant>]]]\n[-l10nJar \"jar:file:<fullpath>/<jarname>_<lang>[_<country>[_<variant>]].jar!/\"\n[-prettyprint <indent>]\n\n[-help]\n'-bundle' - the properties file to process. If not specified, all properties\n    bundles are processed. If 'bundle' is specifed the file name is\n    '<bundle>.js'.\n'-factory' - the ThemeFactory implementation to use, to obtain a Theme\n    instance. If not specified the 'com.sun.webui.theme.SPIThemeFactory'\n    implementation is used.\n'-dir' - the destination directory for the theme javascript file. The file\n    created is named from the 'ThemeJavascript.THEME_BUNDLE' theme property \n    with an extension of '.js' If not specified the file is created in the\n    current directory.\n\n-l10nJar - the URI includling the full path to l10n jar file. This value\n    is used to create a URLClassLoader restricting the class path to this jar.\nIf '-theme' is not specified 'suntheme' is used. This theme is used as the\n    source of the properties files.\nIf '-version' is not specified then '4.1' is used.\n\nThe webui-jsf.jar and webui-jsf-suntheme.jar or equivalent theme jar\n    must appear in the classpath.\n\nNote that if the '-bundle' option is specified,\n    javascript must be written to load that file. The default 'Head' component\n    behavior loads theme files based on the 'ThemeJavascript.THEME_BUNDLE',\n    'ThemeJavascript.THEME_MODULE', and 'ThemeJavascript.THEME_MODULE_PATH'\n    (or 'ThemeJavascript.THEME_MODULE_PATH_UNCOMPRESSED') theme properties.\n";
        String copyright = "//\n// The contents of this file are subject to the terms\n// of the Common Development and Distribution License\n// (the License).  You may not use this file except in\n// compliance with the License.\n//\n// You can obtain a copy of the license at\n// https://woodstock.dev.java.net/public/CDDLv1.0.html.\n// See the License for the specific language governing\n// permissions and limitations under the License.\n//\n// When distributing Covered Code, include this CDDL\n// Header Notice in each file and include the License file\n// at https://woodstock.dev.java.net/public/CDDLv1.0.html.\n// If applicable, add the following below the CDDL Header,\n// with the fields enclosed by brackets [] replaced by\n// you own identifying information:\n// \"Portions Copyrighted [year] [name of copyright owner]\"\n//\n// Copyright 2007 Sun Microsystems, Inc. All rights reserved.\n//\n";
        String DOT = ".";
        String EXT = ".js";
        String FILE_SEPARATOR = System.getProperty("file.separator");
        String properties = null;
        String outfile = null;
        String dir = ".";
        String factoryClass = null;
        String themeName = "suntheme";
        String version = "4.1";
        String locale = null;
        String l10nJar = null;
        int indent = 0;
        int retval = 0;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bundle")) {
                properties = args[++i];
                continue;
            }
            if (args[i].equals("-factory")) {
                factoryClass = args[++i];
                continue;
            }
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-theme")) {
                themeName = args[++i];
                continue;
            }
            if (args[i].equals("-version")) {
                version = args[++i];
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-locale")) {
                locale = args[++i];
                continue;
            }
            if (args[i].equals("-l10nJar")) {
                l10nJar = args[++i];
                continue;
            }
            if (args[i].equals("-prettyprint")) {
                indent = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-help")) {
                System.out.println(usage);
                System.exit(0);
                continue;
            }
            System.err.println(MessageFormat.format(UNKNOWN_OPTION, args[i], usage));
            System.exit(-1);
        }
        while (debug) {
        }
        if (locale == null ^ l10nJar == null) {
            System.err.println(usage);
            System.exit(-1);
        }
        ThemeFactory factory = null;
        if (factoryClass == null) {
            factory = new SPIThemeFactory();
        } else {
            try {
                factory = (ThemeFactory)Class.forName(factoryClass).newInstance();
            }
            catch (Exception e) {
                System.err.println(MessageFormat.format(CANT_GET_THEME_FACTORY_CLASS, factoryClass) + "\n" + e.getMessage());
                System.exit(-1);
            }
        }
        class DefaultThemeContext
        extends ThemeContext {
            DefaultThemeContext() {
            }
        }
        DefaultThemeContext themeContext = new DefaultThemeContext();
        Theme theme = null;
        try {
            theme = factory.getTheme(themeName, version, null, themeContext);
        }
        catch (Exception te) {
            System.err.println(MessageFormat.format(CANT_GET_THEME, themeName, version) + "\n" + te.getMessage());
            System.exit(-1);
        }
        if (properties != null && properties.length() != 0) {
            outfile = properties;
        }
        if (outfile == null && ((outfile = theme.getJSString("themeBundle")) == null || outfile.length() == 0)) {
            outfile = "suntheme";
        }
        outfile = outfile.concat(EXT);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(dir + FILE_SEPARATOR + outfile));
        }
        catch (IOException ex) {
            System.err.println(MessageFormat.format(CANT_CREATE_FILE, dir, FILE_SEPARATOR, outfile) + "\n" + ex.getMessage());
            System.exit(-1);
        }
        StringBuilder sb = new StringBuilder(10240);
        sb.append(copyright).append("//This is a generated file. Do not edit.\n\n");
        try {
            out.write(sb.toString());
        }
        catch (IOException ex) {
            System.err.println(MessageFormat.format(CANT_WRITE_COPYRIGHT, dir, FILE_SEPARATOR, outfile) + "\n" + ex.getMessage());
            try {
                out.close();
            }
            catch (Exception ec) {
                // empty catch block
            }
            System.exit(-1);
        }
        sb.setLength(0);
        JavaScriptTransform noop = new JavaScriptTransform(){

            public String processKey(String key) {
                return key.trim();
            }

            public String processValue(String key, String value) {
                return value.trim();
            }
        };
        JavaScriptTransform messageTransform = new JavaScriptTransform(){

            public String processKey(String key) {
                return key.trim();
            }

            public String processValue(String key, String value) {
                value = value.replace("''", "'");
                value = value.replace("{", "${");
                return value.trim();
            }
        };
        JavaScriptTransform templateTransform = new JavaScriptTransform(){
            String CANT_GET_RESOURCE = "templateTransform: Can''t ''getResource'' key = {0}, value =  {1}";
            String CANT_READ_TEMPLATE_FILE = "Exception reading template file {0}.";
            String CANT_CLOSE_READER = "Exception closing file {0}.";

            public String processKey(String key) {
                return key.trim();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public String processValue(String key, String value) {
                block12: {
                    String path = value.charAt(0) == '/' ? value.substring(1) : value;
                    URL templateFile = this.getClass().getClassLoader().getResource(path);
                    if (templateFile == null) {
                        System.err.println(MessageFormat.format(this.CANT_GET_RESOURCE, key, value));
                        return value.trim();
                    }
                    InputStream streamIn = null;
                    InputStreamReader inreader = null;
                    BufferedReader reader = null;
                    StringBuilder sb = new StringBuilder(512);
                    streamIn = templateFile.openStream();
                    inreader = new InputStreamReader(streamIn);
                    reader = new BufferedReader(inreader);
                    String s = null;
                    while ((s = reader.readLine()) != null) {
                        String sr = s.replaceAll("[ \t]*<[ \t]*", "<").replaceAll("[ \t]*>[ \t]*", ">");
                        sb.append(sr);
                    }
                    value = sb.toString();
                    try {
                        streamIn.close();
                        inreader.close();
                        reader.close();
                    }
                    catch (Exception et) {
                        System.err.println(MessageFormat.format(this.CANT_CLOSE_READER, path) + "\n" + et.getMessage());
                    }
                    break block12;
                    catch (Exception e) {
                        try {
                            System.err.println(MessageFormat.format(this.CANT_READ_TEMPLATE_FILE, path) + "\n" + e.getMessage());
                        }
                        catch (Throwable throwable) {
                            try {
                                streamIn.close();
                                inreader.close();
                                reader.close();
                            }
                            catch (Exception et) {
                                System.err.println(MessageFormat.format(this.CANT_CLOSE_READER, path) + "\n" + et.getMessage());
                            }
                            throw throwable;
                        }
                        try {
                            streamIn.close();
                            inreader.close();
                            reader.close();
                        }
                        catch (Exception et) {
                            System.err.println(MessageFormat.format(this.CANT_CLOSE_READER, path) + "\n" + et.getMessage());
                        }
                    }
                }
                return value.trim();
            }
        };
        JavaScriptTransform transform = noop;
        ThemeResourceBundle.ThemeBundle[] bundles = ThemeResourceBundle.ThemeBundle.values();
        DefaultThemeContext bundleContext = themeContext;
        if (locale != null) {
            bundleContext = new DefaultThemeContext();
            try {
                String[] localesegments = locale.split("_");
                Locale localeInstance = null;
                if (localesegments.length == 1) {
                    localeInstance = new Locale(localesegments[0]);
                } else if (localesegments.length == 2) {
                    localeInstance = new Locale(localesegments[0], localesegments[1]);
                } else if (localesegments.length == 3) {
                    localeInstance = new Locale(localesegments[0], localesegments[1], localesegments[2]);
                }
                URLClassLoader cl = new URLClassLoader(new URL[]{new URL(l10nJar)}, null);
                bundleContext.setDefaultClassLoader(cl);
                bundleContext.setDefaultLocale(localeInstance);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
        }
        JSONObject jsonBundles = new JSONObject();
        for (int i = 0; i < bundles.length; ++i) {
            ThemeResourceBundle.ThemeBundle tb = bundles[i];
            String basename = (String)((ResourceBundleTheme)theme).getProperty(tb.getKey(), tb);
            if (basename == null) continue;
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle(basename, bundleContext.getDefaultLocale(), bundleContext.getDefaultClassLoader());
            }
            catch (Exception e) {
                if (locale != null) continue;
                e.printStackTrace();
                retval = -1;
                break;
            }
            String themeCategory = null;
            switch (tb) {
                case MESSAGES: {
                    themeCategory = "messages";
                    transform = messageTransform;
                    break;
                }
                case STYLESHEET: {
                    themeCategory = "stylesheets";
                    transform = noop;
                    break;
                }
                case TEMPLATE: {
                    themeCategory = "templates";
                    transform = templateTransform;
                    break;
                }
                case PROPERTIES: {
                    themeCategory = "properties";
                    transform = noop;
                    break;
                }
                case JAVASCRIPT: {
                    themeCategory = "javascript";
                    transform = noop;
                    break;
                }
                case IMAGES: {
                    themeCategory = "images";
                    transform = noop;
                    break;
                }
                case CLASSMAPPER: {
                    themeCategory = "styles";
                    transform = noop;
                }
            }
            if (themeCategory == null) {
                System.err.println(MessageFormat.format(UNKNOWN_THEME_BUNDLE, new Object[]{tb}));
                continue;
            }
            if (properties != null && !properties.equals(themeCategory)) continue;
            JSONObject jsonBundleProps = ((ResourceBundleTheme)theme).themeBundleToJavaScript(transform, rb, themeCategory);
            if (jsonBundleProps == null) {
                System.err.println(MessageFormat.format(CANT_CONVER_BUNDLE_TO_JS, themeCategory));
                retval = -1;
                break;
            }
            try {
                jsonBundles.put(themeCategory, (Object)jsonBundleProps);
                continue;
            }
            catch (Exception je) {
                System.err.println(MessageFormat.format(CANT_JSON_PUT, themeCategory) + "\n" + je.getMessage());
                retval = -1;
                break;
            }
        }
        try {
            String outString = null;
            outString = indent != 0 ? jsonBundles.toString(indent).replaceAll("\\\\u", "\\u") + "\n" : jsonBundles.toString().replaceAll("\\\\u", "\\u") + "\n";
            out.write(outString);
            out.close();
        }
        catch (Exception ex) {
            System.err.println(MessageFormat.format(CANT_CLOSE_FILE, dir, FILE_SEPARATOR, outfile) + "\n" + ex.getMessage());
            retval = -1;
        }
        System.exit(retval);
    }

    JSONObject themeBundleToJavaScript(JavaScriptTransform transform, ResourceBundle rb, String bundle) {
        String CANT_JSON_PUT = "JSONException in 'put' for key ''{0}'' from ''{1}''.";
        String CANT_JSON_TOSTRING = "Exception JSONObject.toString() for key ''{0}'' from bundle ''{1}''.";
        JSONObject json = new JSONObject();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = rb.getString(key);
            key = transform.processKey(key);
            key = this.saveConvert(key);
            value = transform.processValue(key, value);
            value = this.saveConvert(value);
            try {
                json.put(key, (Object)value);
            }
            catch (JSONException je) {
                System.err.println(MessageFormat.format(CANT_JSON_PUT, key, bundle) + "\n" + je.getMessage());
                return null;
            }
        }
        return json;
    }

    private String saveConvert(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        StringBuffer outBuffer = new StringBuffer(bufLen);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar < ' ' || aChar > '~') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(ResourceBundleTheme.toHex(aChar >> 12 & 0xF));
                outBuffer.append(ResourceBundleTheme.toHex(aChar >> 8 & 0xF));
                outBuffer.append(ResourceBundleTheme.toHex(aChar >> 4 & 0xF));
                outBuffer.append(ResourceBundleTheme.toHex(aChar & 0xF));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    static interface JavaScriptTransform {
        public static final char DOT = '.';
        public static final char USCORE = '_';
        public static final String OPENBRACERE = "{";
        public static final String OPENPARAMSUB = "${";
        public static final String DQ = "\"";
        public static final String SQ = "'";
        public static final String SQRE = "''";

        public String processKey(String var1);

        public String processValue(String var1, String var2);
    }
}

