/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleConfigLog {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static final int LOG_LEVEL_DEFAULT = 3;
    private static final int LOG_MAXSIZE = 10;
    private static final int LOG_MAXFILES = 5;
    private static final int LOG_STACKSIZE = 20;
    private static final String LOG_FILENAME = "console_config_log";
    private static final int LOG_RETRY = 5;
    private static final String LOG_HEADER_MSG_1 = "# ============================================================";
    private static final String LOG_HEADER_MSG_2 = "# Console configuration log created on ";
    private static final int MAX_LINE_LENGTH = 80;
    private static final int MIN_LINE_LENGTH = 40;
    private static final int MAX_LINE_COUNT = 10;
    private static final String LINE_INDENT = "    ";
    private static boolean enabled = false;
    private static String log_file = "console_config_log";
    private static int log_level = 3;
    private static long log_size = 0L;
    private static long log_maxsize = 0xA00000L;
    private static FileOutputStream log_fo = null;
    private static OutputStreamWriter log_ow = null;
    private static BufferedWriter log_bw = null;
    private static PrintWriter log_pw = null;

    public static synchronized void log(int n, String string) {
        if (enabled) {
            ConsoleConfigLog.log(n, string, null, null, null);
        }
    }

    public static synchronized void log(int n, String string, String string2) {
        if (enabled) {
            ConsoleConfigLog.log(n, string, string2, null, null);
        }
    }

    public static synchronized void log(int n, String string, String string2, String string3) {
        if (enabled) {
            ConsoleConfigLog.log(n, string, string2, string3, null);
        }
    }

    public static synchronized void log(int n, String string, String string2, String string3, String string4) {
        if (enabled && n <= log_level) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException(string, string2, string3, string4);
            ConsoleConfigLog.logMessage(n, consoleConfigException.getLocalizedMessage());
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void log(int n, String[] stringArray) {
        if (enabled && n <= log_level) {
            ConsoleConfigLog.logMessage(n, stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                ConsoleConfigLog.writeMessage(LINE_INDENT + stringArray[i]);
            }
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void log(int n, Throwable throwable) {
        if (enabled && n <= log_level) {
            ConsoleConfigLog.logMessage(n, throwable.getLocalizedMessage());
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void trace(String string) {
        if (enabled && log_level >= 4) {
            ConsoleConfigLog.logMessage(4, string);
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void trace(String[] stringArray) {
        if (enabled && log_level >= 4) {
            ConsoleConfigLog.logMessage(4, stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                ConsoleConfigLog.writeMessage(LINE_INDENT + stringArray[i]);
            }
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void trace(String string, Throwable throwable) {
        if (enabled && log_level >= 4) {
            ConsoleConfigLog.logMessage(4, string);
            if (throwable != null) {
                ConsoleConfigLog.logStackTrace(throwable);
            }
            ConsoleConfigLog.skipLine();
        }
    }

    public static synchronized void open(int n, String string) {
        log_level = n;
        log_file = string;
        if (log_pw != null) {
            enabled = true;
            return;
        }
        boolean bl = false;
        File file = new File(log_file);
        if (file.exists()) {
            log_size = file.length();
        } else {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("Log: cannot open log file");
                log_level = 0;
            }
            bl = true;
            log_size = 0L;
        }
        if (log_level > 0) {
            try {
                log_fo = new FileOutputStream(log_file, true);
                log_ow = new OutputStreamWriter((OutputStream)log_fo, "UTF-8");
                log_bw = new BufferedWriter(log_ow);
                log_pw = new PrintWriter((Writer)log_bw, true);
            }
            catch (Exception exception) {
                log_level = 0;
            }
            if (bl) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy, HH:mm:ss");
                ConsoleConfigLog.writeMessage(LOG_HEADER_MSG_1);
                ConsoleConfigLog.writeMessage(LOG_HEADER_MSG_2 + simpleDateFormat.format(new Date()));
                ConsoleConfigLog.skipLine();
            }
            enabled = true;
        }
    }

    public static synchronized void close() {
        enabled = false;
        log_level = 0;
        if (log_pw != null) {
            try {
                log_pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log_pw = null;
        }
        if (log_bw != null) {
            try {
                log_bw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log_bw = null;
        }
        if (log_ow != null) {
            try {
                log_ow.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log_ow = null;
        }
        if (log_fo != null) {
            try {
                log_fo.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log_fo = null;
        }
    }

    public static int getLevel() {
        int n = 0;
        if (enabled) {
            n = log_level;
        }
        return n;
    }

    private static void logMessage(int n, String string) {
        String string2;
        if (log_size > log_maxsize) {
            ConsoleConfigLog.close();
            ConsoleConfigLog.logRoll();
            ConsoleConfigLog.open(log_level, log_file);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy | HH:mm:ss");
        String string3 = simpleDateFormat.format(new Date());
        switch (n) {
            case 1: {
                string2 = "ERROR";
                break;
            }
            case 2: {
                string2 = "WARN ";
                break;
            }
            case 3: {
                string2 = "INFO ";
                break;
            }
            case 4: {
                string2 = "DEBUG";
                break;
            }
            default: {
                string2 = "     ";
            }
        }
        String string4 = string3 + " | " + string2 + " | " + string;
        for (int i = 0; string4.length() > 0 && i < 10; ++i) {
            String string5 = string4;
            string4 = "";
            if (string5.length() > 80) {
                String string6 = string5.substring(0, 80);
                int n2 = string6.lastIndexOf(" ");
                if (n2 < 40) {
                    n2 = 80;
                }
                string4 = LINE_INDENT + string5.substring(n2);
                string5 = string6.substring(0, n2);
            }
            ConsoleConfigLog.writeMessage(string5);
        }
    }

    private static void logStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        int n;
        String string = throwable.getClass().getName();
        String string2 = "    Exception " + string + ":  " + throwable.getLocalizedMessage();
        ConsoleConfigLog.writeMessage(string2);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            string2 = "    ---Root cause: " + throwable2.getLocalizedMessage();
            ConsoleConfigLog.writeMessage(string2);
        }
        if ((n = (stackTraceElementArray = throwable.getStackTrace()).length) > 20) {
            n = 20;
        }
        for (int i = 0; i < n; ++i) {
            ConsoleConfigLog.writeMessage(LINE_INDENT + stackTraceElementArray[i].toString());
        }
    }

    private static void writeMessage(String string) {
        if (string == null) {
            return;
        }
        log_size += (long)(string.length() + 1);
        try {
            log_pw.println(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void skipLine() {
        log_pw.println();
    }

    private static void logRoll() {
        File[] fileArray = new File[6];
        fileArray[0] = new File(log_file);
        for (int i = 1; i < 6; ++i) {
            fileArray[i] = new File(log_file + "_" + i);
        }
        try {
            if (fileArray[6].exists()) {
                fileArray[6].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 5; i >= 0; --i) {
            try {
                if (!fileArray[i].exists()) continue;
                fileArray[i].renameTo(fileArray[i + 1]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

