/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;

public class ConsoleConfigPasswordManager {
    public static final String ADMIN_NAME_ALIAS = "admin_name";
    public static final String ADMIN_PSWD_ALIAS = "admin_pswd";
    public static final String KEYSTORE_PSWD_ALIAS = "keystore_pswd";
    public static final String TRUSTSTORE_PSWD_ALIAS = "truststore_pswd";
    private static final String junk = "MaStEr!5";
    private static final String PASSWORD_KEYSTORE_TYPE = "JCEKS";
    private static final String REGULAR_KEYSTORE_TYPE = "JKS";
    private static final String TEMPFILE = ".pswd.tmp";
    private static final String BACKFILE = ".pswd.bkp";
    private static Object ksync = new Object();
    private static final String FS = File.separator;
    private String pksPath = null;
    private KeyStore pks = null;
    private boolean bLoaded = false;
    private boolean bPending = false;
    private char[] mp = null;

    public ConsoleConfigPasswordManager(String string) {
        this.pksPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws ConsoleConfigException {
        if (this.bLoaded) {
            return;
        }
        if (this.pksPath == null) {
            throw new ConsoleConfigException("pass_err_01");
        }
        File file = new File(this.pksPath);
        Object object = ksync;
        synchronized (object) {
            this.pks = file.exists() ? ConsoleConfigPasswordManager.loadStore(this.pksPath, PASSWORD_KEYSTORE_TYPE, junk) : ConsoleConfigPasswordManager.newStore(PASSWORD_KEYSTORE_TYPE, junk);
            this.bLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean bl) throws ConsoleConfigException {
        if (!this.bLoaded) {
            return;
        }
        Object object = ksync;
        synchronized (object) {
            ConsoleConfigPasswordManager.saveStore(this.pks, this.pksPath, junk);
            this.bPending = true;
        }
        if (bl) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ConsoleConfigException {
        if (!this.bLoaded) {
            return;
        }
        if (this.bPending) {
            Object object = ksync;
            synchronized (object) {
                ConsoleConfigPasswordManager.commitStore(this.pksPath);
                this.bPending = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws ConsoleConfigException {
        if (this.bLoaded) {
            return;
        }
        Object object = ksync;
        synchronized (object) {
            this.pks = ConsoleConfigPasswordManager.newStore(PASSWORD_KEYSTORE_TYPE, junk);
            this.bLoaded = true;
        }
        this.save(false);
    }

    public String[] getAliasNames() throws ConsoleConfigException {
        if (!this.bLoaded) {
            throw new ConsoleConfigException("pass_err_02");
        }
        String[] stringArray = null;
        try {
            int n = this.pks.size();
            stringArray = new String[n];
            if (n > 0) {
                int n2 = 0;
                Enumeration<String> enumeration = this.pks.aliases();
                while (enumeration.hasMoreElements()) {
                    stringArray[n2++] = enumeration.nextElement();
                }
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("pass_err_02", exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String getValue(String string) throws ConsoleConfigException {
        if (!this.bLoaded) {
            throw new ConsoleConfigException("pass_err_02");
        }
        String string2 = null;
        try {
            Key key = this.pks.getKey(string, ConsoleConfigPasswordManager.fixPassword(junk));
            if (key != null) {
                string2 = new String(key.getEncoded());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConsoleConfigException("pass_err_04", string, exception.getLocalizedMessage());
        }
        return string2;
    }

    public void setValue(String string, String string2) throws ConsoleConfigException {
        if (!this.bLoaded) {
            throw new ConsoleConfigException("pass_err_02");
        }
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            this.pks.setKeyEntry(string, secretKeySpec, ConsoleConfigPasswordManager.fixPassword(junk), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConsoleConfigException("pass_err_05", string, exception.getLocalizedMessage());
        }
    }

    public void removeValue(String string) throws ConsoleConfigException {
        if (!this.bLoaded) {
            throw new ConsoleConfigException("pass_err_02");
        }
        try {
            this.pks.deleteEntry(string);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("pass_err_06", string, exception.getLocalizedMessage());
        }
    }

    public String createTempPasswordFile(String string, Map map) throws ConsoleConfigException {
        Object object;
        String string2;
        int n = 0;
        String[] stringArray = new String[map.size()];
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            object = (String)map.get(string2);
            stringArray[n] = string2 + "=" + (String)object;
            ++n;
        }
        string2 = null;
        try {
            object = new File(string);
            File file = File.createTempFile(".pswd-", null, (File)object);
            string2 = file.getAbsolutePath();
            ConsoleConfigUtil.writeFile(string2, stringArray);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("pass_err_07", exception.getMessage());
        }
        object = System.getProperty("user.name");
        CCServiceLibrary.makeFilePrivate((String)string2, (String)object, (boolean)false);
        return string2;
    }

    public void removeTempPasswordFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void resetStorePassword(String string, String string2, String string3) throws ConsoleConfigException {
        char[] cArray = ConsoleConfigPasswordManager.fixPassword(string2);
        char[] cArray2 = ConsoleConfigPasswordManager.fixPassword(string3);
        KeyStore keyStore = ConsoleConfigPasswordManager.loadStore(string, REGULAR_KEYSTORE_TYPE, string2);
        KeyStore keyStore2 = ConsoleConfigPasswordManager.newStore(REGULAR_KEYSTORE_TYPE, string3);
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                String string4 = enumeration.nextElement();
                if (keyStore.isCertificateEntry(string4)) {
                    serializable = keyStore.getCertificate(string4);
                    keyStore2.setCertificateEntry(string4, (Certificate)serializable);
                    continue;
                }
                if (keyStore.isKeyEntry(string4)) {
                    serializable = keyStore.getKey(string4, cArray);
                    Certificate[] certificateArray = keyStore.getCertificateChain(string4);
                    keyStore2.setKeyEntry(string4, (Key)serializable, cArray2, certificateArray);
                    continue;
                }
                System.out.println("Unknown keystore entry type: " + string4);
            }
            ConsoleConfigPasswordManager.saveStore(keyStore2, string, string3);
            ConsoleConfigPasswordManager.commitStore(string);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("pass_err_08", string, exception.getLocalizedMessage());
        }
    }

    private static char[] fixPassword(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return cArray;
    }

    private static KeyStore loadStore(String string, String string2, String string3) throws ConsoleConfigException {
        KeyStore keyStore = null;
        FileInputStream fileInputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            keyStore = KeyStore.getInstance(string2);
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, ConsoleConfigPasswordManager.fixPassword(string3));
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("pass_err_09", string, exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        return keyStore;
    }

    private static KeyStore newStore(String string, String string2) throws ConsoleConfigException {
        KeyStore keyStore = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            keyStore = KeyStore.getInstance(string);
            keyStore.load(null, ConsoleConfigPasswordManager.fixPassword(string2));
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("pass_err_10", exception.getLocalizedMessage());
        }
        return keyStore;
    }

    private static void saveStore(KeyStore keyStore, String string, String string2) throws ConsoleConfigException {
        String string3 = "";
        int n = string.lastIndexOf(FS);
        if (n >= 0) {
            string3 = string.substring(0, n) + FS;
        }
        File file = new File(string3 + TEMPFILE);
        FileOutputStream fileOutputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            if (file.exists()) {
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            keyStore.store(fileOutputStream, ConsoleConfigPasswordManager.fixPassword(string2));
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("pass_err_11", string, exception.getLocalizedMessage());
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }

    private static void commitStore(String string) throws ConsoleConfigException {
        ConsoleConfigException consoleConfigException = null;
        String string2 = "";
        int n = string.lastIndexOf(FS);
        if (n >= 0) {
            string2 = string.substring(0, n) + FS;
        }
        File file = new File(string2 + BACKFILE);
        File file2 = new File(string2 + TEMPFILE);
        File file3 = new File(string);
        try {
            if (file2.exists()) {
                if (file3.exists()) {
                    if (file.exists()) {
                        file.delete();
                    }
                    file3.renameTo(file);
                }
                file2.renameTo(file3);
            }
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error renaming keystore");
        }
        if (file.exists() && file3.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }
}

