/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigLoginModule;
import com.sun.web.console.config.ConsoleConfigService;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.ConsoleConfigWebModule;
import com.sun.web.console.config.SectionedProperties;
import com.sun.web.console.config.common.ConsoleConfigLoginModuleImpl;
import com.sun.web.console.config.common.ConsoleConfigWebModuleImpl;
import com.sun.web.util.ProductImageUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class ConsoleConfigRegistrationResolver {
    private static final String FS = File.separator;
    private static final String BKP_FILETYPE = ".bkp";
    private static final int REG_FILETYPE_LEN = ".reg".length();
    private static final int REG_PROP_OPTION_PREFIX_LEN = "option_".length();
    private static final String CACHE_HEADER = "Registration cache - ";
    private Properties env;
    private String conf_dir;
    private String prereg_dir;
    private String cache_dir;
    private String cache_path;
    private String cache_temp;
    private String cache_back;
    private SectionedProperties cache = null;
    private Properties[] addWebappList = null;
    private Properties[] remWebappList = null;
    private Properties[] modWebappList = null;

    public ConsoleConfigRegistrationResolver(Properties properties) {
        this.env = properties;
        this.conf_dir = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance");
        this.prereg_dir = this.conf_dir + FS + "prereg";
        this.cache_dir = this.conf_dir + FS + "regcache";
        this.cache_path = this.cache_dir + FS + "registry.properties";
        this.cache_temp = this.cache_dir + FS + "cache.tmp";
        this.cache_back = this.cache_dir + FS + "cache.bkp";
    }

    public SectionedProperties loadCache() throws ConsoleConfigException {
        FileInputStream fileInputStream = null;
        ConsoleConfigException consoleConfigException = null;
        File file = new File(this.cache_path);
        this.cache = new SectionedProperties();
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                this.cache.load(fileInputStream);
            }
            catch (Exception exception) {
                this.cache = null;
                consoleConfigException = new ConsoleConfigException("reg_err_01", exception.getLocalizedMessage());
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        return this.cache;
    }

    public void storeCache() throws ConsoleConfigException {
        if (this.cache == null) {
            return;
        }
        File file = new File(this.cache_dir);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("reg_err_02", exception.getLocalizedMessage());
            }
        }
        FileOutputStream fileOutputStream = null;
        File file2 = new File(this.cache_temp);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy, HH:mm:ss");
        String string = CACHE_HEADER + simpleDateFormat.format(new Date());
        try {
            if (file2.exists()) {
                file2.delete();
            }
            fileOutputStream = new FileOutputStream(file2);
            this.cache.store(fileOutputStream, string);
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("reg_err_03", exception.getLocalizedMessage());
        }
        File file3 = new File(this.cache_back);
        File file4 = new File(this.cache_path);
        if (file4.exists()) {
            try {
                if (file3.exists()) {
                    file3.delete();
                }
                file4.renameTo(file3);
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("reg_err_04", exception.getLocalizedMessage());
            }
        }
        try {
            file2.renameTo(file4);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("reg_err_05", exception.getLocalizedMessage());
        }
    }

    public SectionedProperties loadWebappCache(ConsoleConfigService consoleConfigService) throws ConsoleConfigException {
        SectionedProperties sectionedProperties = new SectionedProperties();
        ConsoleConfigWebModule[] consoleConfigWebModuleArray = consoleConfigService.listWebModules();
        if (consoleConfigWebModuleArray != null && consoleConfigWebModuleArray.length > 0) {
            ConsoleConfigLog.trace("Loaded web modules: " + consoleConfigWebModuleArray.length);
            for (int i = 0; i < consoleConfigWebModuleArray.length; ++i) {
                Properties properties = this.convertFromWebModule(consoleConfigWebModuleArray[i]);
                String string = this.getBlockKey(properties);
                sectionedProperties.setBlock(string, properties);
            }
        }
        return sectionedProperties;
    }

    public String[] resolveJars(ConsoleConfigService consoleConfigService, SectionedProperties sectionedProperties) throws ConsoleConfigException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4 = null;
        boolean bl = false;
        SectionedProperties sectionedProperties2 = this.cache.select("jar-");
        ArrayList arrayList = this.findAddBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList2 = this.findRemoveBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList3 = this.findUpdateBlocks(sectionedProperties, sectionedProperties2);
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        if (n == 0) {
            return object4;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = sectionedProperties2.blockNames();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object3 = sectionedProperties2.getBlock(string);
            object2 = ((Properties)object3).getProperty("location");
            hashMap.put((String)object2, "x");
        }
        string = Long.toString(System.currentTimeMillis());
        if (arrayList.size() > 0) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                ConsoleConfigLog.trace("Resolve jars, adding new jar: " + (String)object3);
                object2 = sectionedProperties.getBlock((String)object3);
                if (!this.validateJarPath((Properties)object2)) continue;
                ((Properties)object2).setProperty("timestamp", string);
                this.cache.setBlock((String)object3, (Properties)object2);
                bl = true;
            }
        }
        if (arrayList2.size() > 0) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                ConsoleConfigLog.trace("Resolve jars, removing jar: " + (String)object3);
                object2 = sectionedProperties2.getBlock((String)object3);
                object = ((Properties)object2).getProperty("system");
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    ConsoleConfigLog.log(1, "reg_err_16", ((Properties)object2).getProperty("id"));
                    continue;
                }
                this.cache.removeBlock((String)object3);
                bl = true;
            }
        }
        if (arrayList3.size() > 0) {
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                ConsoleConfigLog.trace("Resolve jars, replacing jar: " + (String)object3);
                object2 = sectionedProperties.getBlock((String)object3);
                if (!this.validateJarPath((Properties)object2)) continue;
                ((Properties)object2).setProperty("timestamp", string);
                this.cache.setBlock((String)object3, (Properties)object2);
                bl = true;
            }
        }
        object3 = new HashMap();
        object2 = this.cache.select("jar-");
        iterator = ((SectionedProperties)object2).blockNames();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Properties properties = ((SectionedProperties)object2).getBlock((String)object);
            String string2 = properties.getProperty("location");
            ((HashMap)object3).put(string2, "x");
        }
        object = ((HashMap)object3).keySet();
        object4 = new String[object.size()];
        object.toArray((T[])object4);
        boolean bl2 = true;
        if (hashMap.size() == ((HashMap)object3).size()) {
            bl2 = false;
            for (int i = 0; i < ((String[])object4).length; ++i) {
                if (hashMap.get(object4[i]) != null) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            object4 = bl ? new String[]{} : null;
        }
        return object4;
    }

    public Properties[] resolveLoginModules(SectionedProperties sectionedProperties) throws ConsoleConfigException {
        Cloneable cloneable;
        Object object;
        Iterator iterator;
        Properties[] propertiesArray = null;
        SectionedProperties sectionedProperties2 = this.cache.select("loginmodule-");
        ArrayList arrayList = this.findAddBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList2 = this.findRemoveBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList3 = this.findUpdateBlocks(sectionedProperties, sectionedProperties2);
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        if (n == 0) {
            return propertiesArray;
        }
        String string = Long.toString(System.currentTimeMillis());
        if (arrayList.size() > 0) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                cloneable = sectionedProperties.getBlock((String)object);
                ((Properties)cloneable).setProperty("timestamp", string);
                this.cache.setBlock((String)object, (Properties)cloneable);
            }
        }
        if (arrayList2.size() > 0) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.cache.removeBlock((String)object);
            }
        }
        if (arrayList3.size() > 0) {
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                cloneable = sectionedProperties.getBlock((String)object);
                ((Properties)cloneable).setProperty("timestamp", string);
                this.cache.setBlock((String)object, (Properties)cloneable);
            }
        }
        object = this.cache.select("loginmodule-");
        cloneable = new ArrayList();
        iterator = ((SectionedProperties)object).blockNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Properties properties = ((SectionedProperties)object).getBlock(string2);
            ((ArrayList)cloneable).add(properties);
        }
        propertiesArray = new Properties[((ArrayList)cloneable).size()];
        ((ArrayList)cloneable).toArray(propertiesArray);
        return propertiesArray;
    }

    public boolean resolveWebapps(ConsoleConfigService consoleConfigService, SectionedProperties sectionedProperties) throws ConsoleConfigException {
        Object object;
        String string;
        SectionedProperties sectionedProperties2 = this.loadWebappCache(consoleConfigService);
        ArrayList arrayList = this.findAddBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList2 = this.findRemoveBlocks(sectionedProperties, sectionedProperties2);
        ArrayList arrayList3 = this.findUpdateBlocks(sectionedProperties, sectionedProperties2);
        String[] stringArray = new String[arrayList3.size()];
        arrayList3.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            Properties properties = sectionedProperties2.getBlock(string);
            object = properties.getProperty("system");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                ConsoleConfigLog.log(2, "Cannot redeploy a system web application: " + string);
            } else {
                arrayList2.add(string);
                arrayList.add(string);
            }
            arrayList3.remove(string);
        }
        Iterator iterator = sectionedProperties2.blockNames();
        while (iterator.hasNext()) {
            String string2;
            string = (String)iterator.next();
            int n = arrayList2.indexOf(string);
            if (n != -1 || this.validateWebappPath((Properties)(object = sectionedProperties2.getBlock(string))) || (string2 = ((Properties)object).getProperty("system")) != null && string2.equalsIgnoreCase("true")) continue;
            arrayList2.add(string);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            object = sectionedProperties.getBlock(string3);
            if (this.validateWebappPath((Properties)object)) continue;
            arrayList.remove(i);
        }
        if (arrayList2.size() > 0) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Properties properties = sectionedProperties2.getBlock(string4);
                object = properties.getProperty("system");
                if (object == null || !((String)object).equalsIgnoreCase("true")) continue;
                ConsoleConfigLog.log(2, "Cannot remove a system web application: " + string4);
                iterator.remove();
            }
        }
        this.addWebappList = this.setWebappList(arrayList, sectionedProperties);
        this.remWebappList = this.setWebappList(arrayList2, sectionedProperties2);
        this.modWebappList = this.setWebappList(arrayList3, sectionedProperties);
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        return n > 0;
    }

    public String[] resolveNativeLibraryPaths(ConsoleConfigService consoleConfigService, String string) throws ConsoleConfigException {
        int n;
        String[] stringArray = null;
        String[] stringArray2 = consoleConfigService.getNativeLibraryPaths();
        int n2 = 0;
        if (stringArray2 != null) {
            n2 = stringArray2.length;
        }
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (!string.equals(stringArray2[n])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            stringArray = new String[n2 + 1];
            stringArray[0] = string;
            for (n = 0; n < n2; ++n) {
                stringArray[n + 1] = stringArray2[n];
            }
        }
        return stringArray;
    }

    public ArrayList[] resolveJvmOptions(ArrayList arrayList) throws ConsoleConfigException {
        boolean bl;
        ArrayList[] arrayListArray = null;
        ArrayList arrayList2 = this.getCachedJvmOptions();
        boolean bl2 = bl = arrayList2.size() == arrayList.size();
        if (bl) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                Object e = arrayList2.get(i);
                if (arrayList.contains(e)) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            arrayListArray = new ArrayList[]{arrayList2, arrayList};
        }
        return arrayListArray;
    }

    public Properties[] getDeployWebapps() {
        return this.addWebappList;
    }

    public Properties[] getUndeployWebapps() {
        return this.remWebappList;
    }

    public Properties[] getReloadWebapps() {
        return this.modWebappList;
    }

    public boolean deploySharedJars(ConsoleConfigService consoleConfigService, String[] stringArray) throws ConsoleConfigException {
        boolean bl = false;
        if (stringArray != null) {
            if (stringArray.length > 0) {
                bl = true;
                consoleConfigService.setSharedJars(stringArray);
                ConsoleConfigLog.trace("Updated shared jar files");
            }
            this.storeCache();
        }
        return bl;
    }

    public boolean deployLoginModules(ConsoleConfigService consoleConfigService, Properties[] propertiesArray) throws ConsoleConfigException {
        boolean bl = false;
        if (propertiesArray != null) {
            if (propertiesArray.length > 0) {
                ConsoleConfigLoginModule[] consoleConfigLoginModuleArray;
                bl = true;
                ArrayList<ConsoleConfigLoginModule[]> arrayList = new ArrayList<ConsoleConfigLoginModule[]>();
                ConsoleConfigLoginModule[] consoleConfigLoginModuleArray2 = "";
                for (int i = 0; i < propertiesArray.length; ++i) {
                    consoleConfigLoginModuleArray = propertiesArray[i].getProperty("service");
                    if (consoleConfigLoginModuleArray2.equals(consoleConfigLoginModuleArray)) continue;
                    arrayList.add(consoleConfigLoginModuleArray);
                    consoleConfigLoginModuleArray2 = consoleConfigLoginModuleArray;
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    consoleConfigLoginModuleArray2 = (String)iterator.next();
                    consoleConfigLoginModuleArray = this.selectLoginModules((String)consoleConfigLoginModuleArray2, propertiesArray);
                    consoleConfigService.createLoginServiceDefinition((String)consoleConfigLoginModuleArray2, consoleConfigLoginModuleArray);
                    ConsoleConfigLog.log(3, "Updated login modules for " + (String)consoleConfigLoginModuleArray2 + " service");
                }
            }
            this.storeCache();
        }
        return bl;
    }

    public boolean deployWebModules(ConsoleConfigService consoleConfigService, Properties[] propertiesArray) throws ConsoleConfigException {
        boolean bl = false;
        if (propertiesArray != null && propertiesArray.length > 0) {
            bl = true;
            for (int i = 0; i < propertiesArray.length; ++i) {
                Properties properties = propertiesArray[i];
                try {
                    this.deployWebModule(consoleConfigService, properties);
                    continue;
                }
                catch (ConsoleConfigException consoleConfigException) {
                    String string = properties.getProperty("context");
                    ConsoleConfigLog.log(1, "reg_err_17", string, consoleConfigException.getMessage());
                    String string2 = properties.getProperty("system");
                    if (string2 == null || !string2.equalsIgnoreCase("true")) continue;
                    ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("reg_err_18");
                    ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException2));
                    throw consoleConfigException2;
                }
            }
        }
        return bl;
    }

    public boolean undeployWebModules(ConsoleConfigService consoleConfigService, Properties[] propertiesArray) throws ConsoleConfigException {
        boolean bl = false;
        if (propertiesArray != null && propertiesArray.length > 0) {
            bl = true;
            for (int i = 0; i < propertiesArray.length; ++i) {
                Properties properties = propertiesArray[i];
                try {
                    this.undeployWebModule(consoleConfigService, properties);
                    continue;
                }
                catch (ConsoleConfigException consoleConfigException) {
                    String string = properties.getProperty("context");
                    ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("reg_err_19", string, consoleConfigException.getMessage());
                    ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException2));
                }
            }
        }
        return bl;
    }

    public boolean reloadWebModules(ConsoleConfigService consoleConfigService, Properties[] propertiesArray) throws ConsoleConfigException {
        boolean bl = false;
        if (propertiesArray != null && propertiesArray.length > 0) {
            bl = true;
            for (int i = 0; i < propertiesArray.length; ++i) {
                Properties properties = propertiesArray[i];
                try {
                    this.reloadWebModule(consoleConfigService, properties);
                    continue;
                }
                catch (ConsoleConfigException consoleConfigException) {
                    String string = properties.getProperty("context");
                    ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("reg_err_20", string, consoleConfigException.getMessage());
                    ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException2));
                }
            }
        }
        return bl;
    }

    public void deployWebModule(ConsoleConfigService consoleConfigService, Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("appname");
        String string2 = properties.getProperty("context");
        ConsoleConfigWebModule consoleConfigWebModule = this.convertToWebModule(properties);
        consoleConfigWebModule.setTimestamp(System.currentTimeMillis());
        if (string.equalsIgnoreCase("legacy")) {
            String string3 = properties.getProperty("location");
            this.generateProductImages(string2, string3);
        }
        consoleConfigService.deployWebModule(consoleConfigWebModule);
        ConsoleConfigLog.log(3, "reg_err_21", string2);
    }

    public void undeployWebModule(ConsoleConfigService consoleConfigService, Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("context");
        boolean bl = Boolean.valueOf(properties.getProperty("system"));
        if (bl) {
            throw new ConsoleConfigException("Can not remove, " + string + " is a system app");
        }
        consoleConfigService.undeployWebModule(string);
        ConsoleConfigLog.log(3, "reg_err_22", string);
    }

    public void reloadWebModule(ConsoleConfigService consoleConfigService, Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("context");
        consoleConfigService.reloadWebModule(string);
        ConsoleConfigLog.log(3, "reg_err_23", string);
    }

    public boolean deployNativeLibraryPaths(ConsoleConfigService consoleConfigService, String[] stringArray) throws ConsoleConfigException {
        boolean bl = false;
        if (stringArray != null) {
            bl = consoleConfigService.setNativeLibraryPaths(stringArray);
        }
        return bl;
    }

    public boolean deployJvmOptions(ConsoleConfigService consoleConfigService, ArrayList arrayList, ArrayList arrayList2) throws ConsoleConfigException {
        int n;
        String string;
        Iterator iterator;
        Object object;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        try {
            object = consoleConfigService.getJvmOptions();
            if (object != null && ((String[])object).length > 0) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    arrayList3.add(object[i]);
                }
            }
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("reg_err_24", exception.getMessage());
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            throw consoleConfigException;
        }
        object = (ArrayList)arrayList2.clone();
        if (arrayList.size() > 0) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!string.startsWith("-D") || (n = arrayList3.indexOf(string)) < 0) continue;
                arrayList3.remove(n);
            }
        }
        if (arrayList3.size() > 0) {
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!string.startsWith("-D") || (n = ((ArrayList)object).indexOf(string)) >= 0) continue;
                ((ArrayList)object).add(string);
            }
        }
        String[] stringArray = new String[((ArrayList)object).size()];
        stringArray = ((ArrayList)object).toArray(stringArray);
        boolean bl = false;
        try {
            bl = consoleConfigService.setJvmOptions(stringArray);
            ConsoleConfigLog.log(3, "Updated Java options");
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("reg_err_25", exception.getMessage());
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            throw consoleConfigException;
        }
        this.setCachedJvmOptions(arrayList2);
        this.storeCache();
        return bl;
    }

    public Properties convertFromWebModule(ConsoleConfigWebModule consoleConfigWebModule) {
        String string = "webapp";
        String string2 = consoleConfigWebModule.getContextPathName();
        String string3 = consoleConfigWebModule.getAppName();
        String string4 = "0";
        String string5 = "0";
        String string6 = "false";
        String string7 = "false";
        String string8 = "false";
        try {
            string4 = Integer.toString(consoleConfigWebModule.getDebugLevel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string5 = Long.toString(consoleConfigWebModule.getTimestamp());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        if (consoleConfigWebModule.isEnabled()) {
            string6 = "true";
        }
        if (consoleConfigWebModule.isSystem()) {
            string7 = "true";
        }
        if (consoleConfigWebModule.isDefault()) {
            string8 = "true";
        }
        Properties properties = new Properties();
        properties.setProperty("type", string);
        properties.setProperty("id", string2);
        properties.setProperty("appname", string3);
        properties.setProperty("context", string2);
        properties.setProperty("location", consoleConfigWebModule.getLocation());
        properties.setProperty("debug", string4);
        properties.setProperty("timestamp", string5);
        properties.setProperty("system", string7);
        properties.setProperty("default", string8);
        properties.setProperty("enabled", string6);
        properties.setProperty("notification", this.getNotificationProp(properties));
        return properties;
    }

    public ConsoleConfigWebModule convertToWebModule(Properties properties) {
        String string;
        String string2;
        int n = 0;
        long l = 0L;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            n = Integer.parseInt(properties.getProperty("debug"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l = Long.parseLong(properties.getProperty("timestamp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = properties.getProperty("enabled");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        if ((string2 = properties.getProperty("system")) != null && string2.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if ((string = properties.getProperty("default")) != null && string.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl = new ConsoleConfigWebModuleImpl();
        consoleConfigWebModuleImpl.setContextPathName(properties.getProperty("context"));
        consoleConfigWebModuleImpl.setLocation(properties.getProperty("location"));
        consoleConfigWebModuleImpl.setAppName(properties.getProperty("appname"));
        consoleConfigWebModuleImpl.setDebugLevel(n);
        consoleConfigWebModuleImpl.setTimestamp(l);
        consoleConfigWebModuleImpl.setEnabled(bl);
        consoleConfigWebModuleImpl.setSystem(bl2);
        consoleConfigWebModuleImpl.setDefault(bl3);
        return consoleConfigWebModuleImpl;
    }

    public ConsoleConfigLoginModule convertToLoginModule(Properties properties) {
        int n = 0;
        try {
            n = Integer.parseInt(properties.getProperty("order"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = properties.getProperty("service");
        String string2 = properties.getProperty("class");
        String string3 = properties.getProperty("behavior");
        ConsoleConfigLoginModuleImpl consoleConfigLoginModuleImpl = new ConsoleConfigLoginModuleImpl(string, string2, string3);
        consoleConfigLoginModuleImpl.setServiceOrder(n);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith("option_")) continue;
            String string5 = string4.substring(REG_PROP_OPTION_PREFIX_LEN);
            String string6 = properties.getProperty(string4);
            consoleConfigLoginModuleImpl.setOption(string5, string6);
        }
        return consoleConfigLoginModuleImpl;
    }

    private ArrayList findAddBlocks(SectionedProperties sectionedProperties, SectionedProperties sectionedProperties2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = sectionedProperties.blockNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (sectionedProperties2.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private ArrayList findRemoveBlocks(SectionedProperties sectionedProperties, SectionedProperties sectionedProperties2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = sectionedProperties2.blockNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (sectionedProperties.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private ArrayList findUpdateBlocks(SectionedProperties sectionedProperties, SectionedProperties sectionedProperties2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = sectionedProperties.blockNames();
        while (iterator.hasNext()) {
            long l;
            long l2;
            String string;
            String string2 = null;
            string2 = (String)iterator.next();
            if (!sectionedProperties2.containsKey(string2)) continue;
            try {
                string = sectionedProperties.getProperty(string2, "timestamp");
                l2 = Long.parseLong(string);
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, "Bad time stamp", string2);
                continue;
            }
            try {
                string = sectionedProperties2.getProperty(string2, "timestamp");
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, "Bad time stamp", string2);
                continue;
            }
            if (l2 <= l) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private ArrayList getCachedJvmOptions() {
        String string = "jvmoptions-console-jvmoptions";
        Properties properties = this.cache.getBlock(string);
        return ConsoleConfigUtil.getJvmOptions(properties);
    }

    private void setCachedJvmOptions(ArrayList arrayList) {
        String string = "jvmoptions-console-jvmoptions";
        Properties properties = new Properties();
        properties.setProperty("type", "jvmoptions");
        properties.setProperty("id", "jvmoptions");
        properties.setProperty("appname", "console");
        properties.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
        properties.setProperty("notification", "");
        String string2 = null;
        String string3 = null;
        int n = 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (string3 == null || string3.length() <= 0) continue;
            string2 = "value_" + n;
            properties.setProperty(string2, string3);
            ++n;
        }
        this.cache.setBlock(string, properties);
    }

    private boolean validateJarPath(Properties properties) {
        String string;
        Object object;
        String string2 = properties.getProperty("location");
        boolean bl = false;
        try {
            if (string2 == null) {
                throw new Exception("(null path)");
            }
            object = new File(string2);
            if (!((File)object).isAbsolute()) {
                throw new Exception("(not absolute path)");
            }
            string2 = ((File)object).getPath();
            if (string2.endsWith(".jar")) {
                if (string2.endsWith("*.jar")) {
                    string = string2.substring(0, string2.length() - 5);
                    object = new File(string);
                    string2 = ((File)object).getCanonicalPath();
                    string = string2 + File.separator + "*.jar";
                    properties.setProperty("location", string);
                } else {
                    string2 = ((File)object).getCanonicalPath();
                    properties.setProperty("location", string2);
                }
            }
            if (string2.endsWith(".jar")) {
                object = new File(string2);
                bl = ((File)object).exists() && ((File)object).isFile();
            } else {
                if (string2.endsWith(FS) && string2.length() > 1) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                bl = ((File)(object = new File(string2))).exists() && ((File)object).isDirectory();
            }
        }
        catch (Exception exception) {
            bl = false;
            string2 = exception.getMessage();
        }
        if (!bl) {
            object = properties.getProperty("appname");
            string = properties.getProperty("id");
            ConsoleConfigLog.log(1, "reg_err_14", string, (String)object, string2);
        }
        return bl;
    }

    private boolean validateWebappPath(Properties properties) {
        Object object;
        String string = properties.getProperty("location");
        boolean bl = false;
        try {
            if (string == null) {
                throw new Exception("(null path)");
            }
            object = new File(string);
            if (!((File)object).isAbsolute()) {
                throw new Exception("(not absolute path)");
            }
            string = ((File)object).getCanonicalPath();
            properties.setProperty("location", string);
            if (string.endsWith(".war") || string.endsWith(".WAR")) {
                object = new File(string);
                bl = ((File)object).exists() && ((File)object).isFile();
            } else {
                if (string.endsWith(FS) && string.length() > 1) {
                    string = string.substring(0, string.length() - 1);
                }
                bl = ((File)(object = new File(string))).exists() && ((File)object).isDirectory();
            }
        }
        catch (Exception exception) {
            bl = false;
            string = exception.getMessage();
        }
        if (!bl) {
            object = properties.getProperty("appname");
            String string2 = properties.getProperty("context");
            ConsoleConfigLog.log(1, "reg_err_15", string2, (String)object, string);
        }
        return bl;
    }

    private void generateProductImages(String string, String string2) throws ConsoleConfigException {
        String string3 = this.env.getProperty("console_home");
        String string4 = string2 + FS + "WEB-INF" + FS + "app.xml";
        File file = new File(string4);
        if (!file.exists()) {
            string4 = string2 + FS + "app.xml";
        }
        String string5 = string2 + FS + "/com_sun_web_ui/images/";
        try {
            ProductImageUtility productImageUtility = new ProductImageUtility(string3, null);
            productImageUtility.createImagesFromAppxml("all", string4, string5);
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "reg_err_06", string, exception.getMessage());
        }
    }

    private Properties[] setWebappList(ArrayList arrayList, SectionedProperties sectionedProperties) {
        Properties[] propertiesArray = new Properties[arrayList.size()];
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Properties properties;
                String string = (String)iterator.next();
                propertiesArray[n] = properties = sectionedProperties.getBlock(string);
                ++n;
            }
        }
        return propertiesArray;
    }

    private ConsoleConfigLoginModule[] selectLoginModules(String string, Properties[] propertiesArray) {
        Object object;
        ConsoleConfigLoginModule[] consoleConfigLoginModuleArray;
        TreeMap<Object, Properties> treeMap = new TreeMap<Object, Properties>();
        for (int i = 0; i < propertiesArray.length; ++i) {
            consoleConfigLoginModuleArray = propertiesArray[i].getProperty("service");
            if (!string.equals(consoleConfigLoginModuleArray)) continue;
            object = this.getLoginSortKey(propertiesArray[i]);
            treeMap.put(object, propertiesArray[i]);
        }
        Collection collection = treeMap.values();
        consoleConfigLoginModuleArray = new ConsoleConfigLoginModule[collection.size()];
        object = collection.iterator();
        int n = 0;
        while (object.hasNext()) {
            Properties properties = (Properties)object.next();
            consoleConfigLoginModuleArray[n] = this.convertToLoginModule(properties);
            ++n;
        }
        return consoleConfigLoginModuleArray;
    }

    private String getNotificationProp(Properties properties) {
        String string = properties.getProperty("appname");
        String string2 = properties.getProperty("id");
        return this.prereg_dir + FS + string + FS + string2 + ".reg";
    }

    private String getBlockKey(Properties properties) {
        return properties.getProperty("type") + "-" + properties.getProperty("appname") + "-" + properties.getProperty("id");
    }

    private String getLoginSortKey(Properties properties) {
        String string = properties.getProperty("service");
        String string2 = properties.getProperty("order");
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n <= 0) {
            n = 9999;
        }
        String string3 = Integer.toString(n += 10000).substring(1);
        return string + "-" + string3;
    }
}

