/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.sjsas;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.HandshakeCompletedListenerImpl;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustStoreTrustManager;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentSourceImpl;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.web.console.config.ConsoleConfigConstants;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigHttpListener;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigLoginModule;
import com.sun.web.console.config.ConsoleConfigPasswordManager;
import com.sun.web.console.config.ConsoleConfigService;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.ConsoleConfigVirtualServer;
import com.sun.web.console.config.ConsoleConfigWebModule;
import com.sun.web.console.config.common.ConsoleConfigHttpListenerImpl;
import com.sun.web.console.config.common.ConsoleConfigVirtualServerImpl;
import com.sun.web.console.config.common.ConsoleConfigWebModuleImpl;
import com.sun.web.console.config.sjsas.MwaNotificationListener;
import com.sun.web.console.config.sjsas.TemplateCallbackImpl;
import com.sun.web.util.TemplateCallback;
import com.sun.web.util.TemplateRewriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.NotificationListener;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.X509TrustManager;

public class ConsoleConfigServiceImpl
implements ConsoleConfigService {
    private static final String AS_ADMIN_USER_NAME = "AS_ADMIN_USERNAME";
    private static final String AS_ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private static final String AS_ADMIN_ADMINPASSWORD = "AS_ADMIN_ADMINPASSWORD";
    private static final String AS_ADMIN_MASTERPASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private static final String AS_ADMIN_USERPASSWORD = "AS_ADMIN_USERPASSWORD";
    private static final int PSWD_ADMIN_COMMAND = 0;
    private static final int PSWD_CREATE_DOMAIN = 1;
    private static final int PSWD_CHANGE_ADMIN = 2;
    private static final String VS_SERVER = "server";
    private static final String TAGLIB_PROP = "-Dcom.sun.enterprise.taglibs";
    private static final String TAGLISTEN_PROP = "-Dcom.sun.enterprise.taglisteners";
    private static final String WEBUI_JAR = "webui.jar";
    private Properties env = null;
    private Properties asenv = null;
    private String domainPath = null;
    private String domainInst = null;
    private String httpPort = null;
    private String securePort = null;
    private String templateFileName = null;
    private String defaultWebXml = null;
    private String asInstallRoot = null;
    private String passwdFile = null;
    private String configBaseDir = null;
    private String consoleHome = null;
    private String consoleJavaHome = null;
    private String appBase = null;
    private String consoleBase = null;
    private String consoleLogDir = null;
    private String confDir = null;
    private String defaultFile = null;
    private String configFile = null;
    private boolean containerCreated = false;
    private boolean containerStarted = false;
    ConsoleConfigPasswordManager pswdmgr = null;
    private boolean isConnected = false;
    private AppserverConnectionSource connx = null;
    private HandshakeCompletedListenerImpl mHandshakeCompletedListener;
    private DomainRoot mDomainRoot = null;
    private DomainConfig domainConfig = null;
    private ServerConfig serverConfig;
    private ConfigConfig configConfig;
    private String asadminCmd = "asadmin";
    private String asenvFile = "asenv";

    public void initialize() throws ConsoleConfigException {
        try {
            this.pswdmgr = new ConsoleConfigPasswordManager(this.passwdFile);
            this.pswdmgr.load();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Unexpected error from init: " + exception.getMessage());
        }
        if (ConsoleConfigUtil.isWindows()) {
            this.asadminCmd = this.asadminCmd + ".bat";
            this.asenvFile = this.asenvFile + ".bat";
        } else {
            this.asenvFile = this.asenvFile + ".conf";
        }
        String string = this.asInstallRoot + File.separator + "config" + File.separator + this.asenvFile;
        String[] stringArray = ConsoleConfigUtil.readFile(string);
        this.asenv = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            int n = string3.indexOf("=");
            if (n <= 0) continue;
            String string4 = string2 = ConsoleConfigUtil.isWindows() ? this.getWinPropName(string3.substring(0, n)) : string3.substring(0, n);
            if (string2 == null) continue;
            String string5 = "";
            if (n < string3.length()) {
                string5 = this.stripQuotes(string3.substring(n + 1));
            }
            this.asenv.setProperty(string2, string5);
        }
    }

    public int createConsoleContainer() throws ConsoleConfigException {
        String string;
        String string2;
        if (this.containerCreated) {
            throw new ConsoleConfigException("Already created...");
        }
        String[] stringArray = this.getAdminUserAndPswd();
        String string3 = this.getTempPasswordFile(stringArray, 1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + this.asadminCmd).append(" create-domain").append(" --domaindir ").append(this.domainPath).append(" --adminuser ").append(stringArray[0]).append(" --passwordfile ").append(string3).append(" --savemasterpassword ").append(" --adminport ").append(this.getAdminPort()).append(" --instanceport ").append(this.httpPort).append(" --domainproperties ").append("http.ssl.port=").append(this.securePort).append(":domain.jmxPort=").append(this.getJMXPort()).append(" ").append(this.domainInst);
        ConsoleConfigLog.trace(stringBuffer.toString());
        int n = ConsoleConfigUtil.execCommand(stringBuffer.toString());
        this.removeTempPasswordFile(string3);
        if (n != 0) {
            ConsoleConfigLog.log(1, "Create domain failed with return code: " + n);
            return n;
        }
        String string4 = this.consoleHome + File.separator + ConsoleConfigConstants.SJSAS_TEMPLATE_SUBDIR;
        String string5 = this.domainPath + File.separator + this.domainInst + File.separator + "config";
        ConsoleConfigUtil.copySystemRegnots(this.env, string4);
        try {
            string2 = string4 + File.separator + "default-web.xml";
            string = string5 + File.separator + "default-web.xml";
            ConsoleConfigUtil.copyFile(string2, string);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Problem creating new domain", exception);
        }
        string2 = this.confDir + File.separator + "console.policy";
        string = string4 + File.separator + "console_policy.tpl";
        this.copyTemplate(string, string2);
        this.containerCreated = true;
        return 0;
    }

    public int deleteConsoleContainer() throws ConsoleConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + this.asadminCmd).append(" delete-domain").append(" --domaindir ").append(this.domainPath).append(" ").append(this.domainInst);
        int n = ConsoleConfigUtil.execCommand(stringBuffer.toString());
        ConsoleConfigUtil.deleteFile(new File(this.consoleLogDir));
        if (n == 0) {
            ConsoleConfigLog.trace("container " + this.domainInst + " deleted...");
            this.containerCreated = false;
        }
        return n;
    }

    public boolean initialContainerConfig() throws ConsoleConfigException {
        boolean bl = false;
        boolean bl2 = false;
        ConsoleConfigLog.trace("SJSAS: initial container configuration...");
        if (this.containerStarted && this.isConnected) {
            Object object;
            Object object2;
            try {
                object2 = this.configConfig.getHTTPServiceConfig();
                object = object2.getVirtualServerConfigMap();
                VirtualServerConfig virtualServerConfig = (VirtualServerConfig)object.get(VS_SERVER);
                virtualServerConfig.setDefaultWebModule("console");
                bl = true;
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(2, "Error setting console as the default webapp: " + exception.getMessage());
            }
            try {
                bl2 = false;
                object2 = this.getJvmOptions();
                if (object2 != null && ((String[])object2).length > 0) {
                    for (int i = 0; i < ((String[])object2).length; ++i) {
                        if (object2[i].startsWith("-Dcom.sun.enterprise.taglibs=")) {
                            object = this.addToPropertyValue(object2[i], WEBUI_JAR);
                            if (object == null) continue;
                            object2[i] = object;
                            bl2 = true;
                            continue;
                        }
                        if (!object2[i].startsWith("-Dcom.sun.enterprise.taglisteners=") || (object = this.addToPropertyValue(object2[i], WEBUI_JAR)) == null) continue;
                        object2[i] = object;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.setJvmOptions((String[])object2);
                    bl = true;
                }
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("Error resetting JVM options for taglibs: " + exception.getMessage());
            }
            object2 = null;
            int n = 0;
            try {
                J2EEDomain j2EEDomain = this.mDomainRoot.getJ2EEDomain();
                Map map = j2EEDomain.getServerMap();
                J2EEServer j2EEServer = (J2EEServer)map.get(this.serverConfig.getName());
                Object object3 = j2EEServer.getserverVersion();
                ConsoleConfigLog.log(3, "sjsas server version is \"" + (String)object3 + "\"");
                String[] stringArray = ((String)object3).split(" ");
                object2 = stringArray[stringArray.length - 1];
                int n2 = ((String)object2).indexOf(".");
                object3 = n2 > 0 ? ((String)object2).substring(0, n2) : object2;
                n = Integer.parseInt((String)object3);
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("Error reading server version: " + exception.getMessage());
            }
        }
        throw new ConsoleConfigException("sjsas initial processing: not connected in admin mode");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int startServer(String string) throws ConsoleConfigException {
        ConsoleConfigLog.trace("starting server in " + string + " mode");
        int n = 0;
        if (string.equals("admin")) {
            if (this.containerStarted) {
                ConsoleConfigLog.trace("server is already up and running");
                if (this.isConnected) return n;
                ConsoleConfigLog.trace("connecting to DAS...");
                this.connectAdmin();
                this.resetContainerAddress();
                ConsoleConfigLog.trace("connection done...");
                return n;
            }
            ConsoleConfigLog.trace("Server not running, starting server");
            n = this.startContainer();
            if (n == 0) {
                ConsoleConfigLog.trace("server started, connecting to DAS");
                this.containerStarted = true;
                this.connectAdmin();
                this.resetContainerAddress();
                ConsoleConfigLog.trace("connected to DAS");
                return n;
            }
            ConsoleConfigLog.log(1, "Server start failed with return code: " + n);
            this.containerStarted = false;
            throw new ConsoleConfigException("Failed to start server");
        }
        if (this.isConnected) {
            ConsoleConfigLog.trace("disconnecting from admin mode");
            this.disConnectAdmin();
            return n;
        }
        if (this.containerStarted) return n;
        ConsoleConfigLog.trace("starting server in user mode");
        n = this.startContainer();
        if (n != 0) return n;
        this.containerStarted = true;
        ConsoleConfigLog.trace("server started in user mode");
        return n;
    }

    public int stopServer(boolean bl) throws ConsoleConfigException {
        ConsoleConfigLog.trace("stopping server");
        if (!this.containerStarted && this.statServer() != 0) {
            ConsoleConfigLog.trace("server not up, return 0");
            return 0;
        }
        this.disConnectAdmin();
        ConsoleConfigLog.trace("server is up, stop server");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + this.asadminCmd).append(" stop-domain").append(" --domaindir ").append(this.domainPath).append(" ").append(this.domainInst);
        int n = ConsoleConfigUtil.execCommand(stringBuffer.toString());
        if (n == 0) {
            ConsoleConfigLog.trace("server stopped normally");
            this.containerStarted = false;
        } else {
            ConsoleConfigLog.log(1, "Server stop failed with return code: " + n);
        }
        return n;
    }

    public int restartServer(String string) throws ConsoleConfigException {
        int n = this.stopServer(false);
        if (n != 0) {
            return n;
        }
        return this.startServer(string);
    }

    public int statServer() throws ConsoleConfigException {
        int n = 0;
        int n2 = ConsoleConfigUtil.pingConsole(this.env);
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    public int createCertificate() throws ConsoleConfigException {
        String string = this.consoleJavaHome + File.separator + "bin" + File.separator + "keytool";
        String string2 = "s1as";
        String[] stringArray = this.getKeyStoreAndPswd();
        String[] stringArray2 = this.getTrustStoreAndPswd();
        String string3 = this.confDir + File.separator + string2 + ".cer";
        File file = new File(string3);
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = 0;
        File file2 = new File(stringArray[0]);
        if (file2.exists()) {
            n = ConsoleConfigUtil.exportJKSCertificate(string, string2, string3, stringArray[0], stringArray[1]);
        } else {
            String string4 = this.asenv.getProperty("AS_NSS_BIN") + File.separator + "certutil";
            n = ConsoleConfigUtil.exportNSSCertificate(string4, string2, string3, this.confDir);
        }
        if (n == 0) {
            n = ConsoleConfigUtil.importJKSCertificate(string, string2, string3, stringArray2[0], stringArray2[1]);
        }
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void connectAdmin() throws ConsoleConfigException {
        if (this.isConnected) {
            ConsoleConfigLog.trace("Admin connect: already connected");
            return;
        }
        String string = this.getJMXHost();
        int n = this.getJMXPort();
        String[] stringArray = this.getAdminUserAndPswd();
        String[] stringArray2 = this.getTrustStoreAndPswd();
        boolean bl = this.isTLSEnabled();
        TLSParams tLSParams = bl ? this.createTLSParams(stringArray2[0], stringArray2[1]) : null;
        try {
            ConsoleConfigLog.trace("Connecting to DAS, TLS set to " + bl);
            try {
                this.connx = this.connectToDAS(string, n, stringArray[0], stringArray[1], tLSParams);
            }
            catch (Exception exception) {
                ConsoleConfigLog.trace("first attempt failed, reconnecting...");
                this.connx = this.connectToDAS(string, n, stringArray[0], stringArray[1], tLSParams);
                ConsoleConfigLog.trace("second attempt succeeded...");
            }
            ConsoleConfigLog.trace("connected to DAS, getting domain info");
            this.mDomainRoot = this.connx.getDomainRoot();
            this.domainConfig = this.mDomainRoot.getDomainConfig();
            this.configConfig = (ConfigConfig)this.domainConfig.getConfigConfigMap().get("server-config");
            Map map = this.domainConfig.getServerConfigMap();
            this.serverConfig = (ServerConfig)map.get(VS_SERVER);
            this.isConnected = true;
            ConsoleConfigLog.trace("Config server : " + this.serverConfig.getName());
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error starting admin server: " + exception.getMessage());
        }
    }

    public void disConnectAdmin() throws ConsoleConfigException {
        if (!this.isConnected) {
            return;
        }
        try {
            if (this.connx != null) {
                this.connx.getJMXConnector(false).close();
                this.connx = null;
            }
            this.isConnected = false;
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error stopping admin server: " + exception.getMessage());
        }
    }

    public ConsoleConfigWebModule[] listWebModules() throws ConsoleConfigException {
        ConsoleConfigWebModule[] consoleConfigWebModuleArray;
        Vector<ConsoleConfigWebModuleImpl> vector = new Vector<ConsoleConfigWebModuleImpl>();
        ConsoleConfigLog.trace("Listing web modules...");
        try {
            consoleConfigWebModuleArray = this.domainConfig.getWebModuleConfigMap();
            if (consoleConfigWebModuleArray != null) {
                Object[] objectArray = consoleConfigWebModuleArray.values().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl = new ConsoleConfigWebModuleImpl();
                    WebModuleConfig webModuleConfig = (WebModuleConfig)objectArray[i];
                    String string = webModuleConfig.getObjectType();
                    String string2 = webModuleConfig.getContextRoot();
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    String string3 = "";
                    String string4 = "0";
                    boolean bl = false;
                    if (string.equalsIgnoreCase("system-admin")) {
                        ConsoleConfigLog.trace("List web modules: excluding admin module: " + string2);
                        continue;
                    }
                    String string5 = webModuleConfig.getDescription();
                    if (string5 != null && string5.length() > 0) {
                        object = new StringTokenizer(string5, "|");
                        string3 = ((StringTokenizer)object).nextToken();
                        String string6 = ((StringTokenizer)object).nextToken();
                        if (string6 != null && string6.equals("system")) {
                            bl = true;
                        }
                        if ((string4 = ((StringTokenizer)object).nextToken()) == null || string4.equals("null")) {
                            string4 = "0";
                        }
                    }
                    consoleConfigWebModuleImpl.setContextPathName(string2);
                    consoleConfigWebModuleImpl.setAppName(string3);
                    consoleConfigWebModuleImpl.setSystem(bl);
                    consoleConfigWebModuleImpl.setTimestamp(Long.parseLong(string4));
                    object = webModuleConfig.getLocation();
                    if (this.serverConfig.isTemplateString((String)object)) {
                        consoleConfigWebModuleImpl.setLocation(this.serverConfig.resolveTemplateString((String)object));
                    } else {
                        consoleConfigWebModuleImpl.setLocation((String)object);
                    }
                    consoleConfigWebModuleImpl.setEnabled(webModuleConfig.getEnabled());
                    vector.add(consoleConfigWebModuleImpl);
                }
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Problem listing web modules", exception);
        }
        if (vector.size() > 0) {
            ConsoleConfigLog.trace("non zero list of web modules...");
            consoleConfigWebModuleArray = new ConsoleConfigWebModule[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                consoleConfigWebModuleArray[i] = (ConsoleConfigWebModule)vector.elementAt(i);
            }
            return consoleConfigWebModuleArray;
        }
        return null;
    }

    public void deployWebModule(ConsoleConfigWebModule consoleConfigWebModule) throws ConsoleConfigException {
        String string = consoleConfigWebModule.getContextPathName();
        DeploymentMgr deploymentMgr = this.mDomainRoot.getDeploymentMgr();
        Object object = deploymentMgr.initDeploy();
        MwaNotificationListener mwaNotificationListener = new MwaNotificationListener(object);
        deploymentMgr.addNotificationListener((NotificationListener)mwaNotificationListener, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X-DeploymentMgr.Cascade", "true");
        hashMap.put("X-DeploymentMgr.Verify", "false");
        hashMap.put("X-DeploymentMgr.Force", "true");
        hashMap.put("X-DeploymentMgr.Enable", "false");
        hashMap.put("X-DeploymentMgr.AvailabilityEnabled", "false");
        hashMap.put("X-DeploymentMgr.ContextRoot", consoleConfigWebModule.getContextPathName());
        hashMap.put("X-DeploymentMgr.GenerateRMIStubs", "true");
        hashMap.put("X-DeploymentMgr.Name", string);
        ConsoleConfigLog.trace("deploying app: " + string);
        hashMap.put("directorydeployed", "true");
        try {
            DeploymentSourceImpl deploymentSourceImpl = new DeploymentSourceImpl(consoleConfigWebModule.getLocation(), true, new String[1], new String[1], new String[1], new HashMap());
            deploymentMgr.startDeploy(object, deploymentSourceImpl.asMap(), null, hashMap);
            boolean bl = false;
            boolean bl2 = false;
            DeploymentStatus deploymentStatus = null;
            while (!mwaNotificationListener.isCompleted()) {
                try {
                    ConsoleConfigLog.trace("deploy: waiting for deploy of " + deploymentSourceImpl);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            deploymentStatus = mwaNotificationListener.getDeploymentStatus();
            ConsoleConfigLog.trace("Deployment result: " + this.getStageStatusString(deploymentStatus.getStageStatus()));
            if (deploymentStatus.getStageThrowable() != null) {
                throw new Exception(deploymentStatus.getStageThrowable());
            }
            Map map = this.domainConfig.getStandaloneServerConfigMap();
            StandaloneServerConfig standaloneServerConfig = (StandaloneServerConfig)map.get(VS_SERVER);
            Object object2 = standaloneServerConfig.createDeployedItemRefConfig(consoleConfigWebModule.getContextPathName());
            ConsoleConfigLog.trace("enabled state during deploy: " + consoleConfigWebModule.isEnabled());
            object2.setEnabled(consoleConfigWebModule.isEnabled());
            object2.setVirtualServers(VS_SERVER);
            map = this.domainConfig.getWebModuleConfigMap();
            if (map != null) {
                standaloneServerConfig = (WebModuleConfig)map.get(string);
                standaloneServerConfig.setDescription(consoleConfigWebModule.getAppName() + "|" + (consoleConfigWebModule.isSystem() ? "system" : "user") + "|" + consoleConfigWebModule.getTimestamp());
                standaloneServerConfig.setObjectType("user");
                standaloneServerConfig.setEnabled(true);
            }
            if (string.equals("console")) {
                try {
                    standaloneServerConfig = this.configConfig.getHTTPServiceConfig();
                    object2 = standaloneServerConfig.getVirtualServerConfigMap();
                    VirtualServerConfig virtualServerConfig = (VirtualServerConfig)object2.get(VS_SERVER);
                    virtualServerConfig.setDefaultWebModule("console");
                }
                catch (Exception exception) {
                    ConsoleConfigLog.log(2, "Error setting console as the default webapp: " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Webapp was partially deployed; undeploy");
            try {
                this.undeployWebModule(consoleConfigWebModule.getContextPathName());
            }
            catch (Exception exception2) {
                ConsoleConfigLog.log(3, "exception undeploying " + consoleConfigWebModule.getContextPathName() + " which was partially deployed: " + exception2.getMessage());
            }
            throw new ConsoleConfigException("Problem deploying module: " + consoleConfigWebModule.getContextPathName() + ". The module has been undeployed.", exception);
        }
        finally {
            try {
                deploymentMgr.removeNotificationListener((NotificationListener)mwaNotificationListener);
            }
            catch (Exception exception) {}
        }
    }

    public void undeployWebModule(String string) throws ConsoleConfigException {
        if (string == null) {
            throw new ConsoleConfigException("module name cannot be null");
        }
        ConsoleConfigLog.trace("undeploying app: " + string);
        Map map = this.domainConfig.getStandaloneServerConfigMap();
        StandaloneServerConfig standaloneServerConfig = (StandaloneServerConfig)map.get(VS_SERVER);
        standaloneServerConfig.removeDeployedItemRefConfig(string);
        Map map2 = standaloneServerConfig.getDeployedItemRefConfigMap();
        DeploymentMgr deploymentMgr = this.mDomainRoot.getDeploymentMgr();
        Map map3 = deploymentMgr.undeploy(string, null);
        DeploymentStatus deploymentStatus = DeploymentSupport.mapToDeploymentStatus((Map)map3);
        ConsoleConfigLog.trace("Undeployment result: " + this.getStageStatusString(deploymentStatus.getStageStatus()));
        ConsoleConfigLog.trace("status message: " + deploymentStatus.getStageStatusMessage());
        if (deploymentStatus.getStageThrowable() != null) {
            throw new ConsoleConfigException(deploymentStatus.getStageStatusMessage(), new Exception(deploymentStatus.getStageThrowable()));
        }
    }

    public void enableWebModule(String string) throws ConsoleConfigException {
        if (string == null) {
            throw new ConsoleConfigException("module name cannot be null");
        }
        try {
            Map map = this.domainConfig.getWebModuleConfigMap();
            WebModuleConfig webModuleConfig = (WebModuleConfig)map.get(string);
            if (!webModuleConfig.getEnabled()) {
                webModuleConfig.setEnabled(true);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("could not enable webmodule: " + string, exception);
        }
    }

    public void disableWebModule(String string) throws ConsoleConfigException {
        if (string == null) {
            throw new ConsoleConfigException("module name cannot be null");
        }
        try {
            Map map = this.domainConfig.getWebModuleConfigMap();
            WebModuleConfig webModuleConfig = (WebModuleConfig)map.get(string);
            if (webModuleConfig.getEnabled()) {
                webModuleConfig.setEnabled(false);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("could not disable webmodule: " + string, exception);
        }
    }

    public void reloadWebModule(String string) throws ConsoleConfigException {
        this.stopWebModule(string);
        this.startWebModule(string);
    }

    public ConsoleConfigHttpListener getHttpListener(String string) throws ConsoleConfigException {
        if (string == null) {
            throw new ConsoleConfigException("listener name cannot be null");
        }
        HTTPServiceConfig hTTPServiceConfig = this.configConfig.getHTTPServiceConfig();
        Map map = hTTPServiceConfig.getHTTPListenerConfigMap();
        HTTPListenerConfig hTTPListenerConfig = (HTTPListenerConfig)map.get(string);
        ConsoleConfigHttpListenerImpl consoleConfigHttpListenerImpl = null;
        if (hTTPListenerConfig != null) {
            consoleConfigHttpListenerImpl = new ConsoleConfigHttpListenerImpl(hTTPListenerConfig.getName(), hTTPListenerConfig.getPort(), hTTPListenerConfig.getAcceptorThreads(), hTTPListenerConfig.getEnabled(), hTTPListenerConfig.getSecurityEnabled(), hTTPListenerConfig.getDefaultVirtualServer());
            return consoleConfigHttpListenerImpl;
        }
        throw new ConsoleConfigException("HTTP listener " + string + " not found");
    }

    public void setHttpListener(ConsoleConfigHttpListener consoleConfigHttpListener) throws ConsoleConfigException {
        try {
            HTTPServiceConfig hTTPServiceConfig = this.configConfig.getHTTPServiceConfig();
            Map map = hTTPServiceConfig.getHTTPListenerConfigMap();
            HTTPListenerConfig hTTPListenerConfig = (HTTPListenerConfig)map.get(consoleConfigHttpListener.getListenerID());
            if (hTTPListenerConfig != null) {
                hTTPListenerConfig.setPort(consoleConfigHttpListener.getListenerPort());
                hTTPListenerConfig.setAcceptorThreads(consoleConfigHttpListener.getAcceptorThreadCount());
                hTTPListenerConfig.setEnabled(consoleConfigHttpListener.isListenerEnabled());
                hTTPListenerConfig.setSecurityEnabled(consoleConfigHttpListener.isListenerSecure());
                hTTPListenerConfig.setDefaultVirtualServer(consoleConfigHttpListener.getDefaultVirtualServerName());
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Enabled", String.valueOf(consoleConfigHttpListener.isListenerEnabled()));
                hashMap.put("SecurityEnabled", String.valueOf(consoleConfigHttpListener.isListenerSecure()));
                hashMap.put("AcceptorThreads", consoleConfigHttpListener.getAcceptorThreadCount());
                hTTPServiceConfig.createHTTPListenerConfig(consoleConfigHttpListener.getListenerID(), "0.0.0.0", Integer.parseInt(consoleConfigHttpListener.getListenerPort()), consoleConfigHttpListener.getDefaultVirtualServerName(), "", hashMap);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("error setting new HTTP listener", exception);
        }
    }

    public ConsoleConfigVirtualServer getVirtualServer(String string) throws ConsoleConfigException {
        if (string == null) {
            throw new ConsoleConfigException("virtual server name cannot be null");
        }
        HTTPServiceConfig hTTPServiceConfig = this.configConfig.getHTTPServiceConfig();
        Map map = hTTPServiceConfig.getVirtualServerConfigMap();
        VirtualServerConfig virtualServerConfig = (VirtualServerConfig)map.get(string);
        if (virtualServerConfig != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(virtualServerConfig.getHTTPListeners(), ",");
            ConsoleConfigHttpListener[] consoleConfigHttpListenerArray = new ConsoleConfigHttpListener[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                consoleConfigHttpListenerArray[n] = this.getHttpListener(stringTokenizer.nextToken());
                ++n;
            }
            stringTokenizer = new StringTokenizer(virtualServerConfig.getHosts(), ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            ConsoleConfigVirtualServerImpl consoleConfigVirtualServerImpl = new ConsoleConfigVirtualServerImpl(string, consoleConfigHttpListenerArray, virtualServerConfig.getDocRoot(), virtualServerConfig.getLogFile(), virtualServerConfig.getState(), stringArray);
            return consoleConfigVirtualServerImpl;
        }
        throw new ConsoleConfigException("virtual server " + string + " not configured");
    }

    public void setVirtualServer(ConsoleConfigVirtualServer consoleConfigVirtualServer) throws ConsoleConfigException {
        try {
            HTTPServiceConfig hTTPServiceConfig = this.configConfig.getHTTPServiceConfig();
            Map map = hTTPServiceConfig.getVirtualServerConfigMap();
            VirtualServerConfig virtualServerConfig = (VirtualServerConfig)map.get(consoleConfigVirtualServer.getVirtualServerID());
            if (virtualServerConfig != null) {
                virtualServerConfig.setDocRoot(consoleConfigVirtualServer.getDocRoot());
                virtualServerConfig.setHosts(consoleConfigVirtualServer.getVirtualServerHosts().toString());
                virtualServerConfig.setHTTPListeners(consoleConfigVirtualServer.getHTTPListenerNames());
                virtualServerConfig.setLogFile(consoleConfigVirtualServer.getAccessLog());
                virtualServerConfig.setState(consoleConfigVirtualServer.getVirtualServerState());
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("HTTPListeners", consoleConfigVirtualServer.getHTTPListenerNames());
                hashMap.put("State", consoleConfigVirtualServer.getVirtualServerState());
                hashMap.put("property.docroot", consoleConfigVirtualServer.getDocRoot());
                hashMap.put("property.accesslog", consoleConfigVirtualServer.getAccessLog());
                hTTPServiceConfig.createVirtualServerConfig(consoleConfigVirtualServer.getVirtualServerID(), consoleConfigVirtualServer.getVirtualServerHosts().toString(), hashMap);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Exception while setting VS", exception);
        }
    }

    public String[] getNativeLibraryPaths() throws ConsoleConfigException {
        String[] stringArray = new String[]{};
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        String string = javaConfig.getNativeLibraryPathSuffix();
        if (string != null) {
            stringArray = string.split(":");
        }
        return stringArray;
    }

    public boolean setNativeLibraryPaths(String[] stringArray) throws ConsoleConfigException {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl) {
                string = string.concat(":");
            }
            string = string.concat(stringArray[i]);
            bl = false;
        }
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        javaConfig.setNativeLibraryPathSuffix(string);
        return true;
    }

    public String[] getJvmOptions() throws ConsoleConfigException {
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        String[] stringArray = javaConfig.getJVMOptions();
        return stringArray;
    }

    public boolean setJvmOptions(String[] stringArray) throws ConsoleConfigException {
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        javaConfig.setJVMOptions(stringArray);
        return true;
    }

    public ConsoleConfigLoginModule[] listLoginModules(String string) throws ConsoleConfigException {
        throw new ConsoleConfigException("Not yet implemented!");
    }

    public void createLoginServiceDefinition(String string, ConsoleConfigLoginModule[] consoleConfigLoginModuleArray) throws ConsoleConfigException {
        if (consoleConfigLoginModuleArray == null || consoleConfigLoginModuleArray.length == 0) {
            throw new ConsoleConfigException("null or empty loginmodule list");
        }
        String string2 = this.domainPath + File.separator + this.domainInst + File.separator + "config";
        ConsoleConfigUtil.addLoginServiceDefinition(string, consoleConfigLoginModuleArray, string2, "login.conf");
    }

    public String[] listSharedJars() throws ConsoleConfigException {
        try {
            JavaConfig javaConfig = this.configConfig.getJavaConfig();
            String string = javaConfig.getClasspathSuffix();
            String string2 = null;
            String string3 = null;
            try {
                string2 = URLEncoder.encode(string, "UTF-8");
                string3 = URLEncoder.encode("${path.separator}", "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
                string3 = "${path.separator}";
            }
            String[] stringArray = string2.split(string3);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = URLDecoder.decode(stringArray[i], "UTF-8");
                if (!this.serverConfig.isTemplateString(stringArray[i])) continue;
                stringArray[i] = this.serverConfig.resolveTemplateString(stringArray[i]);
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new ConsoleConfigException(exception.getMessage());
        }
    }

    public void addSharedJars(String[] stringArray) throws ConsoleConfigException {
        if (stringArray == null) {
            throw new ConsoleConfigException("empty jar list");
        }
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        String string = javaConfig.getClasspathSuffix();
        boolean bl = string.length() == 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jar")) continue;
            ConsoleConfigLog.trace("ADDING JAR: " + stringArray[i]);
            String string2 = this.getJarPath(stringArray[i]);
            if (string2.length() == 0) continue;
            if (!bl) {
                string.concat(File.pathSeparator);
            }
            string.concat(string2);
            bl = false;
        }
        javaConfig.setClasspathSuffix(string);
    }

    public void setSharedJars(String[] stringArray) throws ConsoleConfigException {
        if (stringArray == null) {
            throw new ConsoleConfigException("empty jar list");
        }
        JavaConfig javaConfig = this.configConfig.getJavaConfig();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.getJarPath(stringArray[i]);
            if (string.length() == 0) continue;
            if (!bl) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(string);
            bl = false;
        }
        ConsoleConfigLog.trace("final classpath: " + stringBuffer.toString());
        javaConfig.setClasspathSuffix(stringBuffer.toString());
    }

    private String getJarPath(String string) {
        File file;
        String string2;
        ConsoleConfigLog.trace("start getJarPath with input: " + string);
        if (!string.endsWith(File.separator + "*.jar")) {
            return string;
        }
        String string3 = string2 = string.substring(0, string.length() - 6);
        if (string2.length() == 0) {
            string3 = File.separator;
        }
        if (!(file = new File(string3)).exists()) {
            return "";
        }
        String[] stringArray = file.list();
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jar")) continue;
            string3 = string2 + File.separator + stringArray[i];
            if (!bl) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(string3);
            bl = false;
        }
        ConsoleConfigLog.trace("end getJarPath with output: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public void resetAdminPassword(String string, String string2, String string3) throws ConsoleConfigException {
        if (this.statServer() != 0) {
            throw new ConsoleConfigException("Console server must be running");
        }
        String[] stringArray = new String[]{string, string2, string3};
        String string4 = this.getTempPasswordFile(stringArray, 2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + this.asadminCmd).append(" update-file-user").append(" --user ").append(string).append(" --passwordfile ").append(string4).append(" --host ").append(this.getAdminHost()).append(" --port ").append(this.getAdminPort()).append(" --secure ").append(" --authrealmname admin-realm ").append(string);
        int n = ConsoleConfigUtil.execCommand(stringBuffer.toString());
        this.removeTempPasswordFile(string4);
        if (n != 0) {
            throw new ConsoleConfigException("Error changing AS admin password: " + n);
        }
    }

    public void resetKeystorePassword(String string, String string2) throws ConsoleConfigException {
        if (this.statServer() == 0) {
            throw new ConsoleConfigException("Console server must be stopped");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + "asadmin ").append("change-master-password").append(" --domaindir ").append(this.domainPath).append(" ").append(this.domainInst);
        String string3 = stringBuffer.toString();
        System.out.println("");
        System.out.println("The console is using the Application Server container.");
        System.out.println("Execute the following command to complete the change:");
        System.out.println("   " + string3);
        System.out.println("");
    }

    public void resetTruststorePassword(String string, String string2) throws ConsoleConfigException {
        String string3 = this.confDir + File.separator + "wccerts.jks";
        ConsoleConfigPasswordManager.resetStorePassword(string3, string, string2);
    }

    public void setEnv(Properties properties) {
        if (properties != null) {
            this.env = properties;
            this.consoleHome = this.env.getProperty("console_home").trim();
            this.domainPath = this.env.getProperty("console_dombase").trim();
            this.domainInst = this.env.getProperty("console_instance").trim();
            this.httpPort = this.env.getProperty("console_httpport").trim();
            this.securePort = this.env.getProperty("console_httpsport").trim();
            this.templateFileName = this.consoleHome + File.separator + ConsoleConfigConstants.SJSAS_TEMPLATE_SUBDIR + File.separator + "domain.xml.tpl";
            this.defaultWebXml = this.consoleHome + File.separator + ConsoleConfigConstants.SJSAS_TEMPLATE_SUBDIR + File.separator + "default-web.xml";
            this.asInstallRoot = this.env.getProperty("container_home").trim();
            this.configBaseDir = this.env.getProperty("console_conf").trim();
            this.consoleJavaHome = this.env.getProperty("java_home").trim();
            this.appBase = this.env.getProperty("console_appbase").trim();
            this.consoleBase = this.env.getProperty("console_base").trim();
            this.confDir = this.domainPath + File.separator + this.domainInst + File.separator + "config";
            this.defaultFile = "default.properties";
            this.configFile = "service.properties";
            this.consoleLogDir = this.env.getProperty("console_log").trim() + File.separator + this.domainInst;
            this.passwdFile = this.configBaseDir + File.separator + this.domainInst + File.separator + ".pswd";
        }
    }

    private void copyTemplate(String string, String string2) throws ConsoleConfigException {
        try {
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            TemplateRewriter templateRewriter = new TemplateRewriter();
            templateRewriter.copyTemplate(string, string2, (TemplateCallback)new TemplateCallbackImpl(this.env));
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("impl_err_02", string, string2, exception.getLocalizedMessage());
        }
    }

    private String getJMXHost() {
        return "127.0.0.1";
    }

    private String getAdminHost() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error getting host name, using \"localhost\"");
        }
        return string;
    }

    private int getAdminPort() {
        int n = -1;
        try {
            String string = this.env.getProperty("container_adminport");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "Error getting admin port: " + exception.getMessage());
        }
        return n;
    }

    private int getJMXPort() {
        int n = -1;
        try {
            String string = this.env.getProperty("container_jmxport");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "Error getting JMX port: " + exception.getMessage());
        }
        return n;
    }

    private String[] getAdminUserAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null, null};
        try {
            stringArray[0] = this.pswdmgr.getValue("admin_name");
            stringArray[1] = this.pswdmgr.getValue("admin_pswd");
            stringArray[2] = this.pswdmgr.getValue("keystore_pswd");
            if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) {
                throw new ConsoleConfigException("Admin password info not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting admin password: " + exception.getMessage());
        }
        return stringArray;
    }

    private String[] getKeyStoreAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            stringArray[0] = this.confDir + File.separator + "keystore.jks";
            stringArray[1] = this.pswdmgr.getValue("keystore_pswd");
            if (stringArray[1] == null) {
                throw new ConsoleConfigException("Keystore password not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting keystore password: " + exception.getMessage());
        }
        return stringArray;
    }

    private String[] getTrustStoreAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            stringArray[0] = this.confDir + File.separator + "wccerts.jks";
            stringArray[1] = this.pswdmgr.getValue("truststore_pswd");
            if (stringArray[1] == null) {
                throw new ConsoleConfigException("Truststore password not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting truststore password: " + exception.getMessage());
        }
        return stringArray;
    }

    private String getTempPasswordFile(String[] stringArray, int n) throws ConsoleConfigException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        switch (n) {
            case 1: {
                hashMap.put(AS_ADMIN_ADMINPASSWORD, stringArray[1]);
                hashMap.put(AS_ADMIN_MASTERPASSWORD, stringArray[2]);
                break;
            }
            case 0: {
                hashMap.put(AS_ADMIN_PASSWORD, stringArray[1]);
                hashMap.put(AS_ADMIN_MASTERPASSWORD, stringArray[2]);
                break;
            }
            case 2: {
                hashMap.put(AS_ADMIN_PASSWORD, stringArray[1]);
                hashMap.put(AS_ADMIN_USERPASSWORD, stringArray[2]);
                break;
            }
            default: {
                hashMap.put(AS_ADMIN_ADMINPASSWORD, stringArray[1]);
            }
        }
        String string = this.consoleBase + File.separator + "tmp";
        return this.pswdmgr.createTempPasswordFile(string, hashMap);
    }

    private void removeTempPasswordFile(String string) {
        this.pswdmgr.removeTempPasswordFile(string);
    }

    private boolean isTLSEnabled() {
        boolean bl = false;
        try {
            String string = this.env.getProperty("container_usetls").trim();
            Boolean bl2 = Boolean.valueOf(string);
            bl = bl2;
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "sjas_err_01" + exception.getMessage());
        }
        return bl;
    }

    private TLSParams createTLSParams(String string, String string2) {
        File file = new File(string);
        char[] cArray = string2.toCharArray();
        this.mHandshakeCompletedListener = new HandshakeCompletedListenerImpl();
        TrustStoreTrustManager trustStoreTrustManager = new TrustStoreTrustManager(file, cArray);
        trustStoreTrustManager.setPrompt(true);
        TLSParams tLSParams = new TLSParams((X509TrustManager)trustStoreTrustManager, (HandshakeCompletedListener)this.mHandshakeCompletedListener);
        return tLSParams;
    }

    private AppserverConnectionSource connectToDAS(String string, int n, String string2, String string3, TLSParams tLSParams) throws IOException {
        String string4 = "host=" + string + ", port=" + n + ", user=" + string2 + ", password=" + string3 + ", tls=" + (tLSParams != null);
        ConsoleConfigLog.trace("Connecting to DAS: " + string4);
        AppserverConnectionSource appserverConnectionSource = new AppserverConnectionSource("sun-as-rmi", string, n, string2, string3, tLSParams, null);
        appserverConnectionSource.getJMXConnector(false);
        ConsoleConfigLog.trace("Connected to DAS: " + string4);
        return appserverConnectionSource;
    }

    private String getStageStatusString(int n) {
        String string = "UNKNOWN/UNDEFINED STATUS=" + n;
        switch (n) {
            case 2: {
                string = "STATUS_CODE_SUCCESS";
                break;
            }
            case 0: {
                string = "STATUS_CODE_FAILURE";
                break;
            }
            case 1: {
                string = "STATUS_CODE_WARNING";
            }
        }
        return string;
    }

    private void stopWebModule(String string) throws ConsoleConfigException {
        J2EEDomain j2EEDomain = this.mDomainRoot.getJ2EEDomain();
        Map map = j2EEDomain.getServerMap();
        J2EEServer j2EEServer = (J2EEServer)map.get(this.serverConfig.getName());
        if (j2EEServer == null) {
            throw new ConsoleConfigException("J2EE server not found");
        }
        j2EEServer.stopApp(string, null);
    }

    private void startWebModule(String string) throws ConsoleConfigException {
        J2EEDomain j2EEDomain = this.mDomainRoot.getJ2EEDomain();
        Map map = j2EEDomain.getServerMap();
        J2EEServer j2EEServer = (J2EEServer)map.get(this.serverConfig.getName());
        if (j2EEServer == null) {
            throw new ConsoleConfigException("J2EE server not found");
        }
        j2EEServer.startApp(string, null);
    }

    private void enableAndStartWebApps() throws ConsoleConfigException {
        ConsoleConfigLog.trace("Enable and Start web modules...");
        String string = null;
        try {
            Map map = this.domainConfig.getWebModuleConfigMap();
            if (map != null) {
                Object[] objectArray = map.values().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl = new ConsoleConfigWebModuleImpl();
                    WebModuleConfig webModuleConfig = (WebModuleConfig)objectArray[i];
                    String string2 = webModuleConfig.getObjectType();
                    string = webModuleConfig.getName();
                    if (string2.equalsIgnoreCase("system-admin")) continue;
                    if (!webModuleConfig.getEnabled()) {
                        webModuleConfig.setEnabled(true);
                    }
                    this.startWebModule(string);
                }
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("problem enabling webmodule: " + string, exception);
        }
    }

    private void disableAndStopWebApps() throws ConsoleConfigException {
        ConsoleConfigLog.trace("Disable and Stop web modules...");
        String string = null;
        try {
            Map map = this.domainConfig.getWebModuleConfigMap();
            if (map != null) {
                Object[] objectArray = map.values().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl = new ConsoleConfigWebModuleImpl();
                    WebModuleConfig webModuleConfig = (WebModuleConfig)objectArray[i];
                    String string2 = webModuleConfig.getObjectType();
                    string = webModuleConfig.getName();
                    if (string2.equalsIgnoreCase("system-admin")) continue;
                    if (webModuleConfig.getEnabled()) {
                        webModuleConfig.setEnabled(false);
                    }
                    this.stopWebModule(string);
                }
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("problem disabling webmodule: " + string, exception);
        }
    }

    private boolean resetContainerAddress() throws ConsoleConfigException {
        Iterator iterator;
        Object object;
        Object object2;
        String string = this.env.getProperty("container_address");
        if (string == null || string.length() == 0) {
            string = "0.0.0.0";
        }
        Map map = null;
        try {
            object2 = this.configConfig.getHTTPServiceConfig();
            map = object2.getHTTPListenerConfigMap();
            object = (HTTPListenerConfig)map.get("http-listener-1");
            iterator = object.getAddress();
            if (iterator != null && string.equals(iterator)) {
                return false;
            }
        }
        catch (Exception exception) {
            String string2 = "Unexpected error retrieving listener address: " + exception.getMessage();
            ConsoleConfigLog.log(1, string2);
            throw new ConsoleConfigException(string2);
        }
        ConsoleConfigLog.log(3, "Resetting listener addresses to " + string);
        object2 = "";
        try {
            IIOPServiceConfig iIOPServiceConfig;
            object = map.keySet();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                iIOPServiceConfig = (HTTPListenerConfig)map.get(object2);
                iIOPServiceConfig.setAddress(string);
                ConsoleConfigLog.trace("Reset HTTP address for " + (String)object2);
            }
            iIOPServiceConfig = this.configConfig.getIIOPServiceConfig();
            Map map2 = iIOPServiceConfig.getIIOPListenerConfigMap();
            object = map2.keySet();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                IIOPListenerConfig iIOPListenerConfig = (IIOPListenerConfig)map2.get(object2);
                iIOPListenerConfig.setAddress(string);
                ConsoleConfigLog.trace("Reset IIOP address for " + (String)object2);
            }
        }
        catch (Exception exception) {
            iterator = "Unexpected error resetting listener " + (String)object2 + " address: " + exception.getMessage();
            ConsoleConfigLog.log(1, (String)((Object)iterator));
            throw new ConsoleConfigException((String)((Object)iterator));
        }
        return true;
    }

    private void setHttpListenerState(boolean bl) throws ConsoleConfigException {
        String string = bl ? "enabling" : "disabling";
        String string2 = "";
        try {
            ConsoleConfigLog.trace(string + " HTTP listeners");
            HTTPServiceConfig hTTPServiceConfig = this.configConfig.getHTTPServiceConfig();
            Map map = hTTPServiceConfig.getHTTPListenerConfigMap();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                HTTPListenerConfig hTTPListenerConfig = (HTTPListenerConfig)map.get(string2);
                hTTPListenerConfig.setEnabled(bl);
            }
        }
        catch (Exception exception) {
            String string3 = "Unexpected error " + string + " listener " + string2 + ": " + exception.getMessage();
            ConsoleConfigLog.log(1, string3);
            throw new ConsoleConfigException(string3);
        }
    }

    private int startContainer() throws ConsoleConfigException {
        String[] stringArray = this.getAdminUserAndPswd();
        String string = this.getTempPasswordFile(stringArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asInstallRoot + File.separator + "bin" + File.separator + this.asadminCmd).append(" start-domain").append(" --domaindir ").append(this.domainPath).append(" --user ").append(stringArray[0]).append(" --passwordfile ").append(string).append(" ").append(this.domainInst);
        ConsoleConfigLog.trace("Starting container with command: " + stringBuffer.toString());
        int n = ConsoleConfigUtil.execCommand(stringBuffer.toString());
        this.removeTempPasswordFile(string);
        return n;
    }

    private String addToPropertyValue(String string, String string2) {
        int n;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        String[] stringArray = string.split("=");
        if (stringArray.length > 1 && (string4 = stringArray[1].trim()).length() > 0) {
            string5 = ",";
        }
        if ((n = string4.indexOf(string2)) < 0) {
            string3 = stringArray[0] + "=" + string4 + string5 + string2;
        }
        return string3;
    }

    private String stripQuotes(String string) {
        String string2 = string;
        if (string2 != null && string2.startsWith("\"") && (string2 = string2.substring(1)).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private String getWinPropName(String string) {
        String string2;
        String string3 = null;
        if (string != null && string.length() >= 5 && (string2 = string.substring(0, 4)).equalsIgnoreCase("set ")) {
            string3 = string.substring(4, string.length());
            string3 = string3.trim();
        }
        return string3;
    }
}

