/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.tomcat;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.config.ConsoleConfigConstants;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigHttpListener;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigLoginModule;
import com.sun.web.console.config.ConsoleConfigModule51;
import com.sun.web.console.config.ConsoleConfigPasswordManager;
import com.sun.web.console.config.ConsoleConfigService;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.ConsoleConfigVirtualServer;
import com.sun.web.console.config.ConsoleConfigWebModule;
import com.sun.web.console.config.common.ConsoleConfigWebModuleImpl;
import com.sun.web.console.config.tomcat.ConsoleConfigTomcatManager;
import com.sun.web.console.config.tomcat.ConsoleConfigTomcatUtil;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConsoleConfigServiceImpl
implements ConsoleConfigService {
    private static final String JARPATH_FILENAME = "catalina.properties";
    private static final String JARPATH_PROPNAME = "shared.loader";
    private static final String JARPATH_HEADER = " Tomcat class loader properties";
    private static final String NOT_ADMIN = "Must be in admin mode to perform function";
    private static final String FS = File.separator;
    private Properties env = null;
    private String domainPath = null;
    private String domainInst = null;
    private String workDir = null;
    private String baseDir = null;
    private String confDir = null;
    private String localHostDir = null;
    private String httpPort = null;
    private String securePort = null;
    private String templateFileName = null;
    private String defaultWebXml = null;
    private String passwdFile = null;
    private String configBaseDir = null;
    private String consoleLogDir = null;
    private String consoleHome = null;
    private String consoleJavaHome = null;
    private String appBase = null;
    private String consoleBase = null;
    private String defaultFile = null;
    private String configFile = null;
    private String domainInstDir = null;
    private boolean containerCreated = false;
    private boolean containerStarted = false;
    private boolean isConnected = false;
    private boolean adminMode = false;
    ConsoleConfigTomcatUtil util = null;
    ConsoleConfigTomcatManager manager = null;
    ConsoleConfigPasswordManager pswdmgr = null;
    private final String BAT_EXT = ".bat";

    public void initialize() throws ConsoleConfigException {
        try {
            this.pswdmgr = new ConsoleConfigPasswordManager(this.passwdFile);
            this.pswdmgr.load();
            this.util = new ConsoleConfigTomcatUtil(this.env);
            String[] stringArray = this.getAdminUserAndPswd();
            String[] stringArray2 = this.getTrustStoreAndPswd();
            this.manager = new ConsoleConfigTomcatManager(this.env, stringArray[0], stringArray[1], stringArray2[0], stringArray2[1]);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Unexpected error from init: " + exception.getMessage());
        }
    }

    public int createConsoleContainer() throws ConsoleConfigException {
        String string;
        if (this.containerCreated) {
            throw new ConsoleConfigException("Already created...");
        }
        if (!ConsoleConfigUtil.createDir(this.workDir)) {
            throw new ConsoleConfigException("cannot create " + this.workDir);
        }
        if (!ConsoleConfigUtil.createDir(this.baseDir)) {
            throw new ConsoleConfigException("cannot create" + this.baseDir);
        }
        if (!ConsoleConfigUtil.createDir(this.confDir)) {
            throw new ConsoleConfigException("cannot create" + this.confDir);
        }
        if (!ConsoleConfigUtil.createDir(this.localHostDir)) {
            throw new ConsoleConfigException("cannot create" + this.localHostDir);
        }
        String string2 = this.consoleHome + FS + ConsoleConfigConstants.TOMCAT_TEMPLATE_SUBDIR;
        try {
            this.util.copyTemplate("console_xml.tpl", "console.xml");
            this.util.copyTemplate("default-web.xml", "web.xml");
            this.util.copyTemplate("console_policy.tpl", "console.policy");
            this.util.copyTemplate("consolelogin_conf.tpl", "consolelogin.conf");
            this.util.copyTemplate("wcstart.tpl", "wcstart");
            this.util.copyTemplate("wcstop.tpl", "wcstop");
            ConsoleConfigUtil.copyProperties(string2 + FS + "catalina_props.tpl", this.confDir + FS + JARPATH_FILENAME, null, null, this.env);
            string = System.getProperty("user.name");
            this.util.configureServerXml(string);
            this.util.copyTemplate("start_tomcat.tpl", "start_tomcat");
            this.util.copyTemplate("stop_tomcat.tpl", "stop_tomcat");
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error creating domain config: ", exception);
        }
        ConsoleConfigUtil.copySystemRegnots(this.env, string2);
        string = this.confDir + FS + "wcstart";
        CCServiceLibrary.makeFileExecutable((String)string);
        string = this.confDir + FS + "wcstop";
        CCServiceLibrary.makeFileExecutable((String)string);
        String[] stringArray = this.getAdminUserAndPswd();
        this.resetAdminPassword(stringArray[0], null, stringArray[1]);
        this.setupManagerWebApp();
        this.deployConsoleApps();
        this.containerCreated = true;
        this.adminMode = false;
        return 0;
    }

    public int deleteConsoleContainer() throws ConsoleConfigException {
        ConsoleConfigUtil.deleteFile(new File(this.domainInstDir));
        ConsoleConfigUtil.deleteFile(new File(this.consoleLogDir));
        this.containerCreated = false;
        this.adminMode = false;
        return 0;
    }

    public boolean initialContainerConfig() {
        return false;
    }

    public int startServer(String string) throws ConsoleConfigException {
        int n = -1;
        if (string.equals("admin")) {
            this.adminMode = true;
            n = 0;
        }
        if (string.equals("user")) {
            Object object;
            String string2 = this.env.getProperty("console_user");
            String string3 = this.env.getProperty("console_group");
            String string4 = this.env.getProperty("container_commons_log");
            if (string4 == null || string4.length() == 0) {
                string4 = "org.apache.commons.logging.impl.NoOpLog";
                this.env.setProperty("container_commons_log", string4);
            }
            this.util.configureServerXml(string2);
            this.util.copyTemplate("start_tomcat.tpl", "start_tomcat");
            this.util.copyTemplate("stop_tomcat.tpl", "stop_tomcat");
            if (this.resetAdminPasswordOwner(string2) != 0) {
                object = this.getAdminUserAndPswd();
                this.resetAdminPassword(object[0], null, (String)object[1]);
            }
            object = System.getProperty("os.name", "");
            String string5 = "wcstart";
            if (object != null && ((String)object).toLowerCase().indexOf("windows") != -1) {
                string5 = string5 + ".bat";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.confDir + FS + string5);
            if (string2 != null) {
                stringBuffer.append(" " + string2);
            }
            if (string3 != null) {
                stringBuffer.append(" " + string3);
            }
            this.containerStarted = (n = ConsoleConfigUtil.execCommand(stringBuffer.toString())) == 0;
            this.adminMode = false;
        }
        return n;
    }

    public int stopServer(boolean bl) throws ConsoleConfigException {
        int n;
        String string = this.env.getProperty("console_user");
        String string2 = System.getProperty("os.name", "");
        String string3 = "wcstop";
        if (string2 != null && string2.toLowerCase().indexOf("windows") != -1) {
            string3 = string3 + ".bat";
        }
        this.resetSharedJars();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.confDir + FS + string3);
        if (bl) {
            stringBuffer.append(" --kill");
        }
        if (string != null) {
            stringBuffer.append(" " + string);
        }
        this.containerStarted = (n = ConsoleConfigUtil.execCommand(stringBuffer.toString())) != 0;
        this.adminMode = false;
        return n;
    }

    public int restartServer(String string) throws ConsoleConfigException {
        if (string.equals("admin")) {
            this.adminMode = true;
            return 0;
        }
        int n = 0;
        if (this.containerStarted) {
            n = this.stopServer(false);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                throw new ConsoleConfigException("Thread has been interrupted");
            }
        }
        return this.startServer(string);
    }

    public int statServer() throws ConsoleConfigException {
        int n = 0;
        int n2 = ConsoleConfigUtil.pingConsole(this.env);
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    public int createCertificate() throws ConsoleConfigException {
        String string;
        String[] stringArray = this.getKeyStoreAndPswd();
        String string2 = this.consoleJavaHome + FS + "bin" + FS + "keytool";
        int n = ConsoleConfigUtil.createJKSCertificate(string2, string = "webconsole", stringArray[0], "RSA", stringArray[1]);
        if (n == 0) {
            String[] stringArray2 = this.getTrustStoreAndPswd();
            String string3 = this.confDir + FS + string + ".cer";
            File file = new File(string3);
            if (file.exists()) {
                file.delete();
            }
            if ((n = ConsoleConfigUtil.exportJKSCertificate(string2, string, string3, stringArray[0], stringArray[1])) == 0) {
                n = ConsoleConfigUtil.importJKSCertificate(string2, string, string3, stringArray2[0], stringArray2[1]);
            }
            if (file.exists()) {
                file.delete();
            }
        }
        return n;
    }

    public void connectAdmin() throws ConsoleConfigException {
        this.adminMode = true;
    }

    public void disConnectAdmin() throws ConsoleConfigException {
        this.adminMode = false;
    }

    public ConsoleConfigWebModule[] listWebModules() throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        ConsoleConfigWebModule[] consoleConfigWebModuleArray = null;
        consoleConfigWebModuleArray = this.util.listContextXml();
        if (consoleConfigWebModuleArray == null || consoleConfigWebModuleArray.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            int n = this.manager.list(arrayList);
            if (n != 0) {
                if (n != 2) {
                    ConsoleConfigLog.log(1, "Error from manager list: " + this.manager.getMessage());
                }
                return consoleConfigWebModuleArray;
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "Error from manager list: " + exception.getMessage());
            return consoleConfigWebModuleArray;
        }
        if (arrayList != null && arrayList.size() > 0) {
            Object object;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object = string.split(":");
                if (((String[])object).length <= 1 || !((String)object[1]).equals("running")) continue;
                arrayList2.add(object[0]);
            }
            for (int i = 0; i < consoleConfigWebModuleArray.length; ++i) {
                object = consoleConfigWebModuleArray[i];
                String string = object.getContextPathName();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                if (!arrayList2.contains(string)) continue;
                object.setEnabled(true);
            }
        }
        return consoleConfigWebModuleArray;
    }

    public void deployWebModule(ConsoleConfigWebModule consoleConfigWebModule) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        String string = consoleConfigWebModule.getContextPathName();
        if (this.util.existContextXml(string)) {
            throw new ConsoleConfigException("Web application " + string + " is already deployed");
        }
        consoleConfigWebModule.setTimestamp(System.currentTimeMillis());
        this.util.configureContextXml(consoleConfigWebModule);
        try {
            int n = this.manager.deploy(string);
            if (n != 0 && n != 2) {
                ConsoleConfigLog.log(1, "Error from manager deploy: " + this.manager.getMessage());
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "Error from manager deploy: " + exception.getMessage());
        }
    }

    public void undeployWebModule(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        ConsoleConfigWebModule consoleConfigWebModule = this.util.readContextXml(string);
        try {
            int n = this.manager.undeploy(string);
            if (n != 0 && n != 2 && n != 1) {
                ConsoleConfigLog.log(1, "Error from manager undeploy: " + this.manager.getMessage());
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "Error from manager undeploy: " + exception.getMessage());
        }
        if (consoleConfigWebModule != null) {
            this.util.removeWebappCache(string);
            this.util.removeContextXml(string);
        }
    }

    public void enableWebModule(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        if (!this.util.existContextXml(string)) {
            throw new ConsoleConfigException("Web application not deployed");
        }
        try {
            int n = this.manager.enable(string);
            if (n == 0) {
                return;
            }
            if (n == 2) {
                throw new ConsoleConfigException("Server is not running");
            }
            throw new ConsoleConfigException("Error from manager enable: " + this.manager.getMessage());
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error from manager enable: " + exception.getMessage());
        }
    }

    public void disableWebModule(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        if (!this.util.existContextXml(string)) {
            throw new ConsoleConfigException("Web application not deployed");
        }
        try {
            int n = this.manager.disable(string);
            if (n == 0) {
                return;
            }
            if (n == 2) {
                throw new ConsoleConfigException("Server is not running");
            }
            throw new ConsoleConfigException("Error from manager disable: " + this.manager.getMessage());
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error from manager disable: " + exception.getMessage());
        }
    }

    public void reloadWebModule(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        if (!this.util.existContextXml(string)) {
            throw new ConsoleConfigException("Web application not deployed");
        }
        ConsoleConfigWebModule consoleConfigWebModule = this.util.readContextXml(string);
        consoleConfigWebModule.setTimestamp(System.currentTimeMillis());
        this.util.configureContextXml(consoleConfigWebModule);
        try {
            int n = this.manager.reload(string);
            if (n != 0 && n != 2) {
                throw new ConsoleConfigException("Error from manager disable: " + this.manager.getMessage());
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error from manager reload: " + exception.getMessage());
        }
    }

    public ConsoleConfigHttpListener getHttpListener(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        if (string == null) {
            throw new ConsoleConfigException("listener name cannot be null");
        }
        return null;
    }

    public void setHttpListener(ConsoleConfigHttpListener consoleConfigHttpListener) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
    }

    public ConsoleConfigVirtualServer getVirtualServer(String string) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
        if (string == null) {
            throw new ConsoleConfigException("virtual server name cannot be null");
        }
        return null;
    }

    public void setVirtualServer(ConsoleConfigVirtualServer consoleConfigVirtualServer) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
    }

    public String[] getNativeLibraryPaths() throws ConsoleConfigException {
        String[] stringArray = new String[]{this.env.getProperty("console_native")};
        return stringArray;
    }

    public boolean setNativeLibraryPaths(String[] stringArray) throws ConsoleConfigException {
        return false;
    }

    public String[] getJvmOptions() throws ConsoleConfigException {
        String[] stringArray = null;
        String string = this.confDir + FS + "jvmoptions";
        try {
            File file = new File(string);
            if (file.exists()) {
                stringArray = ConsoleConfigUtil.readFile(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public boolean setJvmOptions(String[] stringArray) throws ConsoleConfigException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String string = this.confDir + FS + "jvmoptions";
        ConsoleConfigUtil.writeFile(string, stringArray);
        return false;
    }

    public void setJvmOptions(Map map) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException("cannot perform admin function in user mode");
        }
    }

    public ConsoleConfigLoginModule[] listLoginModules(String string) throws ConsoleConfigException {
        throw new ConsoleConfigException("Not yet implemented!");
    }

    public void createLoginServiceDefinition(String string, ConsoleConfigLoginModule[] consoleConfigLoginModuleArray) throws ConsoleConfigException {
        if (consoleConfigLoginModuleArray == null || consoleConfigLoginModuleArray.length == 0) {
            throw new ConsoleConfigException("null or empty loginmodule list");
        }
        ConsoleConfigUtil.addLoginServiceDefinition(string, consoleConfigLoginModuleArray, this.confDir, "consolelogin.conf");
    }

    public String[] listSharedJars() throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException(NOT_ADMIN);
        }
        String[] stringArray = new String[]{};
        String string = this.confDir + FS + JARPATH_FILENAME;
        Properties properties = ConsoleConfigUtil.loadProperties(string);
        ArrayList arrayList = this.getSharedJars(properties);
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private ArrayList getSharedJars(Properties properties) {
        String string = properties.getProperty(JARPATH_PROPNAME);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public void addSharedJars(String[] stringArray) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException(NOT_ADMIN);
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = this.confDir + FS + JARPATH_FILENAME;
        Properties properties = ConsoleConfigUtil.loadProperties(string);
        ArrayList arrayList = this.getSharedJars(properties);
        int n = arrayList.size();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (n != arrayList.size()) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            this.putSharedJars(properties, stringArray2);
            ConsoleConfigUtil.storeProperties(string, properties, JARPATH_HEADER);
        }
    }

    public void setSharedJars(String[] stringArray) throws ConsoleConfigException {
        if (!this.adminMode) {
            throw new ConsoleConfigException(NOT_ADMIN);
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = this.confDir + FS + JARPATH_FILENAME;
        Properties properties = ConsoleConfigUtil.loadProperties(string);
        this.putSharedJars(properties, stringArray);
        ConsoleConfigUtil.storeProperties(string, properties, JARPATH_HEADER);
    }

    private void putSharedJars(Properties properties, String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                string = string + ",";
            }
            string = string + string2;
        }
        properties.setProperty(JARPATH_PROPNAME, string);
    }

    private void resetSharedJars() throws ConsoleConfigException {
        String[] stringArray;
        String string = this.confDir + FS + JARPATH_FILENAME;
        Properties properties = ConsoleConfigUtil.loadProperties(string);
        ArrayList arrayList = this.getSharedJars(properties);
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>(arrayList.size());
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (this.checkJarExists((String)stringArray)) {
                arrayList2.add(stringArray);
                continue;
            }
            ConsoleConfigLog.log(2, "tomcat_err_19", (String)stringArray);
            bl = true;
        }
        if (bl) {
            stringArray = new String[arrayList2.size()];
            arrayList2.toArray(stringArray);
            this.putSharedJars(properties, stringArray);
            ConsoleConfigUtil.storeProperties(string, properties, JARPATH_HEADER);
        }
    }

    private int resetAdminPasswordOwner(String string) {
        int n = -1;
        String string2 = this.confDir + FS + ".apswd";
        File file = new File(string2);
        if (file.exists()) {
            CCServiceLibrary.makeFilePrivate((String)string2, (String)string, (boolean)false);
            n = 0;
        }
        return n;
    }

    public void resetAdminPassword(String string, String string2, String string3) throws ConsoleConfigException {
        Object object;
        if (string == null || string3 == null) {
            throw new IllegalArgumentException("Null argument");
        }
        String string4 = this.confDir + FS + ".apswd";
        String string5 = this.env.getProperty("console_user");
        try {
            object = new File(string4);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tomcat_err_09", string4, exception.getLocalizedMessage());
        }
        try {
            object = new ConsoleConfigModule51();
            String string6 = ((ConsoleConfigModule51)object).get51Seed();
            String string7 = ((ConsoleConfigModule51)object).get51Format(string6, string3);
            String string8 = string + ":" + string7;
            String[] stringArray = new String[]{string8};
            ConsoleConfigUtil.writeFile(string4, stringArray);
            CCServiceLibrary.makeFilePrivate((String)string4, (String)string5, (boolean)false);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tomcat_err_18", exception.getLocalizedMessage());
        }
    }

    public void resetKeystorePassword(String string, String string2) throws ConsoleConfigException {
        String string3 = this.confDir + FS + "keystore.jks";
        ConsoleConfigPasswordManager.resetStorePassword(string3, string, string2);
    }

    public void resetTruststorePassword(String string, String string2) throws ConsoleConfigException {
        String string3 = this.confDir + FS + "wccerts.jks";
        ConsoleConfigPasswordManager.resetStorePassword(string3, string, string2);
    }

    public void setEnv(Properties properties) {
        if (properties != null) {
            this.env = properties;
            this.consoleHome = this.env.getProperty("console_home").trim();
            this.consoleBase = this.env.getProperty("console_base").trim();
            this.configBaseDir = this.env.getProperty("console_conf").trim();
            this.consoleJavaHome = this.env.getProperty("java_home").trim();
            this.appBase = this.env.getProperty("console_appbase").trim();
            this.domainPath = this.env.getProperty("console_dombase").trim();
            this.domainInst = this.env.getProperty("console_instance").trim();
            this.domainInstDir = this.domainPath + FS + this.domainInst;
            this.consoleLogDir = this.env.getProperty("console_log").trim() + FS + this.domainInst;
            this.workDir = this.domainInstDir + FS + "work";
            this.baseDir = this.domainInstDir + FS + "webapps";
            this.confDir = this.domainInstDir + FS + "conf";
            this.localHostDir = this.confDir + FS + "com_sun_web_console" + File.separator + "localhost";
            this.httpPort = this.env.getProperty("console_httpport").trim();
            this.securePort = this.env.getProperty("console_httpsport").trim();
            this.defaultFile = "default.properties";
            this.configFile = "service.properties";
            this.passwdFile = this.configBaseDir + FS + this.domainInst + FS + ".pswd";
        }
    }

    private String getAdminHost() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            System.out.println("Could not get local host name");
        }
        return string;
    }

    private int getAdminPort() {
        int n = -1;
        try {
            String string = this.env.getProperty("container_adminport");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Error getting admin port: " + exception.getMessage());
        }
        return n;
    }

    private int getJMXPort() {
        int n = -1;
        try {
            String string = this.env.getProperty("container_jmxport");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Error getting admin port: " + exception.getMessage());
        }
        return n;
    }

    private String[] getAdminUserAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            stringArray[0] = this.pswdmgr.getValue("admin_name");
            stringArray[1] = this.pswdmgr.getValue("admin_pswd");
            if (stringArray[0] == null || stringArray[1] == null) {
                throw new ConsoleConfigException("Admin password info not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting admin password: " + exception.getMessage());
        }
        return stringArray;
    }

    private String[] getKeyStoreAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            stringArray[0] = this.confDir + FS + "keystore.jks";
            stringArray[1] = this.pswdmgr.getValue("keystore_pswd");
            if (stringArray[1] == null) {
                throw new ConsoleConfigException("Keystore password not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting keystore password: " + exception.getMessage());
        }
        return stringArray;
    }

    private String[] getTrustStoreAndPswd() throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            stringArray[0] = this.confDir + FS + "wccerts.jks";
            stringArray[1] = this.pswdmgr.getValue("truststore_pswd");
            if (stringArray[1] == null) {
                throw new ConsoleConfigException("Truststore password not set");
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error getting truststore password: " + exception.getMessage());
        }
        return stringArray;
    }

    private void setupManagerWebApp() throws ConsoleConfigException {
        String string = "manager_xml.tpl";
        String string2 = "com_sun_web_console" + FS + "localhost" + FS + "manager.xml";
        this.util.copyTemplate(string, string2);
    }

    private void deployConsoleApps() throws ConsoleConfigException {
        String string = this.consoleHome + FS + "webapps" + FS + "console";
        String string2 = this.consoleHome + FS + "webapps" + FS + "com_sun_web_ui";
        ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl = new ConsoleConfigWebModuleImpl();
        consoleConfigWebModuleImpl.setContextPathName("/console");
        consoleConfigWebModuleImpl.setAppName("console");
        consoleConfigWebModuleImpl.setLocation(string);
        consoleConfigWebModuleImpl.setSystem(true);
        consoleConfigWebModuleImpl.setDebugLevel(0);
        this.util.configureContextXml(consoleConfigWebModuleImpl);
        consoleConfigWebModuleImpl.setContextPathName("");
        this.util.configureContextXml(consoleConfigWebModuleImpl);
        ConsoleConfigWebModuleImpl consoleConfigWebModuleImpl2 = new ConsoleConfigWebModuleImpl();
        consoleConfigWebModuleImpl2.setContextPathName("/com_sun_web_ui");
        consoleConfigWebModuleImpl2.setAppName("console");
        consoleConfigWebModuleImpl2.setLocation(string2);
        consoleConfigWebModuleImpl2.setSystem(true);
        consoleConfigWebModuleImpl2.setDebugLevel(0);
        this.util.configureContextXml(consoleConfigWebModuleImpl2);
    }

    private boolean checkJarExists(String string) {
        String string2 = string;
        if (string2.endsWith("*.jar")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        if (string2.endsWith(FS) && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        File file = new File(string2);
        return file.exists();
    }
}

