/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.tomcat;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigWebModule;
import com.sun.web.console.config.common.ConsoleConfigWebModuleImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextXmlParser
extends DefaultHandler {
    private static final String ELEMENT_CONTEXT = "Context";
    private static final String ELEMENT_PARAMETER = "Parameter";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_DOCBASE = "docBase";
    private static final String ATTR_DEBUG = "debug";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String NAME_APPNAME = "name";
    private static final String NAME_SYSTEM = "system";
    private static final String NAME_TIMESTAMP = "timestamp";
    private String filename;
    private String pathname;
    private String docbase;
    private String debug;
    private HashMap param_map;
    private String systemId;
    private static String EOL = System.getProperty("line.separator");
    private boolean inContext = false;
    private boolean inParam = false;

    public ConsoleConfigWebModule parse(String string) throws ConsoleConfigException {
        Object object;
        this.filename = string;
        this.pathname = null;
        this.docbase = null;
        this.debug = null;
        this.param_map = new HashMap(10);
        File file = new File(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            object = sAXParserFactory.newSAXParser();
            ((SAXParser)object).parse(file, (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            String string2 = new Integer(sAXParseException.getLineNumber()).toString();
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
            throw new ConsoleConfigException("tomcat_err_03", this.filename, string2, exception.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new ConsoleConfigException("tomcat_err_04", this.filename, exception.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConsoleConfigException("tomcat_err_05", this.filename, parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new ConsoleConfigException("tomcat_err_04", this.filename, iOException.getLocalizedMessage());
        }
        if (this.pathname == null) {
            throw new ConsoleConfigException("tomcat_err_06", this.filename);
        }
        if (this.pathname.length() == 0) {
            this.pathname = "ROOT";
        }
        if (this.docbase == null || this.docbase.length() == 0) {
            throw new ConsoleConfigException("tomcat_err_07", this.filename);
        }
        object = new ConsoleConfigWebModuleImpl();
        object.setContextPathName(this.pathname);
        object.setLocation(this.docbase);
        int n = 0;
        if (this.debug != null) {
            try {
                n = new Integer(this.debug);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object.setDebugLevel(n);
        object.setAppName((String)this.param_map.get("name"));
        boolean bl = false;
        String string3 = (String)this.param_map.get(NAME_SYSTEM);
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        object.setSystem(bl);
        long l = 0L;
        string3 = (String)this.param_map.get(NAME_TIMESTAMP);
        if (string3 != null && string3.length() > 0) {
            try {
                l = new Long(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object.setTimestamp(l);
        return object;
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.systemId = locator.getSystemId();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string2.length() == 0) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase(ELEMENT_CONTEXT)) {
            this.inContext = true;
            this.inParam = false;
            this.pathname = this.getAttributeValue(ATTR_PATH, attributes);
            this.docbase = this.getAttributeValue(ATTR_DOCBASE, attributes);
            this.debug = this.getAttributeValue(ATTR_DEBUG, attributes);
        }
        if (string4.equalsIgnoreCase(ELEMENT_PARAMETER) && this.inContext) {
            this.inParam = true;
            String string5 = this.getAttributeValue("name", attributes);
            String string6 = this.getAttributeValue(ATTR_VALUE, attributes);
            if (string5 != null && string5.length() > 0) {
                this.param_map.put(string5, string6);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4.length() == 0) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase(ELEMENT_CONTEXT)) {
            this.inContext = false;
            this.inParam = false;
        }
        if (string4.equalsIgnoreCase(ELEMENT_PARAMETER)) {
            this.inParam = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        String string = new Integer(sAXParseException.getLineNumber()).toString();
    }

    private String getAttributeValue(String string, Attributes attributes) {
        String string2 = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getLocalName(i);
                if (string3.length() == 0) {
                    string3 = attributes.getQName(i);
                }
                if (!string3.equalsIgnoreCase(string)) continue;
                string2 = attributes.getValue(i);
                break;
            }
        }
        return string2;
    }

    private int getVersionNumber(String string) {
        int n = 0;
        try {
            String[] stringArray = string.trim().split("[^0123456789.]");
            string = "0" + stringArray[0];
        }
        catch (Exception exception) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n4 = stringTokenizer.countTokens();
            if (n4 > 0) {
                string2 = stringTokenizer.nextToken();
                n2 = new Integer(string2);
            }
            if (n4 > 1) {
                string2 = stringTokenizer.nextToken();
                n3 = new Integer(string2);
            }
            n = n2 * 100 + n3;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }
}

