/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.util.prodname;

import com.sun.webui.util.prodname.GenerateProductImage;
import com.sun.webui.util.prodname.ProductImageException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class ProductImageDriver {
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String VERSION = "version";
    public static final String LOGIN = "login";
    public static final String ALL = "all";
    private static final String FS = File.separator;
    private static final String PRIMARY_FILENAME = "PrimaryProductName.png";
    private static final String SECONDARY_FILENAME = "SecondaryProductName.png";
    private static final String VERSION_FILENAME = "VersionProductName.png";
    private static final String LOGIN_FILENAME = "LoginProductName.png";
    private static final String PROPERTY_FILENAME = "ProductName.properties";
    private static final String PROP_HEADER = "Product name image properties";
    private static final String PROP_PRIMARY = "primary.";
    private static final String PROP_SECONDARY = "secondary.";
    private static final String PROP_VERSION = "version.";
    private static final String PROP_LOGIN = "login.";
    private static final String PROP_URI = "uri";
    private static final String PROP_HEIGHT = "height";
    private static final String PROP_WIDTH = "width";
    private static final String KEY_PROPERTY_FILENAME = "propertyFile";
    private static final String KEY_PRIMARY_FILENAME = "primaryFilename";
    private static final String KEY_PRIMARY_FONTSIZE = "primaryFontSize";
    private static final String KEY_PRIMARY_FONTTYPE = "primaryFontType";
    private static final String KEY_PRIMARY_HEIGHT = "primaryHeight";
    private static final String KEY_PRIMARY_FORECOLOR = "primaryForeColor";
    private static final String KEY_PRIMARY_BACKCOLOR = "primaryBackColor";
    private static final String KEY_PRIMARY_SECOND_FONTSIZE = "primarySecondPartFontSize";
    private static final String KEY_PRIMARY_SECOND_FONTTYPE = "primarySecondPartFontType";
    private static final String KEY_PRIMARY_SPLITSIZE = "primarySplitSize";
    private static final String KEY_SECONDARY_FILENAME = "secondaryFilename";
    private static final String KEY_SECONDARY_FONTSIZE = "secondaryFontSize";
    private static final String KEY_SECONDARY_FONTTYPE = "secondaryFontType";
    private static final String KEY_SECONDARY_HEIGHT = "secondaryHeight";
    private static final String KEY_SECONDARY_FORECOLOR = "secondaryForeColor";
    private static final String KEY_SECONDARY_BACKCOLOR = "secondaryBackColor";
    private static final String KEY_SECONDARY_SECOND_FONTSIZE = "secondarySecondPartFontSize";
    private static final String KEY_SECONDARY_SECOND_FONTTYPE = "secondarySecondPartFontType";
    private static final String KEY_SECONDARY_SPLITSIZE = "secondarySplitSize";
    private static final String KEY_VERSION_FILENAME = "versionFilename";
    private static final String KEY_VERSION_FONTSIZE = "versionFontSize";
    private static final String KEY_VERSION_FONTTYPE = "versionFontType";
    private static final String KEY_VERSION_HEIGHT = "versionHeight";
    private static final String KEY_VERSION_FORECOLOR = "versionForeColor";
    private static final String KEY_VERSION_BACKCOLOR = "versionBackColor";
    private static final String KEY_VERSION_SECOND_FONTSIZE = "versionSecondFontSize";
    private static final String KEY_VERSION_SECOND_FONTTYPE = "versionSecondPartFontType";
    private static final String KEY_LOGIN_FILENAME = "loginFilename";
    private static final String KEY_LOGIN_FONTSIZE = "loginFontSize";
    private static final String KEY_LOGIN_FONTTYPE = "loginFontType";
    private static final String KEY_LOGIN_HEIGHT = "loginHeight";
    private static final String KEY_LOGIN_FORECOLOR = "loginForeColor";
    private static final String KEY_LOGIN_BACKCOLOR = "loginBackColor";
    private static final String KEY_LOGIN_SECOND_FONTSIZE = "loginSecondFontSize";
    private static final String KEY_LOGIN_SECOND_FONTTYPE = "loginSecondPartFontType";
    private String resfile = null;
    private String prifile = "PrimaryProductName.png";
    private String secfile = "SecondaryProductName.png";
    private String verfile = "VersionProductName.png";
    private String logfile = "LoginProductName.png";
    private String propfile = "ProductName.properties";
    private boolean debug = false;

    public ProductImageDriver(String string, boolean bl) throws Exception {
        this.debug = bl;
        if (string != null && string.trim().length() > 0) {
            this.resfile = string;
            File file = null;
            file = new File(this.resfile);
            if (!file.exists()) {
                throw new ProductImageException("image_err_01", this.resfile);
            }
        }
    }

    public void generateImages(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string2, string2, string2, string2};
        this.generateImages(string, stringArray, string3);
    }

    public void generateImages(String string, String[] stringArray, String string2) throws Exception {
        Serializable serializable;
        String string3 = null;
        String string4 = string.toLowerCase();
        if (PRIMARY.startsWith(string4)) {
            string3 = PRIMARY;
        } else if (SECONDARY.startsWith(string4)) {
            string3 = SECONDARY;
        } else if (VERSION.startsWith(string4)) {
            string3 = VERSION;
        } else if (LOGIN.startsWith(string4)) {
            string3 = LOGIN;
        } else if (ALL.startsWith(string4)) {
            string3 = ALL;
        }
        if (string3 == null) {
            throw new ProductImageException("image_err_02", string);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new ProductImageException("image_err_04");
        }
        File file = new File(string2);
        if (file.exists() && !file.isDirectory()) {
            throw new ProductImageException("image_err_05", string2);
        }
        String string5 = "";
        try {
            string5 = this.getUriPath(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (stringArray[0] == null || stringArray[0].trim().length() == 0) {
            throw new Exception("image_err_03");
        }
        string6 = stringArray[0].trim();
        string7 = stringArray[1] != null && stringArray[1].trim().length() > 0 ? stringArray[1].trim() : string6;
        string8 = stringArray[2] != null && stringArray[2].trim().length() > 0 ? stringArray[2].trim() : string6;
        string9 = stringArray[3] != null && stringArray[3].trim().length() > 0 ? stringArray[3].trim() : string6;
        GenerateProductImage generateProductImage = null;
        try {
            generateProductImage = new GenerateProductImage(this.debug);
        }
        catch (Exception exception) {
            throw new ProductImageException("image_err_06", exception.getLocalizedMessage());
        }
        Properties properties = null;
        if (this.resfile != null && ((File)(serializable = new File(this.resfile))).exists()) {
            properties = this.getResourceProperties(this.resfile);
            this.setResourceProperties(generateProductImage, properties);
        }
        generateProductImage.initialize();
        serializable = new Properties();
        String string10 = string2 + FS + this.propfile;
        File file2 = new File(string10);
        if (file2.exists()) {
            serializable = this.getResourceProperties(string10);
        }
        BufferedImage bufferedImage = null;
        String string11 = null;
        if (string3.equals(PRIMARY) || string3.equals(ALL)) {
            try {
                string11 = string2 + FS + this.prifile;
                bufferedImage = generateProductImage.GeneratePrimaryImage(string6);
                this.writeImage(bufferedImage, string11);
                ((Properties)serializable).setProperty("primary.uri", string5 + this.prifile);
                ((Properties)serializable).setProperty("primary.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("primary.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new ProductImageException("image_err_07", PRIMARY, exception.getLocalizedMessage());
            }
        }
        if (string3.equals(SECONDARY) || string3.equals(ALL)) {
            try {
                string11 = string2 + FS + this.secfile;
                bufferedImage = generateProductImage.GenerateSecondaryImage(string7);
                this.writeImage(bufferedImage, string11);
                ((Properties)serializable).setProperty("secondary.uri", string5 + this.secfile);
                ((Properties)serializable).setProperty("secondary.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("secondary.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new ProductImageException("image_err_07", SECONDARY, exception.getLocalizedMessage());
            }
        }
        if (string3.equals(VERSION) || string3.equals(ALL)) {
            try {
                string11 = string2 + FS + this.verfile;
                bufferedImage = generateProductImage.GenerateVersionImage(string8);
                this.writeImage(bufferedImage, string11);
                ((Properties)serializable).setProperty("version.uri", string5 + this.verfile);
                ((Properties)serializable).setProperty("version.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("version.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new ProductImageException("image_err_07", VERSION, exception.getLocalizedMessage());
            }
        }
        if (string3.equals(LOGIN) || string3.equals(ALL)) {
            try {
                string11 = string2 + FS + this.logfile;
                bufferedImage = generateProductImage.GenerateLoginImage(string9);
                this.writeImage(bufferedImage, string11);
                ((Properties)serializable).setProperty("login.uri", string5 + this.logfile);
                ((Properties)serializable).setProperty("login.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("login.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new ProductImageException("image_err_07", LOGIN, exception.getLocalizedMessage());
            }
        }
        File file3 = new File(string10);
        try {
            if (file3.exists()) {
                file3.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string10);
            ((Properties)serializable).store(fileOutputStream, PROP_HEADER);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new ProductImageException("image_err_08", string10, exception.getLocalizedMessage());
        }
    }

    private void writeImage(BufferedImage bufferedImage, String string) throws Exception {
        String string2 = string;
        if (!string2.endsWith(".png")) {
            string2 = string2 + ".png";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new ProductImageException("image_err_09", string2, exception.getLocalizedMessage());
        }
    }

    private Properties getResourceProperties(String string) throws Exception {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            throw new ProductImageException("image_err_10", string, exception.getLocalizedMessage());
        }
        return properties;
    }

    private void setResourceProperties(GenerateProductImage generateProductImage, Properties properties) throws Exception {
        String string = null;
        String string2 = null;
        try {
            string = KEY_PRIMARY_FILENAME;
            string2 = properties.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                this.prifile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FILENAME)) != null && string2.length() > 0) {
                this.secfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FILENAME)) != null && string2.length() > 0) {
                this.verfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_FILENAME)) != null && string2.length() > 0) {
                this.logfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_PROPERTY_FILENAME)) != null && string2.length() > 0) {
                this.propfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_FONTSIZE)) != null) {
                generateProductImage.setPrimaryFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_FONTTYPE)) != null) {
                generateProductImage.setPrimaryFontType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_HEIGHT)) != null) {
                generateProductImage.setPrimaryHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_FORECOLOR)) != null) {
                generateProductImage.setPrimaryForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_BACKCOLOR)) != null) {
                generateProductImage.setPrimaryBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_SECOND_FONTSIZE)) != null) {
                generateProductImage.setPrimarySecondLineSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_SECOND_FONTTYPE)) != null) {
                generateProductImage.setPrimarySecondLineType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_SPLITSIZE)) != null) {
                generateProductImage.setPrimarySplitSize(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FONTSIZE)) != null) {
                generateProductImage.setSecondaryFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FONTTYPE)) != null) {
                generateProductImage.setSecondaryFontType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_HEIGHT)) != null) {
                generateProductImage.setSecondaryHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FORECOLOR)) != null) {
                generateProductImage.setSecondaryForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_BACKCOLOR)) != null) {
                generateProductImage.setSecondaryBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_SECOND_FONTTYPE)) != null) {
                generateProductImage.setSecondarySecondLineType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_SPLITSIZE)) != null) {
                generateProductImage.setSecondarySplitSize(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FONTSIZE)) != null) {
                generateProductImage.setVersionFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FONTTYPE)) != null) {
                generateProductImage.setVersionFontType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_HEIGHT)) != null) {
                generateProductImage.setVersionHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FORECOLOR)) != null) {
                generateProductImage.setVersionForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_BACKCOLOR)) != null) {
                generateProductImage.setVersionBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_SECOND_FONTSIZE)) != null) {
                generateProductImage.setVersionSecondLineSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_SECOND_FONTTYPE)) != null) {
                generateProductImage.setVersionSecondLineType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_FONTSIZE)) != null) {
                generateProductImage.setLoginFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_FONTTYPE)) != null) {
                generateProductImage.setLoginFontType(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_HEIGHT)) != null) {
                generateProductImage.setLoginHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_FORECOLOR)) != null) {
                generateProductImage.setLoginForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_BACKCOLOR)) != null) {
                generateProductImage.setLoginBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_SECOND_FONTSIZE)) != null) {
                generateProductImage.setLoginSecondLineSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_LOGIN_SECOND_FONTTYPE)) != null) {
                generateProductImage.setLoginSecondLineType(string2);
            }
        }
        catch (Exception exception) {
            throw new ProductImageException("image_err_11", string, string2);
        }
    }

    private String[] splitName(String string) {
        String[] stringArray = new String[]{null, null, null, null};
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray[0] = stringTokenizer.nextToken();
        }
        if (n > 1) {
            stringArray[1] = stringTokenizer.nextToken();
        }
        if (n > 2) {
            stringArray[2] = stringTokenizer.nextToken();
        }
        if (n > 3) {
            stringArray[3] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private String getUriPath(String string) throws Exception {
        String string2;
        File file = new File(string);
        String string3 = file.getCanonicalPath();
        String string4 = new String(string3);
        while (!(string4 == null || (file = new File(string2 = string4 + FS + "WEB-INF")).exists() && file.isDirectory())) {
            file = new File(string4);
            string4 = file.getParent();
        }
        string2 = "";
        if (string4 != null) {
            int n = string4.length();
            if (n < string3.length()) {
                string2 = string3.substring(n);
            }
            if (!string2.startsWith(FS)) {
                string2 = FS + string2;
            }
            string2 = string2.replace('\\', '/');
        } else {
            File file2 = new File(string3);
            URI uRI = file2.toURI();
            string2 = uRI.toASCIIString();
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }
}

