/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.KstatInformation;
import com.sun.admin.volmgr.client.util.Util;

public class DeviceStatisticalInformation {
    private static final long NANOSEC = 1000000000L;
    public double totalOpsPerSecond;
    public double readOpsPerSecond;
    public double writeOpsPerSecond;
    public double totalKbytesPerSecond;
    public double kbytesReadPerSecond;
    public double kbytesWrittenPerSecond;
    public double avgTransactionsWaiting;
    public double avgTransactionsRunning;
    public double avgServiceTimeInMS;
    public double pcntTimeTransactionWaiting;
    public double pcntTimeTransactionRunning;
    public KstatInformation currentKstatIO;
    public KstatInformation previousKstatIO;
    private String deviceName;

    public DeviceStatisticalInformation(String string) {
        this.deviceName = string;
        this.initialize();
    }

    public String toString() {
        String string = new String("");
        string = string + "DeviceStatisticalInformation[\n";
        string = string + "\t" + this.totalOpsPerSecond + "\n";
        string = string + "\t" + this.readOpsPerSecond + "\n";
        string = string + "\t" + this.writeOpsPerSecond + "\n";
        string = string + "\t" + this.totalKbytesPerSecond + "\n";
        string = string + "\t" + this.kbytesReadPerSecond + "\n";
        string = string + "\t" + this.kbytesWrittenPerSecond + "\n";
        string = string + "\t" + this.avgTransactionsWaiting + "\n";
        string = string + "\t" + this.avgTransactionsRunning + "\n";
        string = string + "\t" + this.avgServiceTimeInMS + "\n";
        string = string + "\t" + this.pcntTimeTransactionWaiting + "\n";
        string = string + "\t" + this.pcntTimeTransactionRunning + "\n";
        string = string + "]";
        return string;
    }

    public void initialize() {
        this.totalOpsPerSecond = 0.0;
        this.readOpsPerSecond = 0.0;
        this.writeOpsPerSecond = 0.0;
        this.totalKbytesPerSecond = 0.0;
        this.kbytesReadPerSecond = 0.0;
        this.kbytesWrittenPerSecond = 0.0;
        this.avgTransactionsWaiting = 0.0;
        this.avgTransactionsRunning = 0.0;
        this.avgServiceTimeInMS = 0.0;
        this.pcntTimeTransactionWaiting = 0.0;
        this.pcntTimeTransactionRunning = 0.0;
        this.currentKstatIO = new KstatInformation();
        this.previousKstatIO = new KstatInformation();
    }

    public void refresh() {
        this.previousKstatIO = this.currentKstatIO;
        this.currentKstatIO = Util.getApp().getPerfVolMgr().getPerformanceDataFor(this.deviceName);
        this.calculateKstatDeltas();
    }

    public double getTotalOpsPerSecond() {
        return this.totalOpsPerSecond;
    }

    public double getReadOpsPerSecond() {
        return this.readOpsPerSecond;
    }

    public double getWriteOpsPerSecond() {
        return this.writeOpsPerSecond;
    }

    public double getTotalKbytesPerSecond() {
        return this.totalKbytesPerSecond;
    }

    public double getKbytesReadPerSecond() {
        return this.kbytesReadPerSecond;
    }

    public double getKbytesWrittenPerSecond() {
        return this.kbytesWrittenPerSecond;
    }

    public double getAvgTransactionsWaiting() {
        return this.avgTransactionsWaiting;
    }

    public double getAvgTransactionsRunning() {
        return this.avgTransactionsRunning;
    }

    public double getAvgServiceTimeInMS() {
        return this.avgServiceTimeInMS;
    }

    public double getPcntTimeTransactionWaiting() {
        return this.pcntTimeTransactionWaiting;
    }

    public double getPcntTimeTransactionRunning() {
        return this.pcntTimeTransactionRunning;
    }

    private void calculateKstatDeltas() {
        double d = this.currentKstatIO.wlastupdate - this.previousKstatIO.wlastupdate;
        if (d == 0.0) {
            d = 1.0E9;
        }
        double d2 = d / 1.0E9;
        this.readOpsPerSecond = (this.currentKstatIO.reads - this.previousKstatIO.reads) / d2;
        this.writeOpsPerSecond = (this.currentKstatIO.writes - this.previousKstatIO.writes) / d2;
        this.totalOpsPerSecond = this.readOpsPerSecond + this.writeOpsPerSecond;
        this.kbytesReadPerSecond = (this.currentKstatIO.nread - this.previousKstatIO.nread) / d2 / 1024.0;
        this.kbytesWrittenPerSecond = (this.currentKstatIO.nwritten - this.previousKstatIO.nwritten) / d2 / 1024.0;
        this.totalKbytesPerSecond = this.kbytesReadPerSecond + this.kbytesWrittenPerSecond;
        this.avgTransactionsWaiting = (this.currentKstatIO.wlentime - this.previousKstatIO.wlentime) / d;
        this.avgTransactionsRunning = (this.currentKstatIO.rlentime - this.previousKstatIO.rlentime) / d;
        this.avgServiceTimeInMS = this.totalOpsPerSecond > 0.0 ? (this.avgTransactionsWaiting + this.avgTransactionsRunning) / this.totalOpsPerSecond : 0.0;
        this.pcntTimeTransactionWaiting = (this.currentKstatIO.wtime - this.previousKstatIO.wtime) / d * 100.0;
        this.pcntTimeTransactionRunning = (this.currentKstatIO.rtime - this.previousKstatIO.rtime) / d * 100.0;
    }
}

