/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.volmgr.client.AddDeviceListener;
import com.sun.admin.volmgr.client.DeviceTable;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.ttk.TableSelector;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class DeviceTableSelectorManager
implements RowMoveable {
    private TableSelector selector;
    protected DeviceTableModel inTableModel;
    protected DeviceTableModel outTableModel;
    private ArrayList listeners = new ArrayList();

    public DeviceTableSelectorManager(Device[] deviceArray, Device[] deviceArray2, String[] stringArray) {
        if (deviceArray == null) {
            deviceArray = new Device[]{};
        }
        this.inTableModel = stringArray == null ? new DeviceTableModel(deviceArray) : new DeviceTableModel(deviceArray, stringArray);
        DeviceTable deviceTable = new DeviceTable(this.inTableModel);
        if (deviceArray2 == null) {
            deviceArray2 = new Device[]{};
        }
        this.outTableModel = stringArray == null ? new DeviceTableModel(deviceArray2) : new DeviceTableModel(deviceArray2, stringArray);
        DeviceTable deviceTable2 = new DeviceTable(this.outTableModel);
        this.selector = new TableSelector(deviceTable, deviceTable2, this);
        this.setLabels(Util.getActionString("browser_available"), Util.getActionString("browser_selected"), Util.getActionString("browser_add"), Util.getActionString("browser_add_all"), Util.getActionString("browser_remove"), Util.getActionString("browser_remove_all"));
        ImageIcon imageIcon = Util.loadImageIcon("down.gif");
        JButton jButton = this.selector.getMoveDownButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
        imageIcon = Util.loadImageIcon("alldown.gif");
        jButton = this.selector.getMoveAllDownButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
        imageIcon = Util.loadImageIcon("up.gif");
        jButton = this.selector.getMoveUpButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
        imageIcon = Util.loadImageIcon("allup.gif");
        jButton = this.selector.getMoveAllUpButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
    }

    public DeviceTableSelectorManager(Device[] deviceArray, Device[] deviceArray2) {
        this(deviceArray, deviceArray2, null);
    }

    public TableSelector getTableSelector() {
        return this.selector;
    }

    public void setLabels(ActionString actionString, ActionString actionString2, ActionString actionString3, ActionString actionString4, ActionString actionString5, ActionString actionString6) {
        TableSelector tableSelector = this.getTableSelector();
        JLabel jLabel = tableSelector.getInLabel();
        JLabel jLabel2 = tableSelector.getOutLabel();
        jLabel.setText(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        jLabel2.setText(actionString2.getString());
        jLabel2.setDisplayedMnemonic(actionString2.getMnemonic());
        tableSelector.getMoveDownButton().setText(actionString3.getString());
        tableSelector.getMoveAllDownButton().setText(actionString4.getString());
        tableSelector.getMoveUpButton().setText(actionString5.getString());
        tableSelector.getMoveAllUpButton().setText(actionString6.getString());
    }

    public void setInItems(Device[] deviceArray) {
        this.inTableModel.removeAllRows();
        if (deviceArray != null) {
            this.inTableModel.addRows(deviceArray);
        }
    }

    public Device[] getInItems() {
        return DeviceTableSelectorManager.objectArrayToDeviceArray(this.inTableModel.getAllRows());
    }

    public void setOutItems(Device[] deviceArray) {
        this.outTableModel.removeAllRows();
        if (deviceArray != null) {
            this.outTableModel.addRows(deviceArray);
        }
    }

    public Device[] getOutItems() {
        return DeviceTableSelectorManager.objectArrayToDeviceArray(this.outTableModel.getAllRows());
    }

    public synchronized void addAddDeviceListener(AddDeviceListener addDeviceListener) {
        this.listeners.add(addDeviceListener);
    }

    public synchronized void removeAddDeviceListener(AddDeviceListener addDeviceListener) {
        this.listeners.remove(addDeviceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveRows(DeviceTableModel deviceTableModel, DeviceTableModel deviceTableModel2, int n, int n2) {
        DeviceTableModel deviceTableModel3 = deviceTableModel;
        synchronized (deviceTableModel3) {
            Object[] objectArray = deviceTableModel.getRows(n, n2);
            deviceTableModel.removeRows(n, n2);
            deviceTableModel2.addRows(objectArray);
        }
        return true;
    }

    public synchronized boolean moveRowsDown(int n, int n2) {
        int n3 = this.listeners.size();
        if (n3 > 0) {
            Device[] deviceArray = DeviceTableSelectorManager.objectArrayToDeviceArray(this.inTableModel.getRows(n, n2));
            Device[] deviceArray2 = DeviceTableSelectorManager.objectArrayToDeviceArray(this.outTableModel.getAllRows());
            for (int i = 0; i < n3; ++i) {
                AddDeviceListener addDeviceListener = (AddDeviceListener)this.listeners.get(i);
                if (addDeviceListener.canAddDevices(deviceArray, deviceArray2)) continue;
                return false;
            }
        }
        return this.moveRows(this.inTableModel, this.outTableModel, n, n2);
    }

    public boolean moveRowsUp(int n, int n2) {
        return this.moveRows(this.outTableModel, this.inTableModel, n, n2);
    }

    public boolean moveRowsTo(int n, int n2, int n3) {
        return false;
    }

    public boolean canMoveRowsDown(int n, int n2) {
        return true;
    }

    public boolean canMoveRowsUp(int n, int n2) {
        return true;
    }

    public boolean canMoveRowsTo(int n, int n2, int n3) {
        return false;
    }

    protected static Device[] objectArrayToDeviceArray(Object[] objectArray) {
        Device[] deviceArray = new Device[objectArray.length];
        System.arraycopy(objectArray, 0, deviceArray, 0, objectArray.length);
        return deviceArray;
    }
}

