/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.ContentEvent;
import com.sun.admin.volmgr.client.ContentListener;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.VolActionsListener;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class VMgrRootTBar
extends JToolBar
implements PropertyChangeListener {
    private JButton showCommandsBtn;
    private ContentListener contentListener;
    private VolActionsListener buttonClickListener;
    private ImageIcon showCommandsIcon;
    private String showCommandsText;
    private Insets textMargin = new Insets(0, 2, 0, 2);
    private static VMgrRootTBar theToolBar = null;

    public static VMgrRootTBar getToolBar(Content content) {
        if (theToolBar == null) {
            theToolBar = new VMgrRootTBar();
        }
        content.addContentListener(theToolBar.getContentListener());
        return theToolBar;
    }

    public ContentListener getContentListener() {
        return this.contentListener;
    }

    private VMgrRootTBar() {
        this.buttonClickListener = new VolActionsListener();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.showCommandsText = Util.getResourceString("tbar_show_commands");
        this.showCommandsIcon = Util.loadImageIcon("showcommands_24.gif");
        this.showCommandsBtn = new JButton(this.showCommandsIcon);
        this.setUpButton(this.showCommandsBtn, this.showCommandsText, "ShowCommands");
        Constraints.constrain((Container)this, (Component)this.showCommandsBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)5, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                VMgrRootTBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
    }

    private void setUpButton(JButton jButton, String string, String string2) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.buttonClickListener);
    }

    private void notifySelectionChange(int n) {
        VVolMgr vVolMgr = Util.getApp();
        VConsoleProperties vConsoleProperties = vVolMgr.getProperties();
        vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        if (!vVolMgr.getServiceWrapper().hasVolMgrWriteAuth()) {
            this.showCommandsBtn.setEnabled(false);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.showCommandsBtn, null);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            if (string != null) {
                abstractButton.setMargin(this.textMargin);
            } else {
                abstractButton.setMargin(null);
            }
        }
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(Util.getApp().getProperties().getProperty("vconsole.buttondisplay"));
        }
    }
}

