/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.metadb;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.metadb.ConfReplicaPanel;
import com.sun.admin.volmgr.client.metadb.MetadbFilterControl;
import com.sun.admin.volmgr.client.metadb.VMgrMetadbMenuBar;
import com.sun.admin.volmgr.client.metadb.VMgrMetadbTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class MetadbContent
extends Content {
    private static String[][] columnHeaders = null;
    private VFilter filterControl;
    private boolean stopped = false;

    public MetadbContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrMetadbMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrMetadbTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{Util.getResourceString("Diskset"), new Integer(10)}, {Util.getResourceString("state"), new Integer(10)}, {Util.getResourceString("startblock"), new Integer(20010)}, {Util.getResourceString("size"), new Integer(20010)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(Util.getResourceString("Diskset"), Util.getDisplayableDiskSetName(device));
        hashtable.put(Util.getResourceString("state"), Util.formatProperty(device, "state"));
        Long l = (Long)device.getProperty("startblock");
        hashtable.put(Util.getResourceString("startblock"), l);
        hashtable.put(Util.getResourceString("size"), Util.getDeviceSizeWithUnits(device));
        return hashtable;
    }

    public Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Metadb", this.getListProperties());
        return vector.toArray(new Device[vector.size()]);
    }

    public void deleteSelected() {
        String string;
        Object object;
        Object object2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (VScopeNode)vector.get(i);
            object = (Device)object2.getPayload();
            string = Util.getDeviceBaseName((Device)object);
            String string2 = Util.getDiskSetFlag((Device)object);
            stringArray[i] = Util.getBasedir() + "usr/sbin/metadb" + string2 + " -d -f " + string;
            stringArray2[i] = Util.getResourceString("metadb_delete_cmd", string);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        String string3 = Util.getResourceString("sure_delete_metadb");
        object2 = new ConfReplicaPanel(stringArray, string3);
        object = new String(Util.getResourceString("warning_delete_metadb"));
        string = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, actionListener, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("metadb");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("MetadbListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new MetadbFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        String string;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetadbContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        for (int i = 0; i < deviceArray.length; ++i) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            string = Util.getDeviceFullName(deviceArray[i]);
            String string2 = Util.getResourceString("metadb_refresh_loading_device", string);
            progressPanel.setText(string2);
            progressPanel.setValue(i + 1);
            VMgrMetadbMenuBar vMgrMetadbMenuBar = VMgrMetadbMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrMetadbMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[i]), Util.getLargeIcon(deviceArray[i]), string, string, null, -1, (Object)deviceArray[i]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("Metadb") + "  " + Util.getResourceString("tooltip_content_name") + " " + string);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[i]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[i]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[i]);
        }
        VVolMgr vVolMgr = Util.getApp();
        string = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.getTreeNode());
        vVolMgr.fireConsoleAction((VConsoleEvent)string);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrMetadbMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrMetadbTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        VVolMgr vVolMgr = Util.getApp();
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }
}

