/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Hashtable;

public class ColumnLayout
implements LayoutManager2 {
    public static final VOrient TOP = new VOrient();
    public static final VOrient BOTTOM = new VOrient();
    public static final VOrient VFILL = new VOrient();
    public static final VOrient VCENTER = new VOrient();
    public static final HOrient LEFT = new HOrient();
    public static final HOrient RIGHT = new HOrient();
    public static final HOrient HFILL = new HOrient();
    public static final HOrient HCENTER = new HOrient();
    protected static HOrient _HORIENT = HFILL;
    protected static VOrient _VORIENT = VFILL;
    protected static int _GAP = 15;
    private int gap;
    private VOrient vOrient;
    private Hashtable table = new Hashtable();

    public ColumnLayout() {
        this(_VORIENT, _GAP);
    }

    public ColumnLayout(int n) {
        this(_VORIENT, n);
    }

    public ColumnLayout(VOrient vOrient) {
        this(vOrient, _GAP);
    }

    public ColumnLayout(VOrient vOrient, int n) {
        if (n < 0) {
            n = 0;
        }
        this.setGap(n);
        this.setVOrient(vOrient);
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setVOrient(VOrient vOrient) {
        this.vOrient = vOrient;
    }

    public VOrient getVOrient() {
        return this.vOrient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object == null) {
                object = _HORIENT;
            }
            if (!(object instanceof HOrient)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a HOrient (or null)");
            }
            this.table.put(component, object);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, _HORIENT);
    }

    public void removeLayoutComponent(Component component) {
        this.table.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            if (i > 0) {
                dimension.height += this.gap;
            }
            dimension.height += dimension2.height;
            dimension.width = Math.max(dimension2.width, dimension.width);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height;
            if (i <= 0) continue;
            dimension.height += this.gap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.getComponentCount();
        int n3 = 0;
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        if (this.vOrient == VCENTER) {
            n += dimension2.height / 2 - dimension.height / 2;
        } else if (this.vOrient == BOTTOM) {
            n += dimension2.height - dimension.height;
        } else if (this.vOrient == VFILL && n2 > 0 && (n3 = (dimension2.height - dimension.height) / n2) < 0) {
            n3 = 0;
        }
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension3 = component.getPreferredSize();
            HOrient hOrient = (HOrient)this.table.get(component);
            if (hOrient == null) {
                hOrient = _HORIENT;
            }
            if (hOrient == LEFT) {
                n5 = insets.left;
                n4 = dimension3.width;
            } else if (hOrient == HFILL) {
                n5 = insets.left;
                n4 = dimension2.width - insets.left - insets.right;
            } else if (hOrient == RIGHT) {
                n5 = dimension2.width - dimension3.width - insets.right;
                n4 = dimension3.width;
            } else {
                n5 = dimension2.width / 2 - dimension3.width / 2;
                n4 = dimension3.width;
            }
            component.setBounds(n5, n, n4, dimension3.height + n3);
            n += dimension3.height + n3 + this.gap;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public static void main(String[] stringArray) {
        VOrient[] vOrientArray = new VOrient[]{TOP, BOTTOM, VFILL, VCENTER};
        HOrient[] hOrientArray = new HOrient[]{LEFT, RIGHT, HFILL, HCENTER};
        Frame frame = new Frame();
        frame.setLayout(new GridLayout(1, vOrientArray.length, 15, 15));
        Color color = Color.white;
        for (int i = 0; i < vOrientArray.length; ++i) {
            Panel panel = new Panel(new ColumnLayout(vOrientArray[i]));
            panel.setBackground(color);
            color = color.darker();
            for (int j = 0; j < hOrientArray.length; ++j) {
                panel.add((Component)new TextField("Hello"), hOrientArray[j]);
            }
            frame.add(panel);
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static class HOrient {
        private HOrient() {
        }
    }

    public static class VOrient {
        private VOrient() {
        }
    }
}

