/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import com.sun.admin.volmgr.client.ttk.Spinner;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class I18nTextComponent
extends JPanel {
    private String pattern;
    private Component[] componentArguments;
    private Font font;
    private int spacing;
    private FlowLayout layout = new FlowLayout(0);

    public I18nTextComponent(String string) {
        this.setPattern(string);
    }

    public I18nTextComponent(String string, Component[] componentArray) {
        this(string);
        this.setComponentArguments(componentArray);
        this.parseAndLayout();
    }

    public synchronized void setPattern(String string) {
        this.pattern = string;
    }

    public synchronized String getPattern() {
        return this.pattern;
    }

    public void setComponentArguments(Component[] componentArray) {
        this.componentArguments = componentArray;
    }

    public Component[] getComponentArguments() {
        return this.componentArguments;
    }

    public synchronized void setTextFont(Font font) {
        this.font = font;
        this.setSpacing(this.getFontMetrics(font).charWidth(' '));
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setFont(font);
        }
    }

    public synchronized Font getTextFont() {
        return this.font;
    }

    public synchronized void setSpacing(int n) {
        this.spacing = n;
        this.layout.setHgap(n);
        this.layout.setVgap(n);
    }

    public synchronized int getSpacing() {
        return this.spacing;
    }

    private synchronized void addTextComponent(int n, int n2) {
        if (n < n2) {
            JLabel jLabel = new JLabel(this.pattern.substring(n, n2));
            if (this.font == null) {
                this.setTextFont(jLabel.getFont());
            } else {
                jLabel.setFont(this.getTextFont());
            }
            this.add(jLabel);
        }
    }

    public synchronized void parseAndLayout() {
        this.removeAll();
        this.setLayout(this.layout);
        int n = this.pattern.length();
        int n2 = 0;
        block2: for (int i = 0; i < n; ++i) {
            char c = this.pattern.charAt(i);
            if (Character.isWhitespace(c)) {
                this.addTextComponent(n2, i);
                ++i;
                while (i < n) {
                    if (!Character.isWhitespace(this.pattern.charAt(i))) {
                        --i;
                        break;
                    }
                    ++i;
                }
                n2 = i + 1;
                continue;
            }
            if (c != '{' || i != 0 && this.pattern.charAt(i - 1) == '\\') continue;
            int n3 = i++;
            int n4 = 0;
            while (i < n && (c = this.pattern.charAt(i)) != '}') {
                int n5 = Character.digit(c, 10);
                if (n5 < 0) {
                    i = n3;
                    continue block2;
                }
                n4 *= 10;
                n4 += n5;
                ++i;
            }
            this.addTextComponent(n2, n3);
            try {
                this.add(this.componentArguments[n4]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n2 = i + 1;
        }
        this.addTextComponent(n2, n);
    }

    public static void main(String[] stringArray) {
        I18nTextComponent i18nTextComponent = new I18nTextComponent("Build {0} partitions of size {1}{2}.", new Component[]{new JTextField("   3"), new Spinner("1024"), new JComboBox<Object>(new Object[]{"KB", "MB", "GB"})});
        I18nTextComponent i18nTextComponent2 = new I18nTextComponent("Construya {0} particiones de los {2} de la talla {1}.", new Component[]{new JTextField("   3"), new Spinner("1024"), new JComboBox<Object>(new Object[]{"KB", "MB", "GB"})});
        JFrame jFrame = new JFrame("Internationalized Text Component Layout Example");
        Container container = jFrame.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 5;
        container.add((Component)new JLabel("English:"), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 15;
        container.add((Component)i18nTextComponent, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 5;
        container.add((Component)new JLabel("Spanish:"), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        container.add((Component)i18nTextComponent2, gridBagConstraints);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

