/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

public class ArrowIcon
implements Icon,
SwingConstants,
Cloneable {
    private static final int _ICON_WIDTH = 10;
    private static final int _ICON_HEIGHT = 10;
    private static final int _ORIENTATION = 5;
    private static final RGBImageFilter filter = new GrayFilter(true, 50);
    private int width;
    private int height;
    private int orientation;
    private Color color;
    private boolean enabled;

    public ArrowIcon() {
        this(10, 10, 5);
    }

    public ArrowIcon(int n) {
        this(10, 10, n);
    }

    public ArrowIcon(int n, int n2) {
        this(n, n2, 5);
    }

    public ArrowIcon(int n, int n2, int n3) {
        this.setLogicalWidth(n);
        this.setLogicalHeight(n2);
        this.setOrientation(n3);
        this.setEnabled(true);
    }

    public void setLogicalWidth(int n) {
        this.width = n;
    }

    public int getLogicalWidth() {
        return this.width;
    }

    public void setLogicalHeight(int n) {
        this.height = n;
    }

    public int getLogicalHeight() {
        return this.height;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getIconHeight() {
        switch (this.getOrientation()) {
            default: {
                return this.getLogicalHeight();
            }
            case 3: 
            case 7: 
        }
        return this.getLogicalWidth();
    }

    public int getIconWidth() {
        switch (this.getOrientation()) {
            default: {
                return this.getLogicalWidth();
            }
            case 3: 
            case 7: 
        }
        return this.getLogicalHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        int n5 = n3 - 1;
        int n6 = n3 >> 1;
        int n7 = n4 - 1;
        int n8 = n4 >> 1;
        int n9 = this.getOrientation();
        graphics.translate(n, n2);
        switch (n9) {
            case 3: {
                nArray4 = new int[]{0, n5, 0};
                break;
            }
            case 7: {
                nArray4 = new int[]{n5, 0, n5};
                break;
            }
            default: {
                nArray4 = new int[]{0, n6, n5};
            }
        }
        switch (n9) {
            case 1: {
                nArray3 = new int[]{n7, 0, n7};
                break;
            }
            default: {
                nArray3 = new int[]{0, n7, 0};
                break;
            }
            case 3: 
            case 7: {
                nArray3 = new int[]{0, n8, n7};
            }
        }
        switch (n9) {
            case 1: {
                nArray2 = new int[]{0, n7, n6, 0};
                nArray = new int[]{0, n7, n5, n7};
                break;
            }
            default: {
                nArray2 = new int[]{0, 0, n5, 0};
                nArray = new int[]{n6, n7, n5, 0};
                break;
            }
            case 3: {
                nArray2 = new int[]{0, 0, 0, n7};
                nArray = new int[]{0, n7, n5, n8};
                break;
            }
            case 7: {
                nArray2 = new int[]{0, n8, n5, 0};
                nArray = new int[]{n5, 0, n5, n7};
            }
        }
        boolean bl = this.getEnabled();
        Color color = this.getColor();
        if (color == null) {
            color = component.getForeground();
        }
        Color color2 = Color.black;
        Color color3 = Color.white;
        if (!bl) {
            color = ArrowIcon.getDisabledColor(color);
            color2 = ArrowIcon.getDisabledColor(color2);
            color3 = ArrowIcon.getDisabledColor(color3);
        }
        graphics.setColor(color);
        graphics.drawPolygon(nArray4, nArray3, 3);
        graphics.fillPolygon(nArray4, nArray3, 3);
        graphics.setColor(color2);
        graphics.drawLine(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        graphics.setColor(color3);
        graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[3]);
        graphics.translate(-n, -n2);
    }

    private static Color getDisabledColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = n << 16 | n2 << 8 | n3;
        n4 = filter.filterRGB(0, 0, n4);
        n = (n4 & 0xFF0000) >> 16;
        n2 = (n4 & 0xFF00) >> 8;
        n3 = n4 & 0xFF;
        Color color2 = new Color(n, n2, n3);
        return color2;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new GridLayout(2, 2));
        ArrowIcon arrowIcon = new ArrowIcon(1);
        arrowIcon.setColor(Color.green.darker());
        container.add(new JLabel(arrowIcon));
        container.add(new JLabel(new ArrowIcon(5)));
        container.add(new JLabel(new ArrowIcon(3)));
        container.add(new JLabel(new ArrowIcon(7)));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

