/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderConstraints;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public abstract class RowHeaderManager {
    private static final int _SPACING = 0;
    private JTable table;
    private JPanel header;
    private JPanel inner;
    private TableRowHeaderLayout layout;
    private RowGroupable groupable;
    private Hashtable hash = new Hashtable();
    private int spacing;

    public RowHeaderManager(JTable jTable, RowGroupable rowGroupable) {
        this(jTable, rowGroupable, 0);
    }

    public RowHeaderManager(JTable jTable, RowGroupable rowGroupable, int n) {
        this.table = jTable;
        this.groupable = rowGroupable;
        this.spacing = n;
        this.init();
        this.update();
    }

    public JPanel getHeader() {
        return this.header;
    }

    public JPanel getInnerPanel() {
        return this.inner;
    }

    public JTable getTable() {
        return this.table;
    }

    public RowGroupable getRowGroupable() {
        return this.groupable;
    }

    private void init() {
        this.inner = new JPanel();
        this.layout = new TableRowHeaderLayout(this.table, this.spacing);
        this.inner.setLayout(this.layout);
        this.inner.setBorder(new CompoundBorder(new BevelBorder(0), new EmptyBorder(0, 15, 0, 0)));
        this.header = new JPanel();
        this.header.setLayout(new BorderLayout());
        this.header.add((Component)this.inner, "Center");
    }

    private void revalidate(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                RowHeaderManager.this.inner.invalidate();
                RowHeaderManager.this.inner.validate();
                if (bl) {
                    RowHeaderManager.this.inner.repaint();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void update() {
        ComponentProps componentProps;
        HashSet hashSet = new HashSet(this.hash.keySet());
        RowGroupable rowGroupable = this.getRowGroupable();
        RowGroup[] rowGroupArray = rowGroupable.getAllRowGroups();
        for (int i = 0; i < rowGroupArray.length; ++i) {
            Object object;
            TableRowHeaderConstraints tableRowHeaderConstraints;
            RowGroup rowGroup = rowGroupArray[i];
            componentProps = (ComponentProps)this.hash.get(rowGroup);
            hashSet.remove(rowGroup);
            int n = rowGroup.getFirstRow();
            int n2 = rowGroup.getLastRow();
            if (componentProps == null) {
                tableRowHeaderConstraints = new TableRowHeaderConstraints();
                tableRowHeaderConstraints.setRowGroup(rowGroup);
                object = this.getRowHeaderComponent(rowGroup);
                this.inner.add((Component)object, tableRowHeaderConstraints);
                componentProps = new ComponentProps();
                componentProps.component = object;
                componentProps.constraints = tableRowHeaderConstraints;
                this.hash.put(rowGroup, componentProps);
                continue;
            }
            tableRowHeaderConstraints = componentProps.constraints;
            object = tableRowHeaderConstraints.getRowGroup();
            if (n == object.getFirstRow() && n2 == object.getLastRow()) continue;
            tableRowHeaderConstraints.setRowGroup(rowGroup);
            this.layout.setConstraints(componentProps.component, tableRowHeaderConstraints);
        }
        for (RowGroup rowGroup : hashSet) {
            componentProps = (ComponentProps)this.hash.get(rowGroup);
            this.inner.remove(componentProps.component);
            this.hash.remove(rowGroup);
        }
        this.revalidate(hashSet.size() > 0);
    }

    protected void toggleSelection(Component component) {
        TableRowHeaderConstraints tableRowHeaderConstraints = this.layout.getConstraints(component);
        if (tableRowHeaderConstraints == null) {
            throw new IllegalArgumentException("Invalid row header Component");
        }
        RowGroup rowGroup = tableRowHeaderConstraints.getRowGroup();
        int n = rowGroup.getFirstRow();
        int n2 = rowGroup.getLastRow();
        boolean bl = false;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == n2 - n + 1) {
            Arrays.sort(nArray);
            if (nArray[0] == n && nArray[nArray.length - 1] == n2) {
                bl = true;
            }
        }
        if (bl) {
            this.table.clearSelection();
        } else {
            this.table.setRowSelectionInterval(n, n2);
        }
    }

    protected abstract Component getRowHeaderComponent(RowGroup var1);

    private static class ComponentProps {
        public Component component;
        public TableRowHeaderConstraints constraints;

        private ComponentProps() {
        }
    }
}

