/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AttachConcatComponentWizard;
import com.sun.admin.volmgr.client.wizards.ReplaceStripeComponentWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class ConcatStripeDeviceTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "components_props_tab";
    private static final String HELPFILE = "ConcatStripeDeviceTablePropertySheet.html";
    private Device device;
    private String disksetFlag;
    private boolean isSubmirror;
    private JButton replaceButton;
    private JButton enableButton;

    public ConcatStripeDeviceTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.isSubmirror = this.isSubmirror();
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.device);
        }
        return this.disksetFlag;
    }

    private boolean isSubmirror() {
        Vector vector = Util.getApp().getServiceWrapper().getDependents(this.device, "BasedOn");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Device device = (Device)vector.get(i);
            Object object = device.getProperty("type");
            if (!"Mirror".equals(object)) continue;
            return true;
        }
        return false;
    }

    private Device getMirrorFromSubmirror() {
        Vector vector = Util.getApp().getServiceWrapper().getDependents(this.device, "BasedOn");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Device device = (Device)vector.get(i);
            Object object = device.getProperty("type");
            if (!"Mirror".equals(object)) continue;
            return device;
        }
        return null;
    }

    private void setButtonState() {
        int[] nArray;
        boolean bl = false;
        if (this.isSubmirror && Util.getApp().getServiceWrapper().hasVolMgrWriteAuth() && (nArray = this.table.getSelectedRows()).length > 0) {
            bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                Device device = (Device)this.model.getRow(nArray[i]);
                Object object = device.getProperty("type");
                if ("Slice".equals(object)) continue;
                bl = false;
                break;
            }
        }
        this.replaceButton.setEnabled(bl);
        this.enableButton.setEnabled(bl);
    }

    private void attachComp() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)ConcatStripeDeviceTablePropertySheet.this)), (Window)vFrame, true);
                AttachConcatComponentWizard attachConcatComponentWizard = new AttachConcatComponentWizard(ConcatStripeDeviceTablePropertySheet.this.device);
                attachConcatComponentWizard.init();
                attachConcatComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                attachConcatComponentWizard.start();
            }
        }.start();
    }

    private void replaceComp(final Device device) {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)ConcatStripeDeviceTablePropertySheet.this)), (Window)vFrame, true);
                Device device3 = ConcatStripeDeviceTablePropertySheet.this.device;
                Device device2 = ConcatStripeDeviceTablePropertySheet.this.getMirrorFromSubmirror();
                if (device2 == null) {
                    new ErrorDialog(null, Util.getResourceString("mirror_not_found_error", device3));
                    return;
                }
                device3 = device2;
                ReplaceStripeComponentWizard replaceStripeComponentWizard = new ReplaceStripeComponentWizard(device3, device);
                replaceStripeComponentWizard.init();
                replaceStripeComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                replaceStripeComponentWizard.start();
            }
        }.start();
    }

    private void enableComp() {
        Object object;
        Object object2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        Device device = this.device;
        Device device2 = this.getMirrorFromSubmirror();
        if (device2 == null) {
            new ErrorDialog(null, Util.getResourceString("mirror_not_found_error", device));
            return;
        }
        device = device2;
        String string = Util.getDeviceBaseName(device);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object2 = (Device)this.model.getRow(nArray[i]);
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[i] = Util.getResourceString("stripe_enable_comp_cmd", object);
            stringArray2[i] = Util.getBasedir() + "usr/sbin/metareplace" + this.getDiskSetFlag() + " -e " + string + " " + (String)object;
        }
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        object2 = Util.getResourceString("sure_enable_stripe_comp");
        object = new ConfVolumePanel(stringArray2, (String)object2);
        String string2 = new String(Util.getResourceString("warning_enable_stripe_comp"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)object, actionListener, Util.getResourceString("warning_enable"));
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.device);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(super.getMainPanel(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = null;
        if (!Util.isInnerStripe(this.device)) {
            jButton = new JButton();
            if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
                jButton.setEnabled(false);
            } else {
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConcatStripeDeviceTablePropertySheet.this.attachComp();
                    }
                });
            }
            Util.initButton(jButton, "attach_stripe");
            jPanel2.add(jButton);
        }
        final JTable jTable = this.table;
        final DeviceTableModel deviceTableModel = this.model;
        this.replaceButton = new JButton();
        this.enableButton = new JButton();
        if (this.isSubmirror) {
            this.replaceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = jTable.getSelectedRows();
                    Device device = (Device)deviceTableModel.getRow(nArray[0]);
                    ConcatStripeDeviceTablePropertySheet.this.replaceComp(device);
                }
            });
            Util.initButton(this.replaceButton, "replace_component");
            jPanel2.add(this.replaceButton);
            this.enableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConcatStripeDeviceTablePropertySheet.this.enableComp();
                }
            });
            Util.initButton(this.enableButton, "enable_component");
            jPanel2.add(this.enableButton);
        }
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

