/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AttachRAIDComponentWizard;
import com.sun.admin.volmgr.client.wizards.ReplaceRAIDComponentWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class RAIDDeviceTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "components_props_tab";
    private static final String HELPFILE = "RAIDDeviceTablePropertySheet.html";
    private Device raid;
    private String disksetFlag;
    private static String[] propKeys = new String[]{"name", "type", "size", "state", "original"};
    private JButton attachButton;
    private JButton replaceButton;
    private JButton enableButton;

    public RAIDDeviceTablePropertySheet(Device device) {
        super(TITLE, HELPFILE, propKeys);
        this.raid = device;
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.raid);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            switch (this.table.getSelectedRows().length) {
                case 0: {
                    break;
                }
                case 1: {
                    bl2 = true;
                }
                default: {
                    bl = true;
                }
            }
        }
        this.replaceButton.setEnabled(bl2);
        this.enableButton.setEnabled(bl);
    }

    private void attachComp() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)RAIDDeviceTablePropertySheet.this)), (Window)vFrame, true);
                AttachRAIDComponentWizard attachRAIDComponentWizard = new AttachRAIDComponentWizard(RAIDDeviceTablePropertySheet.this.raid);
                attachRAIDComponentWizard.init();
                attachRAIDComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                attachRAIDComponentWizard.start();
            }
        }.start();
    }

    private void replaceComp() {
        final JTable jTable = this.table;
        final DeviceTableModel deviceTableModel = this.model;
        new Thread(){

            public void run() {
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                Device device = (Device)deviceTableModel.getRow(nArray[0]);
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)RAIDDeviceTablePropertySheet.this)), (Window)vFrame, true);
                ReplaceRAIDComponentWizard replaceRAIDComponentWizard = new ReplaceRAIDComponentWizard(RAIDDeviceTablePropertySheet.this.raid, device);
                replaceRAIDComponentWizard.init();
                replaceRAIDComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                replaceRAIDComponentWizard.start();
            }
        }.start();
    }

    private void enableComp() {
        Object object;
        Object object2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string = Util.getDeviceBaseName(this.raid);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object2 = (Device)this.model.getRow(nArray[i]);
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[i] = Util.getResourceString("raid_enable_comp_cmd", object);
            stringArray2[i] = Util.getBasedir() + "usr/sbin/metareplace" + this.getDiskSetFlag() + " -e " + string + " " + (String)object;
        }
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        object2 = Util.getResourceString("sure_enable_raid_comp");
        object = new ConfVolumePanel(stringArray2, (String)object2);
        String string2 = new String(Util.getResourceString("warning_enable_raid_comp"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)object, actionListener, Util.getResourceString("warning_enable"));
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.raid);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(super.getMainPanel(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.attachButton = new JButton();
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            this.attachButton.setEnabled(false);
        } else {
            this.attachButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RAIDDeviceTablePropertySheet.this.attachComp();
                }
            });
        }
        Util.initButton(this.attachButton, "attach_component");
        jPanel2.add(this.attachButton);
        JTable jTable = this.table;
        DeviceTableModel deviceTableModel = this.model;
        this.replaceButton = new JButton();
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RAIDDeviceTablePropertySheet.this.replaceComp();
            }
        });
        Util.initButton(this.replaceButton, "replace_component");
        jPanel2.add(this.replaceButton);
        this.enableButton = new JButton();
        this.enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RAIDDeviceTablePropertySheet.this.enableComp();
            }
        });
        Util.initButton(this.enableButton, "enable_component");
        jPanel2.add(this.enableButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

