/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.volmgr.client.DeviceStatisticalInformation;
import com.sun.admin.volmgr.client.GeneralPropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VolumePerfPropertySheet
extends GeneralPropertySheet {
    private static final String TITLE = "perf_props_tab";
    private static final String BORDERTITLE = "device_perf_props_title";
    private static final String SPACER = "  ";
    private Device volume;
    private DeviceStatisticalInformation stats;
    private JLabel totalsValue;
    private JLabel readValue;
    private JLabel writeValue;
    private JLabel waitValue;
    private JLabel svcValue;
    private JLabel pcntWaitValue;
    private JLabel pcntRunValue;

    public VolumePerfPropertySheet(Device device, String string) {
        super(TITLE, string, BORDERTITLE);
        this.volume = device;
        String string2 = Util.getDeviceFullName(device);
        this.stats = new DeviceStatisticalInformation(string2);
    }

    public Device getDevice() {
        return this.volume;
    }

    public String getDeviceTotals() {
        String string = Util.getResourceString("device_perf_units_ops", Util.formatDouble(this.stats.totalOpsPerSecond));
        String string2 = Util.getResourceString("device_perf_units_kb", Util.formatDouble(this.stats.totalKbytesPerSecond));
        return string + SPACER + string2;
    }

    public String getDeviceReads() {
        String string = Util.getResourceString("device_perf_units_ops", Util.formatDouble(this.stats.readOpsPerSecond));
        String string2 = Util.getResourceString("device_perf_units_kb", Util.formatDouble(this.stats.kbytesReadPerSecond));
        return string + SPACER + string2;
    }

    public String getDeviceWrites() {
        String string = Util.getResourceString("device_perf_units_ops", Util.formatDouble(this.stats.writeOpsPerSecond));
        String string2 = Util.getResourceString("device_perf_units_kb", Util.formatDouble(this.stats.kbytesWrittenPerSecond));
        return string + SPACER + string2;
    }

    public String getDeviceWait() {
        return Util.formatDouble(this.stats.avgTransactionsWaiting).toString();
    }

    public String getDeviceServiceTime() {
        return Util.formatDouble(this.stats.avgServiceTimeInMS).toString();
    }

    public String getDevicePercentWait() {
        return Util.formatDouble(this.stats.pcntTimeTransactionWaiting).toString();
    }

    public String getDevicePercentRun() {
        return Util.formatDouble(this.stats.pcntTimeTransactionRunning).toString();
    }

    protected GeneralPropertySheet.LabeledComponent[] getLabeledComponents() {
        this.totalsValue = new JLabel();
        this.readValue = new JLabel();
        this.writeValue = new JLabel();
        this.waitValue = new JLabel();
        this.svcValue = new JLabel();
        this.pcntWaitValue = new JLabel();
        this.pcntRunValue = new JLabel();
        return new GeneralPropertySheet.LabeledComponent[]{new GeneralPropertySheet.LabeledComponent("totals", this.totalsValue), new GeneralPropertySheet.LabeledComponent("reads", this.readValue), new GeneralPropertySheet.LabeledComponent("writes", this.writeValue), new GeneralPropertySheet.LabeledComponent("wait_queue", this.waitValue), new GeneralPropertySheet.LabeledComponent("svc_time", this.svcValue), new GeneralPropertySheet.LabeledComponent("wait_pcnt", this.pcntWaitValue), new GeneralPropertySheet.LabeledComponent("load_pcnt", this.pcntRunValue)};
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VolumePerfPropertySheet.this.refresh();
            }
        });
        Util.initButton(jButton, "refresh_perf");
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    protected void refresh() {
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VolumePerfPropertySheet.this.stats.refresh();
                VolumePerfPropertySheet.this.totalsValue.setText(VolumePerfPropertySheet.this.getDeviceTotals());
                VolumePerfPropertySheet.this.readValue.setText(VolumePerfPropertySheet.this.getDeviceReads());
                VolumePerfPropertySheet.this.writeValue.setText(VolumePerfPropertySheet.this.getDeviceWrites());
                VolumePerfPropertySheet.this.waitValue.setText(VolumePerfPropertySheet.this.getDeviceWait());
                VolumePerfPropertySheet.this.svcValue.setText(VolumePerfPropertySheet.this.getDeviceServiceTime());
                VolumePerfPropertySheet.this.pcntWaitValue.setText(VolumePerfPropertySheet.this.getDevicePercentWait());
                VolumePerfPropertySheet.this.pcntRunValue.setText(VolumePerfPropertySheet.this.getDevicePercentRun());
                GUIUtil.waitOff();
            }
        };
        SwingUtilities.invokeLater(thread);
    }
}

