/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.RestrictiveLongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.HasDeviceName;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class DeviceNameCard
extends SimpleVWizardCard {
    private String deviceLabel;
    private String prefix;
    private HasDeviceName hasDeviceName;
    private RestrictiveLongSpinnerModel model;
    private Spinner spinner;
    private long max;

    public DeviceNameCard(HasDeviceName hasDeviceName, String string, String string2, String string3, String string4, String string5, long l) {
        super(string, string2, string3);
        this.hasDeviceName = hasDeviceName;
        this.deviceLabel = string4;
        this.prefix = string5;
        this.max = l;
    }

    public abstract long[] getUsedDeviceNumbers();

    public long getDeviceNumber() {
        long l = 0L;
        String string = this.hasDeviceName.getDeviceName();
        try {
            l = Long.parseLong(string.substring(this.prefix.length()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        long[] lArray = this.model.getDisallowed();
        while (Arrays.binarySearch(lArray, l) >= 0) {
            ++l;
        }
        return l;
    }

    protected boolean isValidDeviceNumber(long l) {
        if (l < 0L || l > this.max) {
            return false;
        }
        long[] lArray = this.model.getDisallowed();
        return Arrays.binarySearch(lArray, l) < 0;
    }

    protected boolean isValidDeviceNumber(String string) {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return this.isValidDeviceNumber(l);
    }

    protected void setDeviceName(String string, long l) {
        this.hasDeviceName.setDeviceName(string + l);
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        JLabel jLabel = new JLabel(this.prefix);
        this.model = new RestrictiveLongSpinnerModel(new long[0], 0L, this.max);
        this.spinner = new Spinner("0", (SpinnerDataModel)this.model);
        JTextField jTextField = this.spinner.getTextField();
        jTextField.setColumns(4);
        JLabel jLabel2 = new JLabel();
        Util.initLabel(jLabel2, this.deviceLabel, jTextField);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.spinner, "Center");
        JPanel jPanel3 = new JPanel(new RowLayout(RowLayout.LEFT));
        jPanel3.add((Component)jLabel2, RowLayout.VCENTER);
        jPanel3.add((Component)jPanel2, RowLayout.VCENTER);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    public void refresh() {
        this.model.setDisallowed(this.getUsedDeviceNumbers());
        this.spinner.getTextField().setText(Long.toString(this.getDeviceNumber()));
    }

    public boolean stop(boolean bl) {
        if (bl) {
            String string = this.spinner.getTextField().getText();
            try {
                long l = Long.parseLong(string);
                if (!this.isValidDeviceNumber(l)) {
                    throw new NumberFormatException();
                }
                this.setDeviceName(this.prefix, l);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[]{string, Long.toString(this.max)};
                String string2 = Util.getResourceString("invalid_device_number", objectArray);
                new ErrorDialog(null, string2);
                return false;
            }
        }
        return true;
    }
}

