/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.HasDiskSet;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DiskSetChooserCard
extends SimpleVWizardCard {
    private HasDiskSet hasDisket;
    private JComboBox disksetCombo;
    private String label;

    public DiskSetChooserCard(HasDiskSet hasDiskSet, String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.hasDisket = hasDiskSet;
        this.label = string4;
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        this.disksetCombo = new JComboBox();
        JLabel jLabel = new JLabel();
        Util.initLabel(jLabel, this.label, this.disksetCombo);
        JPanel jPanel2 = new JPanel(new RowLayout(RowLayout.LEFT));
        jPanel2.add((Component)jLabel, RowLayout.VCENTER);
        jPanel2.add((Component)this.disksetCombo, RowLayout.VCENTER);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void refresh() {
        this.disksetCombo.removeAllItems();
        this.disksetCombo.addItem(Util.getResourceString("diskset_none"));
        Device[] deviceArray = Util.getOwnedDiskSets();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (Util.isLocalDiskSet(deviceArray[i])) continue;
            this.disksetCombo.addItem(Util.getDeviceFullName(deviceArray[i]));
        }
        String string = this.hasDisket.getDiskSetName();
        if (string != null) {
            this.disksetCombo.setSelectedItem(string);
        } else {
            this.disksetCombo.setSelectedIndex(0);
        }
    }

    public boolean stop(boolean bl) {
        if (bl) {
            int n = this.disksetCombo.getSelectedIndex();
            this.hasDisket.setDiskSetName(n == 0 ? "" : (String)this.disksetCombo.getItemAt(n));
        }
        return true;
    }
}

