/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.volmgr.client.ttk.ListBuilder;
import com.sun.admin.volmgr.client.ttk.event.ListAdditionEvent;
import com.sun.admin.volmgr.client.ttk.event.ListAdditionListener;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.DiskSetCommandFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiskSetHostsCard
extends SimpleVWizardCard {
    private static String TITLE = "DiskSetHostsCard_title";
    private static final String HELPFILE = "DiskSetHostsCard.html";
    private static String HEADER = "DiskSetHostsCard_header";
    private DiskSetCommandFactory factory;
    private ListBuilder builder;

    public DiskSetHostsCard(DiskSetCommandFactory diskSetCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = diskSetCommandFactory;
        this.initGUI();
    }

    private void updateNextButton() {
        this.setProperty("vwp.canmoveforward", this.builder.getList().getModel().getSize() != 0 ? "vwp.true" : "vwp.false");
    }

    private boolean isValidHostname(String string) {
        if (string != null && !Character.isDigit(string.charAt(0)) && string.indexOf(".") == -1) {
            try {
                InetAddress.getByName(string);
                return true;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean hostInList(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.builder.getList().getModel();
        Object[] objectArray = defaultListModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!Util.areSameHost(string, (String)objectArray[i])) continue;
            return true;
        }
        return false;
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        this.builder = new ListBuilder(Util.getResourceString("DiskSetHostsCard_label"));
        ActionString actionString = new ActionString("JE_Add");
        AbstractButton abstractButton = this.builder.getAddButton();
        abstractButton.setText(actionString.getString());
        abstractButton.setMnemonic(actionString.getMnemonic());
        AbstractButton abstractButton2 = this.builder.getDeleteButton();
        actionString = new ActionString("JE_Delete");
        abstractButton2.setText(actionString.getString());
        abstractButton2.setMnemonic(actionString.getMnemonic());
        this.builder.setListAdditionListener(new ListAdditionListener(){

            public boolean additionPending(ListAdditionEvent listAdditionEvent) {
                String string = listAdditionEvent.getItem().toString();
                if (!DiskSetHostsCard.this.isValidHostname(string)) {
                    String string2 = Util.getResourceString("DiskSetHostsCard_invalid_hostname", string);
                    new ErrorDialog(null, string2);
                    return false;
                }
                if (DiskSetHostsCard.this.hostInList(string)) {
                    String string3 = Util.getResourceString("DiskSetHostsCard_host_in_list", string);
                    new ErrorDialog(null, string3);
                    return false;
                }
                return true;
            }
        });
        this.builder.getList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                DiskSetHostsCard.this.updateNextButton();
            }
        });
        jPanel.add((Component)this.builder, "Center");
        FlowArea flowArea = new FlowArea(Util.getResourceString("DiskSetHostsCard_del_host"));
        jPanel.add((Component)flowArea, "South");
        return jPanel;
    }

    public void refresh() {
        this.builder.getRemovable().removeAllRows();
        Object[] objectArray = this.factory.getHosts();
        if (objectArray != null) {
            this.builder.getAddable().addRows(objectArray);
        }
        this.updateNextButton();
    }

    public boolean stop(boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)this.builder.getList().getModel();
        Object[] objectArray = defaultListModel.toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        this.factory.setHosts(stringArray);
        return true;
    }
}

