/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SingleDeviceChooserCard;
import com.sun.admin.volmgr.client.wizards.command.HSPCommandFactory;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ReplaceHotSpareComponentChooser
extends SingleDeviceChooserCard {
    private static String TITLERESOURCE = "hs_replace_wiz_title";
    private static final String HELPFILE = "ReplaceHotSpareComponentChooser.html";
    private static String HEADER = "hs_replace_wiz_comp_header";
    private HSPCommandFactory factory;
    private JCheckBox allCheckBox;

    public ReplaceHotSpareComponentChooser(HSPCommandFactory hSPCommandFactory) {
        super(TITLERESOURCE, HELPFILE, HEADER, false);
        this.factory = hSPCommandFactory;
        this.initGUI();
    }

    protected Component getMainPanel() {
        Component component = super.getMainPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(component, "Center");
        this.allCheckBox = new JCheckBox();
        Util.initButton(this.allCheckBox, "hs_replace_wiz_comp_all_label");
        this.allCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    ReplaceHotSpareComponentChooser.this.factory.setUseAll(false);
                } else if (itemEvent.getStateChange() == 1) {
                    ReplaceHotSpareComponentChooser.this.factory.setUseAll(true);
                }
            }
        });
        jPanel.add((Component)this.allCheckBox, "South");
        return jPanel;
    }

    protected Device[] getDevices() {
        String string = this.factory.getDiskSetName();
        if (string == null || string.equals("")) {
            string = "";
        }
        return Util.getApp().getServiceWrapper().getDevicesAvailableForUseAs("Hsp", string);
    }

    protected boolean setDevice(Device device) {
        Device[] deviceArray = this.factory.getComponents();
        deviceArray[1] = device;
        this.factory.setComponents(deviceArray);
        return true;
    }

    public void refresh() {
        super.refresh();
        this.allCheckBox.setSelected(this.factory.getUseAll());
    }
}

