/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.admin.volmgr.server.SVMAPI;
import java.io.Serializable;

public abstract class StringDeviceFilter
extends DeviceFilter {
    public static Operator ATTR_EQUALS = new Operator(1000);
    public static Operator ATTR_DOES_NOT_EQUAL = new Operator(1001);
    public static Operator ATTR_CONTAINS = new Operator(1002);
    public static Operator ATTR_DOES_NOT_CONTAIN = new Operator(1003);
    public static Operator ATTR_STARTS_WITH = new Operator(1004);
    public static Operator ATTR_ENDS_WITH = new Operator(1005);
    private Operator operator;
    private String value;

    public StringDeviceFilter() {
    }

    public StringDeviceFilter(Device device, SVMAPI sVMAPI, boolean bl, Operator operator, String string) {
        super(device, sVMAPI, bl);
        this.setOperator(operator);
        this.setValue(string);
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public abstract String getAttribute();

    public boolean matches() {
        if (!this.getSelected()) {
            return true;
        }
        String string = this.getAttribute();
        String string2 = this.getValue();
        if (string == null || string2 == null) {
            return true;
        }
        Operator operator = this.getOperator();
        if (operator.equals(ATTR_EQUALS)) {
            return string.equals(string2);
        }
        if (operator.equals(ATTR_DOES_NOT_EQUAL)) {
            return !string.equals(string2);
        }
        if (operator.equals(ATTR_CONTAINS)) {
            return string.indexOf(string2) != -1;
        }
        if (operator.equals(ATTR_DOES_NOT_CONTAIN)) {
            return string.indexOf(string2) == -1;
        }
        if (operator.equals(ATTR_STARTS_WITH)) {
            return string.startsWith(string2);
        }
        if (operator.equals(ATTR_ENDS_WITH)) {
            return string.endsWith(string2);
        }
        return true;
    }

    public static class Operator
    implements Serializable {
        private int id;

        private Operator(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object object) {
            try {
                return ((Operator)object).getId() == this.getId();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }
}

