/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.QualifiedAttributeExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;
import javax.wbem.query.WQLParser;

public class ProviderFilter {
    private CIMClass qClass;
    private String query = null;
    private String className;
    private SelectList slist;
    private List canList;
    private String sortProp;
    private int sortOrder;
    private ArrayList selectProps;
    private ArrayList whereProps;
    private boolean allSelected;

    public ProviderFilter(CIMClass cc, String query) throws CIMException {
        this.qClass = cc;
        this.query = query;
        this.slist = null;
        this.canList = null;
        this.sortProp = null;
        this.sortOrder = 0;
        this.selectProps = null;
        this.allSelected = true;
        this.parseQuery(query);
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getSelectedPropertyNames() {
        String[] astr = null;
        if (!this.allSelected && this.selectProps != null) {
            astr = new String[this.selectProps.size()];
            this.selectProps.toArray(astr);
        }
        return astr;
    }

    public String[] getPropertiesList() {
        String[] astr = null;
        if (!this.allSelected) {
            ArrayList list = null;
            list = this.selectProps != null ? (ArrayList)this.selectProps.clone() : new ArrayList();
            if (this.whereProps != null) {
                for (String name : this.whereProps) {
                    if (list.contains(name)) continue;
                    list.add(name);
                }
            }
            if (list.size() > 0) {
                astr = new String[list.size()];
                list.toArray(astr);
            }
        }
        return astr;
    }

    public boolean isAllSelected() {
        return this.allSelected;
    }

    public CIMProperty getSortProperty() {
        CIMProperty prop = null;
        if (this.sortProp != null) {
            prop = this.qClass.getProperty(this.sortProp);
        }
        return prop;
    }

    public boolean isSortAscending() {
        return this.sortOrder == 1;
    }

    public List getCanonicalWhere() {
        return this.canList;
    }

    public boolean apply(CIMInstance ci) throws CIMException {
        if (this.canList == null || this.canList.size() == 0) {
            return true;
        }
        boolean bool = false;
        for (List andList : this.canList) {
            if (andList == null || andList.size() <= 0) continue;
            Iterator it2 = andList.iterator();
            while (it2.hasNext()) {
                bool = true;
                BinaryRelQueryExp rexp = null;
                try {
                    rexp = (BinaryRelQueryExp)it2.next();
                }
                catch (Exception ex) {
                    rexp = null;
                }
                if (rexp != null && rexp.apply((CIMElement)ci)) continue;
                bool = false;
                break;
            }
            if (!bool) continue;
            return true;
        }
        return false;
    }

    public CIMInstance project(CIMInstance ci) throws CIMException {
        if (this.allSelected) {
            return ci;
        }
        return (CIMInstance)this.slist.apply((CIMElement)ci);
    }

    private void parseQuery(String query) throws CIMException {
        SelectExp sexp = null;
        NonJoinExp fexp = null;
        QueryExp wexp = null;
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        try {
            sexp = (SelectExp)parser.querySpecification();
            this.slist = sexp.getSelectList();
            fexp = (NonJoinExp)sexp.getFromClause();
            wexp = sexp.getWhereClause();
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.setSelectedPropertyNames(this.slist);
        String name = null;
        QualifiedAttributeExp aexp = fexp.getAttribute();
        if (aexp != null) {
            name = aexp.getAttrClassName();
        }
        if (name == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.className = new String(name);
        this.whereProps = new ArrayList();
        if (wexp != null) {
            this.canList = wexp.canonizeDOC();
        }
        if (this.canList != null && this.canList.size() > 0) {
            for (List andList : this.canList) {
                if (andList != null && andList.size() > 0) {
                    Iterator it2 = andList.iterator();
                    while (it2.hasNext()) {
                        BinaryRelQueryExp rexp = null;
                        try {
                            rexp = (BinaryRelQueryExp)it2.next();
                        }
                        catch (Exception ex) {
                            rexp = null;
                        }
                        if (rexp != null) {
                            this.verifyExpression(rexp);
                            continue;
                        }
                        throw new CIMException("CIM_ERR_INVALID_QUERY");
                    }
                    continue;
                }
                throw new CIMException("CIM_ERR_INVALID_QUERY");
            }
        }
        this.sortProp = null;
        this.sortOrder = 0;
    }

    private void verifyExpression(BinaryRelQueryExp rexp) throws CIMException {
        ValueExp vexp1 = rexp.getLeftValue();
        ValueExp vexp2 = rexp.getRightValue();
        int op = rexp.getOperator();
        String name = ((AttributeExp)vexp1).getAttributeName();
        CIMProperty cp = this.qClass.getProperty(name);
        if (name == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)rexp.toString());
        }
        this.whereProps.add(name);
        if (!(vexp2 instanceof StringValueExp || vexp2 instanceof NumericValue || vexp2 instanceof DateTimeExp)) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)rexp.toString());
        }
        switch (op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)rexp.toString());
            }
        }
    }

    private void setSelectedPropertyNames(SelectList sl) {
        this.selectProps = null;
        this.allSelected = false;
        ArrayList<String> list = new ArrayList<String>();
        if (sl != null) {
            Enumeration en = sl.elements();
            while (en.hasMoreElements()) {
                AttributeExp exp = (AttributeExp)en.nextElement();
                String name = exp.getAttributeName();
                if (name.equals("*")) {
                    this.allSelected = true;
                    continue;
                }
                list.add(name);
            }
        }
        if (list.size() == 0) {
            this.allSelected = true;
        }
        if (!this.allSelected) {
            this.selectProps = list;
        }
    }
}

