/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DataStore
implements Cloneable {
    private static String VERSION_STR = "logsvc.wbem.version.1";
    private static final long SIZE_OF_LOG_HEADER = 65L;
    private static final long SIZE_OF_RECORD_HEADER = 20L;
    String logFileName;
    RandomAccessFile fileDescriptor;
    long totalNumRecords = 0L;
    long currentEndOffset = 0L;
    long lastRecordOffset = 0L;
    long startDate = 0L;
    long firstOffset = 0L;
    int marker;
    String version = "";
    long timeOfLastChange = 0L;

    public DataStore(String fileName) throws IOException, EOFException {
        this.logFileName = fileName;
        this.fileDescriptor = new RandomAccessFile(fileName, "rw");
        if (this.fileDescriptor.length() > 0L) {
            this.fileDescriptor.seek(0L);
            this.currentEndOffset = this.fileDescriptor.readLong();
            this.lastRecordOffset = this.fileDescriptor.readLong();
            this.totalNumRecords = this.fileDescriptor.readLong();
            this.timeOfLastChange = this.fileDescriptor.readLong();
            this.marker = this.fileDescriptor.readInt();
            this.startDate = this.fileDescriptor.readLong();
            this.version = this.fileDescriptor.readUTF();
            this.firstOffset = this.fileDescriptor.getFilePointer();
        } else {
            this.marker = this.hashCode();
            this.timeOfLastChange = this.startDate = System.currentTimeMillis();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.fileDescriptor.writeLong(this.lastRecordOffset);
            this.fileDescriptor.writeLong(this.totalNumRecords);
            this.fileDescriptor.writeLong(this.timeOfLastChange);
            this.fileDescriptor.writeInt(this.marker);
            this.fileDescriptor.writeLong(this.startDate);
            this.fileDescriptor.writeUTF(VERSION_STR);
            this.firstOffset = this.currentEndOffset = this.fileDescriptor.getFilePointer();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.lastRecordOffset = this.currentEndOffset;
            this.fileDescriptor.writeLong(this.lastRecordOffset);
        }
    }

    protected void finalize() throws IOException {
        this.fileDescriptor.close();
    }

    private long checkOffset(long filePointer) {
        if (filePointer < 0L || filePointer >= this.currentEndOffset) {
            return -1L;
        }
        if (filePointer == 0L) {
            filePointer = this.firstOffset;
        }
        return filePointer;
    }

    private void checkMark() throws IOException, EOFException, CorruptDataException {
        int i = this.fileDescriptor.readInt();
        if (i != this.marker) {
            throw new CorruptDataException("EXLOG_MRK");
        }
    }

    private Object convertToObject(byte[] byteArr) throws IOException, ClassNotFoundException {
        if (byteArr.length <= 0) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(byteArr);
        ObjectInputStream in = new ObjectInputStream(bin);
        Object obj = in.readObject();
        return obj;
    }

    protected synchronized long writeRecord(String rec, long fileSize) throws IOException, InvalidRecordException, CorruptDataException {
        int length = 0;
        long previous_record = this.lastRecordOffset;
        if (rec == null) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        this.autoCheck();
        this.fileDescriptor.seek(this.currentEndOffset);
        length = rec.length();
        if (length <= 0) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        long file_length = this.fileDescriptor.length();
        if ((file_length += (long)(12 + length + 8)) > fileSize) {
            return -1L;
        }
        this.lastRecordOffset = this.currentEndOffset;
        this.fileDescriptor.writeInt(this.marker);
        this.fileDescriptor.writeInt(rec.hashCode());
        this.fileDescriptor.writeLong(previous_record);
        this.fileDescriptor.writeInt(length);
        this.fileDescriptor.writeUTF(rec);
        this.currentEndOffset = this.fileDescriptor.getFilePointer();
        ++this.totalNumRecords;
        this.timeOfLastChange = System.currentTimeMillis();
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.fileDescriptor.writeLong(this.lastRecordOffset);
        this.fileDescriptor.writeLong(this.totalNumRecords);
        this.fileDescriptor.writeLong(this.timeOfLastChange);
        return this.fileDescriptor.length();
    }

    protected synchronized Vector readNumRecordsAsStr(long filePointer, int numRecords, int reverse) throws IOException, EOFException, InvalidRecordException, CorruptDataException {
        Vector<DataRecord> return_vec = new Vector<DataRecord>();
        int hash = 0;
        int length = 0;
        int i = 0;
        long current_rec_filePointer = 0L;
        if (filePointer > this.currentEndOffset) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if (reverse == 0) {
            if (filePointer == 0L) {
                filePointer = this.lastRecordOffset;
            } else {
                if (filePointer == this.firstOffset) {
                    return null;
                }
                long fp = filePointer;
                this.fileDescriptor.seek(filePointer += 8L);
                filePointer = this.fileDescriptor.readLong();
                if (fp == filePointer) {
                    return null;
                }
            }
        } else if (reverse == 1 && filePointer != 0L) {
            if (filePointer == this.lastRecordOffset) {
                return null;
            }
            this.autoCheck();
            filePointer = this.checkOffset(filePointer);
            this.fileDescriptor.seek(filePointer += 16L);
            length = this.fileDescriptor.readInt();
            String temp_rec = this.fileDescriptor.readUTF();
            filePointer = this.fileDescriptor.getFilePointer();
        }
        filePointer = this.checkOffset(filePointer);
        if (filePointer < 0L) {
            this.autoCheck();
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(filePointer);
        while (i < numRecords) {
            long previous_record;
            try {
                this.checkMark();
                hash = this.fileDescriptor.readInt();
                previous_record = this.fileDescriptor.readLong();
                length = this.fileDescriptor.readInt();
                if (length < 0) {
                    throw new CorruptDataException("EXLOG_LEN");
                }
                String obj = this.fileDescriptor.readUTF();
                if (obj == null) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                return_vec.addElement(new DataRecord(filePointer, hash, obj, obj.length(), this.version));
                current_rec_filePointer = filePointer;
            }
            catch (EOFException e) {
                if (i > 0) {
                    return return_vec;
                }
                throw e;
            }
            ++i;
            filePointer = this.fileDescriptor.getFilePointer();
            if (reverse != 0) continue;
            if (previous_record > filePointer) {
                throw new CorruptDataException("EXLOG_DAT");
            }
            if (previous_record == current_rec_filePointer) {
                return return_vec;
            }
            this.fileDescriptor.seek(previous_record);
            filePointer = previous_record;
        }
        return return_vec;
    }

    protected synchronized DataRecord readSpecificRecordAsStr(long filePointer, int hashCode) throws InvalidRecordException, IOException, EOFException, CorruptDataException {
        if (filePointer > this.currentEndOffset) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if ((filePointer = this.checkOffset(filePointer)) < 0L) {
            this.autoCheck();
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(filePointer);
        this.checkMark();
        int hash = this.fileDescriptor.readInt();
        if (hash != hashCode) {
            throw new InvalidRecordException("EXLOG_HSH");
        }
        this.fileDescriptor.readLong();
        int length = this.fileDescriptor.readInt();
        if (length < 0) {
            throw new CorruptDataException("EXLOG_LEN");
        }
        String obj = this.fileDescriptor.readUTF();
        if (obj == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        return new DataRecord(filePointer, hash, obj, obj.length(), this.version);
    }

    long getCurrentEndOffset() {
        return this.currentEndOffset;
    }

    protected long getNumRecords() {
        return this.totalNumRecords;
    }

    protected String getFileName() {
        return this.logFileName;
    }

    protected void close() throws AdminLogException {
        try {
            this.fileDescriptor.close();
        }
        catch (IOException e) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
    }

    protected long getFileDate() {
        return this.startDate;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    protected String getVersion() {
        return this.version;
    }

    protected long getTimeOfLastChange() {
        return this.timeOfLastChange;
    }

    protected long getFileSize() throws IOException {
        return this.fileDescriptor.length();
    }

    private void autoCheck() throws CorruptDataException {
        boolean throwable = false;
        try {
            if (this.currentEndOffset != this.fileDescriptor.length()) {
                throwable = true;
            }
        }
        catch (Exception ex) {
            throw new CorruptDataException("EXLOG_OFF");
        }
        if (throwable) {
            throw new CorruptDataException("EXLOG_OFF");
        }
    }

    protected String getLogHeaderFormat() {
        String format = "The format of the log header is as follows:\n\tCurrent end offset     - 8 bytes\tLast record offset     - 8 bytes\tNumber of records      - 8 bytes\tTime of last change    - 8 bytes\tRecord marker          - 4 bytes\tLog creation date      - 8 bytes\tVersion String         - 21 bytes";
        return format;
    }

    protected long getLogHeaderSize() {
        return 65L;
    }

    protected long getRecordHeaderSize() {
        return 20L;
    }

    protected String getRecordHeaderFormat() {
        String format = "The format of the record header is as follows:\n\tRecordMarker           - 4 bytes\tRecordHash             - 4 bytes\tPrevious record offset - 8 bytes\tRecord Length          - 4 bytes";
        return format;
    }
}

